/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2me.global;

import com.sun.j2me.global.CollationElementTable;
import com.sun.j2me.global.CollationElementTableImpl;
import com.sun.j2me.global.NormalizationTable;
import com.sun.j2me.global.NormalizationTableImpl;
import com.sun.j2me.global.StringCollator;
import com.sun.j2me.global.StringNormalizer;

public final class DebugHelper {
    private final StringNormalizer strNormalizer;
    private final StringCollator strCollator;

    public DebugHelper(String locale) {
        NormalizationTable nrmTable = NormalizationTableImpl.getInstance();
        CollationElementTableImpl colTable = CollationElementTableImpl.getInstance(locale == null ? "" : locale);
        this.strNormalizer = new StringNormalizer(nrmTable);
        this.strCollator = new StringCollator(this.strNormalizer, colTable);
    }

    public String getCollationElements(String s) {
        this.strNormalizer.setSource(s, 0);
        this.strCollator.reset();
        StringBuffer sb = new StringBuffer();
        int value = this.strCollator.getNextElement();
        while (value != -1) {
            sb.append('[');
            sb.append(Integer.toHexString(CollationElementTable.getL1(value)));
            sb.append(',');
            sb.append(Integer.toHexString(CollationElementTable.getL2(value)));
            sb.append(',');
            sb.append(Integer.toHexString(CollationElementTable.getL3(value)));
            sb.append(']');
            value = this.strCollator.getNextElement();
        }
        return sb.toString();
    }

    public String getDecomposition(String s) {
        this.strNormalizer.setSource(s, 0);
        StringBuffer sb = new StringBuffer();
        int value = this.strNormalizer.getNextElement();
        if (value != -1) {
            sb.append(Integer.toHexString(NormalizationTable.getCodePoint(value)));
            value = this.strNormalizer.getNextElement();
            while (value != -1) {
                sb.append(',');
                sb.append(Integer.toHexString(NormalizationTable.getCodePoint(value)));
                value = this.strNormalizer.getNextElement();
            }
        }
        return sb.toString();
    }
}

