/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2me.global;

import com.sun.j2me.global.CommonFormatter;
import com.sun.j2me.global.DateFormatSymbols;
import com.sun.j2me.global.DateTimeFormat;
import com.sun.j2me.global.LocaleHelpers;
import com.sun.j2me.global.NumberFormat;
import com.sun.j2me.global.NumberFormatSymbols;
import com.sun.j2me.global.ResourceManagerImpl;
import java.util.Calendar;
import java.util.Hashtable;
import javax.microedition.global.Formatter;
import javax.microedition.global.UnsupportedLocaleException;

public class FormatterImpl
implements CommonFormatter {
    private String locale;
    private Hashtable csymbols = null;

    public FormatterImpl(String locale) throws UnsupportedLocaleException {
        int locale_index = LocaleHelpers.indexInSupportedLocales(locale, Formatter.getSupportedLocales());
        if (locale_index == -1) {
            throw new UnsupportedLocaleException("Locale \"" + locale + "\" unsupported.");
        }
        this.locale = locale;
    }

    private NumberFormatSymbols getNumberFormatSymbols() {
        try {
            ResourceManagerImpl rm = ResourceManagerImpl.getManager("", this.locale);
            NumberFormatSymbols symbols = (NumberFormatSymbols)rm.getResource(0x7FFFFFFE);
            return symbols;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String formatDateTime(Calendar dateTime, int style) {
        try {
            ResourceManagerImpl rm = ResourceManagerImpl.getManager("", this.locale);
            DateFormatSymbols symbols = (DateFormatSymbols)rm.getResource(0x7FFFFFFD);
            DateTimeFormat dtf = new DateTimeFormat(style, symbols);
            NumberFormat nf = new NumberFormat(3, this.getNumberFormatSymbols());
            return dtf.format(dateTime, nf);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String formatCurrency(double number) {
        NumberFormat nf = new NumberFormat(1, this.getNumberFormatSymbols());
        if (Double.isInfinite(number) || Double.isNaN(number)) {
            String oldSymbol = nf.setCurrencySymbol("");
            String formatted = nf.format(number);
            nf.setCurrencySymbol(oldSymbol);
            return formatted;
        }
        return nf.format(number);
    }

    public String formatCurrency(double number, String currencyCode) {
        NumberFormat nf = new NumberFormat(1, this.getNumberFormatSymbols());
        String symbol = nf.getCurrencySymbolForCode(currencyCode);
        if (symbol == null) {
            symbol = currencyCode;
        }
        if (Double.isInfinite(number) || Double.isNaN(number)) {
            symbol = "";
        }
        String oldSymbol = nf.setCurrencySymbol(symbol);
        String formatted = nf.format(number);
        nf.setCurrencySymbol(oldSymbol);
        return formatted;
    }

    public String formatNumber(double number) {
        NumberFormat nf = new NumberFormat(0, this.getNumberFormatSymbols());
        return nf.format(number);
    }

    public String formatNumber(double number, int decimals) {
        NumberFormat nf = new NumberFormat(0, this.getNumberFormatSymbols());
        nf.setMinimumFractionDigits(decimals);
        nf.setMaximumFractionDigits(decimals);
        return nf.format(number);
    }

    public String formatNumber(long number) {
        NumberFormat nf = new NumberFormat(3, this.getNumberFormatSymbols());
        return nf.format(number);
    }

    public String formatPercentage(long number) {
        NumberFormat nf = new NumberFormat(2, this.getNumberFormatSymbols());
        nf.setMultiplier(1);
        return nf.format(number);
    }

    public String formatPercentage(float number, int decimals) {
        NumberFormat nf = new NumberFormat(2, this.getNumberFormatSymbols());
        nf.setMinimumFractionDigits(1);
        nf.setMaximumFractionDigits(decimals);
        return nf.format(number);
    }
}

