/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2me.global;

public class LocaleHelpers {
    public static boolean isValidLocale(String locale) {
        if (locale == null) {
            return true;
        }
        int len = locale.length();
        if (len == 0) {
            return true;
        }
        if (len < 2) {
            return false;
        }
        char ch = locale.charAt(0);
        if (ch < 'a' || ch > 'z') {
            return false;
        }
        ch = locale.charAt(1);
        if (ch < 'a' || ch > 'z') {
            return false;
        }
        if (len > 2) {
            if (len < 5 || len == 6) {
                return false;
            }
            ch = locale.charAt(2);
            if (ch != '-' && ch != '_') {
                return false;
            }
            ch = locale.charAt(3);
            if (ch < 'A' || ch > 'Z') {
                return false;
            }
            ch = locale.charAt(4);
            if (ch < 'A' || ch > 'Z') {
                return false;
            }
            if (len > 6 && (ch = locale.charAt(5)) != '-' && ch != '_') {
                return false;
            }
        }
        return true;
    }

    public static String normalizeLocale(String locale) {
        if (locale == null) {
            return null;
        }
        int len = locale.length();
        if (len > 3) {
            locale = locale.substring(0, 2) + '-' + locale.substring(3);
            if (len > 6) {
                locale = locale.substring(0, 5) + '-' + locale.substring(6);
            }
        }
        return locale;
    }

    public static String getParentLocale(String locale) {
        if (locale == null) {
            return null;
        }
        int len = locale.length();
        if (len == 0) {
            return null;
        }
        if (len > 6) {
            return locale.substring(0, 5);
        }
        if (len > 3) {
            return locale.substring(0, 2);
        }
        return "";
    }

    public static int indexInSupportedLocales(String locale, String[] locales) {
        if (locale == null || locales == null || locales.length == 0) {
            return -1;
        }
        for (int i = 0; i < locales.length; ++i) {
            if (!locale.equals(locales[i])) continue;
            return i;
        }
        return -1;
    }

    private static String extractElement(String input) {
        String trimmed = input.trim();
        int length = trimmed.length();
        if (length >= 2 && trimmed.charAt(0) == '\"' && trimmed.charAt(length - 1) == '\"') {
            return trimmed.substring(1, length - 1);
        }
        return trimmed;
    }

    public static String[] splitString(String input, String separator, int limit) {
        int index = input.indexOf(separator);
        int count = 1;
        while (index >= 0) {
            ++count;
            index = input.indexOf(separator, index + 1);
        }
        if (limit != -1 && count > limit) {
            count = limit;
        }
        String[] elements = new String[count];
        LocaleHelpers.splitString(elements, input, separator, limit);
        return elements;
    }

    public static int splitString(String[] elements, String input, String separator, int limit) {
        int lastIndex = -1;
        int index = input.indexOf(separator);
        int count = 0;
        if (limit == -1 || limit > elements.length) {
            limit = elements.length;
        }
        if (limit == 0) {
            return 0;
        }
        while (index >= 0) {
            elements[count++] = LocaleHelpers.extractElement(input.substring(lastIndex + 1, index));
            if (count == limit) {
                return count;
            }
            lastIndex = index;
            index = input.indexOf(separator, lastIndex + 1);
        }
        elements[count++] = LocaleHelpers.extractElement(input.substring(lastIndex + 1, input.length()));
        return count;
    }

    public static short[] byteArrayToShortArray(byte[] source) {
        short[] output = new short[source.length >> 1];
        int i = 0;
        int j = 0;
        while (i < source.length) {
            output[j] = (short)((source[i] & 0xFF) << 8 | source[i + 1] & 0xFF);
            i += 2;
            ++j;
        }
        return output;
    }

    public static int[] byteArrayToIntArray(byte[] source) {
        int[] output = new int[source.length >> 2];
        int i = 0;
        int j = 0;
        while (i < source.length) {
            output[j] = (source[i] & 0xFF) << 24 | (source[i + 1] & 0xFF) << 16 | (source[i + 2] & 0xFF) << 8 | source[i + 3] & 0xFF;
            i += 4;
            ++j;
        }
        return output;
    }
}

