/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2me.global;

public class MessageFormat {
    private static final char LEFT_PARENTHESIS = '{';
    private static final char RIGHT_PARENTHESIS = '}';

    public static String format(String message, String[] params) {
        if (message == null || params == null) {
            throw new NullPointerException("Template or parameter array is null.");
        }
        boolean inside = false;
        boolean escaped = false;
        StringBuffer result = new StringBuffer();
        StringBuffer placeholder = null;
        int lookingFor = 123;
        for (int i = 0; i < message.length(); ++i) {
            int c = message.charAt(i);
            if (c == lookingFor) {
                if (escaped) {
                    result.append((char)c);
                    escaped = false;
                    continue;
                }
                if (c == 123) {
                    if (i + 1 < message.length() && message.charAt(i + 1) == '{') {
                        escaped = true;
                        continue;
                    }
                    inside = true;
                    lookingFor = 125;
                    placeholder = new StringBuffer();
                    continue;
                }
                inside = false;
                lookingFor = 123;
                try {
                    if (placeholder.length() > 2) {
                        throw new IllegalArgumentException("Illegal placeholder.");
                    }
                    int index = Integer.parseInt(placeholder.toString());
                    result.append(params[index]);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException ie) {
                    throw new IllegalArgumentException("Illegal number of parameters.");
                }
            }
            if (inside) {
                placeholder.append((char)c);
                continue;
            }
            result.append((char)c);
        }
        return result.toString();
    }
}

