/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2me.global;

import com.sun.j2me.global.CommonFormatter;
import com.sun.j2me.global.DateFormatSymbols;
import com.sun.j2me.global.DateTimeFormat;
import com.sun.j2me.global.NumberFormat;
import com.sun.j2me.global.NumberFormatSymbols;
import java.util.Calendar;

public class NeutralFormatterImpl
implements CommonFormatter {
    NeutralFormatterImpl() {
    }

    public String formatDateTime(Calendar dateTime, int style) {
        DateFormatSymbols dfs = new DateFormatSymbols();
        dfs.patterns[0] = "yyyy-MM-d";
        dfs.patterns[1] = "yyyy-MM-d";
        dfs.patterns[2] = "HH:mm:ssz";
        dfs.patterns[3] = "HH:mm:ssz";
        dfs.patterns[4] = "{0}T{1}";
        dfs.patterns[5] = "{0}T{1}";
        DateTimeFormat dtf = new DateTimeFormat(style, dfs);
        NumberFormat nf = new NumberFormat(3, new NumberFormatSymbols());
        return dtf.format(dateTime, nf);
    }

    public String formatCurrency(double number) {
        NumberFormat nf = new NumberFormat(1, null);
        return nf.format(number);
    }

    public String formatCurrency(double number, String currencyCode) {
        NumberFormat nf = new NumberFormat(1, null);
        return nf.format(number) + (Double.isInfinite(number) || Double.isNaN(number) ? "" : currencyCode);
    }

    public String formatNumber(double number) {
        NumberFormat nf = new NumberFormat(0, null);
        return nf.format(number);
    }

    private static String round(String num) {
        String ret = "";
        boolean adjust = true;
        int minusPos = num.indexOf(45);
        for (int i = num.length() - 1; i > minusPos; --i) {
            int c = num.charAt(i);
            if (adjust && c >= 48 && c <= 57) {
                if ((c = (char)(c + '\u0001')) > 57) {
                    c = 48;
                    adjust = true;
                } else {
                    adjust = false;
                }
            }
            ret = (char)c + ret;
        }
        if (adjust) {
            ret = '1' + ret;
        }
        if (minusPos == 0) {
            ret = '-' + ret;
        }
        return ret;
    }

    public String formatNumber(double number, int decimals) {
        String num = new Double(number).toString();
        int ePos = num.indexOf(69);
        int dotPos = num.indexOf(46);
        if (ePos != -1) {
            StringBuffer mantissa = new StringBuffer(num.substring(0, dotPos) + num.substring(dotPos + 1, ePos));
            int eVal = Integer.parseInt(num.substring(ePos + 1));
            if (eVal > 0) {
                while (eVal >= ePos - dotPos) {
                    mantissa.append('0');
                    ++ePos;
                }
                dotPos += eVal;
            } else {
                int insPos = num.indexOf(45) + 1;
                if (insPos > 1) {
                    insPos = 0;
                }
                while (eVal++ < 0) {
                    mantissa.insert(insPos, '0');
                }
                dotPos = insPos + 1;
            }
            num = mantissa.toString();
            num = num.substring(0, dotPos) + '.' + num.substring(dotPos);
        }
        boolean needsRounding = (num = num + "0000000000000000").charAt(++dotPos + decimals) >= '5';
        num = num.substring(0, dotPos + decimals);
        if (needsRounding) {
            num = NeutralFormatterImpl.round(num);
        }
        return num;
    }

    public String formatNumber(long number) {
        NumberFormat nf = new NumberFormat(3, null);
        return nf.format(number);
    }

    public String formatPercentage(long number) {
        NumberFormat nf = new NumberFormat(2, null);
        nf.setMultiplier(1);
        return nf.format(number);
    }

    public String formatPercentage(float number, int decimals) {
        return this.formatNumber((double)number * 100.0, decimals) + '%';
    }
}

