/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2me.global;

import com.sun.j2me.global.LocaleHelpers;
import com.sun.j2me.global.NormalizationTable;
import com.sun.midp.io.j2me.storage.File;
import com.sun.midp.io.j2me.storage.RandomAccessStream;
import com.sun.midp.main.Configuration;
import com.sun.midp.security.SecurityInitializer;
import com.sun.midp.security.SecurityToken;
import java.io.DataInputStream;
import java.io.IOException;

public final class NormalizationTableImpl
extends NormalizationTable
implements Runnable {
    private static SecurityToken classSecurityToken = SecurityInitializer.getSecurityToken();
    private static NormalizationTableImpl instance;
    private static final int STATE_UNINITIALIZED = 0;
    private static final int STATE_LOAD_FINISHED = 1;
    private static final int STATE_LOAD_FAILED = 2;
    private int state = 0;
    private static final int SEQUENCE_FLAG = Integer.MIN_VALUE;
    private static final int HANGUL_SBASE = 44032;
    private static final int HANGUL_LBASE = 4352;
    private static final int HANGUL_VBASE = 4449;
    private static final int HANGUL_TBASE = 4519;
    private static final int HANGUL_LCOUNT = 19;
    private static final int HANGUL_VCOUNT = 21;
    private static final int HANGUL_TCOUNT = 28;
    private static final int HANGUL_NCOUNT = 588;
    private static final int HANGUL_SCOUNT = 11172;
    private byte[] offsets0;
    private short[] offsets1;
    private short[] offsets2;
    private int[] data;
    private final int maxDecomposition;

    public void initSecurityToken(SecurityToken token) {
        if (classSecurityToken == null) {
            classSecurityToken = token;
        }
    }

    private NormalizationTableImpl() {
        int tmpMaxDecomposition = 3;
        String propString = Configuration.getProperty("microedition.global.normalization.maxdecomp");
        if (propString != null && propString.length() != 0) {
            try {
                tmpMaxDecomposition = Integer.parseInt(propString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.maxDecomposition = tmpMaxDecomposition;
    }

    public static synchronized NormalizationTable getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new NormalizationTableImpl();
        new Thread(instance).start();
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeData() {
        NormalizationTableImpl normalizationTableImpl = instance;
        synchronized (normalizationTableImpl) {
            if (NormalizationTableImpl.instance.state != 1) {
                if (NormalizationTableImpl.instance.state == 0) {
                    try {
                        instance.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (NormalizationTableImpl.instance.state != 1) {
                    throw new IllegalStateException();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int newState = 2;
        byte[] buffer0 = null;
        byte[] buffer1 = null;
        byte[] buffer2 = null;
        byte[] buffer3 = null;
        try {
            RandomAccessStream storage = new RandomAccessStream(classSecurityToken);
            storage.connect(File.getStorageRootFor(Configuration.getProperty("microedition.global.root") + Configuration.getProperty("microedition.global.normalization") + ".bin"), 1);
            DataInputStream ds = new DataInputStream(storage.openInputStream());
            try {
                int length = ds.readUnsignedShort();
                buffer0 = new byte[length];
                ds.readFully(buffer0, 0, length);
                length = ds.readUnsignedShort();
                buffer1 = new byte[length <<= 1];
                ds.readFully(buffer1, 0, length);
                length = ds.readUnsignedShort();
                buffer2 = new byte[length <<= 1];
                ds.readFully(buffer2, 0, length);
                length = ds.readUnsignedShort();
                buffer3 = new byte[length <<= 2];
                ds.readFully(buffer3, 0, length);
                newState = 1;
            }
            catch (IOException e) {
                // empty catch block
            }
            ds.close();
            storage.disconnect();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (newState == 1) {
            this.offsets0 = buffer0;
            this.offsets1 = LocaleHelpers.byteArrayToShortArray(buffer1);
            this.offsets2 = LocaleHelpers.byteArrayToShortArray(buffer2);
            this.data = LocaleHelpers.byteArrayToIntArray(buffer3);
        }
        NormalizationTableImpl normalizationTableImpl = this;
        synchronized (normalizationTableImpl) {
            this.state = newState;
            this.notifyAll();
        }
    }

    private static final int hangulDecomposition(int[] buffer, int offset, int cp) {
        int SIndex = cp - 44032;
        buffer[offset++] = 4352 + SIndex / 588;
        buffer[offset++] = 4449 + SIndex % 588 / 28;
        int tmp = SIndex % 28;
        if (tmp > 0) {
            buffer[offset] = 4519 + tmp;
            return 3;
        }
        return 2;
    }

    private static final boolean isValidCodePoint(int cp) {
        if (cp < 0 || cp > 0x10FFFF) {
            return false;
        }
        if (cp >= 64976 && cp <= 65007 || (cp & 0xFFFF) == 65534 || (cp & 0xFFFF) == 65535) {
            return false;
        }
        return (cp & 0x1FF800) != 55296;
    }

    public int getCanonicalDecomposition(int[] buffer, int offset, int cp) {
        if (this.data == null) {
            this.initializeData();
        }
        if (!NormalizationTableImpl.isValidCodePoint(cp)) {
            return 0;
        }
        if (cp >= 44032 && cp < 55204) {
            return NormalizationTableImpl.hangulDecomposition(buffer, offset, cp);
        }
        int index = cp >> 8 & 0x1FFF;
        if (index >= this.offsets0.length || this.offsets0[index] == -1) {
            return cp | Integer.MIN_VALUE;
        }
        if (this.offsets1[index = ((this.offsets0[index] & 0xFF) << 4) + (cp >> 4 & 0xF)] == -1) {
            return cp | Integer.MIN_VALUE;
        }
        if (this.offsets2[index = ((this.offsets1[index] & 0xFFFF) << 4) + (cp & 0xF)] == -1) {
            return cp | Integer.MIN_VALUE;
        }
        int value = this.data[index];
        int sequenceFlag = value & Integer.MIN_VALUE;
        if ((this.data[(index = this.offsets2[index] & 0xFFFF) + 1] & Integer.MIN_VALUE) != sequenceFlag) {
            return value | Integer.MIN_VALUE;
        }
        buffer[offset] = value;
        int i = 1;
        value = this.data[index + 1];
        do {
            buffer[offset + i++] = value;
        } while (((value = this.data[index + i]) & Integer.MIN_VALUE) == sequenceFlag);
        return i;
    }

    public int getMaxDecompositionLength() {
        return this.maxDecomposition;
    }
}

