/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2me.global;

import com.sun.j2me.global.DigitList;
import com.sun.j2me.global.NumberFormatSymbols;

public class NumberFormat {
    private static final String classname = (class$com$sun$j2me$global$NumberFormat == null ? (class$com$sun$j2me$global$NumberFormat = NumberFormat.class$("com.sun.j2me.global.NumberFormat")) : class$com$sun$j2me$global$NumberFormat).getName();
    private static final int DOUBLE_INTEGER_DIGITS = 309;
    private static final int DOUBLE_FRACTION_DIGITS = 340;
    public static final char NONLOCALIZED_PERCENT_SIGN = '%';
    public static final int NUMBERSTYLE = 0;
    public static final int CURRENCYSTYLE = 1;
    public static final int PERCENTSTYLE = 2;
    public static final int INTEGERSTYLE = 3;
    private NumberFormatSymbols symbols;
    private boolean isCurrencyFormat = false;
    private boolean isPercentageFormat = false;
    private DigitList digitList = new DigitList();
    private int style = 0;
    static /* synthetic */ Class class$com$sun$j2me$global$NumberFormat;

    public NumberFormat(int style, NumberFormatSymbols symbols) {
        this.style = style;
        this.symbols = symbols;
        this.isCurrencyFormat = style == 1;
        this.isPercentageFormat = style == 2;
        this.applySymbols();
    }

    public void setMaximumFractionDigits(int count) {
        if (this.symbols != null && count <= 340 && count >= 0 && this.style != 3) {
            this.symbols.maximumFractionDigits[this.style] = count;
            if (this.symbols.minimumFractionDigits[this.style] < count) {
                this.symbols.minimumFractionDigits[this.style] = count;
            }
        }
    }

    public int getMaximumFractionDigits() {
        return this.symbols != null ? this.symbols.maximumFractionDigits[this.style] : -1;
    }

    public void setMinimumFractionDigits(int count) {
        if (this.symbols != null && count >= 0 && this.style != 3) {
            this.symbols.minimumFractionDigits[this.style] = count;
            if (count > this.symbols.maximumFractionDigits[this.style]) {
                this.symbols.maximumFractionDigits[this.style] = count;
            }
        }
    }

    public void setMultiplier(int multiplier) {
        if (this.symbols != null) {
            this.symbols.multiplier[this.style] = multiplier;
        }
    }

    public int getMultiplier() {
        return this.symbols != null ? this.symbols.multiplier[this.style] : 1;
    }

    public void setGroupingUsed(boolean used) {
        if (this.symbols != null) {
            this.symbols.groupingUsed = used;
        }
    }

    public int getMinimumFractionDigits() {
        return this.symbols != null ? this.symbols.minimumFractionDigits[this.style] : -1;
    }

    public void setMinimumIntegerDigits(int count) {
        if (this.symbols != null && count > 0) {
            this.symbols.minimumIntegerDigits[this.style] = count;
        }
    }

    public int getMinimumIntegerDigits() {
        return this.symbols != null ? this.symbols.minimumIntegerDigits[this.style] : -1;
    }

    public String setCurrencySymbol(String symbol) {
        if (this.isCurrencyFormat && this.symbols != null && !symbol.equals(this.symbols.currencySymbol)) {
            String oldsymbol = this.symbols.currencySymbol;
            this.symbols.currencySymbol = symbol;
            this.symbols.suffixes[this.style] = this.replSubStr(this.symbols.suffixes[this.style], oldsymbol, symbol);
            this.symbols.prefixes[this.style] = this.replSubStr(this.symbols.prefixes[this.style], oldsymbol, symbol);
            this.symbols.negativeSuffix[this.style] = this.replSubStr(this.symbols.negativeSuffix[this.style], oldsymbol, symbol);
            this.symbols.negativePrefix[this.style] = this.replSubStr(this.symbols.negativePrefix[this.style], oldsymbol, symbol);
            this.symbols.positiveSuffix[this.style] = this.replSubStr(this.symbols.positiveSuffix[this.style], oldsymbol, symbol);
            this.symbols.positivePrefix[this.style] = this.replSubStr(this.symbols.positivePrefix[this.style], oldsymbol, symbol);
            return oldsymbol;
        }
        return this.symbols.currencySymbol;
    }

    private String replSubStr(String str, String oldVal, String newVal) {
        int pos;
        String res = str;
        if (str.length() > 0 && (pos = str.indexOf(oldVal)) >= 0) {
            res = str.substring(0, pos);
            res = res.concat(newVal);
            res = res.concat(str.substring(pos + oldVal.length()));
            return res;
        }
        return res;
    }

    public String getCurrencySymbolForCode(String currencyCode) {
        for (int i = 0; i < this.symbols.currencies.length; ++i) {
            if (!this.symbols.currencies[i][0].equals(currencyCode)) continue;
            return this.symbols.currencies[i][1];
        }
        return null;
    }

    private void applySymbols() {
        if (this.symbols != null) {
            if (this.symbols.maximumIntegerDigits[this.style] == -1) {
                this.symbols.maximumIntegerDigits[this.style] = 309;
            }
            if (this.symbols.maximumFractionDigits[this.style] == -1) {
                this.symbols.maximumFractionDigits[this.style] = 340;
            }
        }
    }

    public String format(long value) {
        return this.format(new Long(value));
    }

    public String format(double value) {
        if (this.symbols != null) {
            if (Double.isNaN(value)) {
                return "NaN";
            }
            if (Double.isInfinite(value)) {
                String prefix = value > 0.0 ? "" : "-";
                String suffix = "";
                return prefix + this.symbols.infinity + suffix;
            }
        }
        return this.format(new Double(value));
    }

    public String format(int value) {
        return this.format(new Long(value));
    }

    public String format(float value) {
        return this.format((double)value);
    }

    protected String format(Object o) {
        StringBuffer appendTo = new StringBuffer();
        if (o == null) {
            return "";
        }
        if (this.symbols != null) {
            if (o instanceof Double) {
                this.format((Double)o, appendTo);
            }
            if (o instanceof Long) {
                this.format((Long)o, appendTo);
            }
        } else if (this.isPercentageFormat) {
            if (o instanceof Double) {
                appendTo.append(Double.toString((Double)o * 100.0));
            } else if (o instanceof Long) {
                long value = (Long)o;
                appendTo.append(Long.toString(value));
                if (value != 0L) {
                    appendTo.append("00");
                }
            }
            appendTo.append('%');
        } else {
            return o.toString();
        }
        return appendTo.toString();
    }

    private StringBuffer format(double number, StringBuffer result) {
        boolean isNegative;
        if (Double.isNaN(number)) {
            result.append(this.symbols.NaN);
            return result;
        }
        boolean bl = isNegative = number < 0.0 || number == 0.0 && 1.0 / number < 0.0;
        if (isNegative) {
            number = -number;
        }
        if (this.symbols.multiplier[this.style] != 1) {
            number *= (double)this.symbols.multiplier[this.style];
        }
        if (Double.isInfinite(number)) {
            if (isNegative) {
                result.append(this.symbols.negativePrefix[this.style]);
            } else {
                result.append(this.symbols.positivePrefix[this.style]);
            }
            result.append(this.symbols.infinity);
            if (isNegative) {
                result.append(this.symbols.negativeSuffix[this.style]);
            } else {
                result.append(this.symbols.positiveSuffix[this.style]);
            }
            return result;
        }
        this.digitList.set(number, this.symbols.maximumFractionDigits[this.style]);
        result = this.subformat(result, isNegative, false);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer format(long number, StringBuffer result) {
        boolean isNegative;
        boolean bl = isNegative = number < 0L;
        if (isNegative) {
            number = -number;
        }
        if (this.symbols.multiplier[this.style] != 1 && this.symbols.multiplier[this.style] != 0) {
            long cutoff;
            boolean useDouble = false;
            if (number < 0L) {
                cutoff = Long.MIN_VALUE / (long)this.symbols.multiplier[this.style];
                useDouble = number < cutoff;
            } else {
                cutoff = Long.MAX_VALUE / (long)this.symbols.multiplier[this.style];
                boolean bl2 = useDouble = number > cutoff;
            }
            if (useDouble) {
                double dnumber = isNegative ? -number : number;
                return this.format(dnumber, result);
            }
        }
        number *= (long)this.symbols.multiplier[this.style];
        DigitList digitList = this.digitList;
        synchronized (digitList) {
            this.digitList.set(number, 0);
            return this.subformat(result, isNegative, true);
        }
    }

    private StringBuffer subformat(StringBuffer result, boolean isNegative, boolean isInteger) {
        boolean fractionPresent;
        char decimal;
        char zero = this.symbols.zeroDigit;
        int zeroDelta = zero - 48;
        char grouping = this.symbols.groupingSeparator;
        char c = decimal = this.isCurrencyFormat ? this.symbols.monetarySeparator : this.symbols.decimalSeparator;
        if (this.digitList.isZero()) {
            this.digitList.decimalAt = 0;
        }
        int fieldStart = result.length();
        if (isNegative) {
            result.append(this.symbols.negativePrefix[this.style]);
        } else {
            result.append(this.symbols.positivePrefix[this.style]);
        }
        String prefix = this.symbols.prefixes[this.style];
        result.append(prefix);
        int count = this.symbols.minimumIntegerDigits[this.style];
        int digitIndex = 0;
        if (this.digitList.decimalAt > 0 && count < this.digitList.decimalAt) {
            count = this.digitList.decimalAt;
        }
        if (count > this.symbols.maximumIntegerDigits[this.style]) {
            count = this.symbols.maximumIntegerDigits[this.style];
            digitIndex = this.digitList.decimalAt - count;
        }
        int sizeBeforeIntegerPart = result.length();
        for (int i = count - 1; i >= 0; --i) {
            if (i < this.digitList.decimalAt && digitIndex < this.digitList.count) {
                result.append((char)(this.digitList.digits[digitIndex++] + zeroDelta));
            } else {
                result.append(zero);
            }
            if (!this.symbols.groupingUsed || i <= 0 || this.symbols.groupingCount == 0 || i % this.symbols.groupingCount != 0) continue;
            int gStart = result.length();
            result.append(grouping);
        }
        boolean bl = fractionPresent = this.symbols.minimumFractionDigits[this.style] > 0 || !isInteger && digitIndex < this.digitList.count;
        if (!fractionPresent && result.length() == sizeBeforeIntegerPart) {
            result.append(zero);
        }
        int sStart = result.length();
        if (this.symbols.decimalSeparatorAlwaysShown || fractionPresent) {
            result.append(decimal);
        }
        for (int i = 0; i < this.symbols.maximumFractionDigits[this.style] && (i < this.symbols.minimumFractionDigits[this.style] || !isInteger && digitIndex < this.digitList.count); ++i) {
            if (-1 - i > this.digitList.decimalAt - 1) {
                result.append(zero);
                continue;
            }
            if (!isInteger && digitIndex < this.digitList.count) {
                result.append((char)(this.digitList.digits[digitIndex++] + zeroDelta));
                continue;
            }
            result.append(zero);
        }
        String suffix = this.symbols.suffixes[this.style];
        result.append(suffix);
        if (isNegative) {
            result.append(this.symbols.negativeSuffix[this.style]);
        } else {
            result.append(this.symbols.positiveSuffix[this.style]);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

