/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2me.global;

import com.sun.j2me.global.LocaleHelpers;
import com.sun.j2me.global.ResourceAbstractionLayer;
import com.sun.j2me.global.ResourceManagerFactory;
import javax.microedition.global.ResourceException;

public class ResourceManagerImpl {
    private static ResourceAbstractionLayer abstractionLayer = ResourceAbstractionLayer.getInstance();
    public static final String DEVICE = "";
    protected String baseName;
    protected String locale;

    public static final ResourceManagerImpl getManager(String baseName) throws ResourceException {
        String locale = System.getProperty("microedition.locale");
        if (locale == null) {
            throw new ResourceException(4, "System default locale is undefined");
        }
        return ResourceManagerImpl.getManager(baseName, locale);
    }

    public static final ResourceManagerImpl getManager(String baseName, String locale) throws ResourceException {
        if (baseName == null) {
            throw new NullPointerException("Base name is null");
        }
        if (locale == null) {
            throw new NullPointerException("Locale is null");
        }
        if (!LocaleHelpers.isValidLocale(locale) && !DEVICE.equals(locale)) {
            throw new IllegalArgumentException("Invalid locale format");
        }
        locale = LocaleHelpers.normalizeLocale(locale);
        if (baseName.equals(DEVICE)) {
            ResourceManagerFactory devMFactory = abstractionLayer.getDevResourceManagerFactory();
            return devMFactory.getManager(DEVICE, locale);
        }
        ResourceManagerFactory appMFactory = abstractionLayer.getAppResourceManagerFactory();
        return appMFactory.getManager(baseName, locale);
    }

    public static final ResourceManagerImpl getManager(String baseName, String[] locales) {
        if (baseName == null) {
            throw new NullPointerException("Base name is null");
        }
        if (locales == null) {
            throw new NullPointerException("Locales array is null");
        }
        if (locales.length == 0) {
            throw new IllegalArgumentException("Empty locales array");
        }
        for (int i = 0; i < locales.length; ++i) {
            if (locales[i] == null) {
                throw new NullPointerException("Locale at position " + i + " is null");
            }
            if (LocaleHelpers.isValidLocale(locales[i]) || DEVICE.equals(locales[i])) continue;
            throw new IllegalArgumentException("Locale at position " + i + " has invalid format");
        }
        String[] norm_locs = new String[locales.length];
        for (int i = 0; i < locales.length; ++i) {
            norm_locs[i] = LocaleHelpers.normalizeLocale(locales[i]);
        }
        if (baseName.equals(DEVICE)) {
            ResourceManagerFactory devMFactory = abstractionLayer.getDevResourceManagerFactory();
            return devMFactory.getManager(DEVICE, norm_locs);
        }
        ResourceManagerFactory appMFactory = abstractionLayer.getAppResourceManagerFactory();
        return appMFactory.getManager(baseName, norm_locs);
    }

    public static String[] getSupportedLocales(String baseName) {
        if (baseName == null) {
            throw new NullPointerException("Base name is null");
        }
        if (baseName.equals(DEVICE)) {
            ResourceManagerFactory devMFactory = abstractionLayer.getDevResourceManagerFactory();
            return devMFactory.getSupportedLocales(baseName);
        }
        ResourceManagerFactory appMFactory = abstractionLayer.getAppResourceManagerFactory();
        return appMFactory.getSupportedLocales(baseName);
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getLocale() {
        return this.locale;
    }

    public byte[] getData(int id) throws ResourceException {
        throw new ResourceException(0, DEVICE);
    }

    public String getString(int id) throws ResourceException {
        throw new ResourceException(0, DEVICE);
    }

    public Object getResource(int id) throws ResourceException {
        throw new ResourceException(0, DEVICE);
    }

    public boolean isCaching() {
        return false;
    }

    public boolean isValidResourceID(int id) {
        return false;
    }
}

