/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2me.global;

import com.sun.j2me.global.CollationElementTable;
import com.sun.j2me.global.NormalizationTable;
import com.sun.j2me.global.StringDecomposer;

public class StringCollator
implements StringDecomposer {
    private static final int CAPACITY_INCREMENT = 64;
    private int[] collation = new int[64];
    private int colOffset;
    private int colLength;
    private int[] decomposition = new int[64];
    private int decOffset;
    private int decLength;
    private int maxContraction;
    private StringDecomposer source;
    private CollationElementTable table;
    private int[] savedBookmarks;
    private int[] maxMatch;
    private int[] match;
    private int maxLength;
    private int prefixLength;
    private int maxBookmark;

    public StringCollator(StringDecomposer decomposer, CollationElementTable table) {
        this.source = decomposer;
        this.table = table;
        this.maxContraction = table.getMaxContractionLength();
        this.savedBookmarks = new int[this.maxContraction];
        this.match = new int[this.maxContraction];
        this.maxMatch = new int[this.maxContraction];
    }

    public final void reset() {
        this.decOffset = 0;
        this.decLength = 0;
        this.colOffset = 0;
        this.colLength = 0;
    }

    private final int getNextSourceElement() {
        int ecp;
        if (this.decOffset < this.decLength) {
            return this.decomposition[this.decOffset++];
        }
        do {
            if ((ecp = this.source.getNextElement()) != -1) continue;
            return ecp;
        } while (NormalizationTable.isIgnorable(ecp));
        if (NormalizationTable.hasLogicalOrderException(ecp)) {
            this.decomposition[0] = ecp;
            this.decOffset = 0;
            this.decLength = 1;
            do {
                if ((ecp = this.source.getNextElement()) != -1) continue;
                return this.decomposition[this.decOffset++];
            } while (NormalizationTable.isIgnorable(ecp));
        }
        return ecp;
    }

    private final int peekSourceElement(int offset) {
        int ecp;
        if (this.decOffset + offset < this.decLength) {
            return this.decomposition[this.decOffset + offset];
        }
        do {
            if ((ecp = this.source.getNextElement()) != -1) continue;
            return ecp;
        } while (NormalizationTable.isIgnorable(ecp));
        if ((offset += this.decOffset) + 1 >= this.decomposition.length) {
            offset -= this.decOffset;
            this.decLength -= this.decOffset;
            if (this.decOffset <= 1) {
                int[] newDecomposition = new int[this.decomposition.length + 64];
                System.arraycopy(this.decomposition, this.decOffset, newDecomposition, 0, this.decLength);
                this.decomposition = newDecomposition;
            } else {
                System.arraycopy(this.decomposition, this.decOffset, this.decomposition, 0, this.decLength);
            }
            this.decOffset = 0;
        }
        if (NormalizationTable.hasLogicalOrderException(ecp)) {
            int lastCP = ecp;
            do {
                if ((ecp = this.source.getNextElement()) != -1) continue;
                this.decomposition[offset] = lastCP;
                return lastCP;
            } while (NormalizationTable.isIgnorable(ecp));
            this.decomposition[offset++] = ecp;
            this.decomposition[offset] = lastCP;
            this.decLength += 2;
            return ecp;
        }
        this.decomposition[offset] = ecp;
        ++this.decLength;
        return ecp;
    }

    private final void matchTailAux(int bookmark, int index, int accepted, int lastCC) {
        if (this.prefixLength + accepted >= this.maxContraction) {
            return;
        }
        int ecp = this.peekSourceElement(index);
        if (ecp == -1) {
            return;
        }
        int cc = NormalizationTable.getCombiningClass(ecp);
        while (cc == lastCC) {
            if ((ecp = this.peekSourceElement(++index)) == -1) {
                return;
            }
            cc = NormalizationTable.getCombiningClass(ecp);
        }
        if (cc == 0) {
            return;
        }
        this.matchTailAux(bookmark, index + 1, accepted, cc);
        int bookmark2 = this.table.getChildBookmark(bookmark, NormalizationTable.getCodePoint(ecp));
        if (bookmark2 != -1) {
            int bookmark3;
            this.match[accepted] = ecp;
            this.matchTailAux(bookmark2, index + 1, accepted + 1, lastCC);
            if (accepted + 1 > this.maxLength && (bookmark3 = this.table.getChildBookmark(bookmark2, -1)) != -1) {
                this.maxLength = accepted + 1;
                this.maxBookmark = bookmark3;
                System.arraycopy(this.match, 0, this.maxMatch, 0, this.maxLength);
            }
        }
    }

    private final int matchTail(int bookmark, int index) {
        this.maxLength = 0;
        this.maxBookmark = -1;
        this.prefixLength = index;
        this.matchTailAux(bookmark, index, 0, -1);
        if (this.maxBookmark != -1) {
            this.decOffset += index;
            int length = this.decLength - this.decOffset;
            if (length == this.maxLength) {
                this.decOffset = 0;
                this.decLength = 0;
                return this.maxBookmark;
            }
            int i = 0;
            int k = 0;
            for (int j = 0; j < length; ++j) {
                int cp = this.decomposition[this.decOffset + j];
                if (k < this.maxLength && cp == this.maxMatch[k]) {
                    ++k;
                    continue;
                }
                this.decomposition[i] = cp;
                ++i;
            }
            this.decOffset = 0;
            this.decLength -= this.maxLength + index;
        }
        return this.maxBookmark;
    }

    private final int match(int initialBookmark) {
        int ecp;
        int i;
        int bookmark = initialBookmark;
        for (i = 0; i < this.maxContraction && (ecp = this.peekSourceElement(i)) != -1 && (bookmark = this.table.getChildBookmark(bookmark, NormalizationTable.getCodePoint(ecp))) != -1; ++i) {
            this.savedBookmarks[i] = bookmark;
        }
        do {
            --i;
            while (i >= 0 && !NormalizationTable.isStable(this.decomposition[this.decOffset + i])) {
                --i;
            }
            bookmark = i >= 0 ? this.savedBookmarks[i] : initialBookmark;
            bookmark = this.matchTail(bookmark, i + 1);
            if (bookmark != -1) {
                return bookmark;
            }
            bookmark = i >= 0 ? this.savedBookmarks[i] : initialBookmark;
            if ((bookmark = this.table.getChildBookmark(bookmark, -1)) == -1) continue;
            this.decOffset += i + 1;
            if (this.decOffset == this.decLength) {
                this.decOffset = 0;
                this.decLength = 0;
            }
            return bookmark;
        } while (i > 0);
        return initialBookmark;
    }

    public final int getNextElement() {
        if (this.colOffset < this.colLength) {
            return this.collation[this.colOffset++];
        }
        int value = this.getNextSourceElement();
        if (value == -1) {
            return -1;
        }
        if (CollationElementTable.isBookmark(value = this.table.getCollationElements(this.collation, 0, NormalizationTable.getCodePoint(value)))) {
            value = this.match(value);
            value = this.table.getCollationElements(this.collation, 0, value);
        }
        if (CollationElementTable.isSingleCollationEl(value)) {
            return value;
        }
        this.colOffset = 1;
        this.colLength = value;
        return this.collation[0];
    }
}

