/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2me.global;

import com.sun.j2me.global.CollationElementTable;
import com.sun.j2me.global.CollationElementTableImpl;
import com.sun.j2me.global.CommonStringComparator;
import com.sun.j2me.global.NormalizationTable;
import com.sun.j2me.global.NormalizationTableImpl;
import com.sun.j2me.global.StringCollator;
import com.sun.j2me.global.StringNormalizer;

public class StringComparatorImpl
implements CommonStringComparator {
    private static final int CAPACITY_INCREMENT = 64;
    private int level;
    private int[] buffer1 = new int[64];
    private int[] buffer2 = new int[64];
    int buffersLength = 64;
    private final NormalizationTable nrmTable;
    private final StringNormalizer strNormalizer1;
    private final StringNormalizer strNormalizer2;
    private final StringCollator strCollator1;
    private final StringCollator strCollator2;

    public StringComparatorImpl(String locale, int level) {
        this.level = level;
        CollationElementTableImpl colTable = null;
        this.nrmTable = NormalizationTableImpl.getInstance();
        colTable = CollationElementTableImpl.getInstance(locale);
        this.strNormalizer1 = new StringNormalizer(this.nrmTable);
        this.strCollator1 = new StringCollator(this.strNormalizer1, colTable);
        this.strNormalizer2 = new StringNormalizer(this.nrmTable);
        this.strCollator2 = new StringCollator(this.strNormalizer2, colTable);
    }

    private final boolean isUnsafeCharacter(char c) {
        if ((c & 0xF800) == 55296) {
            return true;
        }
        int value = this.nrmTable.getCanonicalDecomposition(this.buffer1, 0, c);
        if (!NormalizationTable.isSingleCodePoint(value)) {
            return true;
        }
        return NormalizationTable.isUnsafe(value);
    }

    private final int skipBeginning(String s1, String s2) {
        int length = s1.length();
        if (s2.length() < length) {
            length = s2.length();
        }
        if (length == 0) {
            return 0;
        }
        if (s1.charAt(0) != s2.charAt(0)) {
            return 0;
        }
        for (int offset = 1; offset < length; ++offset) {
            if (s1.charAt(offset) == s2.charAt(offset)) continue;
            if (!this.isUnsafeCharacter(s1.charAt(offset)) && !this.isUnsafeCharacter(s2.charAt(offset))) {
                return offset;
            }
            --offset;
            while (offset > 0) {
                if (!this.isUnsafeCharacter(s1.charAt(offset))) {
                    return offset;
                }
                --offset;
            }
            return offset;
        }
        if (length < s1.length()) {
            if (!this.isUnsafeCharacter(s1.charAt(length))) {
                return length;
            }
            --length;
            while (length > 0) {
                if (!this.isUnsafeCharacter(s1.charAt(length))) {
                    return length;
                }
                --length;
            }
            return length;
        }
        if (length < s2.length()) {
            if (!this.isUnsafeCharacter(s2.charAt(length))) {
                return length;
            }
            --length;
            while (length > 0) {
                if (!this.isUnsafeCharacter(s1.charAt(length))) {
                    return length;
                }
                --length;
            }
            return length;
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compare(String s1, String s2) {
        StringComparatorImpl stringComparatorImpl = this;
        synchronized (stringComparatorImpl) {
            int result;
            int value2;
            int value1;
            int offset = this.skipBeginning(s1, s2);
            this.strNormalizer1.setSource(s1, offset);
            this.strNormalizer2.setSource(s2, offset);
            this.strCollator1.reset();
            this.strCollator2.reset();
            int buffered = 0;
            int idx1 = 0;
            int idx2 = 0;
            do {
                if (buffered >= this.buffersLength) {
                    this.buffersLength += 64;
                    int[] newBuffer1 = new int[this.buffersLength];
                    int[] newBuffer2 = new int[this.buffersLength];
                    System.arraycopy(this.buffer1, 0, newBuffer1, 0, buffered);
                    System.arraycopy(this.buffer2, 0, newBuffer2, 0, buffered);
                    this.buffer1 = newBuffer1;
                    this.buffer2 = newBuffer2;
                }
                this.buffer1[buffered] = this.strCollator1.getNextElement();
                this.buffer2[buffered] = this.strCollator2.getNextElement();
                ++buffered;
                value1 = this.buffer1[idx1];
                value2 = this.buffer2[idx2];
                if (value1 != -1) {
                    value1 = CollationElementTable.getL1(value1);
                }
                if (value2 != -1) {
                    value2 = CollationElementTable.getL1(value2);
                }
                if (value1 != 0) {
                    if (value2 != 0) {
                        result = value1 - value2;
                        if (result != 0) {
                            return result;
                        }
                        ++idx1;
                    }
                    ++idx2;
                    continue;
                }
                if (value2 == 0) {
                    ++idx2;
                }
                ++idx1;
            } while (value1 != -1 || value2 != -1);
            if (this.level < 2) {
                return 0;
            }
            idx1 = 0;
            idx2 = 0;
            do {
                value1 = this.buffer1[idx1];
                value2 = this.buffer2[idx2];
                if (value1 != -1) {
                    value1 = CollationElementTable.getL2(value1);
                }
                if (value2 != -1) {
                    value2 = CollationElementTable.getL2(value2);
                }
                if (value1 != 0) {
                    if (value2 != 0) {
                        result = value1 - value2;
                        if (result != 0) {
                            return result;
                        }
                        ++idx1;
                    }
                    ++idx2;
                    continue;
                }
                if (value2 == 0) {
                    ++idx2;
                }
                ++idx1;
            } while (value1 != -1 || value2 != -1);
            if (this.level < 3) {
                return 0;
            }
            idx1 = 0;
            idx2 = 0;
            do {
                value1 = this.buffer1[idx1];
                value2 = this.buffer2[idx2];
                if (value1 != -1) {
                    value1 = CollationElementTable.getL3(value1);
                }
                if (value2 != -1) {
                    value2 = CollationElementTable.getL3(value2);
                }
                if (value1 != 0) {
                    if (value2 != 0) {
                        result = value1 - value2;
                        if (result != 0) {
                            return result;
                        }
                        ++idx1;
                    }
                    ++idx2;
                    continue;
                }
                if (value2 == 0) {
                    ++idx2;
                }
                ++idx1;
            } while (value1 != -1 || value2 != -1);
            if (this.level == 15) {
                this.strNormalizer1.reset();
                this.strNormalizer2.reset();
                do {
                    value1 = this.strNormalizer1.getNextElement();
                    value2 = this.strNormalizer2.getNextElement();
                    if (value1 != -1) {
                        value1 = NormalizationTable.getCodePoint(value1);
                    }
                    if (value2 != -1) {
                        value2 = NormalizationTable.getCodePoint(value2);
                    }
                    if ((result = value1 - value2) == 0) continue;
                    return result;
                } while (value1 != -1 || value2 != -1);
            }
        }
        return 0;
    }

    public boolean equals(String s1, String s2) {
        return this.compare(s1, s2) == 0;
    }
}

