/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2me.global;

import com.sun.j2me.global.NormalizationTable;
import com.sun.j2me.global.StringDecomposer;

public final class StringNormalizer
implements StringDecomposer {
    private static final int CAPACITY_INCREMENT = 64;
    private int[] decomposition = new int[64];
    private int decOffset;
    private int decLength;
    private int strOffset;
    private int strLength;
    private int strInitOffset;
    private int maxDecomposition;
    private String source;
    private NormalizationTable table;

    public StringNormalizer(NormalizationTable table) {
        this.table = table;
        this.maxDecomposition = table.getMaxDecompositionLength();
    }

    public StringNormalizer(String s, NormalizationTable table) {
        this(table);
        this.source = s;
        this.strLength = s.length();
    }

    public final void setSource(String s) {
        this.source = s;
        this.strLength = s.length();
        this.strInitOffset = 0;
        this.reset();
    }

    public final void setSource(String s, int offset) {
        this.source = s;
        this.strLength = s.length();
        this.strInitOffset = offset;
        this.reset();
    }

    public final void reset() {
        this.decOffset = 0;
        this.decLength = 0;
        this.strOffset = this.strInitOffset;
    }

    public final int nextUTF32() {
        char cp2;
        int cp;
        if (this.strOffset >= this.strLength) {
            return -1;
        }
        if (((cp = this.source.charAt(this.strOffset++)) & 0xFC00) == 55296 && this.strOffset < this.strLength && ((cp2 = this.source.charAt(this.strOffset)) & 0xFC00) == 56320) {
            int wwww = cp >> 6 & 0xF;
            cp = wwww + 1 << 16 | (cp & 0x3F) << 10 | cp2 & 0x3FF;
            ++this.strOffset;
        }
        return cp;
    }

    public int getNextElement() {
        boolean checkOrder;
        if (this.decOffset < this.decLength) {
            return this.decomposition[this.decOffset++];
        }
        int value = this.nextUTF32();
        if (value == -1) {
            return -1;
        }
        if (NormalizationTable.isSingleCodePoint(value = this.table.getCanonicalDecomposition(this.decomposition, 0, value))) {
            if (NormalizationTable.isStable(value)) {
                return value;
            }
            this.decomposition[0] = value;
            this.decLength = 1;
        } else {
            this.decLength = value;
        }
        this.decOffset = 0;
        value = this.nextUTF32();
        while (value != -1) {
            if (this.decLength + this.maxDecomposition > this.decomposition.length) {
                int[] newDecomposition = new int[this.decomposition.length + 64];
                System.arraycopy(this.decomposition, 0, newDecomposition, 0, this.decLength);
                this.decomposition = newDecomposition;
            }
            if (NormalizationTable.isSingleCodePoint(value = this.table.getCanonicalDecomposition(this.decomposition, this.decLength, value))) {
                this.decomposition[this.decLength++] = value;
                if (NormalizationTable.isStable(value)) {
                    break;
                }
            } else {
                this.decLength += value;
            }
            value = this.nextUTF32();
        }
        do {
            checkOrder = false;
            for (int i = 1; i < this.decLength; ++i) {
                int cc2;
                int cp1 = this.decomposition[i - 1];
                int cp2 = this.decomposition[i];
                int cc1 = NormalizationTable.getCombiningClass(cp1);
                if (cc1 <= (cc2 = NormalizationTable.getCombiningClass(cp2)) || cc2 == 0) continue;
                this.decomposition[i - 1] = cp2;
                this.decomposition[i] = cp1;
                checkOrder = true;
            }
        } while (checkOrder);
        if (this.decLength > 0) {
            return this.decomposition[this.decOffset++];
        }
        return -1;
    }
}

