/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2me.payment;

import com.sun.j2me.payment.PaymentAdapter;
import com.sun.j2me.payment.PaymentException;
import com.sun.j2me.payment.Transaction;
import com.sun.midp.security.SecurityToken;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.wireless.messaging.BinaryMessage;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;

public class PPSMSAdapter
extends PaymentAdapter {
    private static final int SMS_LENGTH = 140;
    private static SecurityToken classSecurityToken;

    public static void initSecurityToken(SecurityToken token) {
        if (classSecurityToken != null) {
            return;
        }
        classSecurityToken = token;
    }

    private PPSMSAdapter() {
    }

    public String getDisplayName() {
        return "Premium Priced SMS";
    }

    public static PPSMSAdapter getInstance(String configuration) {
        return new PPSMSAdapter();
    }

    public void validatePriceInfo(double price, String paySpecificPriceInfo) throws PaymentException {
        if (paySpecificPriceInfo == null || paySpecificPriceInfo.length() == 0 || this.parseAndValidateSpecInfo(paySpecificPriceInfo) == null) {
            throw new PaymentException(10, paySpecificPriceInfo);
        }
    }

    private Object[] parseAndValidateSpecInfo(String paySpecificInfo) {
        Object[] info = null;
        int firstIndex = paySpecificInfo.indexOf(44);
        if (firstIndex == -1) {
            return null;
        }
        int lastIndex = paySpecificInfo.lastIndexOf(44);
        String msisdn = paySpecificInfo.substring(0, firstIndex).trim();
        try {
            long i = msisdn.startsWith("+") ? Long.parseLong(msisdn.substring(1)) : Long.parseLong(msisdn);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        String prefix = "";
        String smsCount = null;
        if (firstIndex == lastIndex) {
            prefix = paySpecificInfo.substring(firstIndex + 1, paySpecificInfo.length()).trim();
        } else {
            prefix = paySpecificInfo.substring(firstIndex + 1, lastIndex).trim();
            smsCount = paySpecificInfo.substring(lastIndex + 1, paySpecificInfo.length()).trim();
        }
        if (!prefix.equals("")) {
            int maxLength = 8;
            if (prefix.startsWith("0x") || prefix.startsWith("0X")) {
                maxLength = 18;
                try {
                    if (prefix.length() >= maxLength) {
                        Long.parseLong(prefix.substring(2, 9), 16);
                        Long.parseLong(prefix.substring(10), 16);
                    } else {
                        Long.parseLong(prefix.substring(2), 16);
                    }
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
                if (prefix.length() % 2 != 0) {
                    return null;
                }
            }
            if (prefix.length() > maxLength) {
                return null;
            }
        }
        if (smsCount == null) {
            info = new Object[2];
        } else {
            info = new Object[3];
            try {
                info[2] = Integer.valueOf(smsCount);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        info[0] = msisdn;
        info[1] = prefix;
        return info;
    }

    public Transaction process(Transaction transaction) {
        switch (transaction.getState()) {
            case 2: {
                PPSMSThread thread = new PPSMSThread(transaction);
                transaction.setWaiting(true);
                thread.start();
                break;
            }
            default: {
                return super.process(transaction);
            }
        }
        return transaction;
    }

    public static byte[] hexToBytes(String s) {
        char[] hex = s.toCharArray();
        int length = hex.length / 2;
        byte[] raw = new byte[length];
        for (int i = 0; i < length; ++i) {
            int high = Character.digit(hex[i * 2], 16);
            int low = Character.digit(hex[i * 2 + 1], 16);
            int value = high << 4 | low;
            raw[i] = (byte)value;
        }
        return raw;
    }

    private class ErrorForm
    extends Form
    implements CommandListener {
        private Transaction transaction;
        private final Command okCommand = new Command("Ok", 4, 1);

        public ErrorForm(Transaction transaction) {
            super("Communication Error!");
            this.append("The Premium Priced SMS cannot be sent");
            this.transaction = transaction;
            this.addCommand(this.okCommand);
            this.setCommandListener(this);
        }

        public void commandAction(Command c, Displayable d) {
            PPSMSAdapter.this.preemptDisplay(classSecurityToken, null);
            this.transaction.setState(4);
            this.transaction.setNeedsUI(false);
        }
    }

    private class PPSMSThread
    extends Thread {
        private Transaction transaction;

        public PPSMSThread(Transaction transaction) {
            this.transaction = transaction;
        }

        public void run() {
            byte[] payload = this.transaction.getPayload();
            Object[] specInfo = PPSMSAdapter.this.parseAndValidateSpecInfo(this.transaction.getSpecificPriceInfo());
            String msisdn = (String)specInfo[0];
            String prefix = (String)specInfo[1];
            int smsCount = 1;
            if (specInfo.length > 2) {
                smsCount = (Integer)specInfo[2];
            }
            try {
                byte[] prefixBytes;
                BinaryMessage msg = null;
                MessageConnection conn = (MessageConnection)Connector.open((String)("sms://" + msisdn));
                if (prefix.startsWith("0x") || prefix.startsWith("0X")) {
                    prefixBytes = PPSMSAdapter.hexToBytes(prefix.substring(2));
                    System.err.println("Prefix: " + new String(prefixBytes));
                } else {
                    prefixBytes = prefix.getBytes("UTF-8");
                }
                int messageLength = prefixBytes.length + (payload == null ? 0 : payload.length);
                if (messageLength > 140) {
                    throw new Exception("Message to be sent is too long");
                }
                byte[] message = new byte[messageLength];
                System.arraycopy(prefixBytes, 0, message, 0, prefixBytes.length);
                if (payload != null) {
                    System.arraycopy(payload, 0, message, prefixBytes.length, payload.length);
                }
                msg = (BinaryMessage)conn.newMessage("binary");
                msg.setPayloadData(message);
                for (int i = 0; i < smsCount; ++i) {
                    conn.send((Message)msg);
                }
                conn.close();
                this.transaction.setState(3);
            }
            catch (Exception e) {
                this.transaction.setState(4);
            }
            this.transaction.setWaiting(false);
        }
    }
}

