/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2me.payment;

public class PaymentException
extends Exception {
    public static final int UNSUPPORTED_PAYMENT_INFO = 0;
    public static final int MISSING_MANDATORY_ATTRIBUTE = 1;
    public static final int INVALID_ATTRIBUTE_VALUE = 2;
    public static final int UNSUPPORTED_ADAPTERS = 3;
    public static final int UNSUPPORTED_PROVIDERS = 4;
    public static final int UNSUPPORTED_URL_SCHEME = 5;
    public static final int INFORMATION_NOT_YET_VALID = 6;
    public static final int INFORMATION_EXPIRED = 7;
    public static final int INCOMPLETE_INFORMATION = 8;
    public static final int INVALID_ADAPTER_CONFIGURATION = 9;
    public static final int INVALID_PRICE_INFORMATION = 10;
    public static final int INVALID_UPDATE_URL = 11;
    public static final int UPDATE_SERVER_NOT_FOUND = 12;
    public static final int UPDATE_NOT_FOUND = 13;
    public static final int UPDATE_SERVER_BUSY = 14;
    public static final int UPDATE_REQUEST_ERROR = 15;
    public static final int INVALID_UPDATE_TYPE = 16;
    public static final int UNSUPPORTED_UPDATE_CHARSET = 17;
    public static final int EXPIRED_PROVIDER_CERT = 18;
    public static final int EXPIRED_CA_CERT = 19;
    public static final int INVALID_PROVIDER_CERT = 20;
    public static final int NO_TRUSTED_CHAIN = 21;
    public static final int SIGNATURE_VERIFICATION_FAILED = 22;
    public static final int INVALID_PROPERTIES_FORMAT = 23;
    private int reason;
    private String param;

    public PaymentException(int reason) {
        this.reason = reason;
    }

    public PaymentException(int reason, String detail) {
        super(detail);
        this.reason = reason;
    }

    public PaymentException(int reason, String param, String detail) {
        super(detail);
        this.reason = reason;
        this.param = param;
    }

    public final int getReason() {
        return this.reason;
    }

    public final void setParam(String param) {
        this.param = param;
    }

    public final String getParam() {
        return this.param;
    }

    public final String getDetail() {
        return super.getMessage();
    }

    public final String getMessage() {
        String message;
        switch (this.reason) {
            case 0: {
                message = "Unsupported version of the payment information (" + this.param + ")";
                break;
            }
            case 1: {
                message = "The required " + this.param + " attribute is missing";
                break;
            }
            case 2: {
                message = "The " + this.param + " attribute contains an " + "invalid value";
                if (super.getMessage() == null) break;
                message = message + " (" + super.getMessage() + ")";
                break;
            }
            case 3: {
                message = "None of the adapters is supported (" + this.param + ")";
                break;
            }
            case 4: {
                message = "None of the providers is supported (" + this.param + ")";
                break;
            }
            case 5: {
                message = "The update URL has an unsupported scheme (" + this.param + ")";
                break;
            }
            case 6: {
                message = "Payment information is not yet valid";
                break;
            }
            case 7: {
                message = "Payment information is expired";
                break;
            }
            case 8: {
                message = "The payment information is incomplete";
                break;
            }
            case 9: {
                message = "The " + this.param + " attribute contains an " + "invalid adapter configuration string";
                if (super.getMessage() == null) break;
                message = message + " (" + super.getMessage() + ")";
                break;
            }
            case 10: {
                message = "The " + this.param + " attribute contains " + "invalid payment specific price information";
                if (super.getMessage() == null) break;
                message = message + " (" + super.getMessage() + ")";
                break;
            }
            case 11: {
                message = "The update URL " + this.param + " is invalid";
                break;
            }
            case 12: {
                message = "The server for the payment update was not found at the URL " + this.param;
                break;
            }
            case 13: {
                message = "The payment update file was not found at the URL " + this.param;
                break;
            }
            case 14: {
                message = "The payment update server is busy";
                break;
            }
            case 15: {
                message = "The payment update request has been denied by the update server (HTTP response code = " + this.param + ")";
                break;
            }
            case 16: {
                message = "The payment update file has a missing or incorrect type (" + this.param + ")";
                break;
            }
            case 17: {
                message = "The payment update file is in an unsupported character set (" + this.param + ")";
                break;
            }
            case 18: {
                message = "The provider certificate (" + this.param + ") is " + "expired or not yet valid";
                break;
            }
            case 19: {
                message = "The root CA's public key expired (" + this.param + ")";
                break;
            }
            case 20: {
                message = "The provider certificate (" + this.param + ") is " + "invalid or unsupported";
                break;
            }
            case 21: {
                message = "Can't verify any provider certificate";
                break;
            }
            case 22: {
                message = "Verification of the payment update signature failed";
                break;
            }
            case 23: {
                message = "The payment update file is not a valid properties file";
                if (super.getMessage() == null) break;
                message = message + " (" + super.getMessage() + ")";
                break;
            }
            default: {
                message = super.getMessage();
            }
        }
        return message;
    }
}

