/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2me.payment;

import com.sun.j2me.payment.PaymentAdapter;
import com.sun.j2me.payment.PaymentException;
import com.sun.j2me.payment.PaymentModule;
import com.sun.j2me.payment.ProviderInfo;
import com.sun.j2me.payment.Utils;
import com.sun.midp.io.Base64;
import com.sun.midp.io.HttpUrl;
import com.sun.midp.io.Properties;
import com.sun.midp.io.Util;
import com.sun.midp.publickeystore.PublicKeyInfo;
import com.sun.midp.publickeystore.WebPublicKeyStore;
import com.sun.midp.security.Permissions;
import com.sun.midp.ssl.CryptoException;
import com.sun.midp.ssl.PublicKey;
import com.sun.midp.ssl.Signature;
import com.sun.midp.ssl.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Date;
import java.util.Vector;
import javax.microedition.pki.CertificateException;

public final class PaymentInfo {
    public static final int AUTO_REQUEST_OFF = 0;
    public static final int AUTO_REQUEST_ACCEPT = 1;
    public static final int AUTO_REQUEST_REJECT = 2;
    private static final String PAY_VERSION = "Pay-Version";
    private static final String PAY_ADAPTERS = "Pay-Adapters";
    private static final String PAY_DBG_DEMOMODE = "Pay-Debug-DemoMode";
    private static final String PAY_DBG_FAILINITIALIZE = "Pay-Debug-FailInitialize";
    private static final String PAY_DBG_FAILIO = "Pay-Debug-FailIO";
    private static final String PAY_DBG_MISSEDTRANSACTIONS = "Pay-Debug-MissedTransactions";
    private static final String PAY_DBG_RANDOMTESTS = "Pay-Debug-RandomTests";
    private static final String PAY_DBG_AUTOREQUESTMODE = "Pay-Debug-AutoRequestMode";
    private static final String PAY_DBG_NOADAPTER = "Pay-Debug-NoAdapter";
    private static final String PAY_UPDATE_DATE = "Pay-Update-Date";
    private static final String PAY_UPDATE_STAMP = "Pay-Update-Stamp";
    private static final String PAY_UPDATE_URL = "Pay-Update-URL";
    private static final String PAY_CACHE = "Pay-Cache";
    private static final String PAY_PROVIDERS = "Pay-Providers";
    private static final String PAY_PREFIX = "Pay-";
    private static final String PAY_FEATURE_PREFIX = "Pay-Feature-";
    private static final String INFO_SUFFIX = "-Info";
    private static final String TAG = "-Tag-";
    private static final String PAY_CERTIFICATE_PREFIX = "Pay-Certificate-";
    private static final String PAY_SIGNATURE_PREFIX = "Pay-Signature-";
    private static final String PAY_SIGNATURE_RSA_SHA1 = "Pay-Signature-RSA-SHA1";
    private static final String[] VALID_ADAPTER_NAMES = new String[]{"PPSMS"};
    private static final String YES_VALUE = "yes";
    private static final String NO_VALUE = "no";
    private static final String[] YES_NO_OPTIONS = new String[]{"yes", "no"};
    private static final String[] ACCEPT_REJECT_OPTIONS = new String[]{"accept", "reject"};
    private static final Utils utilities = PaymentModule.getInstance().getUtilities();
    private int version;
    private String[] adapters;
    private boolean dbgDemoMode;
    private boolean dbgFailInitialize;
    private boolean dbgFailIO;
    private int dbgMissedTransactions;
    private boolean dbgRandomTests;
    private int dbgAutoRequestMode;
    private boolean dbgNoAdapter;
    private Date updateDate;
    private Date updateStamp;
    private String updateURL;
    private boolean cache;
    private Date expirationDate;
    private int[] featureToTag;
    private ProviderInfo[] providers;
    private static final char[][] PKI_PREFIXES = new char[][]{"Pay-Certificate-".toCharArray(), "Pay-Signature-".toCharArray()};

    private PaymentInfo() {
    }

    public static PaymentInfo createFromProperties(Properties jadProperties, Properties jarProperties) throws PaymentException {
        PaymentInfo paymentInfo = new PaymentInfo();
        paymentInfo.loadFromJadProperties(jadProperties);
        paymentInfo.loadFromJarProperties(jarProperties);
        return paymentInfo;
    }

    public static void validateJadProperties(Properties jadProperties) throws PaymentException {
        PaymentInfo paymentInfo = new PaymentInfo();
        paymentInfo.loadFromJadProperties(jadProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePaymentInfo(byte[] data, String charset) throws PaymentException {
        byte[] testData;
        byte[] signature;
        PublicKey publicKey;
        Properties props;
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        try {
            try {
                props = utilities.loadProperties(bis, charset);
            }
            finally {
                ((InputStream)bis).close();
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new PaymentException(17, charset, null);
        }
        catch (IOException e) {
            throw new PaymentException(23, e.getMessage());
        }
        X509Certificate trustedCertificate = PaymentInfo.findTrustedCertificate(props);
        try {
            publicKey = trustedCertificate.getPublicKey();
        }
        catch (CertificateException e) {
            throw new PaymentException(20, trustedCertificate.getSubject(), null);
        }
        String encodedSignature = props.getProperty(PAY_SIGNATURE_RSA_SHA1);
        if (encodedSignature == null) {
            throw new PaymentException(1, PAY_SIGNATURE_RSA_SHA1, null);
        }
        try {
            signature = Base64.decode(encodedSignature);
        }
        catch (IOException e) {
            throw new PaymentException(2, PAY_SIGNATURE_RSA_SHA1, "invalid or unsupported signature");
        }
        try {
            String propString = new String(data, charset);
            testData = PaymentInfo.removePKIProperties(propString).getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new PaymentException(17, charset, null);
        }
        try {
            Signature sigVerifier = Signature.getInstance((byte)2, false);
            sigVerifier.init(publicKey, (byte)2);
            if (!sigVerifier.verify(testData, 0, testData.length, signature, 0, (short)signature.length)) {
                throw new PaymentException(22);
            }
        }
        catch (CryptoException e) {
            throw new PaymentException(22);
        }
        this.loadFromJppProperties(props);
        this.updateDate = new Date();
    }

    public void export(Writer os) throws IOException {
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append(PAY_VERSION);
        buffer.append(": ");
        buffer.append(this.version >> 8 & 0xFF);
        buffer.append('.');
        buffer.append(this.version & 0xFF);
        buffer.append("\n");
        if (this.updateDate != null) {
            buffer.append(PAY_UPDATE_DATE);
            buffer.append(": ");
            buffer.append(utilities.formatISODate(this.updateDate.getTime()));
            buffer.append("\n");
        }
        buffer.append(PAY_UPDATE_STAMP);
        buffer.append(": ");
        buffer.append(utilities.formatISODate(this.updateStamp.getTime()));
        buffer.append("\n");
        buffer.append(PAY_UPDATE_URL);
        buffer.append(": ");
        buffer.append(this.updateURL);
        buffer.append("\n");
        buffer.append(PAY_CACHE);
        buffer.append(": ");
        if (this.expirationDate != null) {
            buffer.append(utilities.formatISODate(this.expirationDate.getTime()));
        } else {
            buffer.append(this.cache ? YES_VALUE : NO_VALUE);
        }
        buffer.append("\n");
        for (i = 0; i < this.featureToTag.length; ++i) {
            buffer.append(PAY_FEATURE_PREFIX);
            buffer.append(i);
            buffer.append(": ");
            buffer.append(this.featureToTag[i]);
            buffer.append("\n");
        }
        os.write(buffer.toString());
        buffer.setLength(0);
        buffer.append(PAY_PROVIDERS);
        buffer.append(": ");
        buffer.append(this.providers[0].getName());
        for (i = 1; i < this.providers.length; ++i) {
            buffer.append(", ");
            buffer.append(this.providers[i].getName());
        }
        buffer.append("\n");
        for (i = 0; i < this.providers.length; ++i) {
            this.exportProvider(buffer, this.providers[i]);
        }
        os.write(buffer.toString());
    }

    public boolean needsUpdate() {
        long currentTime;
        if (!this.cache) {
            return true;
        }
        if (this.expirationDate != null && (currentTime = System.currentTimeMillis()) > this.expirationDate.getTime()) {
            return true;
        }
        for (int i = 0; i < this.providers.length; ++i) {
            if (this.providers[i].getNumPriceTags() != 0) continue;
            return true;
        }
        return false;
    }

    public boolean cache() {
        return this.cache;
    }

    public boolean isDemoMode() {
        return this.dbgDemoMode;
    }

    public boolean getDbgFailInitialize() {
        return this.dbgFailInitialize;
    }

    public boolean getDbgFailIO() {
        return this.dbgFailIO;
    }

    public int getDbgMissedTransactions() {
        return this.dbgMissedTransactions;
    }

    public boolean getDbgRandomTests() {
        return this.dbgRandomTests;
    }

    public int getDbgAutoRequestMode() {
        return this.dbgAutoRequestMode;
    }

    public boolean getDbgNoAdapter() {
        return this.dbgNoAdapter;
    }

    public String getUpdateURL() {
        return this.updateURL;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public Date getUpdateStamp() {
        return this.updateStamp;
    }

    public int getNumFeatures() {
        return this.featureToTag.length;
    }

    public int getPriceTagForFeature(int index) {
        return this.featureToTag[index];
    }

    public int getNumProviders() {
        return this.providers.length;
    }

    public ProviderInfo getProvider(int index) {
        return this.providers[index];
    }

    private boolean hasDuplicates(Vector vector) {
        int lastIndex = vector.size() - 1;
        for (int i = 0; i < lastIndex; ++i) {
            if (vector.indexOf(vector.elementAt(i), i + 1) == -1) continue;
            return true;
        }
        return false;
    }

    private String[] toStringArray(Vector vector) {
        Object[] strings = new String[vector.size()];
        vector.copyInto(strings);
        return strings;
    }

    private boolean validateAdapterName(String name) {
        if (name.startsWith("X-")) {
            return name.length() > 2;
        }
        for (int i = 0; i < VALID_ADAPTER_NAMES.length; ++i) {
            if (!VALID_ADAPTER_NAMES[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean validateCurrencyCode(String name) {
        if (name.length() != 3) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            if (name.charAt(i) >= 'A' && name.charAt(i) <= 'Z') continue;
            return false;
        }
        return true;
    }

    private int readOptionalSelection(Properties props, String attribute, String[] options, int defValue) throws PaymentException {
        int i;
        String value = props.getProperty(attribute);
        if (value == null) {
            return defValue;
        }
        for (int i2 = 0; i2 < options.length; ++i2) {
            if (!options[i2].equals(value)) continue;
            return i2;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("expecting ");
        buffer.append(options[0]);
        for (i = 1; i < options.length - 1; ++i) {
            buffer.append(", ");
            buffer.append(options[i]);
        }
        buffer.append(" or ");
        buffer.append(options[i]);
        throw new PaymentException(2, attribute, buffer.toString());
    }

    private int parseVersion(String value) throws PaymentException {
        try {
            int dotIndex = value.indexOf(46);
            if (dotIndex != -1) {
                int major = Integer.parseInt(value.substring(0, dotIndex));
                int minor = Integer.parseInt(value.substring(dotIndex + 1));
                return major << 8 | minor & 0xFF;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        throw new PaymentException(2, "expecting <major>.<minor>");
    }

    private void loadFromJadProperties(Properties props) throws PaymentException {
        String payVersion = props.getProperty(PAY_VERSION);
        String payAdapters = props.getProperty(PAY_ADAPTERS);
        int versionNumber = 256;
        if (payVersion != null) {
            try {
                versionNumber = this.parseVersion(payVersion);
            }
            catch (PaymentException e) {
                e.setParam(PAY_VERSION);
                throw e;
            }
            if (versionNumber != 256 && versionNumber != 257) {
                throw new PaymentException(0, PAY_VERSION, null);
            }
            if (payAdapters == null) {
                throw new PaymentException(1, PAY_ADAPTERS, null);
            }
        } else if (payAdapters != null) {
            throw new PaymentException(1, PAY_VERSION, null);
        }
        String[] adapters = null;
        if (payVersion != null) {
            Vector names = Util.getCommaSeparatedValues(payAdapters);
            if (names.size() == 0) {
                throw new PaymentException(2, PAY_ADAPTERS, "the value is empty");
            }
            if (this.hasDuplicates(names)) {
                throw new PaymentException(2, PAY_ADAPTERS, "duplicate fields in the value");
            }
            adapters = this.toStringArray(names);
            for (int i = 0; i < adapters.length; ++i) {
                if (this.validateAdapterName(adapters[i])) continue;
                throw new PaymentException(2, PAY_ADAPTERS, adapters[i] + " is not a valid " + "adapter name");
            }
        }
        boolean dbgDemoMode = this.readOptionalSelection(props, PAY_DBG_DEMOMODE, YES_NO_OPTIONS, 1) != 1;
        boolean dbgFailInitialize = this.readOptionalSelection(props, PAY_DBG_FAILINITIALIZE, YES_NO_OPTIONS, 1) != 1;
        boolean dbgFailIO = this.readOptionalSelection(props, PAY_DBG_FAILIO, YES_NO_OPTIONS, 1) != 1;
        int dbgMissedTransactions = -1;
        boolean dbgRandomTests = this.readOptionalSelection(props, PAY_DBG_RANDOMTESTS, YES_NO_OPTIONS, 1) != 1;
        int dbgAutoRequestMode = this.readOptionalSelection(props, PAY_DBG_AUTOREQUESTMODE, ACCEPT_REJECT_OPTIONS, -1) + 1;
        boolean dbgNoAdapter = this.readOptionalSelection(props, PAY_DBG_NOADAPTER, YES_NO_OPTIONS, 1) != 1;
        String dbgMissedTransactionsStr = props.getProperty(PAY_DBG_MISSEDTRANSACTIONS);
        if (dbgMissedTransactionsStr != null) {
            try {
                dbgMissedTransactions = Integer.parseInt(dbgMissedTransactionsStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (dbgMissedTransactions < 0) {
                throw new PaymentException(2, PAY_DBG_MISSEDTRANSACTIONS, "expecting a positive number");
            }
        }
        this.version = versionNumber;
        this.adapters = adapters;
        this.dbgDemoMode = dbgDemoMode;
        this.dbgFailInitialize = dbgFailInitialize;
        this.dbgFailIO = dbgFailIO;
        this.dbgMissedTransactions = dbgMissedTransactions;
        this.dbgRandomTests = dbgRandomTests;
        this.dbgAutoRequestMode = dbgAutoRequestMode;
        this.dbgNoAdapter = dbgNoAdapter;
    }

    private ProviderInfo loadProvider(Properties props, String provider) throws PaymentException {
        String tempKey = PAY_PREFIX + provider + INFO_SUFFIX;
        String tempValue = props.getProperty(tempKey);
        if (tempValue == null) {
            throw new PaymentException(1, tempKey, null);
        }
        int offset = 0;
        int index = tempValue.indexOf(44);
        if (index == -1) {
            throw new PaymentException(2, tempKey, "the currency code is not present");
        }
        String adapter = tempValue.substring(offset, index).trim();
        if (!this.validateAdapterName(adapter)) {
            throw new PaymentException(2, tempKey, adapter + " is not a valid adapter name");
        }
        offset = index + 1;
        String currency = (index = tempValue.indexOf(44, offset)) == -1 ? tempValue.substring(offset).trim() : tempValue.substring(offset, index).trim();
        if (!this.validateCurrencyCode(currency)) {
            throw new PaymentException(2, tempKey, "not a valid currency code");
        }
        if (index == -1) {
            throw new PaymentException(2, tempKey, "the payment specific info is not present");
        }
        offset = index + 1;
        String configuration = tempValue.substring(offset).trim();
        tempKey = PAY_PREFIX + provider + TAG;
        tempValue = props.getProperty(tempKey + 0);
        double[] prices = null;
        String[] paySpecificPriceInfo = null;
        if (tempValue != null) {
            int numTags = 0;
            Vector<String> tempVector = new Vector<String>();
            do {
                tempVector.addElement(tempValue);
            } while ((tempValue = props.getProperty(tempKey + ++numTags)) != null);
            prices = new double[numTags];
            paySpecificPriceInfo = new String[numTags];
            for (int i = 0; i < numTags; ++i) {
                tempValue = (String)tempVector.elementAt(i);
                index = tempValue.indexOf(44);
                try {
                    String tempPrice = index == -1 ? tempValue.trim() : tempValue.substring(0, index).trim();
                    prices[i] = Double.parseDouble(tempPrice);
                }
                catch (NumberFormatException e) {
                    throw new PaymentException(2, tempKey + i, "invalid price");
                }
                if (index == -1) continue;
                paySpecificPriceInfo[i] = tempValue.substring(index + 1).trim();
            }
        }
        return new ProviderInfo(provider, adapter, configuration, currency, prices, paySpecificPriceInfo);
    }

    private void loadFromPropertiesAux(Properties props, boolean strict) throws PaymentException {
        Date updateStamp;
        int versionNumber;
        long currentTime = System.currentTimeMillis();
        String tempValue = props.getProperty(PAY_VERSION);
        if (tempValue == null) {
            throw new PaymentException(1, PAY_VERSION, null);
        }
        try {
            versionNumber = this.parseVersion(tempValue);
        }
        catch (PaymentException e) {
            e.setParam(PAY_VERSION);
            throw e;
        }
        if (versionNumber != 256 && versionNumber != 257) {
            throw new PaymentException(0, PAY_VERSION, null);
        }
        tempValue = props.getProperty(PAY_UPDATE_STAMP);
        if (tempValue == null) {
            throw new PaymentException(1, PAY_UPDATE_STAMP, null);
        }
        try {
            long millis = utilities.parseISODate(tempValue);
            if (millis > currentTime) {
                throw new PaymentException(6);
            }
            updateStamp = new Date(millis);
        }
        catch (IllegalArgumentException e) {
            throw new PaymentException(2, PAY_UPDATE_STAMP, e.getMessage());
        }
        String updateURL = props.getProperty(PAY_UPDATE_URL);
        if (updateURL == null) {
            throw new PaymentException(1, PAY_UPDATE_URL, null);
        }
        try {
            HttpUrl tempURL = new HttpUrl(updateURL);
            if (!"http".equals(tempURL.scheme) && !"https".equals(tempURL.scheme)) {
                throw new PaymentException(5, tempURL.scheme, null);
            }
        }
        catch (IllegalArgumentException e) {
            throw new PaymentException(2, PAY_UPDATE_URL, e.getMessage());
        }
        tempValue = props.getProperty(PAY_CACHE);
        boolean cache = true;
        Date expirationDate = null;
        if (tempValue != null) {
            if (YES_VALUE.equals(tempValue)) {
                cache = true;
            } else if (NO_VALUE.equals(tempValue)) {
                cache = false;
            } else {
                try {
                    long millis = utilities.parseISODate(tempValue);
                    if (strict && millis < currentTime) {
                        throw new PaymentException(7);
                    }
                    expirationDate = new Date(millis);
                }
                catch (IllegalArgumentException e) {
                    throw new PaymentException(2, PAY_CACHE, "expecting yes, no or a valid date");
                }
            }
        }
        Vector<String> tempVector = new Vector<String>();
        tempValue = props.getProperty("Pay-Feature-0");
        if (tempValue == null) {
            throw new PaymentException(1, "Pay-Feature-0", null);
        }
        int index = 0;
        tempVector.setSize(0);
        do {
            tempVector.addElement(tempValue);
        } while ((tempValue = props.getProperty(PAY_FEATURE_PREFIX + ++index)) != null);
        int maxTag = 0;
        int[] featureToTag = new int[index];
        for (int i = 0; i < index; ++i) {
            int value = -1;
            try {
                value = Integer.parseInt((String)tempVector.elementAt(i));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (value < 0) {
                throw new PaymentException(2, PAY_FEATURE_PREFIX + i, "expecting a positive number");
            }
            if (maxTag < value) {
                maxTag = value;
            }
            featureToTag[i] = value;
        }
        tempValue = props.getProperty(PAY_PROVIDERS);
        if (tempValue == null) {
            throw new PaymentException(1, PAY_PROVIDERS, null);
        }
        Vector names = Util.getCommaSeparatedValues(tempValue);
        if (names.size() == 0) {
            throw new PaymentException(2, PAY_PROVIDERS, "the value is empty");
        }
        if (this.hasDuplicates(names)) {
            throw new PaymentException(2, PAY_PROVIDERS, "duplicate fields in the value");
        }
        ProviderInfo[] providers = new ProviderInfo[names.size()];
        int numTags = maxTag + 1;
        boolean hasSupportedProvider = false;
        PaymentModule paymentModule = PaymentModule.getInstance();
        for (int i = 0; i < providers.length; ++i) {
            PaymentAdapter adapter;
            ProviderInfo provider = this.loadProvider(props, (String)names.elementAt(i));
            if ((strict || provider.getNumPriceTags() != 0) && provider.getNumPriceTags() < numTags) {
                throw new PaymentException(8);
            }
            try {
                adapter = paymentModule.getAdapter(provider.getAdapter(), provider.getConfiguration(), this.dbgDemoMode && this.dbgNoAdapter);
            }
            catch (PaymentException e) {
                e.setParam(PAY_PREFIX + provider.getName() + INFO_SUFFIX);
                throw e;
            }
            if (adapter != null) {
                hasSupportedProvider = true;
                int numTags2 = provider.getNumPriceTags();
                for (int j = 0; j < numTags2; ++j) {
                    try {
                        adapter.validatePriceInfo(provider.getPrice(j), provider.getPaySpecificPriceInfo(j));
                        continue;
                    }
                    catch (PaymentException e) {
                        e.setParam(PAY_PREFIX + provider.getName() + TAG + j);
                        throw e;
                    }
                }
            }
            providers[i] = provider;
        }
        this.version = versionNumber;
        this.updateStamp = updateStamp;
        this.updateURL = updateURL;
        this.cache = cache;
        this.expirationDate = expirationDate;
        this.featureToTag = featureToTag;
        this.providers = providers;
    }

    private void loadFromJarProperties(Properties props) throws PaymentException {
        this.loadFromPropertiesAux(props, false);
        String tempValue = props.getProperty(PAY_UPDATE_DATE);
        this.updateDate = null;
        if (tempValue != null) {
            try {
                long millis = utilities.parseISODate(tempValue);
                this.updateDate = new Date(millis);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private void loadFromJppProperties(Properties props) throws PaymentException {
        this.loadFromPropertiesAux(props, true);
    }

    private void exportProvider(StringBuffer buffer, ProviderInfo provider) {
        String providerPrefix = PAY_PREFIX + provider.getName();
        buffer.append(providerPrefix);
        buffer.append(INFO_SUFFIX);
        buffer.append(": ");
        buffer.append(provider.getAdapter());
        buffer.append(", ");
        buffer.append(provider.getCurrency());
        buffer.append(", ");
        buffer.append(provider.getConfiguration());
        buffer.append("\n");
        int count = provider.getNumPriceTags();
        for (int i = 0; i < count; ++i) {
            buffer.append(providerPrefix);
            buffer.append(TAG);
            buffer.append(i);
            buffer.append(": ");
            buffer.append(provider.getPrice(i));
            String value = provider.getPaySpecificPriceInfo(i);
            if (value != null) {
                buffer.append(", ");
                buffer.append(value);
            }
            buffer.append("\n");
        }
    }

    private static X509Certificate findTrustedCertificate(Properties props) throws PaymentException {
        int certPath = 1;
        int certIndex = 1;
        Vector<X509Certificate> certificates = new Vector<X509Certificate>();
        String encodedCert = props.getProperty(PAY_CERTIFICATE_PREFIX + certPath + "-" + certIndex);
        if (encodedCert == null) {
            throw new PaymentException(1, PAY_CERTIFICATE_PREFIX + certPath + "-" + certIndex, null);
        }
        do {
            certificates.setSize(0);
            do {
                try {
                    byte[] binaryCert = Base64.decode(encodedCert);
                    certificates.addElement(X509Certificate.generateCertificate(binaryCert, 0, binaryCert.length));
                }
                catch (Exception e) {
                    throw new PaymentException(2, PAY_CERTIFICATE_PREFIX + certPath + "-" + certIndex, "invalid or unsupported certificate");
                }
            } while ((encodedCert = props.getProperty(PAY_CERTIFICATE_PREFIX + certPath + "-" + ++certIndex)) != null);
            try {
                String lastCa = X509Certificate.verifyChain(certificates, 1, 8, WebPublicKeyStore.getTrustedKeyStore()).getIssuer();
                String domain = Permissions.UNTRUSTED_DOMAIN_NAME;
                Vector keys = WebPublicKeyStore.getTrustedKeyStore().findKeys(lastCa);
                if (keys != null) {
                    domain = ((PublicKeyInfo)keys.elementAt(0)).getDomain();
                }
                if (!Permissions.UNTRUSTED_DOMAIN_NAME.equals(domain)) {
                    return (X509Certificate)certificates.elementAt(0);
                }
            }
            catch (CertificateException e) {
                switch (e.getReason()) {
                    case 8: {
                        break;
                    }
                    case 3: 
                    case 6: {
                        throw new PaymentException(18, e.getCertificate().getSubject(), null);
                    }
                    case 12: {
                        throw new PaymentException(19, e.getCertificate().getIssuer(), null);
                    }
                    default: {
                        throw new PaymentException(20, e.getCertificate().getSubject(), null);
                    }
                }
            }
            certIndex = 1;
        } while ((encodedCert = props.getProperty(PAY_CERTIFICATE_PREFIX + ++certPath + "-" + certIndex)) != null);
        throw new PaymentException(21);
    }

    private static String removePKIProperties(String string) {
        char[] data = string.toCharArray();
        int length = data.length;
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        do {
            int prefixIdx;
            int j;
            for (j = i; j < length && data[j] != '\n' && data[j] <= ' '; ++j) {
            }
            if (j == length) break;
            if (data[j] == '\n') {
                i = j + 1;
                continue;
            }
            for (prefixIdx = 0; prefixIdx < PKI_PREFIXES.length; ++prefixIdx) {
                char[] prefix = PKI_PREFIXES[prefixIdx];
                int k = 0;
                for (j = i; j < length && k < prefix.length && data[j] == prefix[k]; ++j, ++k) {
                }
                if (k == prefix.length) break;
            }
            for (j = i; j < length && data[j] != '\n'; ++j) {
            }
            if (j < length) {
                ++j;
            }
            if (prefixIdx == PKI_PREFIXES.length) {
                buffer.append(data, i, j - i);
            }
            i = j;
        } while (i < length);
        return buffer.toString();
    }
}

