/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2me.payment;

import com.sun.j2me.payment.PPSMSAdapter;
import com.sun.j2me.payment.PaymentAdapter;
import com.sun.j2me.payment.PaymentException;
import com.sun.j2me.payment.PaymentInfo;
import com.sun.j2me.payment.ProviderInfo;
import com.sun.j2me.payment.Transaction;
import com.sun.j2me.payment.TransactionModuleImpl;
import com.sun.j2me.payment.TransactionProcessor;
import com.sun.j2me.payment.TransactionStore;
import com.sun.j2me.payment.Utils;
import com.sun.midp.io.DateParser;
import com.sun.midp.io.Util;
import com.sun.midp.main.Configuration;
import com.sun.midp.security.SecurityInitializer;
import com.sun.midp.security.SecurityToken;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.StringItem;
import javax.microedition.payment.TransactionListener;
import javax.microedition.payment.TransactionModuleException;
import javax.microedition.payment.TransactionRecord;

public abstract class PaymentModule
implements TransactionProcessor {
    private static SecurityToken classSecurityToken;
    private static final int ALERT_TIMEOUT = 1250;
    private static final String PAYMENT_MODULE = "microedition.payment.paymentmodule";
    private static PaymentModule paymentModule;
    private TransactionProcessingThread processingThread;
    private TransactionNotificationThread notificationThread;
    private final Utils utilities = this.getUtilities();
    private final String NEVER = this.utilities.getString(0x2290000);
    private Hashtable paymentAdapters = new Hashtable();
    private PaymentModuleUI currentUI;
    private static final int MAX_RETRY_COUNT = 3;
    private static final int RETRY_SHIFT = 2;
    private static final int STATE_CONNECTING = 0;
    private static final int STATE_SENDING_REQUEST = 1;
    private static final int STATE_RETRY_WAITING = 2;
    private static final int STATE_DOWNLOADING = 256;
    private static final int STATE_VERIFYING = 257;
    private static final int STATE_FINISHED = 512;
    private static final int MIME_TYPE = 0;
    private static final int CHARSET = 1;
    private static final int TRANSFER_CHUNK = 1024;
    private static final String UPDATE_MIME_TYPE = "text/vnd.sun.pay.provision";
    private static final char[] CHARSET_MASK;

    public static void initSecurityToken(SecurityToken token) {
        if (classSecurityToken != null) {
            return;
        }
        classSecurityToken = token;
        PPSMSAdapter.initSecurityToken(token);
    }

    protected PaymentModule() {
    }

    public static PaymentModule getInstance() {
        String className;
        if (paymentModule == null && (className = Configuration.getProperty(PAYMENT_MODULE)) != null) {
            try {
                paymentModule = (PaymentModule)Class.forName(className).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return paymentModule;
    }

    public abstract TransactionModuleImpl createTransactionModule(Object var1) throws TransactionModuleException;

    protected abstract TransactionStore getTransactionStore();

    protected abstract Utils getUtilities();

    public final int getNextApplicationID() throws IOException {
        return this.getTransactionStore().getNextApplicationID();
    }

    protected static PaymentInfo getPaymentInfo(Transaction transaction) {
        return transaction.getTransactionModule().getPaymentInfo();
    }

    protected static void savePaymentInfo(Transaction transaction) {
        try {
            transaction.getTransactionModule().savePaymentInfo();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    final void continueProcessing() {
        this.processingThread.continueWork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void initialize(TransactionModuleImpl transactionModule) throws TransactionModuleException {
        InitializationTransaction initializationTransaction;
        if (this.processingThread == null) {
            this.processingThread = new TransactionProcessingThread();
            this.processingThread.start();
        }
        InitializationTransaction initializationTransaction2 = initializationTransaction = new InitializationTransaction(this, transactionModule);
        synchronized (initializationTransaction2) {
            this.processingThread.addTransaction(initializationTransaction);
            try {
                initializationTransaction.wait();
            }
            catch (InterruptedException e) {
                throw new TransactionModuleException("Initialization interrupted");
            }
        }
        if (initializationTransaction.getState() != 3) {
            throw new TransactionModuleException("Initialization failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized int addTransaction(TransactionModuleImpl transactionModule, int featureID, String featureTitle, String featureDescription, byte[] payload) throws TransactionModuleException {
        PaymentInfo paymentInfo;
        int transactionID;
        if (this.processingThread == null) {
            this.processingThread = new TransactionProcessingThread();
            this.processingThread.start();
        }
        TransactionStore transactionStore = this.getTransactionStore();
        Transaction transaction = new Transaction(this, transactionModule, featureID, featureTitle, featureDescription, payload);
        try {
            transactionID = transactionStore.reserve(transactionModule.getApplicationID(), transaction);
        }
        catch (IOException e) {
            throw new TransactionModuleException("No more space for transaction records");
        }
        transaction.setTransactionID(transactionID);
        PaymentInfo paymentInfo2 = paymentInfo = PaymentModule.getPaymentInfo(transaction);
        synchronized (paymentInfo2) {
            this.processingThread.addTransaction(transaction);
            if (paymentInfo.needsUpdate()) {
                try {
                    paymentInfo.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (paymentInfo.needsUpdate()) {
                    throw new TransactionModuleException("The provisioning information needs an update");
                }
            }
        }
        return transactionID;
    }

    final void addTransactionForNotification(TransactionRecord record, TransactionModuleImpl module) {
        if (this.notificationThread == null) {
            this.notificationThread = new TransactionNotificationThread();
            this.notificationThread.start();
        }
        this.notificationThread.addTransaction(record, module);
    }

    final void addTransactionsForNotification(TransactionRecord[] records, TransactionModuleImpl module) {
        if (this.notificationThread == null) {
            this.notificationThread = new TransactionNotificationThread();
            this.notificationThread.start();
        }
        this.notificationThread.addTransactions(records, module);
    }

    protected void assignTransaction(Transaction transaction, int providerID) {
        PaymentInfo paymentInfo = PaymentModule.getPaymentInfo(transaction);
        int priceTag = paymentInfo.getPriceTagForFeature(transaction.getFeatureID());
        ProviderInfo providerInfo = paymentInfo.getProvider(providerID);
        PaymentAdapter adapter = null;
        try {
            adapter = this.getAdapter(providerInfo.getAdapter(), providerInfo.getConfiguration(), false);
        }
        catch (PaymentException e) {
            // empty catch block
        }
        transaction.setProviderName(providerInfo.getName());
        transaction.setCurrency(providerInfo.getCurrency());
        transaction.setPrice(providerInfo.getPrice(priceTag));
        transaction.setSpecificPriceInfo(providerInfo.getPaySpecificPriceInfo(priceTag));
        if (this.handleTransactionDebugMode(transaction)) {
            return;
        }
        transaction.setTransactionProcessor(adapter);
        transaction.setState(2);
    }

    protected final int[] getValidProviders(PaymentInfo paymentInfo) {
        int numProviders = paymentInfo.getNumProviders();
        int numAccepted = 0;
        boolean[] accepted = new boolean[numProviders];
        for (int i = 0; i < numProviders; ++i) {
            accepted[i] = false;
            ProviderInfo providerInfo = paymentInfo.getProvider(i);
            PaymentAdapter adapter = null;
            try {
                adapter = this.getAdapter(providerInfo.getAdapter(), providerInfo.getConfiguration(), paymentInfo.isDemoMode() && paymentInfo.getDbgNoAdapter());
            }
            catch (PaymentException e) {
                // empty catch block
            }
            if (adapter == null) continue;
            accepted[i] = true;
            ++numAccepted;
        }
        int[] providers = new int[numAccepted];
        int j = 0;
        for (int i = 0; i < numProviders; ++i) {
            if (!accepted[i]) continue;
            providers[j++] = i;
        }
        return providers;
    }

    public boolean isSupportedAdapter(String name) {
        return "PPSMS".equals(name);
    }

    protected PaymentAdapter createAdapter(String adapter, String configuration) throws PaymentException {
        if ("PPSMS".equals(adapter)) {
            if (configuration.indexOf(44) != -1) {
                String mcc = configuration.substring(0, configuration.indexOf(44));
                String mnc = configuration.substring(configuration.indexOf(44) + 1);
                if (mcc != null && mnc != null) {
                    mcc = mcc.trim();
                    mnc = mnc.trim();
                    try {
                        Integer.parseInt(mcc);
                        Integer.parseInt(mnc);
                    }
                    catch (NumberFormatException nfe) {
                        throw new PaymentException(9, configuration);
                    }
                    if (mcc.length() != 3 || mnc.length() < 2 || mnc.length() > 3) {
                        throw new PaymentException(9, configuration);
                    }
                    if (mcc.equals(System.getProperty("payment.mcc")) && mnc.equals(System.getProperty("payment.mnc"))) {
                        return PPSMSAdapter.getInstance(configuration);
                    }
                    return null;
                }
                throw new PaymentException(9, configuration);
            }
            throw new PaymentException(9, configuration);
        }
        return null;
    }

    protected PaymentAdapter getAdapter(String name, String configuration, boolean noAdapterMode) throws PaymentException {
        String adapterLookupString = name + "#" + PaymentModule.normalizeConfigurationString(configuration);
        PaymentAdapter adapter = (PaymentAdapter)this.paymentAdapters.get(adapterLookupString);
        if (adapter == null && (adapter = this.createAdapter(name, configuration)) != null) {
            this.paymentAdapters.put(adapterLookupString, adapter);
        }
        return adapter;
    }

    protected abstract void preemptDisplay(SecurityToken var1, Displayable var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction process(Transaction transaction) {
        boolean needsUpdate;
        PaymentInfo paymentInfo;
        boolean initializationTransaction = transaction instanceof InitializationTransaction;
        if (initializationTransaction) {
            int state = transaction.getState();
            switch (state) {
                case 0: {
                    paymentInfo = PaymentModule.getPaymentInfo(transaction);
                    needsUpdate = paymentInfo.needsUpdate();
                    if (!needsUpdate && this.handleAutoRequestMode(transaction)) break;
                    if (needsUpdate) {
                        this.currentUI = new PaymentModuleUI(transaction);
                        transaction.setState(1);
                        break;
                    }
                    int[] providers = this.getValidProviders(paymentInfo);
                    if (providers.length == 0) {
                        this.currentUI = new PaymentModuleUI(transaction);
                        transaction.setWaiting(true);
                        this.currentUI.showInitializationErrorForm();
                        break;
                    }
                    transaction.setState(3);
                    transaction.setNeedsUI(false);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    Transaction providers = transaction;
                    synchronized (providers) {
                        transaction.notifyAll();
                    }
                    return null;
                }
            }
            if (state != 1) {
                return transaction;
            }
        }
        switch (transaction.getState()) {
            case 0: {
                paymentInfo = PaymentModule.getPaymentInfo(transaction);
                needsUpdate = paymentInfo.needsUpdate();
                if (!needsUpdate && this.handleAutoRequestMode(transaction)) break;
                this.currentUI = new PaymentModuleUI(transaction);
                if (needsUpdate) {
                    transaction.setState(1);
                    break;
                }
                transaction.setWaiting(true);
                this.currentUI.showProviderSelectionForm();
                break;
            }
            case 1: {
                PaymentInfo e2;
                paymentInfo = PaymentModule.getPaymentInfo(transaction);
                try {
                    String name = paymentInfo.getUpdateURL();
                    int permission = name.startsWith("https") ? 4 : 2;
                    int colon = name.indexOf(58);
                    if (colon != -1) {
                        name = name.substring(colon + 1);
                    }
                    transaction.getTransactionModule().checkForPermission(permission, name);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                transaction.setWaiting(true);
                this.currentUI.showPaymentUpdateForm();
                try {
                    e2 = paymentInfo;
                    synchronized (e2) {
                        this.updatePaymentInfo(paymentInfo);
                    }
                    if (paymentInfo.cache()) {
                        PaymentModule.savePaymentInfo(transaction);
                    }
                    this.preemptDisplay(classSecurityToken, null);
                    if (this.handleAutoRequestMode(transaction)) {
                        transaction.setWaiting(false);
                        this.currentUI = null;
                        break;
                    }
                    if (initializationTransaction) {
                        int[] providers = this.getValidProviders(paymentInfo);
                        if (providers.length == 0) {
                            this.currentUI.showInitializationErrorForm();
                        } else {
                            transaction.setState(3);
                            transaction.setNeedsUI(false);
                            transaction.setWaiting(false);
                        }
                    } else {
                        this.currentUI.showProviderSelectionForm();
                    }
                }
                catch (InterruptedException e3) {
                    this.preemptDisplay(classSecurityToken, null);
                    if (paymentInfo.needsUpdate()) {
                        this.currentUI = null;
                        transaction.setState(4);
                        transaction.setNeedsUI(false);
                        transaction.setWaiting(false);
                    } else if (initializationTransaction) {
                        this.currentUI.showInitializationErrorForm();
                    } else {
                        this.currentUI.showProviderSelectionForm();
                    }
                }
                catch (Exception e4) {
                    System.out.println(e4.getMessage());
                    this.preemptDisplay(classSecurityToken, null);
                    this.currentUI.displayException(this.utilities.getString(36241424), this.getErrorMessage(e4));
                    break;
                }
                e2 = paymentInfo;
                synchronized (e2) {
                    paymentInfo.notifyAll();
                    break;
                }
            }
            case 3: 
            case 4: 
            case 5: {
                TransactionStore transactionStore = this.getTransactionStore();
                try {
                    TransactionRecord transactionRecord = transactionStore.addTransaction(transaction);
                    this.addTransactionForNotification(transactionRecord, transaction.getTransactionModule());
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            case 6: {
                return null;
            }
        }
        return transaction;
    }

    private String getErrorMessage(Exception e) {
        int prefixKey = 36241425;
        int suffixKey = 36241426;
        int key = -1;
        if (e instanceof SecurityException) {
            key = 36241427;
            suffixKey = -1;
        } else if (e instanceof IOException) {
            key = 36241428;
            suffixKey = -1;
        } else if (e instanceof PaymentException) {
            PaymentException pe = (PaymentException)e;
            switch (pe.getReason()) {
                case 0: 
                case 3: 
                case 4: 
                case 5: 
                case 17: {
                    key = 36241429;
                    break;
                }
                case 6: {
                    key = 36241430;
                    break;
                }
                case 7: {
                    key = 36241431;
                    break;
                }
                case 1: 
                case 2: 
                case 9: 
                case 10: 
                case 23: {
                    key = 36241432;
                    break;
                }
                case 8: {
                    key = 36241433;
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    key = 36241434;
                    break;
                }
                case 14: 
                case 15: {
                    key = 36241435;
                    break;
                }
                case 16: {
                    key = 36241436;
                    break;
                }
                case 18: {
                    key = 36241437;
                    break;
                }
                case 20: {
                    key = 36241438;
                    break;
                }
                case 19: 
                case 21: {
                    key = 36241439;
                    break;
                }
                case 22: {
                    key = 0x2290020;
                }
            }
        }
        StringBuffer buffer = new StringBuffer(this.utilities.getString(prefixKey));
        if (key != -1) {
            buffer.append(" ");
            buffer.append(this.utilities.getString(key));
            if (suffixKey != -1) {
                buffer.append(" ");
                buffer.append(this.utilities.getString(suffixKey));
            }
        }
        return buffer.toString();
    }

    private HttpConnection createConnection(String url) throws PaymentException, IOException, InterruptedException {
        HttpConnection httpConnection = null;
        int responseCode = -1;
        try {
            int retry = 0;
            while (true) {
                Connection connection;
                this.currentUI.notifyStateChange(0 + (retry << 2));
                try {
                    connection = Connector.open((String)url);
                }
                catch (IllegalArgumentException e) {
                    throw new PaymentException(11, url, null);
                }
                catch (ConnectionNotFoundException e) {
                    throw new PaymentException(11, url, null);
                }
                if (!(connection instanceof HttpConnection)) {
                    connection.close();
                    throw new PaymentException(11, url, null);
                }
                httpConnection = (HttpConnection)connection;
                String prof = System.getProperty("microedition.profiles");
                int space = prof.indexOf(32);
                if (space != -1) {
                    prof = prof.substring(0, space);
                }
                httpConnection.setRequestProperty("User-Agent", "Profile/" + prof + " Configuration/" + System.getProperty("microedition.configuration"));
                httpConnection.setRequestProperty("Accept-Charset", "UTF-8, " + System.getProperty("microedition.encoding"));
                String locale = System.getProperty("microedition.locale");
                if (locale != null) {
                    httpConnection.setRequestProperty("Accept-Language", locale);
                }
                this.currentUI.notifyStateChange(1 + (retry << 2));
                try {
                    responseCode = httpConnection.getResponseCode();
                }
                catch (IOException e) {
                    if (httpConnection.getHost() == null) {
                        throw new PaymentException(11, url, null);
                    }
                    throw new PaymentException(12, url, null);
                }
                if (responseCode != 503 || ++retry > 3) break;
                long sleepTime = 10000L;
                String value = httpConnection.getHeaderField("Retry-After");
                if (value != null) {
                    try {
                        sleepTime = Integer.parseInt(value) * 1000;
                    }
                    catch (NumberFormatException ne) {
                        try {
                            sleepTime = DateParser.parse(value);
                            sleepTime -= System.currentTimeMillis();
                        }
                        catch (IllegalArgumentException de) {
                            // empty catch block
                        }
                    }
                }
                httpConnection.close();
                httpConnection = null;
                if (sleepTime < 0L) {
                    sleepTime = 10000L;
                } else if (sleepTime > 60000L) {
                    sleepTime = 60000L;
                }
                this.currentUI.notifyStateChange(2 + (retry << 2));
                Thread.sleep(sleepTime);
            }
            switch (responseCode) {
                case 200: {
                    break;
                }
                case 404: {
                    throw new PaymentException(13, url, null);
                }
                case 503: {
                    throw new PaymentException(14, url, null);
                }
                default: {
                    throw new PaymentException(15, Integer.toString(responseCode), null);
                }
            }
        }
        catch (PaymentException e) {
            if (httpConnection != null) {
                httpConnection.close();
            }
            throw e;
        }
        catch (IOException e) {
            if (httpConnection != null) {
                httpConnection.close();
            }
            throw e;
        }
        return httpConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePaymentInfo(PaymentInfo paymentInfo) throws PaymentException, IOException, InterruptedException {
        String url = paymentInfo.getUpdateURL();
        HttpConnection httpConnection = this.createConnection(url);
        String[] contentType = new String[]{null, null};
        PaymentModule.parseContentType(contentType, httpConnection.getType());
        if (!UPDATE_MIME_TYPE.equals(contentType[0])) {
            httpConnection.close();
            throw new PaymentException(16, contentType[0], null);
        }
        byte[] data = null;
        try {
            this.currentUI.notifyStateChange(256);
            DataInputStream is = httpConnection.openDataInputStream();
            try {
                int read;
                ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
                byte[] buffer = new byte[1024];
                while ((read = ((InputStream)is).read(buffer, 0, 1024)) > 0) {
                    os.write(buffer, 0, read);
                }
                os.flush();
                data = os.toByteArray();
                os.close();
            }
            finally {
                ((InputStream)is).close();
            }
        }
        finally {
            httpConnection.close();
        }
        this.currentUI.notifyStateChange(257);
        paymentInfo.updatePaymentInfo(data, contentType[1]);
        this.currentUI.notifyStateChange(512);
    }

    private static int findEndOf(String string, char[] mask) {
        char[] data = string.toCharArray();
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < data.length && j < mask.length) {
            if (mask[j] == '+') {
                if (data[i] <= ' ') {
                    ++i;
                    continue;
                }
                ++j;
                continue;
            }
            if (data[i] == mask[j]) {
                ++i;
                ++j;
                continue;
            }
            i = k + 1;
            j = 0;
            k = i;
        }
        while (j < mask.length && mask[j] == '+') {
            ++j;
        }
        return j == mask.length ? i : -1;
    }

    private static void parseContentType(String[] values, String contentType) {
        String mimeType = null;
        String charset = "ISO-8859-1";
        if (contentType != null) {
            int index = contentType.indexOf(59);
            mimeType = contentType;
            if (index != -1) {
                mimeType = contentType.substring(0, index);
                index = PaymentModule.findEndOf(contentType, CHARSET_MASK);
                if (index != -1) {
                    int index2 = contentType.indexOf(59, index);
                    if (index2 == -1) {
                        index2 = contentType.length();
                    }
                    charset = contentType.substring(index, index2);
                    charset = charset.trim().toUpperCase();
                }
            }
            mimeType = mimeType.trim().toLowerCase();
        }
        values[0] = mimeType;
        values[1] = charset;
    }

    private static String normalizeConfigurationString(String configuration) {
        StringBuffer reconstructed = new StringBuffer();
        Vector elements = Util.getCommaSeparatedValues(configuration);
        int count = elements.size();
        if (count > 0) {
            reconstructed.append((String)elements.elementAt(0));
            for (int i = 1; i < count; ++i) {
                reconstructed.append(",");
                reconstructed.append((String)elements.elementAt(i));
            }
        }
        return reconstructed.toString();
    }

    protected boolean handleTransactionDebugMode(Transaction transaction) {
        return false;
    }

    protected boolean handleAutoRequestMode(Transaction transaction) {
        return false;
    }

    static {
        PaymentModule.initSecurityToken(SecurityInitializer.getSecurityToken());
        CHARSET_MASK = new char[]{';', '+', 'c', 'h', 'a', 'r', 's', 'e', 't', '+', '='};
    }

    protected static final class InitializationTransaction
    extends Transaction {
        public InitializationTransaction(TransactionProcessor processor, TransactionModuleImpl module) {
            super(processor, module);
        }
    }

    private class PaymentModuleUI
    implements CommandListener,
    ItemCommandListener,
    ItemStateListener {
        private Transaction transaction;
        private final Command noCommand;
        private final Command yesCommand;
        private final Command updateCommand;
        private final Command cancelCommand;
        private final Command stopCommand;
        private Form providerSelectionForm;
        private static final int QUESTION_LENGTH = 90;
        private StringItem featureDescriptionItem;
        private StringItem paymentQuestionItem;
        private ChoiceGroup providerSelectionChoice;
        private StringItem choiceReplacementItem;
        private StringItem psfUpdateDateItem;
        private StringItem psfUpdateStampItem;
        private int[] providers;
        private int choiceItemIndex;
        private Form initializationErrorForm;
        private StringItem iefUpdateDateItem;
        private StringItem iefUpdateStampItem;
        private Form paymentUpdateForm;
        private Gauge progressGauge;
        private int updateState;
        private boolean cancel;
        private long lastUIUpdate;

        public PaymentModuleUI(Transaction transaction) {
            this.noCommand = new Command(PaymentModule.this.utilities.getString(36241409), 3, 1);
            this.yesCommand = new Command(PaymentModule.this.utilities.getString(0x2290002), 4, 1);
            this.updateCommand = new Command(PaymentModule.this.utilities.getString(36241411), 8, 2);
            this.cancelCommand = new Command(PaymentModule.this.utilities.getString(36241443), 3, 1);
            this.stopCommand = new Command(PaymentModule.this.utilities.getString(36241412), 6, 1);
            this.updateState = -1;
            this.transaction = transaction;
        }

        public void showPaymentUpdateForm() {
            if (this.paymentUpdateForm == null) {
                this.paymentUpdateForm = new Form(PaymentModule.this.utilities.getString(36241413));
                this.progressGauge = new Gauge(null, false, -1, 2);
                this.progressGauge.setPreferredSize(this.paymentUpdateForm.getWidth(), -1);
                this.paymentUpdateForm.append(this.progressGauge);
                this.paymentUpdateForm.addCommand(this.stopCommand);
                this.paymentUpdateForm.setCommandListener(this);
            }
            this.updatePaymentUpdateForm();
            PaymentModule.this.preemptDisplay(classSecurityToken, this.paymentUpdateForm);
        }

        public void showProviderSelectionForm() {
            PaymentInfo paymentInfo;
            if (this.providerSelectionForm == null) {
                this.providerSelectionForm = new Form(this.transaction.getFeatureTitle());
                this.featureDescriptionItem = new StringItem(this.transaction.getFeatureDescription(), null);
                this.paymentQuestionItem = new StringItem(null, null);
                this.providerSelectionChoice = new ChoiceGroup(PaymentModule.this.utilities.getString(36241414), 4);
                this.choiceReplacementItem = new StringItem(null, null);
                this.psfUpdateDateItem = new StringItem(PaymentModule.this.utilities.getString(36241415), null);
                this.psfUpdateStampItem = new StringItem(PaymentModule.this.utilities.getString(36241416), null);
                this.featureDescriptionItem.setLayout(768);
                this.paymentQuestionItem.setLayout(768);
                this.choiceReplacementItem.setLayout(768);
                this.providerSelectionChoice.setLayout(768);
                this.psfUpdateDateItem.setLayout(768);
                this.psfUpdateStampItem.setLayout(768);
                Font defaultFont = Font.getDefaultFont();
                int separatorHeight = defaultFont.getHeight() >>> 1;
                int separatorWidth = this.providerSelectionForm.getWidth() >>> 1;
                int reserveLines = defaultFont.charWidth('M') * 90 / this.providerSelectionForm.getWidth() + 1;
                this.paymentQuestionItem.setPreferredSize(-1, reserveLines * defaultFont.getHeight());
                StringItem separator = new StringItem(null, null);
                separator.setPreferredSize(separatorWidth, separatorHeight);
                separator.setLayout(768);
                this.providerSelectionForm.append(this.featureDescriptionItem);
                this.providerSelectionForm.append(separator);
                this.providerSelectionForm.append(this.paymentQuestionItem);
                this.choiceItemIndex = this.providerSelectionForm.append(this.providerSelectionChoice);
                separator = new StringItem(null, null);
                separator.setPreferredSize(separatorWidth, separatorHeight);
                separator.setLayout(768);
                this.providerSelectionForm.append(separator);
                this.providerSelectionForm.append(this.psfUpdateDateItem);
                this.providerSelectionForm.append(this.psfUpdateStampItem);
                StringItem updateItem = new StringItem(null, this.updateCommand.getLabel(), 2);
                updateItem.setLayout(258);
                updateItem.setDefaultCommand(this.updateCommand);
                updateItem.setItemCommandListener(this);
                separator = new StringItem(null, null);
                separator.setPreferredSize(separatorWidth, separatorHeight);
                separator.setLayout(768);
                this.providerSelectionForm.append(separator);
                this.providerSelectionForm.append(updateItem);
                StringItem lastItem = new StringItem(null, null);
                lastItem.setLayout(1);
                this.providerSelectionForm.append(lastItem);
                this.providerSelectionForm.setCommandListener(this);
                this.providerSelectionForm.setItemStateListener(this);
            }
            this.psfUpdateDateItem.setText((paymentInfo = PaymentModule.getPaymentInfo(this.transaction)).getUpdateDate() == null ? PaymentModule.this.NEVER : paymentInfo.getUpdateDate().toString());
            this.psfUpdateStampItem.setText(paymentInfo.getUpdateStamp().toString());
            this.providers = PaymentModule.this.getValidProviders(paymentInfo);
            if (this.providers.length == 0) {
                if (this.providerSelectionForm.get(this.choiceItemIndex) == this.providerSelectionChoice) {
                    this.providerSelectionForm.set(this.choiceItemIndex, this.choiceReplacementItem);
                }
                this.providerSelectionForm.removeCommand(this.yesCommand);
                this.providerSelectionForm.removeCommand(this.noCommand);
                this.providerSelectionForm.addCommand(this.cancelCommand);
                this.paymentQuestionItem.setText(PaymentModule.this.utilities.getString(0x2290022));
            } else {
                if (this.providerSelectionForm.get(this.choiceItemIndex) != this.providerSelectionChoice) {
                    this.providerSelectionForm.set(this.choiceItemIndex, this.providerSelectionChoice);
                }
                this.providerSelectionForm.removeCommand(this.cancelCommand);
                this.providerSelectionForm.addCommand(this.yesCommand);
                this.providerSelectionForm.addCommand(this.noCommand);
                int oldIndex = this.providerSelectionChoice.getSelectedIndex();
                this.providerSelectionChoice.deleteAll();
                for (int i = 0; i < this.providers.length; ++i) {
                    ProviderInfo providerInfo = paymentInfo.getProvider(this.providers[i]);
                    PaymentAdapter adapter = null;
                    try {
                        adapter = PaymentModule.this.getAdapter(providerInfo.getAdapter(), providerInfo.getConfiguration(), false);
                    }
                    catch (PaymentException e) {
                        // empty catch block
                    }
                    this.providerSelectionChoice.append(adapter.getDisplayName() + " - " + providerInfo.getName(), null);
                }
                if (oldIndex >= this.providers.length) {
                    oldIndex = this.providers.length - 1;
                }
                if (oldIndex < 0) {
                    oldIndex = 0;
                }
                this.providerSelectionChoice.setSelectedIndex(oldIndex, true);
                this.updateProviderSelectionForm();
            }
            PaymentModule.this.preemptDisplay(classSecurityToken, this.providerSelectionForm);
        }

        public void showInitializationErrorForm() {
            PaymentInfo paymentInfo;
            if (this.initializationErrorForm == null) {
                this.initializationErrorForm = new Form(PaymentModule.this.utilities.getString(36241444));
                StringItem errorMessage = new StringItem(null, PaymentModule.this.utilities.getString(36241445));
                this.iefUpdateDateItem = new StringItem(PaymentModule.this.utilities.getString(36241415), null);
                this.iefUpdateStampItem = new StringItem(PaymentModule.this.utilities.getString(36241416), null);
                errorMessage.setLayout(768);
                this.iefUpdateDateItem.setLayout(768);
                this.iefUpdateStampItem.setLayout(768);
                Font defaultFont = Font.getDefaultFont();
                int separatorHeight = defaultFont.getHeight() >>> 1;
                int separatorWidth = this.initializationErrorForm.getWidth() >>> 1;
                this.initializationErrorForm.append(errorMessage);
                StringItem separator = new StringItem(null, null);
                separator.setPreferredSize(separatorWidth, separatorHeight);
                separator.setLayout(768);
                this.initializationErrorForm.append(separator);
                this.initializationErrorForm.append(this.iefUpdateDateItem);
                this.initializationErrorForm.append(this.iefUpdateStampItem);
                StringItem updateItem = new StringItem(null, this.updateCommand.getLabel(), 2);
                updateItem.setLayout(258);
                updateItem.setDefaultCommand(this.updateCommand);
                updateItem.setItemCommandListener(this);
                separator = new StringItem(null, null);
                separator.setPreferredSize(separatorWidth, separatorHeight);
                separator.setLayout(768);
                this.initializationErrorForm.append(separator);
                this.initializationErrorForm.append(updateItem);
                StringItem lastItem = new StringItem(null, null);
                lastItem.setLayout(1);
                this.initializationErrorForm.append(lastItem);
                this.initializationErrorForm.addCommand(this.yesCommand);
                this.initializationErrorForm.addCommand(this.noCommand);
                this.initializationErrorForm.setCommandListener(this);
                this.initializationErrorForm.setItemStateListener(this);
            }
            this.iefUpdateDateItem.setText((paymentInfo = PaymentModule.getPaymentInfo(this.transaction)).getUpdateDate() == null ? PaymentModule.this.NEVER : paymentInfo.getUpdateDate().toString());
            this.iefUpdateStampItem.setText(paymentInfo.getUpdateStamp().toString());
            PaymentModule.this.preemptDisplay(classSecurityToken, this.initializationErrorForm);
        }

        private void displayException(String title, String message) {
            Alert a = new Alert(title, message, null, AlertType.ERROR);
            a.setTimeout(4000);
            a.setCommandListener(this);
            PaymentModule.this.preemptDisplay(classSecurityToken, a);
        }

        private void updateProviderSelectionForm() {
            int providerID = this.providers[this.providerSelectionChoice.getSelectedIndex()];
            PaymentInfo paymentInfo = PaymentModule.getPaymentInfo(this.transaction);
            int priceTag = paymentInfo.getPriceTagForFeature(this.transaction.getFeatureID());
            ProviderInfo providerInfo = paymentInfo.getProvider(providerID);
            PaymentAdapter adapter = null;
            try {
                adapter = PaymentModule.this.getAdapter(providerInfo.getAdapter(), providerInfo.getConfiguration(), false);
            }
            catch (PaymentException e) {
                // empty catch block
            }
            String question = adapter.getPaymentQuestion(providerInfo.getName(), providerInfo.getPrice(priceTag), providerInfo.getCurrency());
            this.paymentQuestionItem.setText(question);
        }

        private void updatePaymentUpdateForm() {
            int key;
            int retry = 0;
            if (this.updateState == -1) {
                this.progressGauge.setLabel(null);
                return;
            }
            if (this.cancel) {
                this.progressGauge.setLabel(PaymentModule.this.utilities.getString(0x2290009));
                return;
            }
            if (this.updateState < 256) {
                retry = this.updateState >>> 2;
                this.updateState &= 3;
            }
            switch (this.updateState) {
                case 0: {
                    key = 36241418;
                    break;
                }
                case 1: {
                    key = 36241419;
                    break;
                }
                case 2: {
                    key = 36241420;
                    break;
                }
                case 256: {
                    key = 36241421;
                    break;
                }
                case 257: {
                    key = 36241422;
                    break;
                }
                default: {
                    return;
                }
            }
            String message = PaymentModule.this.utilities.getString(key);
            if (retry > 0) {
                String[] params = new String[]{Integer.toString(retry), Integer.toString(3)};
                message = message + "\n" + PaymentModule.this.utilities.getString(36241423, params);
            }
            this.progressGauge.setLabel(message);
        }

        public void notifyStateChange(int newState) throws InterruptedException {
            if (this.cancel) {
                throw new InterruptedException("stopped");
            }
            if (this.updateState != newState) {
                long sleepTime = this.lastUIUpdate + 1250L - System.currentTimeMillis();
                if (sleepTime > 0L) {
                    Thread.sleep(sleepTime);
                }
                this.updateState = newState;
                this.updatePaymentUpdateForm();
                this.lastUIUpdate = System.currentTimeMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commandAction(Command c, Displayable d) {
            if (d == this.providerSelectionForm) {
                if (c == this.yesCommand) {
                    PaymentModule.this.preemptDisplay(classSecurityToken, null);
                    PaymentModule.this.currentUI = null;
                    PaymentModule.this.assignTransaction(this.transaction, this.providers[this.providerSelectionChoice.getSelectedIndex()]);
                    this.transaction.setWaiting(false);
                } else if (c == this.noCommand) {
                    PaymentModule.this.preemptDisplay(classSecurityToken, null);
                    PaymentModule.this.currentUI = null;
                    this.transaction.setState(5);
                    this.transaction.setNeedsUI(false);
                    this.transaction.setWaiting(false);
                } else if (c == this.cancelCommand) {
                    PaymentModule.this.preemptDisplay(classSecurityToken, null);
                    PaymentModule.this.currentUI = null;
                    this.transaction.setState(4);
                    this.transaction.setNeedsUI(false);
                    this.transaction.setWaiting(false);
                }
            } else if (d == this.initializationErrorForm) {
                if (c == this.yesCommand) {
                    PaymentModule.this.preemptDisplay(classSecurityToken, null);
                    PaymentModule.this.currentUI = null;
                    this.transaction.setState(3);
                    this.transaction.setNeedsUI(false);
                    this.transaction.setWaiting(false);
                } else if (c == this.noCommand) {
                    PaymentModule.this.preemptDisplay(classSecurityToken, null);
                    PaymentModule.this.currentUI = null;
                    this.transaction.setState(4);
                    this.transaction.setNeedsUI(false);
                    this.transaction.setWaiting(false);
                }
            } else if (d == this.paymentUpdateForm) {
                if (c == this.stopCommand && !this.cancel) {
                    this.cancel = true;
                    this.updatePaymentUpdateForm();
                }
            } else if (c == Alert.DISMISS_COMMAND) {
                PaymentModule.this.preemptDisplay(classSecurityToken, null);
                PaymentInfo paymentInfo = PaymentModule.getPaymentInfo(this.transaction);
                if (paymentInfo.needsUpdate()) {
                    PaymentModule.this.currentUI = null;
                    this.transaction.setState(4);
                    this.transaction.setNeedsUI(false);
                    this.transaction.setWaiting(false);
                } else if (this.transaction instanceof InitializationTransaction) {
                    this.showInitializationErrorForm();
                } else {
                    this.showProviderSelectionForm();
                }
                PaymentInfo paymentInfo2 = paymentInfo;
                synchronized (paymentInfo2) {
                    paymentInfo.notifyAll();
                }
            }
        }

        public void commandAction(Command c, Item item) {
            if (c == this.updateCommand) {
                PaymentModule.this.preemptDisplay(classSecurityToken, null);
                this.updateState = -1;
                this.cancel = false;
                this.transaction.setState(1);
                this.transaction.setWaiting(false);
            }
        }

        public void itemStateChanged(Item item) {
            if (item == this.providerSelectionChoice) {
                this.updateProviderSelectionForm();
            }
        }
    }

    private class TransactionNotificationThread
    extends Thread {
        private Vector notificationQueue = new Vector();
        private boolean finished;
        private boolean wait = true;
        private static final int RECORD = 0;
        private static final int MODULE = 1;

        private TransactionNotificationThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            TransactionStore transactionStore = PaymentModule.this.getTransactionStore();
            while (!this.finished) {
                for (int count = this.notificationQueue.size(); count > 0; --count) {
                    Object[] element = (Object[])this.notificationQueue.elementAt(0);
                    Object object = element[1];
                    synchronized (object) {
                        TransactionRecord record = (TransactionRecord)element[0];
                        TransactionListener listener = ((TransactionModuleImpl)element[1]).getListener();
                        if (listener != null) {
                            try {
                                int transactionID = record.getTransactionID();
                                if (!transactionStore.wasDelivered(transactionID)) {
                                    listener.processed(record);
                                    transactionStore.setDelivered(transactionID);
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        this.notificationQueue.removeElementAt(0);
                        continue;
                    }
                }
                Vector vector = this.notificationQueue;
                synchronized (vector) {
                    if (this.wait) {
                        try {
                            this.notificationQueue.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    this.wait = true;
                }
            }
        }

        public void addTransaction(TransactionRecord record, TransactionModuleImpl module) {
            Object[] element = new Object[]{record, module};
            this.notificationQueue.addElement(element);
            this.continueWork();
        }

        public void addTransactions(TransactionRecord[] records, TransactionModuleImpl module) {
            for (int i = 0; i < records.length; ++i) {
                Object[] element = new Object[]{records[i], module};
                this.notificationQueue.addElement(element);
            }
            this.continueWork();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void continueWork() {
            Vector vector = this.notificationQueue;
            synchronized (vector) {
                this.wait = false;
                this.notificationQueue.notify();
            }
        }
    }

    private class TransactionProcessingThread
    extends Thread {
        private Transaction[] transactionQueue = new Transaction[16];
        private boolean finished;
        private boolean wait = true;

        private TransactionProcessingThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            while (!this.finished) {
                boolean blockUI = false;
                for (int i = 0; i < this.transactionQueue.length; ++i) {
                    Transaction transaction = this.transactionQueue[i];
                    if (transaction == null || blockUI && transaction.needsUI()) continue;
                    if (transaction.needsUI()) {
                        blockUI = true;
                    }
                    if (transaction.isWaiting()) continue;
                    if ((transaction = transaction.process()) != null && transaction.needsUI()) {
                        blockUI = true;
                    }
                    this.transactionQueue[i] = transaction;
                    this.wait = false;
                }
                Transaction[] transactionArray = this.transactionQueue;
                // MONITORENTER : this.transactionQueue
                if (this.wait) {
                    try {
                        this.transactionQueue.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.wait = true;
                // MONITOREXIT : transactionArray
            }
        }

        public void addTransaction(Transaction transaction) throws TransactionModuleException {
            int i;
            for (i = 0; i < this.transactionQueue.length; ++i) {
                if (this.transactionQueue[i] != null) continue;
                this.transactionQueue[i] = transaction;
                this.continueWork();
                break;
            }
            if (i == this.transactionQueue.length) {
                throw new TransactionModuleException("No more space for new transactions");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void continueWork() {
            Transaction[] transactionArray = this.transactionQueue;
            synchronized (this.transactionQueue) {
                this.wait = false;
                this.transactionQueue.notify();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }
}

