/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2me.payment;

import com.sun.j2me.payment.PaymentModule;
import com.sun.j2me.payment.TransactionModuleImpl;
import com.sun.j2me.payment.TransactionProcessor;

public class Transaction {
    public static final int ENTERED = 0;
    public static final int UPDATE = 1;
    public static final int ASSIGNED = 2;
    public static final int SUCCESSFUL = 3;
    public static final int FAILED = 4;
    public static final int REJECTED = 5;
    public static final int DISCARDED = 6;
    protected static final int ADAPTER_SPECIFIC = 256;
    private int transactionID;
    private int featureID;
    private String featureTitle;
    private String featureDescription;
    private byte[] payload;
    private TransactionModuleImpl transactionModule;
    private String providerName;
    private String currency;
    private double price;
    private String specificPriceInfo;
    private int state;
    private boolean waiting;
    private boolean needsUI;
    private TransactionProcessor processor;

    Transaction(TransactionProcessor processor, TransactionModuleImpl module) {
        this.transactionModule = module;
        this.processor = processor;
        this.needsUI = true;
    }

    Transaction(TransactionProcessor processor, TransactionModuleImpl module, int featureID, String featureTitle, String featureDescription, byte[] payload) {
        this.transactionModule = module;
        this.featureID = featureID;
        this.featureTitle = featureTitle;
        this.featureDescription = featureDescription;
        this.payload = payload;
        this.processor = processor;
        this.needsUI = true;
    }

    public Transaction(Transaction templ) {
        this.transactionID = templ.transactionID;
        this.featureID = templ.featureID;
        this.featureTitle = templ.featureTitle;
        this.featureDescription = templ.featureDescription;
        this.payload = templ.payload;
        this.transactionModule = templ.transactionModule;
        this.providerName = templ.providerName;
        this.currency = templ.currency;
        this.price = templ.price;
        this.specificPriceInfo = templ.specificPriceInfo;
        this.state = templ.state;
        this.waiting = templ.waiting;
        this.needsUI = templ.needsUI;
        this.processor = templ.processor;
    }

    public final String getFeatureTitle() {
        return this.featureTitle;
    }

    public final String getFeatureDescription() {
        return this.featureDescription;
    }

    public final byte[] getPayload() {
        return this.payload;
    }

    public final String getProviderName() {
        return this.providerName;
    }

    public final String getCurrency() {
        return this.currency;
    }

    public final double getPrice() {
        return this.price;
    }

    public final String getSpecificPriceInfo() {
        return this.specificPriceInfo;
    }

    public void setTransactionProcessor(TransactionProcessor processor) {
        this.processor = processor;
    }

    public final void setWaiting(boolean value) {
        if (this.waiting == value) {
            return;
        }
        if (this.waiting) {
            this.waiting = false;
            PaymentModule.getInstance().continueProcessing();
            return;
        }
        this.waiting = true;
    }

    public final boolean isWaiting() {
        return this.waiting;
    }

    public final void setNeedsUI(boolean value) {
        this.needsUI = value;
    }

    public final boolean needsUI() {
        return this.needsUI;
    }

    public final void setState(int newState) {
        this.state = newState;
    }

    public final int getState() {
        return this.state;
    }

    public final int getTransactionID() {
        return this.transactionID;
    }

    public final int getFeatureID() {
        return this.featureID;
    }

    public final TransactionModuleImpl getTransactionModule() {
        return this.transactionModule;
    }

    final Transaction process() {
        return this.processor.process(this);
    }

    final void setTransactionID(int value) {
        this.transactionID = value;
    }

    final void setProviderName(String value) {
        this.providerName = value;
    }

    final void setCurrency(String value) {
        this.currency = value;
    }

    final void setPrice(double value) {
        this.price = value;
    }

    final void setSpecificPriceInfo(String value) {
        this.specificPriceInfo = value;
    }
}

