/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2me.payment;

import com.sun.j2me.payment.PaymentInfo;
import com.sun.j2me.payment.PaymentModule;
import com.sun.j2me.payment.TransactionStore;
import java.io.IOException;
import javax.microedition.midlet.MIDlet;
import javax.microedition.payment.TransactionFeatureException;
import javax.microedition.payment.TransactionListener;
import javax.microedition.payment.TransactionListenerException;
import javax.microedition.payment.TransactionModuleException;
import javax.microedition.payment.TransactionPayloadException;
import javax.microedition.payment.TransactionRecord;

public abstract class TransactionModuleImpl {
    protected MIDlet midlet;
    protected TransactionListener listener;
    public static final int PAYLOAD_LIMIT = 132;

    protected TransactionModuleImpl(Object object) throws TransactionModuleException {
        if (object == null) {
            throw new NullPointerException();
        }
        if (!(object instanceof MIDlet)) {
            throw new TransactionModuleException("The input parameter is not a MIDlet instance");
        }
        this.midlet = (MIDlet)object;
        PaymentInfo paymentInfo = this.getPaymentInfo();
        if (paymentInfo == null) {
            throw new TransactionModuleException("Missing provisioning information");
        }
        PaymentModule.getInstance().initialize(this);
    }

    public final synchronized void setListener(TransactionListener listener) {
        this.listener = listener;
    }

    public final int process(int featureID, String featureTitle, String featureDescription, byte[] payload) throws TransactionModuleException, TransactionFeatureException, TransactionListenerException, TransactionPayloadException {
        try {
            this.checkForPermission(48, null);
        }
        catch (InterruptedException e) {
            throw new SecurityException();
        }
        if (featureTitle == null || featureDescription == null) {
            throw new TransactionModuleException("The " + (featureTitle == null ? "featureTitle" : "featureDescription") + " is null");
        }
        if (featureTitle.length() == 0 || featureDescription.length() == 0) {
            throw new TransactionModuleException("The " + (featureTitle.length() == 0 ? "featureTitle" : "featureDescription") + " is empty");
        }
        if (payload != null && payload.length > 132) {
            throw new TransactionPayloadException();
        }
        if (featureID < 0 || featureID >= this.getPaymentInfo().getNumFeatures()) {
            throw new TransactionFeatureException();
        }
        if (this.listener == null) {
            throw new TransactionListenerException();
        }
        return PaymentModule.getInstance().addTransaction(this, featureID, featureTitle, featureDescription, payload);
    }

    public final TransactionRecord[] getPastTransactions(int max) {
        if (max == 0) {
            return null;
        }
        TransactionRecord[] allPassed = this.getPassedTransactions();
        if (allPassed == null || allPassed.length <= max) {
            return allPassed;
        }
        TransactionRecord[] truncated = new TransactionRecord[max];
        System.arraycopy(allPassed, 0, truncated, 0, max);
        return truncated;
    }

    public void deliverMissedTransactions() throws TransactionListenerException {
        if (this.listener == null) {
            throw new TransactionListenerException();
        }
        TransactionRecord[] allMissed = this.getMissedTransactions();
        if (allMissed != null) {
            PaymentModule.getInstance().addTransactionsForNotification(allMissed, this);
        }
    }

    public final MIDlet getMIDlet() {
        return this.midlet;
    }

    protected TransactionRecord[] getMissedTransactions() {
        int applicationID = this.getApplicationID();
        TransactionStore transactionStore = PaymentModule.getInstance().getTransactionStore();
        TransactionRecord[] allMissed = null;
        try {
            allMissed = transactionStore.getMissedTransactions(applicationID);
        }
        catch (IOException e) {
            // empty catch block
        }
        return allMissed;
    }

    protected TransactionRecord[] getPassedTransactions() {
        int applicationID = this.getApplicationID();
        TransactionStore transactionStore = PaymentModule.getInstance().getTransactionStore();
        TransactionRecord[] allPassed = null;
        try {
            allPassed = transactionStore.getPassedTransactions(applicationID);
        }
        catch (IOException e) {
            // empty catch block
        }
        return allPassed;
    }

    final TransactionListener getListener() {
        return this.listener;
    }

    protected abstract void checkForPermission(int var1, String var2) throws InterruptedException;

    protected abstract PaymentInfo getPaymentInfo();

    protected abstract void savePaymentInfo() throws IOException;

    protected abstract int getApplicationID();
}

