/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.io.j2me.btgoep;

import com.sun.kvem.jsr082.impl.NetmonCommon;
import com.sun.midp.io.j2me.btgoep.BTGOEPConnection;
import java.io.IOException;
import javax.microedition.io.StreamConnection;

final class BTGOEPNetmonConnection
extends BTGOEPConnection {
    private int id;
    private boolean isNetmonClosed;

    BTGOEPNetmonConnection(StreamConnection sock, String url) throws IOException {
        super(sock);
        long groupid = System.currentTimeMillis();
        this.id = NetmonCommon.connect0(url, groupid);
    }

    public void close() throws IOException {
        this.disconnect();
        super.close();
    }

    public void write(byte[] outData, int len) throws IOException {
        try {
            super.write(outData, len);
            NetmonCommon.write0(this.id, outData, 0, len);
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    public int read(byte[] inData) throws IOException {
        try {
            int len = super.read(inData);
            if (len != -1) {
                NetmonCommon.read0(this.id, inData, 0, len);
            }
            return len;
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect() {
        BTGOEPNetmonConnection bTGOEPNetmonConnection = this;
        synchronized (bTGOEPNetmonConnection) {
            if (this.isNetmonClosed) {
                return;
            }
            this.isNetmonClosed = true;
        }
        NetmonCommon.disconnect0(this.id);
    }
}

