/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.bluetooth;

import com.sun.kvem.jsr082.bluetooth.BCC;
import com.sun.kvem.jsr082.bluetooth.BCCNameWrapper;
import com.sun.kvem.jsr082.bluetooth.BluetoothNotifier;
import com.sun.kvem.jsr082.bluetooth.DiscoveryAgentImpl;
import com.sun.kvem.jsr082.bluetooth.SDDBImpl;
import com.sun.kvem.jsr082.bluetooth.ServiceRecordImpl;
import com.sun.kvem.jsr082.obex.SessionNotifierImpl;
import java.util.Hashtable;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.ServiceRegistrationException;
import javax.microedition.io.Connection;

public final class LocalDeviceImpl {
    private static BCC bcc;
    private static final boolean DEBUG = false;
    private static boolean isInitialized;
    private DiscoveryAgentImpl discoveryAgentImpl;
    private String bluetoothAddress;
    private Hashtable ldProperties;
    private CancelerOfLIAC cancelerOfLIAC = new CancelerOfLIAC();
    static /* synthetic */ Class class$com$sun$kvem$jsr082$bluetooth$LocalDeviceImpl;
    static /* synthetic */ Class class$javax$bluetooth$LocalDevice;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalDeviceImpl(LocalDevice parent) throws BluetoothStateException {
        Class clazz = class$com$sun$kvem$jsr082$bluetooth$LocalDeviceImpl == null ? (class$com$sun$kvem$jsr082$bluetooth$LocalDeviceImpl = LocalDeviceImpl.class$("com.sun.kvem.jsr082.bluetooth.LocalDeviceImpl")) : class$com$sun$kvem$jsr082$bluetooth$LocalDeviceImpl;
        synchronized (clazz) {
            if (isInitialized) {
                throw new RuntimeException("Already initialized");
            }
            if (parent == null || parent.getClass() != (class$javax$bluetooth$LocalDevice == null ? (class$javax$bluetooth$LocalDevice = LocalDeviceImpl.class$("javax.bluetooth.LocalDevice")) : class$javax$bluetooth$LocalDevice)) {
                throw new RuntimeException("Can't call to this <init>");
            }
            try {
                String bccClassName = BCCNameWrapper.getBBCImplClassName();
                Class<?> clazz2 = Class.forName(bccClassName);
                bcc = (BCC)clazz2.newInstance();
                bcc.initialize();
                this.bluetoothAddress = bcc.getBluetoothAddress();
                this.ldProperties = bcc.getProperties();
                bcc.getFriendlyName();
                bcc.getDeviceClass();
                bcc.getDiscoverable();
                this.discoveryAgentImpl = DiscoveryAgentImpl.getInstance(bcc);
                bcc.setDiscoveryAgent(this.discoveryAgentImpl);
                new SDDBImpl(bcc);
            }
            catch (Throwable e) {
                bcc = null;
                throw new BluetoothStateException(e.getMessage());
            }
            isInitialized = true;
        }
    }

    public String getFriendlyName() {
        return bcc.getFriendlyName();
    }

    public DeviceClass getDeviceClass() {
        return bcc.getDeviceClass();
    }

    public String getProperty(String property) {
        return this.ldProperties != null ? (String)this.ldProperties.get(property) : null;
    }

    public int getDiscoverable() {
        return bcc.getDiscoverable();
    }

    static BCC getBCC() {
        return bcc;
    }

    public String getBluetoothAddress() {
        return this.bluetoothAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setDiscoverable(int accessCode) throws BluetoothStateException {
        if (accessCode != 10390323 && accessCode != 10390272 && accessCode != 0 && (accessCode < 10390272 || accessCode > 10390335)) {
            throw new IllegalArgumentException("Access code is out of range: " + accessCode);
        }
        boolean res = false;
        CancelerOfLIAC cancelerOfLIAC = this.cancelerOfLIAC;
        synchronized (cancelerOfLIAC) {
            res = bcc.setBTDeviceAccessCode(accessCode);
            if (res) {
                this.cancelerOfLIAC.notifyNewAccessCode(accessCode);
            }
        }
        if (res && accessCode != 0) {
            SDDBImpl.getSDDBInstance();
        }
        return res;
    }

    public ServiceRecord getRecord(Connection notifier) {
        if (notifier == null) {
            throw new NullPointerException("notifier is null");
        }
        if (!(notifier instanceof BluetoothNotifier)) {
            if (!(notifier instanceof SessionNotifierImpl)) {
                throw new IllegalArgumentException("not bluetooth notifier");
            }
            Connection transport = ((SessionNotifierImpl)notifier).getTransport();
            if (!(transport instanceof BluetoothNotifier)) {
                throw new IllegalArgumentException("not bluetooth notifier");
            }
            return ((BluetoothNotifier)transport).getServiceRecord();
        }
        BluetoothNotifier notif = (BluetoothNotifier)notifier;
        return notif.getServiceRecord();
    }

    public void updateRecord(ServiceRecord srvRecord) throws ServiceRegistrationException {
        if (srvRecord == null) {
            throw new NullPointerException("notifier is null");
        }
        if (!(srvRecord instanceof ServiceRecordImpl)) {
            throw new IllegalArgumentException("wrong service record");
        }
        ServiceRecordImpl record = (ServiceRecordImpl)srvRecord;
        BluetoothNotifier notifier = record.getNotifier();
        if (notifier == null) {
            throw new IllegalArgumentException("remote device service record");
        }
        notifier.updateServiceRecord();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CancelerOfLIAC
    implements Runnable {
        private long MINUTE = 60000L;
        private int RETRY_DELAY = 100;
        private int currentCode = 10390323;
        private int savedCode;
        private long start_time = -1L;
        private boolean isCanceledFromOutside = true;

        private CancelerOfLIAC() {
        }

        synchronized void notifyNewAccessCode(int newCode) {
            if (newCode == this.currentCode) {
                return;
            }
            this.savedCode = this.currentCode;
            this.currentCode = newCode;
            if (newCode == 10390272) {
                this.start_time = System.currentTimeMillis();
                new Thread(this).start();
            } else {
                boolean stopKiller = this.start_time != -1L && this.isCanceledFromOutside;
                this.start_time = -1L;
                this.isCanceledFromOutside = false;
                if (stopKiller) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                try {
                    Thread.sleep(this.RETRY_DELAY);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                CancelerOfLIAC cancelerOfLIAC = this;
                synchronized (cancelerOfLIAC) {
                    if (this.start_time == -1L) {
                        this.notify();
                        return;
                    }
                    if (System.currentTimeMillis() - this.start_time < this.MINUTE) {
                        continue;
                    }
                    this.isCanceledFromOutside = false;
                    boolean res = false;
                    try {
                        res = LocalDeviceImpl.this.setDiscoverable(this.savedCode);
                    }
                    catch (BluetoothStateException bluetoothStateException) {
                        // empty catch block
                    }
                    if (res) {
                        return;
                    }
                    this.isCanceledFromOutside = true;
                }
            }
        }
    }
}

