/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.bluetooth;

import com.sun.kvem.jsr082.bluetooth.BCC;
import com.sun.kvem.jsr082.bluetooth.BluetoothConnection;
import com.sun.kvem.jsr082.bluetooth.LocalDeviceImpl;
import com.sun.kvem.jsr082.obex.ObexPacketStream;
import java.io.IOException;
import javax.bluetooth.RemoteDevice;
import javax.microedition.io.Connection;

public final class RemoteDeviceImpl
extends RemoteDevice {
    private BCC bcc = LocalDeviceImpl.getBCC();
    private String friendlyName;

    RemoteDeviceImpl(String address) {
        super(address);
    }

    public static RemoteDevice getRemoteDevice(Connection conn) throws IOException {
        if (conn == null) {
            throw new NullPointerException("null connection");
        }
        BluetoothConnection btconn = null;
        try {
            btconn = RemoteDeviceImpl.getBluetoothConnection(conn);
        }
        catch (NullPointerException npe) {
            if (conn instanceof ObexPacketStream) {
                throw new IOException("connection is closed");
            }
            throw npe;
        }
        return btconn.getRemoteDevice();
    }

    public String getFriendlyName(boolean alwaysAsk) throws IOException {
        if (this.friendlyName == null || alwaysAsk) {
            this.friendlyName = this.bcc.getFriendlyName(this);
        }
        return this.friendlyName;
    }

    public boolean isTrustedDevice() {
        return this.bcc.isTrustedDevice(this);
    }

    public boolean authenticate() throws IOException {
        return this.bcc.authenticate(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authorize(Connection conn) throws IOException {
        BluetoothConnection btconn = null;
        try {
            btconn = RemoteDeviceImpl.getBluetoothConnection(conn);
        }
        catch (NullPointerException npe) {
            if (conn instanceof ObexPacketStream) {
                throw new IOException("connection is closed");
            }
            throw npe;
        }
        RemoteDeviceImpl device = btconn.getRemoteDevice();
        if (!this.equals((Object)device)) {
            throw new IllegalArgumentException("connection to other device");
        }
        if (!btconn.isServerSide()) {
            throw new IllegalArgumentException("not server side");
        }
        Connection connection = conn;
        synchronized (connection) {
            boolean res;
            boolean isAuthorized = btconn.isAuthorized();
            if (isAuthorized) {
                return true;
            }
            isAuthorized = this.isTrustedDevice() ? true : this.bcc.authorize(this, btconn);
            if (isAuthorized && !this.isAuthenticated() && !(res = this.authenticate())) {
                return false;
            }
            if (isAuthorized) {
                btconn.setAuthorized();
            }
            return isAuthorized;
        }
    }

    public boolean encrypt(Connection conn, boolean on) throws IOException {
        BluetoothConnection btconn = null;
        try {
            btconn = RemoteDeviceImpl.getBluetoothConnection(conn);
        }
        catch (NullPointerException npe) {
            if (conn instanceof ObexPacketStream) {
                throw new IOException("connection is closed");
            }
            throw npe;
        }
        RemoteDeviceImpl device = btconn.getRemoteDevice();
        if (!this.equals((Object)device)) {
            throw new IllegalArgumentException("connection to other device");
        }
        return this.bcc.encrypt(this, btconn, on);
    }

    public boolean isAuthorized(Connection conn) throws IOException {
        RemoteDeviceImpl device;
        BluetoothConnection btconn = null;
        try {
            btconn = RemoteDeviceImpl.getBluetoothConnection(conn);
        }
        catch (NullPointerException npe) {
            if (conn instanceof ObexPacketStream) {
                throw new IOException("connection is closed");
            }
            throw npe;
        }
        try {
            device = btconn.getRemoteDevice();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        if (!this.equals((Object)device)) {
            throw new IllegalArgumentException("connection to other device");
        }
        return btconn.isAuthorized();
    }

    public boolean isAuthenticated() {
        return this.bcc.isAuthenticated(this);
    }

    public boolean isEncrypted() {
        return this.bcc.isEncrypted(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("RemoteDevice[");
        sb.append("address=").append(this.getBluetoothAddress());
        sb.append(", name=").append((String)null);
        sb.append(", encrypted=").append(this.isEncrypted());
        sb.append(", authenticated=").append(this.isAuthenticated());
        sb.append("]");
        return sb.toString();
    }

    private static BluetoothConnection getBluetoothConnection(Connection conn) {
        if (!(conn instanceof BluetoothConnection)) {
            if (!(conn instanceof ObexPacketStream)) {
                if (conn == null) {
                    throw new NullPointerException("null connection");
                }
                throw new IllegalArgumentException("not bluetooth connection");
            }
            Connection transport = ((ObexPacketStream)conn).getTransport();
            if (!(transport instanceof BluetoothConnection)) {
                throw new IllegalArgumentException("not bluetooth connection");
            }
            return (BluetoothConnection)transport;
        }
        return (BluetoothConnection)conn;
    }
}

