/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.bluetooth;

import com.sun.kvem.jsr082.bluetooth.BCC;
import com.sun.kvem.jsr082.bluetooth.SDDBStorage;
import com.sun.kvem.jsr082.bluetooth.SDPServer;
import com.sun.kvem.jsr082.bluetooth.ServiceRecordImpl;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public final class SDDBImpl {
    private static final boolean DEBUG = false;
    private static SDDBImpl sddbInstance;
    private static int freeHandle;
    private Hashtable recordStorage;
    private SDPServer server;
    private BCC control;
    private boolean isInitialized;
    private static final String SDDB_STORAGE = "com.sun.kvem.jsr082.bluetooth.SDDBStorage";
    private SDDBStorage storage;

    public static synchronized SDDBImpl getSDDBInstance() {
        if (!SDDBImpl.sddbInstance.isInitialized) {
            sddbInstance.init();
            SDDBImpl.sddbInstance.isInitialized = true;
        }
        return sddbInstance;
    }

    SDDBImpl(BCC control) {
        this.control = control;
        sddbInstance = this;
    }

    private void init() {
        try {
            this.load();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.server = new SDPServer(this);
        this.server.start();
    }

    public static synchronized int getFreeID() {
        return freeHandle++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServiceRecord(ServiceRecordImpl record) {
        int handle = record.getHandle();
        Hashtable hashtable = this.recordStorage;
        synchronized (hashtable) {
            this.recordStorage.put(new Integer(handle), record);
            if (record.isPush()) {
                try {
                    this.store();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        this.control.updateDeviceClass(this.getDeviceClasses());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceRecord(ServiceRecordImpl record) {
        Hashtable hashtable = this.recordStorage;
        synchronized (hashtable) {
            int handle = record.getHandle();
            this.recordStorage.remove(new Integer(handle));
        }
        this.control.updateDeviceClass(this.getDeviceClasses());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] getHandles() {
        Hashtable hashtable = this.recordStorage;
        synchronized (hashtable) {
            int i = 0;
            int sz = this.recordStorage.size();
            int[] handles = new int[sz];
            Enumeration e = this.recordStorage.elements();
            while (e.hasMoreElements()) {
                ServiceRecordImpl rec = (ServiceRecordImpl)e.nextElement();
                handles[i] = rec.getHandle();
                ++i;
            }
            return handles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceRecordImpl getServiceRecord(int handle) {
        Hashtable hashtable = this.recordStorage;
        synchronized (hashtable) {
            return (ServiceRecordImpl)this.recordStorage.get(new Integer(handle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDeviceClasses() {
        Hashtable hashtable = this.recordStorage;
        synchronized (hashtable) {
            int devClass = 0;
            Enumeration e = this.recordStorage.elements();
            while (e.hasMoreElements()) {
                ServiceRecordImpl rec = (ServiceRecordImpl)e.nextElement();
                devClass |= rec.getDeviceServiceClasses();
            }
            return devClass;
        }
    }

    private SDDBStorage getStorage() throws IOException {
        if (this.storage == null) {
            String className = System.getProperty(SDDB_STORAGE);
            if (className == null) {
                throw new IOException();
            }
            try {
                this.storage = (SDDBStorage)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                throw new IOException();
            }
        }
        return this.storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws IOException {
        Hashtable<Integer, ServiceRecordImpl> loadedRecords = new Hashtable<Integer, ServiceRecordImpl>();
        int maximumHandle = -1;
        InputStream in = this.getStorage().openInputStream();
        if (in != null) {
            DataInputStream is = new DataInputStream(in);
            try {
                int count = is.readInt();
                for (int i = 0; i < count; ++i) {
                    ServiceRecordImpl rec = ServiceRecordImpl.read(is);
                    int handle = rec.getHandle();
                    if (maximumHandle < handle) {
                        maximumHandle = handle;
                    }
                    rec.setPush(true);
                    loadedRecords.put(new Integer(handle), rec);
                }
            }
            finally {
                is.close();
            }
        }
        this.recordStorage = loadedRecords;
        freeHandle = maximumHandle + 1;
        this.control.updateDeviceClass(this.getDeviceClasses());
    }

    public void store() throws IOException {
        this.store(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(boolean conditional) throws IOException {
        DataOutputStream os = new DataOutputStream(this.getStorage().openOutputStream());
        try {
            ServiceRecordImpl rec;
            Enumeration e = this.recordStorage.elements();
            int count = 0;
            while (e.hasMoreElements()) {
                rec = (ServiceRecordImpl)e.nextElement();
                if (!rec.isPush()) continue;
                if (conditional) {
                    if (!rec.hasNotifier()) continue;
                    ++count;
                    continue;
                }
                ++count;
            }
            os.writeInt(count);
            e = this.recordStorage.elements();
            while (e.hasMoreElements()) {
                rec = (ServiceRecordImpl)e.nextElement();
                if (!rec.isPush()) continue;
                if (conditional) {
                    if (!rec.hasNotifier()) continue;
                    rec.store(os);
                    continue;
                }
                rec.store(os);
            }
        }
        finally {
            os.close();
        }
        if (conditional) {
            this.control.updateDeviceClass(this.getDeviceClasses());
        }
    }

    public ServiceRecordImpl getServiceRecord(ServiceRecordImpl rec) {
        String url = rec.getConnectionURL(0, false);
        Enumeration e = this.recordStorage.elements();
        while (e.hasMoreElements()) {
            ServiceRecordImpl tmp = (ServiceRecordImpl)e.nextElement();
            if (!tmp.getConnectionURL(0, false).equals(url)) continue;
            return tmp;
        }
        return null;
    }
}

