/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.bluetooth;

import com.sun.kvem.jsr082.bluetooth.SDPResponseListener;
import com.sun.kvem.jsr082.bluetooth.ServiceRecordImpl;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.UUID;

abstract class ServiceSearcherBase
implements SDPResponseListener {
    private static final int MASK_OVERFLOW = -65536;
    RemoteDevice btDev;
    UUID[] uuidSet;
    int[] attrSet;

    ServiceSearcherBase(int[] attrSet, UUID[] uuidSet, RemoteDevice btDev) {
        int i;
        Object checkObj = new Object();
        Hashtable<Integer, Object> dupChecker = new Hashtable<Integer, Object>();
        if (uuidSet == null) {
            throw new NullPointerException("null instance of UUID set");
        }
        if (btDev == null) {
            throw new NullPointerException("null instance of RemoteDevice");
        }
        if (uuidSet.length == 0) {
            throw new IllegalArgumentException("zero UUID set size");
        }
        if (attrSet != null) {
            if (attrSet.length == 0) {
                throw new IllegalArgumentException("zero attrSet size");
            }
            if (attrSet.length > ServiceRecordImpl.RETRIEVABLE_MAX) {
                throw new IllegalArgumentException("attrSet size exceeding");
            }
            for (i = 0; i < attrSet.length; ++i) {
                if ((attrSet[i] & 0xFFFF0000) != 0) {
                    throw new IllegalArgumentException("illegal attrSet");
                }
                if (dupChecker.put(new Integer(attrSet[i]), checkObj) == null) continue;
                throw new IllegalArgumentException("duplicated attribute ID");
            }
        }
        for (i = 0; i <= 4; ++i) {
            dupChecker.put(new Integer(i), checkObj);
        }
        this.attrSet = new int[dupChecker.size()];
        Enumeration set = dupChecker.keys();
        i = 0;
        while (set.hasMoreElements()) {
            this.attrSet[i] = (Integer)set.nextElement();
            ++i;
        }
        dupChecker.clear();
        for (i = 0; i < uuidSet.length; ++i) {
            if (uuidSet[i] == null) {
                throw new NullPointerException("null instance of UUID");
            }
            if (dupChecker.put((Integer)uuidSet[i], checkObj) == null) continue;
            throw new IllegalArgumentException("duplicated UUID");
        }
        this.uuidSet = new UUID[dupChecker.size()];
        set = dupChecker.keys();
        i = 0;
        while (set.hasMoreElements()) {
            this.uuidSet[i] = (UUID)set.nextElement();
            ++i;
        }
        this.btDev = btDev;
    }
}

