/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.impl;

import java.util.Enumeration;
import java.util.Vector;

public class BTPushFilter {
    private static final char META_ASTERISK = '*';
    private static final char META_CHAR = '?';
    private static final char DELIMITER = ';';
    private static final String TAG_BLACKLIST = "blacklist=";
    private static final String TAG_AUTHENTICATED = "authenticated";
    private static final String TAG_AUTHORIZED = "authorized";
    private String allowedSender;

    public BTPushFilter(String filter) {
        this.allowedSender = filter.toLowerCase();
    }

    private String getBlackList(String allowedSender) {
        int posBlackList = allowedSender.indexOf(TAG_BLACKLIST);
        if (posBlackList == -1) {
            return new String("");
        }
        return allowedSender.substring(posBlackList += TAG_BLACKLIST.length());
    }

    private String getDirectFilter(String allowedSender) {
        int posBlackList = allowedSender.indexOf(TAG_BLACKLIST);
        if (posBlackList == -1) {
            return allowedSender;
        }
        return allowedSender.substring(0, posBlackList - 1);
    }

    private Vector getBlacklistMasks(String blackList) {
        Vector<String> masks = new Vector<String>();
        int pos = 0;
        while (pos < blackList.length()) {
            int comma = blackList.indexOf(59, pos);
            if (comma == -1) {
                masks.addElement(blackList.substring(pos));
                pos = blackList.length();
                continue;
            }
            masks.addElement(blackList.substring(pos, comma));
            pos = comma + 1;
        }
        return masks;
    }

    public boolean accepts(String clientAddress) {
        String filterDomain;
        String filterAddress;
        String domain;
        String address;
        int comma = (clientAddress = clientAddress.toLowerCase()).indexOf(59, 0);
        if (comma == -1) {
            address = clientAddress;
            domain = "";
        } else {
            address = clientAddress.substring(0, comma);
            domain = clientAddress.substring(comma + 1);
        }
        Vector blackListMasks = this.getBlacklistMasks(this.getBlackList(this.allowedSender));
        Enumeration e = blackListMasks.elements();
        while (e.hasMoreElements()) {
            String mask = (String)e.nextElement();
            if (!this.matches(address, mask)) continue;
            return false;
        }
        String directFilter = this.getDirectFilter(this.allowedSender);
        comma = directFilter.indexOf(59, 0);
        if (comma == -1) {
            filterAddress = directFilter;
            filterDomain = "";
        } else {
            filterAddress = directFilter.substring(0, comma);
            filterDomain = directFilter.substring(comma + 1);
        }
        if (filterDomain.compareTo(domain) != 0) {
            return false;
        }
        return this.matches(address, filterAddress);
    }

    private boolean matches(String address, String mask) {
        if (address == null || mask == null) {
            return false;
        }
        if (address == mask) {
            return true;
        }
        int backAddr = 0;
        int backMask = -1;
        int posAddr = 0;
        for (int posMask = 0; posAddr != address.length() || posMask != mask.length(); ++posAddr, ++posMask) {
            if (posMask == mask.length()) {
                if (backMask == -1) {
                    return false;
                }
                posAddr = backAddr++;
                posMask = backMask;
                continue;
            }
            if (mask.charAt(posMask) == '*') {
                --posAddr;
                backMask = posMask;
                continue;
            }
            if (posAddr == address.length()) {
                return false;
            }
            if (mask.charAt(posMask) == address.charAt(posAddr) || mask.charAt(posMask) == '?') continue;
            if (backMask == -1) {
                return false;
            }
            posAddr = backAddr++;
            posMask = backMask;
        }
        return true;
    }

    public String toString() {
        return this.allowedSender;
    }
}

