/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.impl;

import com.sun.kvem.jsr082.bluetooth.SDDBImpl;
import com.sun.kvem.jsr082.impl.BTPushFilter;
import com.sun.kvem.jsr082.impl.FakeServerRequestHandler;
import com.sun.kvem.jsr082.impl.bluetooth.BTEnableAlert;
import com.sun.kvem.jsr082.impl.bluetooth.BTNotifierBase;
import com.sun.kvem.jsr082.impl.bluetooth.BluetoothController;
import com.sun.kvem.jsr082.obex.ObexTransportNotifier;
import com.sun.midp.io.j2me.btl2cap.BTL2CAPNotifier;
import com.sun.midp.io.j2me.btl2cap.Protocol;
import com.sun.midp.io.j2me.btspp.BTSPPNotifier;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.bluetooth.BluetoothConnectionException;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.LocalDevice;
import javax.microedition.io.StreamConnection;
import javax.obex.ServerRequestHandler;
import javax.obex.SessionNotifier;

public class JSR082PushRegistry
implements Runnable {
    String url;
    public static final int TYPE_L2CAP = 1;
    public static final int TYPE_GOEP = 2;
    public static final int TYPE_SPP = 3;
    private static Object threadsLock = new Object();
    private static Hashtable notifiers = new Hashtable();
    private static String currentFriendlyName = "";
    private int type;
    private int fd;
    private String filter;
    static final String LOCALHOST = "localhost";
    static final String BTGOEP = "btgoep";
    static final String BTL2CAP = "btl2cap";
    static final String BTSPP = "btspp";
    static final String AUTHORIZED = "authorized";
    static final String AUTHENTICATED = "authenticated";
    static final String BLACKLIST = "blacklist";

    public JSR082PushRegistry(String connURL, String filter) {
        this.url = connURL;
        if (this.url.startsWith("btgoep://")) {
            this.type = 2;
        } else if (this.url.startsWith("btspp://")) {
            this.type = 3;
        } else if (this.url.startsWith("btl2cap://")) {
            this.type = 1;
        }
        this.filter = filter;
    }

    public void setFileDescriptor(int fd) {
        this.fd = fd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCurrentFriendlyName(String name) {
        Object object = threadsLock;
        synchronized (object) {
            currentFriendlyName = name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentFriendlyName() {
        Object object = threadsLock;
        synchronized (object) {
            return currentFriendlyName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void killListener(Vector filedescriptors) {
        boolean needToRestore = false;
        Object object = threadsLock;
        synchronized (object) {
            Enumeration e = notifiers.keys();
            while (e.hasMoreElements()) {
                Integer i = (Integer)e.nextElement();
                if (filedescriptors.contains(i)) continue;
                Object notif = notifiers.get(i);
                try {
                    if (notif instanceof BTNotifierBase) {
                        ((BTNotifierBase)notif).close();
                    } else if (notif instanceof ObexTransportNotifier) {
                        ((ObexTransportNotifier)notif).close();
                    }
                    needToRestore = true;
                    BluetoothController.getInstance().removePushConnection(i.toString());
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                notifiers.remove(i);
                break;
            }
        }
        if (needToRestore) {
            JSR082PushRegistry.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            LocalDevice ld = LocalDevice.getLocalDevice();
            if (ld.getDiscoverable() != 10390323) {
                BTEnableAlert.setDeviceDiscoverable();
            }
            boolean passedFilter = false;
            StreamConnection c = null;
            switch (this.type) {
                case 3: {
                    com.sun.midp.io.j2me.btspp.Protocol p = new com.sun.midp.io.j2me.btspp.Protocol();
                    BTSPPNotifier scn = (BTSPPNotifier)p.openPrim(null, this.url.substring(6), 3, false, true, new BTPushFilter(this.filter));
                    Object object = threadsLock;
                    synchronized (object) {
                        notifiers.put(new Integer(this.fd), scn);
                    }
                    BluetoothController.getInstance().addPushConnection(new Integer(this.fd).toString());
                    do {
                        try {
                            passedFilter = true;
                            c = scn.acceptAndOpen();
                        }
                        catch (BluetoothConnectionException bce) {
                            bce.printStackTrace();
                            if (bce.getStatus() != 2) continue;
                            passedFilter = false;
                        }
                        catch (BluetoothStateException bse) {
                            scn.close();
                            return;
                        }
                        catch (IOException ioe) {
                            Object object2 = threadsLock;
                            synchronized (object2) {
                                if (notifiers.get(new Integer(this.fd)) != null) {
                                    throw ioe;
                                }
                            }
                        }
                    } while (!passedFilter);
                    JSR082PushRegistry.connectionReceived(this.fd);
                    break;
                }
                case 1: {
                    Protocol p = new Protocol();
                    BTL2CAPNotifier lcn = (BTL2CAPNotifier)p.openPrim(null, this.url.substring(8), 3, false, true, new BTPushFilter(this.filter));
                    Object ioe = threadsLock;
                    synchronized (ioe) {
                        notifiers.put(new Integer(this.fd), lcn);
                    }
                    BluetoothController.getInstance().addPushConnection(new Integer(this.fd).toString());
                    do {
                        try {
                            passedFilter = true;
                            c = lcn.acceptAndOpen();
                        }
                        catch (BluetoothConnectionException bce) {
                            bce.printStackTrace();
                            if (bce.getStatus() != 2) continue;
                            passedFilter = false;
                        }
                        catch (IOException ioe2) {
                            Object object = threadsLock;
                            synchronized (object) {
                                if (notifiers.get(new Integer(this.fd)) != null) {
                                    throw ioe2;
                                }
                            }
                        }
                    } while (!passedFilter);
                    JSR082PushRegistry.connectionReceived(this.fd);
                    break;
                }
                case 2: {
                    com.sun.midp.io.j2me.btgoep.Protocol p = new com.sun.midp.io.j2me.btgoep.Protocol();
                    SessionNotifier sn = (SessionNotifier)p.openPrim(this.url.substring(7), 3, false, true, new BTPushFilter(this.filter));
                    Object ioe2 = threadsLock;
                    synchronized (ioe2) {
                        notifiers.put(new Integer(this.fd), sn);
                    }
                    BluetoothController.getInstance().addPushConnection(new Integer(this.fd).toString());
                    do {
                        try {
                            passedFilter = true;
                            c = sn.acceptAndOpen((ServerRequestHandler)new FakeServerRequestHandler());
                        }
                        catch (BluetoothConnectionException bce) {
                            bce.printStackTrace();
                            if (bce.getStatus() != 2) continue;
                            passedFilter = false;
                        }
                        catch (NullPointerException npe) {
                        }
                        catch (IOException ioe) {
                            Object object = threadsLock;
                            synchronized (object) {
                                if (notifiers.get(new Integer(this.fd)) != null) {
                                    throw ioe;
                                }
                            }
                        }
                    } while (!passedFilter);
                    JSR082PushRegistry.connectionReceived(this.fd);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static native void connectionReceived(int var0);

    public static native String getBluetoothConnections();

    private static boolean checkCorrectAddressFilter(String str) {
        boolean hasStar = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = Character.toLowerCase(str.charAt(i));
            if (Character.isDigit(c) || c == 'a' || c == 'b' || c == 'c' || c == 'd' || c == 'e' || c == 'f' || c == '?') continue;
            if (c != '*') {
                return false;
            }
            hasStar = true;
        }
        return str.length() == 12 || (str.length() >= 12 || hasStar) && str.length() <= 12;
    }

    private static boolean isBoolean(String str) {
        return str.toLowerCase().equals("true") || str.toLowerCase().equals("false");
    }

    public static boolean checkFilterString(String filter) throws IllegalArgumentException {
        String tmp;
        int index;
        if (filter == null || filter.length() < 1) {
            return false;
        }
        int filterPos = 0;
        boolean directFilter = false;
        boolean blackList = false;
        boolean auth = false;
        do {
            if ((tmp = (index = filter.indexOf(59, filterPos)) == -1 ? filter.substring(filterPos) : filter.substring(filterPos, index)).toLowerCase().equals(AUTHENTICATED) || tmp.toLowerCase().equals(AUTHORIZED)) {
                if (auth) {
                    return false;
                }
                auth = true;
                if (!directFilter) {
                    return false;
                }
                filterPos = index + 1;
                continue;
            }
            if (tmp.toLowerCase().startsWith(BLACKLIST)) {
                blackList = true;
                filterPos = filter.indexOf(61) + 1;
                break;
            }
            if (tmp.length() > 12) {
                return false;
            }
            directFilter = true;
            if (!JSR082PushRegistry.checkCorrectAddressFilter(tmp)) {
                return false;
            }
            filterPos = index + 1;
        } while (index != -1);
        if (blackList) {
            int counter = 1;
            do {
                if (counter++ > 1024) {
                    return false;
                }
                index = filter.indexOf(59, filterPos);
                tmp = index == -1 ? filter.substring(filterPos) : filter.substring(filterPos, index);
                if (!JSR082PushRegistry.checkCorrectAddressFilter(tmp)) {
                    return false;
                }
                filterPos = index + 1;
            } while (index != -1);
        }
        return true;
    }

    public static boolean checkConnectionString(String connURL) throws IllegalArgumentException {
        int currentPos = 0;
        int index = connURL.indexOf(58);
        String protocol = connURL.substring(0, index);
        if (!(connURL = connURL.substring(index + 1)).startsWith("//")) {
            return false;
        }
        currentPos = 2;
        index = currentPos + LOCALHOST.length();
        String tmp = connURL.substring(currentPos, index);
        if (!tmp.toLowerCase().equals(LOCALHOST)) {
            return false;
        }
        currentPos = index++;
        if (connURL.charAt(currentPos++) != ':') {
            return false;
        }
        index = connURL.indexOf(59);
        String uuid = index == -1 ? connURL.substring(currentPos) : connURL.substring(currentPos, index);
        if (uuid.length() > 32) {
            return false;
        }
        for (int i = 0; i < uuid.length(); ++i) {
            char c = Character.toLowerCase(uuid.charAt(i));
            if (Character.isDigit(c) || c == 'a' || c == 'b' || c == 'c' || c == 'd' || c == 'e' || c == 'f') continue;
            return false;
        }
        if (index == -1) {
            return true;
        }
        Hashtable<String, String> params = new Hashtable<String, String>();
        while (index != -1) {
            currentPos = index + 1;
            if ((index = connURL.indexOf(61, currentPos)) == -1) {
                return false;
            }
            String param = connURL.substring(currentPos, index).toLowerCase();
            if (!((param.toLowerCase().equals("name") || param.toLowerCase().equals("master") || param.toLowerCase().equals("encrypt") || param.toLowerCase().equals("authorize") || param.toLowerCase().equals("authenticate") || param.toLowerCase().equals("receivemtu") && protocol.equals(BTL2CAP) || param.toLowerCase().equals("transmitmtu") && protocol.equals(BTL2CAP)) && !params.containsKey(param.toLowerCase()))) {
                return false;
            }
            currentPos = index + 1;
            tmp = (index = connURL.indexOf(59, currentPos)) == -1 ? connURL.substring(currentPos) : connURL.substring(currentPos, index);
            params.put(param.toLowerCase(), tmp);
            if (param.toLowerCase().equals("receivemtu") || param.toLowerCase().equals("transmitmtu")) {
                try {
                    Integer.parseInt(tmp, 10);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
            }
            if (param.toLowerCase().equals("name") || JSR082PushRegistry.isBoolean(tmp)) continue;
            return false;
        }
        String authorize = (String)params.get("authorize");
        String authenticate = (String)params.get("authenticate");
        String encrypt = (String)params.get("encrypt");
        if (authenticate != null && authorize != null && authorize.toLowerCase().equals("true") && authenticate.toLowerCase().equals("false")) {
            return false;
        }
        return encrypt == null || !encrypt.toLowerCase().equals("true") || authenticate == null || !authenticate.toLowerCase().equals("false");
    }

    private static void store() {
        try {
            LocalDevice.getLocalDevice();
            SDDBImpl sddb = SDDBImpl.getSDDBInstance();
            sddb.store(true);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

