/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.impl;

import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import com.sun.midp.security.SecurityToken;
import java.io.InterruptedIOException;

public final class PermissionsHandler {
    public static final int OBEX_CLIENT = 21;
    public static final int OBEX_SERVER = 22;
    public static final int TCP_OBEX_CLIENT = 23;
    public static final int TCP_OBEX_SERVER = 24;
    public static final int BLUETOOTH_CLIENT = 33;
    public static final int BLUETOOTH_SERVER = 34;
    public static final int BLUETOOTH_AUTHORIZE = 35;
    public static final int BLUETOOTH_ENABLE = 51;
    public static final int BLUETOOTH_DISCOVERABLE = 54;
    private boolean permissionChecked;
    private boolean isOwnerTrusted;
    private SecurityToken ownerSecurityToken = null;

    public final void checkForPermission(Object tokenObj, int requiredPermission, String origName) throws InterruptedIOException {
        if (this.permissionChecked) {
            return;
        }
        SecurityToken token = (SecurityToken)tokenObj;
        if (token != null) {
            token.checkIfPermissionAllowed(requiredPermission);
            this.ownerSecurityToken = token;
            this.isOwnerTrusted = true;
            this.permissionChecked = true;
            return;
        }
        Scheduler scheduler = Scheduler.getScheduler();
        MIDletSuite midletSuite = scheduler.getMIDletSuite();
        if (midletSuite == null) {
            return;
        }
        try {
            midletSuite.checkForPermission(requiredPermission, origName);
            this.permissionChecked = true;
        }
        catch (InterruptedException ie) {
            throw new InterruptedIOException("Interrupted while trying to ask the user permission");
        }
    }
}

