/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.impl.bluetooth;

import com.sun.kvem.jsr082.impl.BTPushFilter;
import com.sun.kvem.jsr082.impl.JSR082PushRegistry;
import com.sun.kvem.jsr082.impl.PermissionsHandler;
import com.sun.kvem.jsr082.impl.Utilites;
import com.sun.kvem.jsr082.impl.bluetooth.BTConnectionBase;
import com.sun.kvem.jsr082.impl.bluetooth.BTNotifierBase;
import com.sun.kvem.jsr082.impl.bluetooth.BluetoothController;
import com.sun.kvem.jsr082.impl.bluetooth.SecurityTokenHandler;
import com.sun.kvem.jsr082.impl.io.JSR082Connection;
import com.sun.kvem.jsr082.impl.io.JSR082Notifier;
import com.sun.midp.midlet.Scheduler;
import java.io.IOException;
import java.util.Hashtable;
import javax.bluetooth.BluetoothConnectionException;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.UUID;
import javax.microedition.io.Connection;

public abstract class BluetoothProtocolBase {
    private static final boolean DEBUG = false;
    private final PermissionsHandler clientPH = new PermissionsHandler();
    private final PermissionsHandler serverPH = new PermissionsHandler();
    protected BTPushFilter pushFilter;
    protected String protocol;
    private static final String cn = "bt<common>.Protocol";
    protected String errorMsg;
    protected String numberStr;
    private boolean encrypt;
    private boolean authenticate;
    private boolean authorize;
    private boolean master;
    private String serverName;
    private int mode;
    protected boolean isPush = false;
    protected boolean isSystemUse;
    protected String origName;
    private String btaddress;

    public BluetoothProtocolBase(String protocol) {
        this.protocol = protocol;
    }

    public Connection openPrim(String name, int mode, boolean timeouts) throws IOException {
        return this.openPrim(null, name, mode, timeouts, false, null);
    }

    public Connection openPrim(Object token, String name, int mode, boolean timeouts) throws IOException {
        return this.openPrim(token, name, mode, timeouts, false, null);
    }

    public Connection openPrim(Object token, String name, int mode, boolean timeouts, boolean isPush, BTPushFilter pushFilter) throws IOException {
        this.isPush = isPush;
        this.pushFilter = pushFilter;
        String localhostStr = "//localhost";
        this.origName = this.protocol + name;
        this.errorMsg = "Malformed URL: " + this.protocol + name;
        try {
            LocalDevice.getLocalDevice();
        }
        catch (BluetoothStateException e) {
            throw new IOException("bluetooth support is not initialized.");
        }
        this.checkOpenMode(mode);
        this.mode = mode;
        String namename = name;
        name = name.toLowerCase();
        if (name.startsWith("//localhost")) {
            if (token instanceof BluetoothController) {
                this.isSystemUse = true;
            } else {
                this.serverPH.checkForPermission(token, 34, this.origName);
                this.isSystemUse = token != null;
            }
            return this.processServerNotifier(name, namename, isPush);
        }
        if (token instanceof BluetoothController) {
            this.isSystemUse = true;
        } else {
            this.clientPH.checkForPermission(token, 33, this.origName);
            this.isSystemUse = token != null;
        }
        return this.processClientConnection(name, namename);
    }

    private Hashtable parseURL(String name, String origName) {
        Hashtable<String, String> params = null;
        int namePos = 0;
        if (!name.startsWith("//")) {
            throw new IllegalArgumentException(this.errorMsg);
        }
        int index = name.indexOf(58);
        if (index == -1) {
            throw new IllegalArgumentException(this.errorMsg);
        }
        if (index == name.length() - 1) {
            throw new IllegalArgumentException(this.errorMsg);
        }
        this.btaddress = name.substring(2, index);
        namePos = index + 1;
        if ((index = name.indexOf(59, namePos)) != -1) {
            this.numberStr = name.substring(namePos, index);
            params = new Hashtable<String, String>();
        } else {
            this.numberStr = name.substring(namePos);
        }
        while (index != -1) {
            if (index == name.length() - 1) {
                throw new IllegalArgumentException(this.errorMsg);
            }
            namePos = index + 1;
            if ((index = name.indexOf(61, namePos)) <= namePos || index == name.length() - 1) {
                throw new IllegalArgumentException(this.errorMsg);
            }
            String key = name.substring(namePos, index);
            if (params.containsKey(key)) {
                throw new IllegalArgumentException(this.errorMsg);
            }
            namePos = index + 1;
            index = name.indexOf(59, namePos);
            String value = "name".equals(key) ? (index != -1 ? origName.substring(namePos, index) : origName.substring(namePos)) : (index != -1 ? name.substring(namePos, index) : name.substring(namePos));
            params.put(key, value);
        }
        return params;
    }

    private Connection processClientConnection(String name, String namename) throws IOException {
        BTConnectionBase handler = this.createConnection();
        Hashtable params = this.parseURL(name, namename);
        if (!Utilites.checkBluetoothAddress(this.btaddress)) {
            throw new IllegalArgumentException(this.errorMsg);
        }
        this.btaddress = this.btaddress.toUpperCase();
        handler.setRemoteAddress(this.btaddress);
        int channelOrPSM = this.getChannelOrPSM();
        this.getParameters(params, handler, false);
        if (params != null && !params.isEmpty()) {
            throw new IllegalArgumentException(this.errorMsg);
        }
        int port = handler.clientConnectionGetTransportPort(this.btaddress, channelOrPSM);
        if (port == 0) {
            throw new IOException("Connection is refused");
        }
        JSR082Connection conn = null;
        try {
            conn = new JSR082Connection(SecurityTokenHandler.getSecurityToken(), port);
        }
        catch (IOException e) {
            throw new IOException("Connection is refused");
        }
        try {
            handler.initClientConnection(conn, this.mode, this.master, this.authenticate, this.encrypt);
        }
        catch (IOException e) {
            try {
                conn.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw e;
        }
        return handler;
    }

    private Connection processServerNotifier(String name, String namename, boolean isPush) throws IOException {
        BTNotifierBase handler = this.createNotifier();
        this.checkIfInstalled(name);
        Hashtable params = this.parseURL(name, namename);
        this.setUUID(handler);
        this.getParameters(params, handler, true);
        if (params != null && !params.isEmpty()) {
            throw new IllegalArgumentException(this.errorMsg);
        }
        JSR082Notifier notif = new JSR082Notifier(SecurityTokenHandler.getSecurityToken());
        try {
            handler.initServerNotifier(notif, this.mode, this.serverName, this.master, this.authorize, this.authenticate, this.encrypt, isPush, this.pushFilter);
        }
        catch (IOException e) {
            try {
                notif.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw e;
        }
        return handler;
    }

    protected void getParameters(Hashtable params, Connection handler, boolean isServer) throws BluetoothConnectionException {
        if (params != null) {
            if (isServer) {
                this.serverName = (String)params.remove("name");
                if (this.serverName != null) {
                    if (this.serverName.length() == 0) {
                        throw new IllegalArgumentException("zero length service name");
                    }
                    for (int i = 0; i < this.serverName.length(); ++i) {
                        char c = this.serverName.charAt(i);
                        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == ' ' || c == '-' || c == '_') continue;
                        throw new IllegalArgumentException("wrong character in service name");
                    }
                }
                this.authorize = BluetoothProtocolBase.extractBoolean("authorize", params, false);
            }
            this.encrypt = BluetoothProtocolBase.extractBoolean("encrypt", params, false);
            boolean needAuthenticate = this.encrypt || this.authorize;
            this.authenticate = BluetoothProtocolBase.extractBoolean("authenticate", params, needAuthenticate);
            if (needAuthenticate && !this.authenticate) {
                throw new BluetoothConnectionException(6, "invalid security parameters");
            }
            this.master = BluetoothProtocolBase.extractBoolean("master", params, false);
        }
    }

    protected void setUUID(BTNotifierBase handler) {
        try {
            handler.serverUUID = new UUID(this.numberStr, false);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(this.errorMsg);
        }
    }

    protected static boolean extractBoolean(String key, Hashtable params, boolean deflt) {
        String val = (String)params.remove(key);
        if (val == null) {
            return deflt;
        }
        if (val.equals("true")) {
            return true;
        }
        if (val.equals("false")) {
            return false;
        }
        throw new IllegalArgumentException(key + " should be 'true' of 'false': " + val);
    }

    private void checkIfInstalled(String name) throws IOException {
        int index;
        String connections = JSR082PushRegistry.getBluetoothConnections();
        if (this.isPush || connections == null || connections.length() == 0) {
            return;
        }
        do {
            if (!connections.startsWith(this.protocol)) continue;
            index = connections.indexOf(58);
            connections.substring(index + 1);
            if (!name.toLowerCase().equals(connections.substring(this.protocol.length(), this.protocol.length() + 44).toLowerCase())) continue;
            index = 0;
            for (int i = 0; i < 3; ++i) {
                index = connections.indexOf(44, index + 1);
            }
            int index2 = connections.indexOf(38, index);
            if (connections.substring(index + 1, index2).equals(Scheduler.getScheduler().getMIDletSuite().getStorageName())) continue;
            throw new IOException("Connection registered to another MIDletSuite");
        } while ((connections = (index = connections.indexOf(36)) != connections.length() - 1 && index != -1 ? connections.substring(index + 1) : null) != null);
    }

    protected void checkOpenMode(int mode) {
        if (mode != 3) {
            throw new IllegalArgumentException("Unsupported mode: " + mode);
        }
    }

    protected abstract int getChannelOrPSM();

    protected abstract BTConnectionBase createConnection() throws IOException;

    protected abstract BTNotifierBase createNotifier() throws IOException;
}

