/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.obex;

import com.sun.kvem.jsr082.obex.ObexPacketStream;
import com.sun.kvem.jsr082.obex.SSLWrapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.obex.Authenticator;
import javax.obex.PasswordAuthentication;

class ObexAuth {
    private static final boolean DEBUG = false;
    private static byte[] column = new byte[]{58};
    String realm;
    boolean userID;
    boolean access;
    byte[] nonce;
    private static int counter = 0;
    private byte[] realm_array;
    private int challengeLength;
    private static byte[] privateKey = null;
    static /* synthetic */ Class class$com$sun$kvem$jsr082$obex$ObexAuth;

    static ObexAuth createChallenge(String realm, boolean userID, boolean access) {
        return new ObexAuth(realm, null, userID, access);
    }

    private ObexAuth(String realm, byte[] nonce, boolean userID, boolean access) {
        this.realm = realm;
        this.nonce = nonce;
        this.userID = userID;
        this.access = access;
    }

    int prepareChallenge() {
        if (this.challengeLength != 0) {
            return this.challengeLength;
        }
        try {
            int len = 24;
            this.realm_array = null;
            if (this.realm != null) {
                this.realm_array = this.realm.getBytes("UTF-16BE");
                len += 3 + this.realm_array.length;
            }
            this.challengeLength = len;
        }
        catch (UnsupportedEncodingException e) {
            return 0;
        }
        return this.challengeLength;
    }

    int addChallenge(byte[] packet, int offset) throws IOException {
        int len = this.prepareChallenge();
        packet[offset] = 77;
        packet[offset + 1] = (byte)(len >> 8);
        packet[offset + 2] = (byte)(len & 0xFF);
        packet[offset + 3] = 0;
        packet[offset + 4] = 16;
        this.nonce = ObexAuth.makeNonce();
        System.arraycopy(this.nonce, 0, packet, offset + 5, 16);
        packet[offset + 21] = 1;
        packet[offset + 22] = 1;
        packet[offset + 23] = (byte)((this.userID ? 1 : 0) + (this.access ? 0 : 2));
        if (this.realm != null) {
            int realm_len = this.realm_array.length;
            packet[offset + 24] = 2;
            packet[offset + 25] = (byte)(realm_len + 1);
            packet[offset + 26] = -1;
            System.arraycopy(this.realm_array, 0, packet, offset + 27, realm_len);
        }
        return len;
    }

    private static byte[] makeNonce() throws IOException {
        SSLWrapper md5 = new SSLWrapper();
        byte[] timestamp = ObexAuth.createTimestamp();
        md5.update(timestamp, 0, timestamp.length);
        md5.update(column, 0, 1);
        byte[] privateKey = ObexAuth.getPrivateKey();
        byte[] nonce = new byte[16];
        md5.doFinal(privateKey, 0, privateKey.length, nonce, 0);
        return nonce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] createTimestamp() {
        long time = System.currentTimeMillis();
        byte[] timestamp = new byte[9];
        timestamp[0] = (byte)(time >> 56);
        timestamp[1] = (byte)(time >> 48);
        timestamp[2] = (byte)(time >> 40);
        timestamp[3] = (byte)(time >> 32);
        timestamp[4] = (byte)(time >> 24);
        timestamp[5] = (byte)(time >> 16);
        timestamp[6] = (byte)(time >> 8);
        timestamp[7] = (byte)time;
        Class clazz = class$com$sun$kvem$jsr082$obex$ObexAuth == null ? (class$com$sun$kvem$jsr082$obex$ObexAuth = ObexAuth.class$("com.sun.kvem.jsr082.obex.ObexAuth")) : class$com$sun$kvem$jsr082$obex$ObexAuth;
        synchronized (clazz) {
            timestamp[8] = (byte)counter++;
        }
        return timestamp;
    }

    private static synchronized byte[] getPrivateKey() throws IOException {
        if (privateKey != null) {
            return privateKey;
        }
        SSLWrapper md5 = new SSLWrapper();
        byte[] keyData = null;
        try {
            keyData = "timestamp = ".getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        md5.update(keyData, 0, keyData.length);
        byte[] timestamp = ObexAuth.createTimestamp();
        privateKey = new byte[16];
        md5.doFinal(timestamp, 0, timestamp.length, privateKey, 0);
        return privateKey;
    }

    static void makeDigest(byte[] buffer, int offset, byte[] nonce, byte[] password) throws IOException {
        SSLWrapper md5 = new SSLWrapper();
        md5.update(nonce, 0, 16);
        md5.update(column, 0, 1);
        md5.doFinal(password, 0, password.length, buffer, offset);
    }

    static ObexAuth parseAuthChallenge(byte[] buffer, int packetOffset, int length) throws IOException {
        int offset;
        int len;
        boolean readonly = false;
        boolean needUserid = false;
        byte[] nonce = null;
        String realm = null;
        length += packetOffset;
        block7: for (offset = packetOffset + 3; offset < length; offset += len) {
            int tag = buffer[offset] & 0xFF;
            len = buffer[offset + 1] & 0xFF;
            offset += 2;
            switch (tag) {
                case 0: {
                    if (len != 16 || nonce != null) {
                        throw new IOException("protocol error");
                    }
                    nonce = new byte[16];
                    System.arraycopy(buffer, offset, nonce, 0, 16);
                    continue block7;
                }
                case 1: {
                    if (len != 1) {
                        throw new IOException("protocol error");
                    }
                    byte options = buffer[offset];
                    readonly = (options & 2) != 0;
                    needUserid = (options & 1) != 0;
                    continue block7;
                }
                case 2: {
                    try {
                        int encodingID = buffer[offset] & 0xFF;
                        String encoding = null;
                        if (encodingID == 255) {
                            encoding = "UTF-16BE";
                        } else if (encodingID == 0) {
                            encoding = "US-ASCII";
                        } else if (encodingID < 10) {
                            encoding = "ISO-8859-" + encoding;
                        } else {
                            throw new UnsupportedEncodingException();
                        }
                        realm = new String(buffer, offset + 1, len - 1, encoding);
                        continue block7;
                    }
                    catch (UnsupportedEncodingException e) {
                        // empty catch block
                    }
                }
            }
        }
        if (offset != length) {
            throw new IOException("protocol error");
        }
        return new ObexAuth(realm, nonce, needUserid, !readonly);
    }

    int replyAuthChallenge(byte[] buffer, int packetOffset, Authenticator authenticator) throws IOException {
        if (this.realm == null) {
            this.realm = "";
        }
        byte[] password = null;
        byte[] username = null;
        try {
            PasswordAuthentication pass = authenticator.onAuthenticationChallenge(this.realm, this.userID, this.access);
            password = pass.getPassword();
            int uidLen = 0;
            username = pass.getUserName();
            if (this.userID || username != null) {
                if (this.userID && username.length == 0) {
                    throw new Exception();
                }
                uidLen = 2 + username.length;
                if (uidLen > 22) {
                    uidLen = 22;
                }
            }
            int len = 39 + uidLen;
            buffer[packetOffset + 0] = 78;
            buffer[packetOffset + 1] = (byte)(len >> 8);
            buffer[packetOffset + 2] = (byte)(len & 0xFF);
            buffer[packetOffset + 3] = 0;
            buffer[packetOffset + 4] = 16;
            ObexAuth.makeDigest(buffer, packetOffset + 5, this.nonce, password);
            buffer[packetOffset + 21] = 2;
            buffer[packetOffset + 22] = 16;
            System.arraycopy(this.nonce, 0, buffer, packetOffset + 23, 16);
            if (uidLen > 2) {
                buffer[packetOffset + 39] = 1;
                buffer[packetOffset + 40] = (byte)(uidLen - 2);
                System.arraycopy(username, 0, buffer, packetOffset + 41, uidLen - 2);
            }
            return len;
        }
        catch (Throwable t) {
            return 0;
        }
    }

    private static void print(String msg, byte[] array) {
    }

    private static boolean compare(byte[] src1, byte[] src2) {
        for (int i = 0; i < 16; ++i) {
            if (src1[i] == src2[i]) continue;
            return false;
        }
        return true;
    }

    static boolean checkAuthResponse(byte[] buffer, int packetOffset, int length, ObexPacketStream stream, Vector challenges) throws IOException {
        int offset;
        int len;
        length += packetOffset;
        byte[] digest = null;
        byte[] username = null;
        byte[] nonce = null;
        block7: for (offset = packetOffset + 3; offset < length; offset += len) {
            int tag = buffer[offset] & 0xFF;
            len = buffer[offset + 1] & 0xFF;
            offset += 2;
            switch (tag) {
                case 0: {
                    if (len != 16 || digest != null) {
                        throw new IOException("protocol error (1)");
                    }
                    digest = new byte[16];
                    System.arraycopy(buffer, offset, digest, 0, 16);
                    continue block7;
                }
                case 1: {
                    if (len > 20 || len == 0 || username != null) {
                        throw new IOException("protocol error (2)");
                    }
                    username = new byte[len];
                    System.arraycopy(buffer, offset, username, 0, len);
                    continue block7;
                }
                case 2: {
                    if (len != 16 || nonce != null) {
                        throw new IOException("protocol error (3)");
                    }
                    nonce = new byte[16];
                    System.arraycopy(buffer, offset, nonce, 0, 16);
                    continue block7;
                }
            }
        }
        if (offset != length) {
            throw new IOException("protocol error (4)");
        }
        ObexAuth auth = null;
        if (nonce == null) {
            if (challenges.size() == 0) {
                return false;
            }
            auth = (ObexAuth)challenges.elementAt(0);
            nonce = auth.nonce;
            challenges.removeElementAt(0);
        } else {
            for (int i = 0; i < challenges.size(); ++i) {
                ObexAuth a = (ObexAuth)challenges.elementAt(i);
                if (!ObexAuth.compare(nonce, a.nonce)) continue;
                auth = a;
                challenges.removeElementAt(i);
                break;
            }
            if (auth == null) {
                return false;
            }
        }
        if (auth.userID && username == null) {
            stream.onAuthenticationFailure(username);
            return false;
        }
        try {
            byte[] password = stream.authenticator.onAuthenticationResponse(username);
            byte[] localDigest = new byte[16];
            ObexAuth.makeDigest(localDigest, 0, nonce, password);
            boolean res = ObexAuth.compare(localDigest, digest);
            if (!res) {
                stream.onAuthenticationFailure(username);
            }
            return res;
        }
        catch (Throwable t) {
            stream.onAuthenticationFailure(username);
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

