/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.obex;

import com.sun.kvem.jsr082.obex.HeaderSetImpl;
import com.sun.kvem.jsr082.obex.ObexAuth;
import com.sun.kvem.jsr082.obex.ObexPacketStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Vector;

public class QueuedHeader {
    private static final boolean DEBUG = false;
    private ObexPacketStream stream;
    private int type;
    private Object value;
    byte[] buffer;
    int packetLength;

    QueuedHeader(ObexPacketStream stream) {
        this.stream = stream;
    }

    void sendOrQueue(int type, Object value) throws IOException {
        if (this.stream.moreHeaders && this.send(type, value)) {
            this.stream.challengesToSend = true;
            return;
        }
        this.queue(type, value);
    }

    void queue(int type, Object value) throws IOException {
        int maxSendLength = this.stream.maxSendLength;
        boolean fail = false;
        switch (HeaderSetImpl.internalType(type)) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                if (((String)value).length() + 7 <= maxSendLength) break;
                fail = true;
                break;
            }
            case 0: {
                if ((((String)value).length() << 1) + 8 <= maxSendLength) break;
                fail = true;
                break;
            }
            case 1: {
                if (((byte[])value).length + 6 <= maxSendLength) break;
                fail = true;
                break;
            }
            case 8: {
                Vector challenges = (Vector)value;
                if (challenges.isEmpty()) {
                    return;
                }
                int len = 0;
                for (int i = 0; i < challenges.size(); ++i) {
                    len += ((ObexAuth)challenges.elementAt(i)).prepareChallenge();
                }
                if (len + 3 <= maxSendLength) break;
                fail = true;
            }
        }
        if (fail) {
            this.stream.headerTooLarge();
            return;
        }
        this.type = type;
        this.value = value;
        this.newHeader();
    }

    boolean trySendAgain() throws IOException {
        return this.send(this.type, this.value);
    }

    boolean send(int type, Object value) throws IOException {
        this.buffer = this.stream.buffer;
        this.packetLength = this.stream.packetLength;
        int maxSendLength = this.stream.maxSendLength;
        try {
            this.buffer[this.packetLength++] = (byte)type;
            switch (HeaderSetImpl.internalType(type)) {
                case 5: {
                    this.encodeTime8601((Calendar)value);
                    break;
                }
                case 4: {
                    this.encodeInt(((Calendar)value).getTime().getTime() / 1000L);
                    break;
                }
                case 6: {
                    byte[] str = ((String)value).getBytes("ISO-8859-1");
                    this.encodeLength16(str.length + 4);
                    System.arraycopy(str, 0, this.buffer, this.packetLength, str.length);
                    this.packetLength += str.length;
                    this.buffer[this.packetLength++] = 0;
                    break;
                }
                case 8: {
                    int i;
                    --this.packetLength;
                    Vector challenges = (Vector)value;
                    this.stream.authFailed = false;
                    for (i = 0; i < challenges.size(); ++i) {
                        ObexAuth auth = (ObexAuth)challenges.elementAt(i);
                        this.packetLength += auth.addChallenge(this.buffer, this.packetLength);
                    }
                    if (this.packetLength > maxSendLength) break;
                    for (i = 0; i < challenges.size(); ++i) {
                        this.stream.authFailed = true;
                        this.stream.authChallenges.addElement(challenges.elementAt(i));
                    }
                    break;
                }
                case 3: {
                    this.encodeInt((Long)value);
                    break;
                }
                case 0: {
                    byte[] str = ((String)value).getBytes("UTF-16BE");
                    this.encodeLength16(str.length + 5);
                    System.arraycopy(str, 0, this.buffer, this.packetLength, str.length);
                    this.packetLength += str.length;
                    this.buffer[this.packetLength++] = 0;
                    this.buffer[this.packetLength++] = 0;
                    break;
                }
                case 1: {
                    byte[] array = (byte[])value;
                    this.encodeLength16(array.length + 3);
                    System.arraycopy(array, 0, this.buffer, this.packetLength, array.length);
                    this.packetLength += array.length;
                    this.stream.containsTargetHeader = this.stream.containsTargetHeader | type == 70;
                    break;
                }
                case 2: {
                    this.buffer[this.packetLength++] = (Byte)value;
                    break;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.toString());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.stream.moreHeaders = false;
            return false;
        }
        if (this.packetLength > maxSendLength) {
            this.stream.moreHeaders = false;
            return false;
        }
        if (this.stream.dataOpened) {
            int dataOffset = this.stream.dataOffset;
            int len = this.stream.packetLength - dataOffset;
            this.buffer[dataOffset + 1] = (byte)(len >> 8);
            this.buffer[dataOffset + 2] = (byte)len;
            this.stream.dataOpened = false;
            this.stream.dataClosed = true;
        }
        this.stream.packetLength = this.packetLength;
        this.value = null;
        return true;
    }

    private void newHeader() {
        this.stream.queuedHeaders.addElement(this);
        this.stream.newHeader = this.stream.emptyHeadersPool.empty() ? new QueuedHeader(this.stream) : (QueuedHeader)this.stream.emptyHeadersPool.pop();
    }

    private void removeHeader() {
        this.stream.queuedHeaders.removeElement(this);
        this.stream.emptyHeadersPool.push(this);
    }

    boolean sendAllQueued() throws IOException {
        while (this.stream.queuedHeaders.size() > 0 && this.stream.moreHeaders) {
            QueuedHeader header = (QueuedHeader)this.stream.queuedHeaders.firstElement();
            boolean res = header.trySendAgain();
            if (!res) {
                return false;
            }
            this.stream.queuedHeaders.removeElementAt(0);
        }
        return true;
    }

    private final void encodeInt(long val) {
        this.buffer[this.packetLength++] = (byte)(val >> 24);
        this.buffer[this.packetLength++] = (byte)(val >> 16);
        this.buffer[this.packetLength++] = (byte)(val >> 8);
        this.buffer[this.packetLength++] = (byte)val;
    }

    private final void encodeLength16(int value) {
        this.buffer[this.packetLength++] = (byte)(value >> 8);
        this.buffer[this.packetLength++] = (byte)value;
    }

    private final void encodeTime8601(Calendar cal) {
        this.encodeLength16(19);
        Calendar cal2 = Calendar.getInstance(ObexPacketStream.utcTimeZone);
        cal2.setTime(cal.getTime());
        int year = cal2.get(1);
        int month = cal2.get(2) + 1;
        int date = cal2.get(5);
        int hour = cal2.get(11);
        int minute = cal2.get(12);
        int second = cal2.get(13);
        int zero = 48;
        if (year < 0 || year > 9999) {
            // empty if block
        }
        this.buffer[this.packetLength++] = (byte)(year / 1000 + zero);
        this.buffer[this.packetLength++] = (byte)((year %= 1000) / 100 + zero);
        this.buffer[this.packetLength++] = (byte)((year %= 100) / 10 + zero);
        this.buffer[this.packetLength++] = (byte)((year %= 10) + zero);
        this.buffer[this.packetLength++] = (byte)(month / 10 + zero);
        this.buffer[this.packetLength++] = (byte)(month % 10 + zero);
        this.buffer[this.packetLength++] = (byte)(date / 10 + zero);
        this.buffer[this.packetLength++] = (byte)(date % 10 + zero);
        this.buffer[this.packetLength++] = 84;
        this.buffer[this.packetLength++] = (byte)(hour / 10 + zero);
        this.buffer[this.packetLength++] = (byte)(hour % 10 + zero);
        this.buffer[this.packetLength++] = (byte)(minute / 10 + zero);
        this.buffer[this.packetLength++] = (byte)(minute % 10 + zero);
        this.buffer[this.packetLength++] = (byte)(second / 10 + zero);
        this.buffer[this.packetLength++] = (byte)(second % 10 + zero);
        this.buffer[this.packetLength++] = 90;
    }
}

