/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.obex;

import com.sun.kvem.jsr082.obex.HeaderSetImpl;
import com.sun.kvem.jsr082.obex.ServerConnectionImpl;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.obex.HeaderSet;
import javax.obex.Operation;

final class ServerOperation
implements Operation {
    private static final boolean DEBUG = false;
    private Object lock = new Object();
    private HeaderSetImpl recvHeaders;
    private ServerConnectionImpl stream;
    private int opcode;
    private boolean isGet;
    private boolean isAborted;
    private boolean requestEnd;
    private boolean inputStreamEof;
    private boolean inputStreamOpened;
    private boolean inputStreamClosed;
    private boolean outputStreamOpened;
    private boolean outputStreamClosed;
    private OperationInputStream is = new OperationInputStream();
    private OperationOutputStream os = new OperationOutputStream();
    private byte[] head = new byte[]{-112, 0, 0};
    private int openObjects = 1;

    ServerOperation(ServerConnectionImpl stream) throws IOException {
        this.stream = stream;
        this.opcode = 3;
        this.isGet = true;
        this.recvHeaders = new HeaderSetImpl(1);
        int mode = ServerOperation.waitForData(stream, this.recvHeaders, 3);
        switch (mode) {
            case 0: {
                this.isAborted = true;
                stream.operationClosed = true;
                break;
            }
            case 2: {
                this.requestEnd = true;
                this.inputStreamEof = true;
                stream.packetBegin(this.head);
                stream.packetAddConnectionID(stream.getConnectionID(), null);
                stream.packetAddAuthResponses();
                stream.packetAddHeaders(null);
            }
        }
    }

    ServerOperation(ServerConnectionImpl stream, HeaderSetImpl recvHeaders) {
        this.stream = stream;
        this.opcode = 2;
        this.isGet = false;
        this.recvHeaders = recvHeaders;
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream openOutputStream() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.stream.operationClosed) {
                throw new IOException("operation closed");
            }
            if (this.outputStreamOpened) {
                throw new IOException("no more output streams available");
            }
            if (!this.requestEnd) {
                throw new IOException("input data not read out");
            }
            this.outputStreamOpened = true;
            ++this.openObjects;
            return this.os;
        }
    }

    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openInputStream() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.stream.operationClosed) {
                throw new IOException("operation closed");
            }
            if (this.inputStreamOpened) {
                throw new IOException("no more input streams available");
            }
            this.inputStreamOpened = true;
            ++this.openObjects;
            return this.is;
        }
    }

    public void abort() throws IOException {
        throw new IOException("not permitted");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderSet getReceivedHeaders() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.stream.operationClosed) {
                throw new IOException("operation closed");
            }
            return new HeaderSetImpl(this.recvHeaders);
        }
    }

    public int getResponseCode() throws IOException {
        throw new IOException("not permitted");
    }

    public String getEncoding() {
        return null;
    }

    public long getLength() {
        Long res = (Long)this.recvHeaders.getHeader(195);
        if (res == null) {
            return -1L;
        }
        return res;
    }

    public String getType() {
        return (String)this.recvHeaders.getHeader(66);
    }

    public void close() {
        this.stream.operationClosed = true;
    }

    void destroy(int status) {
        try {
            this.outputStreamClosed = true;
            if (!this.requestEnd) {
                this.stream.packetBegin(this.head);
                this.stream.packetAddConnectionID(this.stream.getConnectionID(), null);
                this.stream.packetAddAuthResponses();
            }
            this.stream.packetAddHeaders(null);
            this.close();
            if (this.isAborted) {
                status = 160;
            }
            this.stream.setPacketType(status);
            this.stream.packetEnd();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.stream.queuedHeaders.removeAllElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendHeaders(HeaderSet headers) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.stream.operationClosed) {
                throw new IOException("operation closed");
            }
            if (headers == null) {
                throw new NullPointerException("null headerset");
            }
            if (!(headers instanceof HeaderSetImpl)) {
                throw new IllegalArgumentException("wrong headerset class");
            }
            HeaderSetImpl headersImpl = (HeaderSetImpl)headers;
            if (!headersImpl.isSendable()) {
                throw new IllegalArgumentException("not created with createHeaderSet");
            }
            this.stream.packetAddHeaders(headersImpl);
            if (this.requestEnd && this.isGet) {
                while (!this.stream.queuedHeaders.isEmpty()) {
                    this.packetExchange();
                }
            }
        }
    }

    private void packetExchange() throws IOException {
        if (this.stream.operationHeadersOverflow) {
            throw new IOException("operation terminated, too long headers");
        }
        if (!this.requestEnd) {
            boolean bl = this.requestEnd = this.stream.packetType == (this.opcode | 0x80);
            if (this.stream.isEof && !this.requestEnd) {
                while (this.recvHeaders.packetType == 2) {
                    this.stream.sendPacket(this.head, this.stream.getConnectionID(), null, false);
                    this.stream.recvPacket();
                    this.stream.parsePacketHeaders(this.recvHeaders, 3);
                }
                if (this.recvHeaders.packetType == 255) {
                    this.stream.operationClosed = true;
                    this.isAborted = true;
                    throw new IOException("operation aborted");
                }
                if (this.stream.packetType != (this.opcode | 0x80)) {
                    this.stream.operationClosed = true;
                    this.stream.brokenLink();
                    throw new IOException("protocol error");
                }
            }
            if (this.requestEnd) {
                this.stream.packetBegin(this.head);
                this.stream.packetAddConnectionID(this.stream.getConnectionID(), null);
                this.stream.packetAddAuthResponses();
                this.stream.packetAddHeaders(null);
                return;
            }
            this.stream.sendPacket(ServerConnectionImpl.PACKET_CONTINUE, this.stream.getConnectionID(), null, false);
            this.stream.recvPacket();
            if (this.stream.packetType == 255) {
                this.stream.parsePacketHeaders(this.recvHeaders, 3);
                this.isAborted = true;
                this.stream.operationClosed = true;
                throw new IOException("operation aborted");
            }
            if ((this.stream.packetType & ~128) != this.opcode) {
                this.stream.operationClosed = true;
                this.stream.brokenLink();
                throw new IOException("protocol error");
            }
            this.stream.parsePacketDataBegin(this.recvHeaders, 3);
            return;
        }
        this.stream.packetEnd();
        this.stream.recvPacket();
        this.stream.parsePacketHeaders(this.recvHeaders, 3);
        if (this.stream.packetType == 255) {
            this.isAborted = true;
            this.stream.operationClosed = true;
            throw new IOException("operation aborted");
        }
        if (this.stream.packetType != (this.opcode | 0x80)) {
            this.stream.operationClosed = true;
            this.stream.brokenLink();
            throw new IOException("protocol error");
        }
        this.stream.packetBegin(this.head);
        this.stream.packetAddConnectionID(this.stream.getConnectionID(), null);
        this.stream.packetAddAuthResponses();
        this.stream.packetAddHeaders(null);
    }

    static int waitForData(ServerConnectionImpl stream, HeaderSetImpl inputHeaderSet, int op) throws IOException {
        stream.parsePacketDataBegin(inputHeaderSet, 3);
        int hasData = stream.parsePacketData(inputHeaderSet, null, 0, 0);
        while (true) {
            if (stream.packetType == 255) {
                return 0;
            }
            if (hasData == 1 || stream.isEof) {
                return 1;
            }
            if (stream.packetType == (op | 0x80)) {
                return 2;
            }
            if (stream.packetType != op) {
                stream.brokenLink();
                throw new IOException("protocol error");
            }
            stream.sendPacket(ServerConnectionImpl.PACKET_CONTINUE, stream.getConnectionID(), null, false);
            stream.recvPacket();
            stream.parsePacketDataBegin(inputHeaderSet, 3);
            hasData = stream.parsePacketData(inputHeaderSet, null, 0, 0);
        }
    }

    private class OperationOutputStream
    extends OutputStream {
        OperationOutputStream() {
        }

        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b}, 0, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] b, int offset, int len) throws IOException {
            Object object = ServerOperation.this.lock;
            synchronized (object) {
                if (ServerOperation.this.outputStreamClosed) {
                    throw new IOException("operation finished");
                }
                if (len < 0 || offset < 0 || offset + len > b.length) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                while (len > 0) {
                    int wr = ServerOperation.this.stream.packetAddData(b, offset, len);
                    if (wr != len) {
                        ServerOperation.this.packetExchange();
                    }
                    len -= wr;
                    offset += wr;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            Object object = ServerOperation.this.lock;
            synchronized (object) {
                if (ServerOperation.this.outputStreamClosed) {
                    throw new IOException("operation finished");
                }
                ServerOperation.this.packetExchange();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            Object object = ServerOperation.this.lock;
            synchronized (object) {
                boolean res;
                if (ServerOperation.this.outputStreamClosed) {
                    return;
                }
                ServerOperation.this.outputStreamClosed = true;
                if (ServerOperation.this.outputStreamOpened && !(res = ServerOperation.this.stream.packetEOFBody())) {
                    ServerOperation.this.packetExchange();
                    ServerOperation.this.stream.packetEOFBody();
                }
            }
        }
    }

    private class OperationInputStream
    extends InputStream {
        OperationInputStream() {
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            int len = this.read(b, 0, 1);
            if (len == -1) {
                return -1;
            }
            return b[0] & 0xFF;
        }

        public int read(byte[] b, int offset, int len) throws IOException {
            Object object = ServerOperation.this.lock;
            synchronized (object) {
                if (ServerOperation.this.inputStreamClosed) {
                    throw new IOException("operation finished");
                }
                if (len < 0 || offset < 0 || offset + len > b.length) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                if (len == 0) {
                    return 0;
                }
                if (ServerOperation.this.inputStreamEof) {
                    return -1;
                }
                int result = 0;
                do {
                    int rd;
                    if ((rd = ServerOperation.this.stream.parsePacketData(ServerOperation.this.recvHeaders, b, offset, len)) != 0) {
                        offset += rd;
                        result += rd;
                        if ((len -= rd) == 0) {
                            return result;
                        }
                    }
                    ServerOperation.this.packetExchange();
                } while (!((ServerOperation)ServerOperation.this).stream.isEof);
                ServerOperation.this.inputStreamEof = true;
                return result == 0 ? -1 : result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            Object object = ServerOperation.this.lock;
            synchronized (object) {
                ServerOperation.this.inputStreamClosed = true;
                ServerOperation.this.inputStreamEof = false;
            }
        }
    }
}

