/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.location;

import com.sun.kvem.location.LocationProviderImpl;
import com.sun.kvem.location.PortingLayer;
import javax.microedition.location.Criteria;
import javax.microedition.location.Location;
import javax.microedition.location.LocationException;

public class GPSLocationProvider
extends LocationProviderImpl
implements Runnable {
    private boolean resetRequested;

    public GPSLocationProvider() {
        this.criteria = new Criteria();
        if (this.locationThread == null) {
            this.locationThread = new Thread(this);
            this.locationThread.start();
        }
    }

    public boolean matchesCriteria(Criteria criteria) {
        if (!criteria.isAllowedToCost() && this.criteria.isAllowedToCost()) {
            return false;
        }
        boolean ret = criteria.isSpeedAndCourseRequired() && this.criteria.isSpeedAndCourseRequired();
        ret |= criteria.isAltitudeRequired() && this.criteria.isAltitudeRequired();
        ret |= criteria.isAddressInfoRequired() && this.criteria.isAddressInfoRequired();
        ret |= criteria.getHorizontalAccuracy() >= this.criteria.getHorizontalAccuracy();
        ret |= criteria.getVerticalAccuracy() >= this.criteria.getVerticalAccuracy();
        ret |= criteria.getPreferredResponseTime() >= this.criteria.getPreferredResponseTime();
        return ret |= criteria.getPreferredPowerConsumption() == this.criteria.getPreferredPowerConsumption();
    }

    public void reset() {
        this.resetRequested = true;
    }

    public Location getLocationImpl(int timeout) throws LocationException, InterruptedException {
        if (timeout == 0 || timeout < -1) {
            throw new IllegalArgumentException("Timeout must be larger than 0, it is: " + timeout);
        }
        if (this.getState() == 3) {
            throw new LocationException("Provider is out of service");
        }
        if (timeout == -1) {
            timeout = this.getDefaultTimeout();
        }
        timeout *= 1000;
        Location ret = null;
        while (timeout >= 0) {
            if (this.resetRequested) {
                this.resetRequested = false;
                throw new InterruptedException();
            }
            ret = PortingLayer.getInstance().getLocation();
            if (ret == null) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                timeout -= 500;
                continue;
            }
            timeout = -1;
        }
        if (ret == null) {
            throw new LocationException("Could not retrieve location");
        }
        return ret;
    }

    public int getDefaultInterval() {
        return 2;
    }

    public int getDefaultMaxAge() {
        return 1;
    }

    public int getDefaultTimeout() {
        return 1;
    }

    public int getState() {
        return PortingLayer.getInstance().getProviderState();
    }

    public void setCriteria(Criteria c) {
        this.criteria = c;
    }

    String getName() {
        return "GPS";
    }
}

