/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.location;

import com.sun.kvem.location.GPSLocationProvider;
import com.sun.kvem.location.LocationEventCodes;
import com.sun.kvem.location.LocationEventHandler;
import com.sun.kvem.location.LocationImpl;
import com.sun.kvem.location.LocationProviderImpl;
import com.sun.kvem.location.PortingLayer;
import com.sun.midp.lcdui.SystemEventDispatcher;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import java.util.Vector;
import javax.microedition.location.Criteria;
import javax.microedition.location.Location;
import javax.microedition.location.LocationException;
import javax.microedition.location.LocationListener;
import javax.microedition.location.LocationProvider;
import javax.microedition.location.Orientation;
import javax.microedition.location.QualifiedCoordinates;

public class KvemPortingLayer
extends PortingLayer
implements LocationEventCodes {
    static final double EARTH_RADIUS = 6378137.0;
    static final double FLATTENING = 298.257223563;
    static final double DEG2RAD = 0.01745329252;
    private double distance;
    private double azimuth;
    private LocationProviderImpl[] providers;

    public float azimuthTo(double lat1, double long1, float altitude1, double lat2, double long2, float altitude2) {
        this.computeAzimuthAndDirection(lat1, long1, lat2, long2);
        return (float)this.azimuth;
    }

    public float distance(double lat1, double long1, double lat2, double long2) {
        if (lat1 == lat2 && long1 == long2) {
            return 0.0f;
        }
        this.computeAzimuthAndDirection(lat1, long1, lat2, long2);
        return (float)this.distance;
    }

    public boolean isOrientationSupported() {
        String orientation = SystemEventDispatcher.getEventData("4100");
        return !"false".equals(orientation);
    }

    public Orientation getOrientation() {
        if (this.isOrientationSupported()) {
            String orientation = SystemEventDispatcher.getEventData("4100");
            String[] res = this.parse(orientation, ";");
            if ("null".equals(res[0])) {
                return null;
            }
            float azimuth = Float.parseFloat(res[0]);
            boolean isMagnetic = "true".equals(res[1]);
            float pitch = "null".equals(res[2]) ? 0.0f : Float.parseFloat(res[2]);
            float roll = "null".equals(res[3]) ? 0.0f : Float.parseFloat(res[3]);
            return new Orientation(azimuth, isMagnetic, pitch, roll);
        }
        return null;
    }

    public void updatePositionData(long timeout) throws LocationException, InterruptedException {
    }

    public void reset() {
    }

    private void computeAzimuthAndDirection(double lat1, double long1, double lat2, double long2) {
        double c = 0.0;
        double d = 0.0;
        double e = 0.0;
        double y = 0.0;
        double sa = 0.0;
        double sx = 0.0;
        double sy = 0.0;
        double cx = 0.0;
        double cy = 0.0;
        double cz = 0.0;
        double c2a = 0.0;
        double f = 0.0033528106647474805;
        double eps = -12.5;
        double glon1 = long1 * 0.01745329252;
        double glat1 = lat1 * 0.01745329252;
        double glon2 = long2 * 0.01745329252;
        double glat2 = lat2 * 0.01745329252;
        double r = 1.0 - f;
        double tu1 = r * Math.sin(glat1) / Math.cos(glat1);
        double tu2 = r * Math.sin(glat2) / Math.cos(glat2);
        double cu1 = 1.0 / Math.sqrt(1.0 + tu1 * tu1);
        double su1 = cu1 * tu1;
        double cu2 = 1.0 / Math.sqrt(1.0 + tu2 * tu2);
        double s = cu1 * cu2;
        double baz = s * tu2;
        double faz = baz * tu1;
        double x = glon2 - glon1;
        do {
            sx = Math.sin(x);
            cx = Math.cos(x);
            tu1 = cu2 * sx;
            tu2 = baz - su1 * cu2 * cx;
            sy = Math.sqrt(tu1 * tu1 + tu2 * tu2);
            cy = s * cx + faz;
            y = this.atan2(sy, cy);
            sa = s * sx / sy;
            c2a = -sa * sa + 1.0;
            cz = faz + faz;
            if (c2a > 0.0) {
                cz = -cz / c2a + cy;
            }
            e = cz * cz * 2.0 - 1.0;
            c = ((-3.0 * c2a + 4.0) * f + 4.0) * c2a * f / 16.0;
            d = x;
            x = ((e * cy * c + cz) * sy * c + y) * sa;
        } while (Math.abs(d - (x = (1.0 - c) * x * f + glon2 - glon1)) <= eps);
        faz = this.atan2(tu1, tu2);
        x = Math.sqrt((1.0 / r / r - 1.0) * c2a + 1.0) + 1.0;
        x = (x - 2.0) / x;
        c = 1.0 - x;
        c = (x * x / 4.0 + 1.0) / c;
        d = (0.375 * x * x - 1.0) * x;
        x = e * cy;
        s = 1.0 - e * e;
        this.distance = ((((sy * sy * 4.0 - 3.0) * s * cz * d / 6.0 - x) * d / 4.0 + cz) * sy * d + y) * c * 6378137.0 * r;
        this.azimuth = faz / 0.01745329252;
        if (this.azimuth < 0.0) {
            this.azimuth += 360.0;
        }
        if (lat1 == 90.0) {
            this.azimuth = 180.0;
        } else if (lat1 == -90.0) {
            this.azimuth = 0.0;
        }
    }

    private double atan2(double x, double y) {
        String res = this.atan2Impl(Double.toString(x), Double.toString(y));
        return Double.parseDouble(res);
    }

    private native String atan2Impl(String var1, String var2);

    public LocationProviderImpl[] getProviders() {
        if (this.providers == null) {
            GPSLocationProvider gps = new GPSLocationProvider();
            gps.setCriteria(this.getProviderCriteria());
            this.providers = new LocationProviderImpl[]{gps};
        }
        return this.providers;
    }

    public Location getLocation() {
        if (this.getProviderState() == 2) {
            return null;
        }
        String loc = SystemEventDispatcher.getEventData("4200");
        String[] res = this.parse(loc, ";");
        double lattitude = "null".equals(res[0]) ? 0.0 : Double.parseDouble(res[0]);
        double longitude = "null".equals(res[1]) ? 0.0 : Double.parseDouble(res[1]);
        float altitude = this.parseFloat(res[2]);
        float speed = this.parseFloat(res[3]);
        float course = this.parseFloat(res[4]);
        return new LocationImpl(new QualifiedCoordinates(lattitude, longitude, altitude, 10.0f, 10.0f), speed, course, 0, null, null);
    }

    private float parseFloat(String strVal) {
        if ("null".equals(strVal)) {
            return 0.0f;
        }
        if ("NaN".equals(strVal)) {
            return Float.NaN;
        }
        return Float.parseFloat(strVal);
    }

    public int getProviderState() {
        String provState = SystemEventDispatcher.getEventData("4000");
        try {
            return Integer.parseInt(provState);
        }
        catch (NumberFormatException nfe) {
            return 3;
        }
    }

    private Criteria getProviderCriteria() {
        Criteria c = new Criteria();
        int[] data = new int[8];
        this.getProviderCriteriaImpl(data);
        c.setHorizontalAccuracy(data[0]);
        c.setVerticalAccuracy(data[1]);
        c.setPreferredResponseTime(data[2]);
        c.setPreferredPowerConsumption(data[3]);
        c.setCostAllowed(data[4] == 1);
        c.setSpeedAndCourseRequired(data[5] == 1);
        c.setAltitudeRequired(data[6] == 1);
        c.setAddressInfoRequired(data[7] == 1);
        return c;
    }

    private native void getProviderCriteriaImpl(int[] var1);

    public void checkForPermission(int permission) {
        MIDletSuite suite = Scheduler.getScheduler().getMIDletSuite();
        try {
            suite.checkForPermission(permission, null);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void registerLocationListener(LocationListener listener, LocationProvider provider) {
        LocationEventHandler.getInstance().registerLocationListener(listener, provider);
    }

    public Vector getCategories(String storeName) {
        Vector<String> categories = new Vector<String>();
        String catStr = this.getCategoriesImpl(storeName);
        if (catStr != null && !catStr.equals("")) {
            int index = catStr.indexOf(59);
            while (index > 0) {
                String categ = catStr.substring(0, index);
                categories.addElement(categ);
                catStr = catStr.substring(index + 1);
                index = catStr.indexOf(59);
            }
            if (catStr.length() > 0) {
                categories.addElement(catStr);
            }
        }
        return categories;
    }

    private native String getCategoriesImpl(String var1);

    public void addCategory(String categoryName, String storeName) {
        this.addCategoryImpl(categoryName, storeName);
    }

    private native void addCategoryImpl(String var1, String var2);

    public void deleteCategory(String categoryName, String storeName) {
        this.deleteCategoryImpl(categoryName, storeName);
    }

    private native void deleteCategoryImpl(String var1, String var2);

    public int addLandmark(String storeName, byte[] lm) {
        return this.addLandmarkImpl(storeName, lm);
    }

    private native int addLandmarkImpl(String var1, byte[] var2);

    public void deleteLandmark(String storeName, int recordId) {
        this.deleteLandmarkImpl(storeName, recordId);
    }

    private native void deleteLandmarkImpl(String var1, int var2);

    public void updateLandmark(String storeName, int recordId, byte[] lmData) {
        this.updateLandmarkImpl(storeName, recordId, lmData);
    }

    private native void updateLandmarkImpl(String var1, int var2, byte[] var3);

    public byte[] getLandmarks(String storeName) {
        int dataSize = 1024;
        byte[] buffer = new byte[dataSize];
        int bytesRead = this.getLandmarksImpl(storeName, buffer);
        if (bytesRead < 0) {
            dataSize = -bytesRead;
            buffer = new byte[dataSize];
            bytesRead = this.getLandmarksImpl(storeName, buffer);
        }
        byte[] result = new byte[bytesRead];
        System.arraycopy(buffer, 0, result, 0, bytesRead);
        return result;
    }

    private native int getLandmarksImpl(String var1, byte[] var2);

    private String[] parse(String s, String c) {
        int i;
        Vector<String> v = new Vector<String>();
        while ((i = s.indexOf(c)) > 0) {
            String aux = s.substring(0, i);
            s = s.substring(i + 1);
            v.addElement(aux);
        }
        v.addElement(s);
        String[] ret = new String[v.size()];
        for (int j = 0; j < ret.length; ++j) {
            ret[j] = (String)v.elementAt(j);
        }
        return ret;
    }
}

