/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp.pim;

import com.sun.kvem.midp.pim.AbstractPIMItem;
import com.sun.kvem.midp.pim.PIMHandler;
import com.sun.kvem.midp.pim.PIMImpl;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.microedition.pim.PIMException;
import javax.microedition.pim.PIMItem;
import javax.microedition.pim.PIMList;
import javax.microedition.pim.UnsupportedFieldException;

public abstract class AbstractPIMList
implements PIMList {
    private final String name;
    private Vector items = new Vector();
    private int mode;
    private boolean open = true;
    private final int type;

    AbstractPIMList(int type, String name, int mode) {
        this.type = type;
        this.name = name;
        this.mode = mode;
    }

    public void addCategory(String category) throws PIMException {
        this.checkWritePermission();
        this.checkOpen();
        this.checkNullCategory(category);
        PIMHandler handler = PIMHandler.getInstance();
        String[] categories = handler.getCategories(this.type, this.name);
        for (int i = 0; i < categories.length; ++i) {
            if (!category.equals(categories[i])) continue;
            return;
        }
        String[] newCategories = new String[categories.length + 1];
        System.arraycopy(categories, 0, newCategories, 0, categories.length);
        newCategories[categories.length] = category;
        handler.setCategories(this.type, this.name, newCategories);
    }

    public Enumeration itemsByCategory(String category) throws PIMException {
        this.checkReadPermission();
        this.checkOpen();
        Vector<AbstractPIMItem> v = new Vector<AbstractPIMItem>();
        if (category == null || category.equals("UNCATEGORIZED")) {
            Enumeration e = this.items.elements();
            while (e.hasMoreElements()) {
                AbstractPIMItem item = (AbstractPIMItem)e.nextElement();
                if (item.getCategoriesRaw() != null) continue;
                v.addElement(item);
            }
        } else {
            Enumeration e = this.items.elements();
            while (e.hasMoreElements()) {
                AbstractPIMItem item = (AbstractPIMItem)e.nextElement();
                if (!item.isInCategory(category)) continue;
                v.addElement(item);
            }
        }
        return v.elements();
    }

    public Enumeration items(PIMItem matchingItem) throws PIMException {
        this.checkReadPermission();
        this.checkOpen();
        if (!this.equals(matchingItem.getPIMList())) {
            throw new IllegalArgumentException("Cannot match item from another list");
        }
        int[] searchFields = matchingItem.getFields();
        int[] searchFieldDataTypes = new int[searchFields.length];
        Object[][] searchData = new Object[searchFields.length][];
        for (int i = 0; i < searchFields.length; ++i) {
            searchFieldDataTypes[i] = this.getFieldDataType(searchFields[i]);
            searchData[i] = new Object[matchingItem.countValues(searchFields[i])];
            block11: for (int j = 0; j < searchData[i].length; ++j) {
                searchData[i][j] = ((AbstractPIMItem)matchingItem).getField(searchFields[i], false, false).getValue(j);
                switch (searchFieldDataTypes[i]) {
                    case 4: {
                        String s = (String)searchData[i][j];
                        if (s == null) continue block11;
                        searchData[i][j] = s.toUpperCase();
                        continue block11;
                    }
                    case 5: {
                        String[] a = (String[])searchData[i][j];
                        if (a == null) continue block11;
                        for (int k = 0; k < a.length; ++k) {
                            if (a[k] == null) continue;
                            a[k] = a[k].toUpperCase();
                        }
                        continue block11;
                    }
                }
            }
        }
        Vector<AbstractPIMItem> v = new Vector<AbstractPIMItem>();
        Enumeration e = this.items.elements();
        block13: while (e.hasMoreElements()) {
            AbstractPIMItem item = (AbstractPIMItem)e.nextElement();
            for (int i = 0; i < searchFields.length; ++i) {
                int field = searchFields[i];
                int itemIndices = item.countValues(field);
                for (int j = 0; j < searchData[i].length; ++j) {
                    boolean matchedThisIndex = false;
                    int searchAttributes = matchingItem.getAttributes(field, j);
                    block16: for (int k = 0; k < itemIndices && !matchedThisIndex; ++k) {
                        Object value = item.getField(field, false, false).getValue(k);
                        switch (searchFieldDataTypes[i]) {
                            case 1: 
                            case 2: 
                            case 3: {
                                if (!searchData[i][j].equals(value)) continue block16;
                                matchedThisIndex = true;
                                continue block16;
                            }
                            case 0: {
                                int m;
                                Object[] a = (byte[])searchData[i][j];
                                Object[] b = (byte[])value;
                                if (b == null || a.length != b.length) continue block16;
                                boolean arrayMatches = true;
                                for (m = 0; m < a.length && arrayMatches; ++m) {
                                    arrayMatches = a[m] == b[m];
                                }
                                matchedThisIndex = arrayMatches;
                                continue block16;
                            }
                            case 4: {
                                String s1 = (String)searchData[i][j];
                                String s2 = (String)value;
                                if (s2 == null) {
                                    if (s1 != null) continue block16;
                                    matchedThisIndex = true;
                                    continue block16;
                                }
                                if (s2.toUpperCase().indexOf(s1) == -1) continue block16;
                                matchedThisIndex = true;
                                continue block16;
                            }
                            case 5: {
                                int m;
                                Object[] a = (String[])searchData[i][j];
                                Object[] b = (String[])value;
                                if (a == null) {
                                    if (b != null) continue block16;
                                    matchedThisIndex = true;
                                    continue block16;
                                }
                                if (b == null || a.length != b.length) continue block16;
                                boolean arrayMatches = true;
                                for (m = 0; m < a.length && arrayMatches; ++m) {
                                    if (a[m] == null || a[m].length() <= 0) continue;
                                    arrayMatches = b[m] != null && b[m].toUpperCase().indexOf((String)a[m]) != -1;
                                }
                                matchedThisIndex = arrayMatches;
                                continue block16;
                            }
                        }
                    }
                    if (!matchedThisIndex) continue block13;
                }
            }
            v.addElement(item);
        }
        return v.elements();
    }

    public void close() throws PIMException {
        this.checkOpen();
        this.open = false;
        this.items = null;
    }

    public String getArrayElementLabel(int stringArrayField, int arrayElement) {
        if (this.getFieldDataType(stringArrayField) != 5) {
            throw new IllegalArgumentException("Not a string array field");
        }
        if (!this.isSupportedArrayElement(stringArrayField, arrayElement)) {
            throw new IllegalArgumentException("Invalid array element " + arrayElement);
        }
        return PIMHandler.getInstance().getArrayElementLabel(this.type, stringArrayField, arrayElement);
    }

    public int[] getSupportedArrayElements(int stringArrayField) {
        if (this.getFieldDataType(stringArrayField) != 5) {
            throw new IllegalArgumentException("Not a string array field");
        }
        return PIMHandler.getInstance().getSupportedArrayElements(this.type, stringArrayField);
    }

    public String getAttributeLabel(int attribute) {
        this.checkAttribute(attribute);
        String label = PIMHandler.getInstance().getAttributeLabel(this.type, attribute);
        if (label == null) {
            throw new IllegalArgumentException("Invalid attribute: " + attribute);
        }
        return label;
    }

    public int maxValues(int field) {
        try {
            this.checkField(field);
        }
        catch (UnsupportedFieldException e) {
            return 0;
        }
        return PIMHandler.getInstance().getMaximumValues(this.type, field);
    }

    public boolean isSupportedAttribute(int field, int attribute) {
        int i;
        if (!this.isSupportedField(field)) {
            return false;
        }
        if (this.type == 1 && attribute == 0) {
            return true;
        }
        for (i = attribute; (i & 1) == 0 && i != 0; i >>= 1) {
        }
        if (i != 1) {
            return false;
        }
        return PIMHandler.getInstance().isSupportedAttribute(this.type, field, attribute);
    }

    public int maxCategories() {
        return -1;
    }

    public String[] getCategories() throws PIMException {
        this.checkOpen();
        return PIMHandler.getInstance().getCategories(this.type, this.name);
    }

    public boolean isCategory(String category) throws PIMException {
        this.checkOpen();
        this.checkNullCategory(category);
        String[] categories = PIMHandler.getInstance().getCategories(this.type, this.name);
        for (int i = 0; i < categories.length; ++i) {
            if (!category.equals(categories[i])) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public int stringArraySize(int stringArrayField) {
        if (this.getFieldDataType(stringArrayField) != 5) {
            throw new IllegalArgumentException("Not a string array field");
        }
        return PIMHandler.getInstance().getStringArraySize(this.type, stringArrayField);
    }

    public boolean isSupportedField(int field) {
        return PIMHandler.getInstance().isSupportedField(this.type, field);
    }

    public void deleteCategory(String category, boolean deleteUnassignedItems) throws PIMException {
        this.checkWritePermission();
        this.checkOpen();
        this.checkNullCategory(category);
        String[] categories = PIMHandler.getInstance().getCategories(this.type, this.name);
        int categoryIndex = -1;
        for (int i = 0; i < categories.length && categoryIndex == -1; ++i) {
            if (!category.equals(categories[i])) continue;
            categoryIndex = i;
        }
        if (categoryIndex == -1) {
            return;
        }
        String[] newCategories = new String[categories.length - 1];
        System.arraycopy(categories, 0, newCategories, 0, categoryIndex);
        System.arraycopy(categories, categoryIndex + 1, newCategories, categoryIndex, newCategories.length - categoryIndex);
        PIMHandler.getInstance().setCategories(this.type, this.name, newCategories);
        Object[] a = new AbstractPIMItem[this.items.size()];
        this.items.copyInto(a);
        for (int i = 0; i < a.length; ++i) {
            if (!((AbstractPIMItem)a[i]).isInCategory(category)) continue;
            ((AbstractPIMItem)a[i]).removeFromCategory(category);
            if (!deleteUnassignedItems || ((AbstractPIMItem)a[i]).getCategories().length != 0) continue;
            this.items.removeElement(a[i]);
        }
    }

    public Enumeration items() throws PIMException {
        this.checkReadPermission();
        this.checkOpen();
        Object[] data = new PIMItem[this.items.size()];
        this.items.copyInto(data);
        return new Enumeration((PIMItem[])data){
            int index = 0;
            private final /* synthetic */ PIMItem[] val$data;
            {
                this.val$data = pIMItemArray;
            }

            public boolean hasMoreElements() {
                return this.index < this.val$data.length;
            }

            public Object nextElement() {
                try {
                    return this.val$data[this.index++];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new NoSuchElementException();
                }
            }
        };
    }

    public int[] getSupportedAttributes(int field) {
        this.checkField(field);
        return PIMHandler.getInstance().getSupportedAttributes(this.type, field);
    }

    public int getFieldDataType(int field) {
        int dataType = PIMHandler.getInstance().getFieldDataType(this.type, field);
        if (dataType == -1) {
            throw AbstractPIMItem.complaintAboutField(this.type, field);
        }
        return dataType;
    }

    public String getFieldLabel(int field) {
        this.checkField(field);
        return PIMHandler.getInstance().getFieldLabel(this.type, field);
    }

    public void renameCategory(String currentCategory, String newCategory) throws PIMException {
        this.checkWritePermission();
        this.checkOpen();
        if (currentCategory == null || newCategory == null) {
            throw new NullPointerException("Null category");
        }
        String[] categories = PIMHandler.getInstance().getCategories(this.type, this.name);
        if (newCategory.equals(currentCategory)) {
            return;
        }
        int oldCategoryIndex = -1;
        int newCategoryIndex = -1;
        for (int i = 0; i < categories.length; ++i) {
            if (currentCategory.equals(categories[i])) {
                oldCategoryIndex = i;
                continue;
            }
            if (!newCategory.equals(categories[i])) continue;
            newCategoryIndex = i;
        }
        if (oldCategoryIndex == -1) {
            throw new PIMException("No such category: " + currentCategory);
        }
        if (newCategoryIndex == -1) {
            categories[oldCategoryIndex] = newCategory;
        } else {
            String[] a = new String[categories.length - 1];
            System.arraycopy(categories, 0, a, 0, oldCategoryIndex);
            System.arraycopy(categories, oldCategoryIndex + 1, a, oldCategoryIndex, a.length - oldCategoryIndex);
            categories = a;
        }
        PIMHandler.getInstance().setCategories(this.type, this.name, categories);
        Enumeration e = this.items.elements();
        while (e.hasMoreElements()) {
            AbstractPIMItem item = (AbstractPIMItem)e.nextElement();
            if (!item.isInCategory(currentCategory)) continue;
            item.removeFromCategory(currentCategory);
            item.addToCategory(newCategory);
        }
    }

    public boolean isSupportedArrayElement(int stringArrayField, int arrayElement) {
        int dataType = PIMHandler.getInstance().getFieldDataType(this.type, stringArrayField);
        if (dataType != 5) {
            return false;
        }
        return PIMHandler.getInstance().isSupportedArrayElement(this.type, stringArrayField, arrayElement);
    }

    public int[] getSupportedFields() {
        return PIMHandler.getInstance().getSupportedFields(this.type);
    }

    public Enumeration items(String matchingValue) throws PIMException {
        this.checkReadPermission();
        this.checkOpen();
        matchingValue = matchingValue.toUpperCase();
        Vector<AbstractPIMItem> v = new Vector<AbstractPIMItem>();
        Enumeration e = this.items.elements();
        block4: while (e.hasMoreElements()) {
            AbstractPIMItem item = (AbstractPIMItem)e.nextElement();
            int[] fields = item.getFields();
            block5: for (int i = 0; i < fields.length; ++i) {
                switch (this.getFieldDataType(fields[i])) {
                    case 4: {
                        int j;
                        for (j = item.countValues(fields[i]) - 1; j >= 0; --j) {
                            String value = item.getString(fields[i], j);
                            if (value == null || value.toUpperCase().indexOf(matchingValue) == -1) continue;
                            v.addElement(item);
                            continue block4;
                        }
                        continue block5;
                    }
                    case 5: {
                        int j;
                        for (j = item.countValues(fields[i]) - 1; j >= 0; --j) {
                            String[] a = item.getStringArray(fields[i], j);
                            if (a == null) continue;
                            for (int k = 0; k < a.length; ++k) {
                                if (a[k] == null || a[k].toUpperCase().indexOf(matchingValue) == -1) continue;
                                v.addElement(item);
                                continue block4;
                            }
                        }
                        continue block5;
                    }
                }
            }
        }
        return v.elements();
    }

    protected void checkReadPermission() throws SecurityException {
        if (this.mode == 2) {
            throw new SecurityException("List cannot be read");
        }
    }

    protected void checkWritePermission() throws SecurityException {
        if (this.mode == 1) {
            throw new SecurityException("List cannot be written");
        }
    }

    protected void checkOpen() throws PIMException {
        if (!this.open) {
            throw new PIMException("List is closed.");
        }
    }

    protected void checkNullCategory(String category) {
        if (category == null) {
            throw new NullPointerException("Null category");
        }
    }

    public void addItem(AbstractPIMItem item) {
        this.items.addElement(item);
        item.setPIMList(this);
    }

    void removeItem(PIMItem item) throws PIMException {
        if (PIMImpl.askUserForAcknowledgement(this.type, "remove item from")) {
            this.checkWritePermission();
            this.checkOpen();
            if (item == null) {
                throw new NullPointerException("Null item");
            }
            if (!this.items.removeElement(item)) {
                throw new PIMException("Item not in list");
            }
            ((AbstractPIMItem)item).remove();
        }
    }

    Object commit(Object key, byte[] data) {
        return PIMHandler.getInstance().commitListElement(this.type, this.name, key, data);
    }

    int getType() {
        return this.type;
    }

    private void checkField(int field) {
        if (PIMHandler.getInstance().getFieldDataType(this.type, field) == -1) {
            throw AbstractPIMItem.complaintAboutField(this.type, field);
        }
    }

    private void checkAttribute(int attribute) {
        if (attribute == 0) {
            return;
        }
        while ((attribute & 1) == 0 && attribute != 0) {
            attribute >>= 1;
        }
        if (attribute != 1) {
            throw new IllegalArgumentException("Invalid attribute: " + attribute);
        }
    }
}

