/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp.pim;

import com.sun.kvem.midp.pim.MarkableInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class LineReader
extends InputStreamReader {
    private final InputStream in;
    private final Matcher matcher;

    public LineReader(InputStream in, String encoding, Matcher matcher) throws UnsupportedEncodingException {
        this(new MarkableInputStream(in), encoding, matcher);
    }

    private LineReader(MarkableInputStream in, String encoding, Matcher matcher) throws UnsupportedEncodingException {
        super((InputStream)in, encoding);
        this.in = in;
        this.matcher = matcher;
    }

    public String readLine() throws IOException {
        StringBuffer sb = new StringBuffer();
        boolean lineIsOnlyWhiteSpace = true;
        boolean done = false;
        int i = this.read();
        block8: while (i != -1 && !done) {
            switch (i) {
                case 13: {
                    i = this.read();
                    if (i != 10) {
                        throw new IOException("Bad line terminator");
                    }
                }
                case 10: {
                    if (lineIsOnlyWhiteSpace) {
                        sb.setLength(0);
                    }
                    this.mark(1);
                    i = this.read();
                    this.reset();
                    switch (i) {
                        case 9: 
                        case 32: {
                            this.skip(1L);
                            continue block8;
                        }
                    }
                    if (!lineIsOnlyWhiteSpace) {
                        done = true;
                        continue block8;
                    }
                    this.skip(1L);
                    continue block8;
                }
                case 9: 
                case 32: {
                    sb.append((char)i);
                    i = this.read();
                    continue block8;
                }
            }
            sb.append((char)i);
            if (this.matcher.match(sb)) {
                return sb.toString().trim();
            }
            i = this.read();
            lineIsOnlyWhiteSpace = false;
        }
        if (lineIsOnlyWhiteSpace) {
            return null;
        }
        return sb.toString().trim();
    }

    public void mark(int lookahead) throws IOException {
        this.in.mark(lookahead);
    }

    public boolean markSupported() {
        return true;
    }

    public void reset() throws IOException {
        this.in.reset();
    }

    public static interface Matcher {
        public boolean match(StringBuffer var1);
    }
}

