/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.payment;

import com.sun.j2me.payment.PaymentAdapter;
import com.sun.j2me.payment.PaymentException;
import com.sun.j2me.payment.Transaction;
import com.sun.midp.lcdui.Resource;
import com.sun.midp.security.SecurityToken;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpsConnection;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;

public class CreditCardAdapter
extends PaymentAdapter {
    private static final String PAY_REQUEST_KEY = "Pay-Request";
    private static final String PAY_REQUEST_PAYMENT = "payment";
    private static final String PAY_CC_NUMBER = "Pay-CC-Number";
    private static final String PAY_CC_HOLDER = "Pay-CC-Holder";
    private static final String PAY_CC_EXPIRY = "Pay-Expiry-Date";
    private static final String PAY_CC_TYPE = "Pay-CC-Type";
    private static final String PAY_FEATURE_ID = "Pay-Feature-ID";
    private static final String PAY_PROVIDER = "Pay-Provider";
    private static final String PAY_PAYLOAD = "Pay-Payload";
    private static final String PAY_CCV = "Pay-CCV";
    private static final String PAY_RESPONSE_KEY = "Pay-Response";
    private static final String VISA_NAME = "VISA";
    private static final String[] VISA_PREFIX = new String[]{"4"};
    private static final int[] VISA_LENGTH = new int[]{13, 16};
    private static final String MASTERCARD_NAME = "MASTERCARD";
    private static final String[] MASTERCARD_PREFIX = new String[]{"51", "52", "53", "54", "55"};
    private static final int[] MASTERCARD_LENGTH = new int[]{16};
    private static final String AMERICAN_EXPRES_NAME = "AMEX";
    private static final String[] AMERICAN_EXPRES_PREFIX = new String[]{"34", "37"};
    private static final int[] AMERICAN_EXPRES_LENGTH = new int[]{15};
    private static final int VISA = 0;
    private static final int MASTERCARD = 1;
    private static final int AMEX = 2;
    private static SecurityToken classSecurityToken;
    private String httpsServerUrl;
    private int cardType;

    public static void initSecurityToken(SecurityToken token) {
        if (classSecurityToken != null) {
            return;
        }
        classSecurityToken = token;
    }

    private CreditCardAdapter(int cardType, String url) {
        this.cardType = cardType;
        this.httpsServerUrl = url;
    }

    public String getDisplayName() {
        return Resource.getString("Credit Card Adapter");
    }

    public static PaymentAdapter getInstance(String configuration) throws PaymentException {
        String provider;
        int indexOfComma = configuration.indexOf(44);
        String url = "";
        if (indexOfComma != -1) {
            provider = configuration.substring(0, indexOfComma).trim();
            url = configuration.substring(indexOfComma + 1).trim();
        } else {
            provider = configuration;
        }
        if (VISA_NAME.equals(provider)) {
            return new CreditCardAdapter(0, url);
        }
        if (MASTERCARD_NAME.equals(provider)) {
            return new CreditCardAdapter(1, url);
        }
        if (AMERICAN_EXPRES_NAME.equals(provider)) {
            return new CreditCardAdapter(2, url);
        }
        return null;
    }

    public void validatePriceInfo(double price, String paySpecificPriceInfo) throws PaymentException {
        if (paySpecificPriceInfo == null || paySpecificPriceInfo.equals("")) {
            throw new PaymentException(10);
        }
    }

    public boolean validateCreditCardInfo(CCTransaction transaction, Form form) {
        int year;
        int month;
        if (transaction.cardHolderName.equals("") || transaction.expirationDate.equals("") || transaction.cardNumber.equals("")) {
            form.append(Resource.getString("All fields except verification have to be filled."));
            return false;
        }
        if (transaction.expirationDate.length() > 7 || transaction.expirationDate.length() < 6) {
            form.append(Resource.getString("Expiration date is in wrong format."));
            return false;
        }
        try {
            month = Integer.parseInt(transaction.expirationDate.substring(0, transaction.expirationDate.indexOf("/")));
            year = Integer.parseInt(transaction.expirationDate.substring(transaction.expirationDate.indexOf("/") + 1));
        }
        catch (Exception e) {
            form.append(Resource.getString("Expiration date is in wrong format."));
            return false;
        }
        if (month < 1 || month > 12) {
            form.append(Resource.getString("Wrong month number in expiration day."));
            return false;
        }
        int[] numOfDays = new int[]{30, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        int yearDays = 0;
        for (int i = 0; i < month; ++i) {
            yearDays += numOfDays[i];
        }
        int diff = year - 1970;
        int leap = diff / 4;
        long msec = (long)(diff * 365 + leap + yearDays) * 24L * 60L * 60L * 1000L;
        if (msec < System.currentTimeMillis()) {
            form.append(Resource.getString("Card has already expired."));
            return false;
        }
        if (transaction.cardNumber.endsWith("0")) {
            form.append(Resource.getString("Wrong credit card number."));
            return false;
        }
        switch (this.cardType) {
            case 0: {
                if (this.validatePrefixAndLength(transaction.cardNumber, VISA_PREFIX, VISA_LENGTH)) break;
                form.append(Resource.getString("Wrong credit card number."));
                return false;
            }
            case 1: {
                if (this.validatePrefixAndLength(transaction.cardNumber, MASTERCARD_PREFIX, MASTERCARD_LENGTH)) break;
                form.append(Resource.getString("Wrong credit card number."));
                return false;
            }
            case 2: {
                if (this.validatePrefixAndLength(transaction.cardNumber, AMERICAN_EXPRES_PREFIX, AMERICAN_EXPRES_LENGTH)) break;
                form.append(Resource.getString("Wrong credit card number."));
                return false;
            }
            default: {
                form.append(Resource.getString("Unsupported credit card provider."));
            }
        }
        return true;
    }

    private boolean validatePrefixAndLength(String cardNumber, String[] prefix, int[] length) {
        int i;
        boolean result = false;
        for (i = 0; i < prefix.length && !result; ++i) {
            result = cardNumber.startsWith(prefix[i]);
        }
        if (!result) {
            return false;
        }
        result = false;
        for (i = 0; i < length.length && !result; ++i) {
            result = cardNumber.length() == length[i];
        }
        return result;
    }

    public Transaction process(Transaction transaction) {
        switch (transaction.getState()) {
            case 2: {
                transaction = new CCTransaction(transaction);
                transaction.setWaiting(true);
                CCForm form = new CCForm((CCTransaction)transaction);
                this.preemptDisplay(classSecurityToken, form);
                break;
            }
            case 256: {
                CCThread thread = new CCThread((CCTransaction)transaction);
                transaction.setWaiting(true);
                thread.start();
                break;
            }
            case 3: {
                CCTransaction ccTransaction = (CCTransaction)transaction;
            }
            default: {
                return super.process(transaction);
            }
        }
        return transaction;
    }

    private class CCThread
    extends Thread {
        private CCTransaction transaction;

        public CCThread(CCTransaction transaction) {
            this.transaction = transaction;
            if (CreditCardAdapter.this.httpsServerUrl == null || CreditCardAdapter.this.httpsServerUrl.equals("https://localhost") || CreditCardAdapter.this.httpsServerUrl.equals("https://127.0.0.1") || CreditCardAdapter.this.httpsServerUrl.equals("")) {
                CreditCardAdapter.this.httpsServerUrl = System.getProperty("https.url");
                if (CreditCardAdapter.this.httpsServerUrl != null) {
                    String port = CreditCardAdapter.this.httpsServerUrl.substring(CreditCardAdapter.this.httpsServerUrl.lastIndexOf(58) + 1);
                    CreditCardAdapter.this.httpsServerUrl = "https://127.0.0.1:" + port;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (CreditCardAdapter.this.httpsServerUrl == null) {
                this.transaction.setState(4);
                this.transaction.setWaiting(false);
                return;
            }
            HttpsConnection c = null;
            Object infoForm = null;
            try {
                String payResponse;
                c = (HttpsConnection)Connector.open((String)CreditCardAdapter.this.httpsServerUrl);
                String prof = System.getProperty("microedition.profiles");
                int space = prof.indexOf(32);
                if (space != -1) {
                    prof = prof.substring(0, space);
                }
                c.setRequestProperty("User-Agent", "Profile/" + prof + " Configuration/" + System.getProperty("microedition.configuration"));
                c.setRequestProperty("Accept-Charset", "UTF-8, " + System.getProperty("microedition.encoding"));
                String locale = System.getProperty("microedition.locale");
                if (locale != null && locale.length() > 0) {
                    c.setRequestProperty("Accept-Language", locale);
                }
                c.setRequestProperty(CreditCardAdapter.PAY_REQUEST_KEY, CreditCardAdapter.PAY_REQUEST_PAYMENT);
                c.setRequestProperty(CreditCardAdapter.PAY_CC_TYPE, String.valueOf(CreditCardAdapter.this.cardType));
                c.setRequestProperty(CreditCardAdapter.PAY_CC_NUMBER, this.transaction.cardNumber);
                c.setRequestProperty(CreditCardAdapter.PAY_CC_HOLDER, this.transaction.cardHolderName);
                c.setRequestProperty(CreditCardAdapter.PAY_CC_EXPIRY, this.transaction.expirationDate);
                c.setRequestProperty(CreditCardAdapter.PAY_FEATURE_ID, this.transaction.getSpecificPriceInfo());
                c.setRequestProperty(CreditCardAdapter.PAY_PROVIDER, this.transaction.getProviderName());
                if (this.transaction.cardVerificationNumber != null && this.transaction.cardVerificationNumber.length() > 0) {
                    c.setRequestProperty(CreditCardAdapter.PAY_CCV, this.transaction.cardVerificationNumber);
                }
                if (this.transaction.getPayload() != null && this.transaction.getPayload().length > 0) {
                    c.setRequestProperty(CreditCardAdapter.PAY_PAYLOAD, new String(this.transaction.getPayload()));
                }
                if ((payResponse = c.getHeaderField(CreditCardAdapter.PAY_RESPONSE_KEY)) != null) {
                    if (payResponse.indexOf("SUCCESSFUL") != -1) {
                        this.transaction.setState(3);
                    } else {
                        this.transaction.setState(4);
                    }
                } else {
                    this.transaction.setState(4);
                }
            }
            catch (Exception e) {
                this.transaction.setState(4);
            }
            finally {
                this.transaction.setWaiting(false);
            }
        }
    }

    private class InfoForm
    extends Form
    implements CommandListener {
        private final Command okCmd = new Command(Resource.getString("OK"), 4, 1);
        private Transaction transaction;

        public InfoForm(String label, Transaction tran) {
            super(label);
            this.addCommand(this.okCmd);
            this.setCommandListener(this);
            this.transaction = tran;
        }

        public void commandAction(Command c, Displayable d) {
            CreditCardAdapter.this.preemptDisplay(classSecurityToken, null);
            this.transaction.setWaiting(false);
        }
    }

    private class CCForm
    extends Form
    implements CommandListener {
        private CCTransaction transaction;
        private final TextField cardHolderField = new TextField(Resource.getString("Card Holder:"), null, 30, 0);
        private final TextField cardNumberField = new TextField(Resource.getString("Card Number:"), null, 16, 2);
        private final TextField expirationField = new TextField(Resource.getString("Expiration (mm/yyyy):"), null, 7, 0);
        private final TextField verificationField = new TextField(Resource.getString("Verification:"), null, 6, 65536);
        private final Command acceptCommand = new Command(Resource.getString("Purchase"), 4, 1);
        private final Command rejectCommand = new Command(Resource.getString("Cancel"), 3, 1);
        private final Form errorForm = new Form(Resource.getString("Credit card information error"));
        private final Command backCommand = new Command(Resource.getString("Back"), 2, 1);

        public CCForm(CCTransaction transaction) {
            super(Resource.getString("Credit card payment"));
            this.transaction = transaction;
            int multiplied = (int)(transaction.getPrice() * 100.0 + 0.5);
            String priceString = Integer.toString(multiplied);
            int length = priceString.length();
            StringBuffer buffer = new StringBuffer();
            buffer.append(priceString.substring(0, length - 2));
            buffer.append(".");
            buffer.append(priceString.substring(length - 2));
            buffer.append(" ");
            buffer.append(transaction.getCurrency());
            String card = null;
            switch (CreditCardAdapter.this.cardType) {
                case 0: {
                    card = CreditCardAdapter.VISA_NAME;
                    break;
                }
                case 1: {
                    card = CreditCardAdapter.MASTERCARD_NAME;
                    break;
                }
                case 2: {
                    card = CreditCardAdapter.AMERICAN_EXPRES_NAME;
                    break;
                }
                default: {
                    card = "UNKNOWN";
                }
            }
            this.append(new StringItem(Resource.getString("Amount:"), buffer.toString()));
            this.append(new StringItem(Resource.getString("Card type:"), card));
            this.append(this.cardHolderField);
            this.append(this.cardNumberField);
            this.append(this.expirationField);
            this.append(this.verificationField);
            this.addCommand(this.acceptCommand);
            this.addCommand(this.rejectCommand);
            this.setCommandListener(this);
            this.errorForm.addCommand(this.backCommand);
            this.errorForm.setCommandListener(this);
        }

        public void commandAction(Command c, Displayable d) {
            if (c == this.acceptCommand) {
                CreditCardAdapter.this.preemptDisplay(classSecurityToken, null);
                this.transaction.cardHolderName = this.cardHolderField.getString();
                this.transaction.cardNumber = this.cardNumberField.getString();
                this.transaction.expirationDate = this.expirationField.getString();
                this.transaction.cardVerificationNumber = this.verificationField.getString();
                this.errorForm.append(Resource.getString("You have entered information containing an error:"));
                if (!CreditCardAdapter.this.validateCreditCardInfo(this.transaction, this.errorForm)) {
                    CreditCardAdapter.this.preemptDisplay(classSecurityToken, this.errorForm);
                } else {
                    this.transaction.setState(256);
                    this.transaction.setNeedsUI(false);
                    this.transaction.setWaiting(false);
                }
            } else if (c == this.rejectCommand) {
                CreditCardAdapter.this.preemptDisplay(classSecurityToken, null);
                this.transaction.setState(5);
                this.transaction.setNeedsUI(false);
                this.transaction.setWaiting(false);
            } else if (c == this.backCommand) {
                this.errorForm.deleteAll();
                CreditCardAdapter.this.preemptDisplay(classSecurityToken, null);
                CreditCardAdapter.this.preemptDisplay(classSecurityToken, this);
            }
        }
    }

    private static class CCTransaction
    extends Transaction {
        public static final int COMPLETE = 256;
        public String cardHolderName;
        public String cardNumber;
        public String expirationDate;
        public String cardVerificationNumber;

        public CCTransaction(Transaction transaction) {
            super(transaction);
        }
    }
}

