/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.payment;

import com.sun.j2me.payment.PaymentAdapter;
import com.sun.j2me.payment.PaymentException;
import com.sun.j2me.payment.PaymentInfo;
import com.sun.j2me.payment.PaymentModule;
import com.sun.j2me.payment.Transaction;
import com.sun.j2me.payment.TransactionModuleImpl;
import com.sun.j2me.payment.TransactionStore;
import com.sun.j2me.payment.Utils;
import com.sun.kvem.payment.CreditCardAdapter;
import com.sun.kvem.payment.KvemTransactionModuleImpl;
import com.sun.kvem.payment.KvemUtils;
import com.sun.kvem.payment.TransactionStoreImpl;
import com.sun.midp.lcdui.DisplayManager;
import com.sun.midp.lcdui.DisplayManagerFactory;
import com.sun.midp.lcdui.MIDletEventListener;
import com.sun.midp.lcdui.Resource;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.security.SecurityInitializer;
import com.sun.midp.security.SecurityToken;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.payment.TransactionModuleException;

public class KvemPaymentModule
extends PaymentModule
implements MIDletEventListener {
    private static SecurityToken classSecurityToken;
    static Random random;
    private TransactionStore transactionStore;
    private Utils utilities;
    private final DisplayManager displayManager = DisplayManagerFactory.getDisplayManager();
    private Object preemptToken;

    public static void initSecurityToken(SecurityToken token) {
        if (classSecurityToken != null) {
            return;
        }
        classSecurityToken = token;
        CreditCardAdapter.initSecurityToken(token);
    }

    public boolean isSupportedAdapter(String name) {
        if ("X-CCARD".equals(name)) {
            return true;
        }
        return super.isSupportedAdapter(name);
    }

    public TransactionModuleImpl createTransactionModule(Object object) throws TransactionModuleException {
        return new KvemTransactionModuleImpl(object);
    }

    public final void initializeTransactionStore(MIDletSuite midletSuite) {
        PaymentInfo paymentInfo = midletSuite.getPaymentInfo();
        int numMissedTransactions = paymentInfo.getDbgMissedTransactions();
        if (paymentInfo.isDemoMode() && numMissedTransactions > 0) {
            TransactionStoreImpl transactionStore = (TransactionStoreImpl)this.getTransactionStore();
            try {
                transactionStore.generateFakeRecords(midletSuite.getPaymentID(), midletSuite.getProperty("MIDlet-Name"), paymentInfo, Resource.getString("Feature") + " ", this.getValidProviders(paymentInfo), numMissedTransactions);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public final int getSizeUsedInStore(int applicationID) {
        TransactionStore transactionStore = this.getTransactionStore();
        int size = 0;
        try {
            size = transactionStore.getSizeUsedByApplication(applicationID);
        }
        catch (IOException e) {
            // empty catch block
        }
        return size;
    }

    public final void uninstallFromStore(SecurityToken securityToken, int applicationID) {
        securityToken.checkIfPermissionAllowed(1);
        TransactionStore transactionStore = this.getTransactionStore();
        try {
            transactionStore.removeApplicationRecords(applicationID);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public final void cleanUp() throws IOException {
        if (System.getProperty("sun.payment.allowcleanup") == null) {
            throw new SecurityException();
        }
        this.getTransactionStore().cleanUp();
    }

    protected final boolean handleTransactionDebugMode(Transaction transaction) {
        PaymentInfo paymentInfo = KvemPaymentModule.getPaymentInfo(transaction);
        if (paymentInfo.isDemoMode()) {
            if (paymentInfo.getDbgFailIO() || paymentInfo.getDbgRandomTests() && random.nextInt(128) < 64) {
                transaction.setState(4);
            } else {
                transaction.setState(3);
            }
            transaction.setNeedsUI(false);
            return true;
        }
        return false;
    }

    protected final boolean handleAutoRequestMode(Transaction transaction) {
        PaymentInfo paymentInfo = KvemPaymentModule.getPaymentInfo(transaction);
        if (!paymentInfo.isDemoMode()) {
            return false;
        }
        int autoRequestMode = paymentInfo.getDbgAutoRequestMode();
        if (autoRequestMode == 0) {
            return false;
        }
        int[] providers = this.getValidProviders(paymentInfo);
        if (transaction instanceof PaymentModule.InitializationTransaction) {
            if (providers.length > 0) {
                return false;
            }
            transaction.setState(autoRequestMode == 1 ? 3 : 4);
            transaction.setNeedsUI(false);
            return true;
        }
        if (providers.length == 0) {
            transaction.setState(4);
            transaction.setNeedsUI(false);
            return true;
        }
        if (autoRequestMode == 1) {
            this.assignTransaction(transaction, providers[0]);
        } else {
            transaction.setState(5);
            transaction.setNeedsUI(false);
        }
        return true;
    }

    protected PaymentAdapter getAdapter(String name, String configuration, boolean noAdapterMode) throws PaymentException {
        if (noAdapterMode) {
            return null;
        }
        return super.getAdapter(name, configuration, noAdapterMode);
    }

    protected PaymentAdapter createAdapter(String adapter, String configuration) throws PaymentException {
        if ("X-CCARD".equals(adapter)) {
            return CreditCardAdapter.getInstance(configuration);
        }
        return super.createAdapter(adapter, configuration);
    }

    protected TransactionStore getTransactionStore() {
        if (this.transactionStore == null) {
            try {
                this.transactionStore = new TransactionStoreImpl(classSecurityToken);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.transactionStore;
    }

    protected Utils getUtilities() {
        if (this.utilities == null) {
            this.utilities = new KvemUtils();
        }
        return this.utilities;
    }

    public void pauseMIDlet(MIDlet midlet) {
    }

    public void startMIDlet(MIDlet midlet) {
    }

    public void destroyMIDlet(MIDlet midlet) {
    }

    protected final void preemptDisplay(SecurityToken token, Displayable nextDisplayable) {
        if (nextDisplayable == null) {
            this.displayManager.donePreempting(this.preemptToken);
            this.preemptToken = null;
        } else {
            try {
                this.preemptToken = this.displayManager.preemptDisplay(token, this, nextDisplayable, true);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static {
        random = new Random();
        KvemPaymentModule.initSecurityToken(SecurityInitializer.getSecurityToken());
    }
}

