/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.payment;

import com.sun.j2me.payment.Transaction;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.payment.TransactionRecord;

final class TransactionRecordImpl
implements TransactionRecord {
    private int transactionID;
    private int applicationID;
    private String applicationName;
    private int featureID;
    private String featureTitle;
    private double price;
    private String currency;
    private int state;
    private long timestamp;
    private boolean missed;
    private boolean fake;
    private static final String EMPTY_CURRENCY = "";
    private static final String TEMPLATE_CURRENCY = "USD";

    TransactionRecordImpl(int applicationID, String applicationName, Transaction transaction, long timestamp, boolean fake) {
        this.applicationID = applicationID;
        this.applicationName = applicationName;
        this.transactionID = transaction.getTransactionID();
        this.featureID = transaction.getFeatureID();
        this.featureTitle = transaction.getFeatureTitle();
        this.price = transaction.getPrice();
        this.currency = transaction.getCurrency();
        if (this.currency == null) {
            this.currency = EMPTY_CURRENCY;
        }
        switch (transaction.getState()) {
            case 3: {
                this.state = 0;
                break;
            }
            case 5: {
                this.state = 2;
                break;
            }
            case 4: {
                this.state = 1;
            }
        }
        this.timestamp = timestamp;
        this.fake = fake;
        this.missed = true;
    }

    TransactionRecordImpl createDuplicateRecord(boolean newMissed) {
        TransactionRecordImpl newRecord = new TransactionRecordImpl();
        newRecord.transactionID = this.transactionID;
        newRecord.applicationID = this.applicationID;
        newRecord.applicationName = this.applicationName;
        newRecord.featureID = this.featureID;
        newRecord.featureTitle = this.featureTitle;
        newRecord.price = this.price;
        newRecord.currency = this.currency;
        newRecord.state = this.state;
        newRecord.timestamp = this.timestamp;
        newRecord.fake = this.fake;
        newRecord.missed = newMissed;
        return newRecord;
    }

    public int getFeatureID() {
        return this.featureID;
    }

    public long getFinishedTimestamp() {
        return this.timestamp;
    }

    public int getState() {
        return this.state;
    }

    public int getTransactionID() {
        return this.transactionID;
    }

    public boolean wasMissed() {
        return this.missed;
    }

    public int getApplicationID() {
        return this.applicationID;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getFeatureTitle() {
        return this.featureTitle;
    }

    public double getPrice() {
        return this.price;
    }

    public String getCurrency() {
        return this.currency;
    }

    public boolean isFake() {
        return this.fake;
    }

    int getSerializedSize() {
        if (this.fake) {
            return 0;
        }
        int size = 0;
        try {
            size = TransactionRecordImpl.calculateSize(this.applicationName, this.featureTitle);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return size;
    }

    private TransactionRecordImpl() {
    }

    static TransactionRecordImpl createFakeRecord(int transactionID, int applicationID, String applicationName, int featureID, String featureTitle, double price, String currency, int state, long timestamp) {
        TransactionRecordImpl record = new TransactionRecordImpl();
        record.transactionID = transactionID;
        record.applicationID = applicationID;
        record.applicationName = applicationName;
        record.featureID = featureID;
        record.featureTitle = featureTitle;
        record.price = price;
        record.currency = currency;
        record.state = state;
        record.timestamp = timestamp;
        record.missed = true;
        record.fake = true;
        return record;
    }

    static TransactionRecordImpl read(DataInputStream is) throws IOException {
        TransactionRecordImpl newRecord = new TransactionRecordImpl();
        newRecord.transactionID = is.readInt();
        newRecord.applicationID = is.readInt();
        newRecord.applicationName = is.readUTF();
        newRecord.featureID = is.readInt();
        newRecord.featureTitle = is.readUTF();
        newRecord.price = is.readDouble();
        newRecord.currency = is.readUTF();
        newRecord.state = is.readInt();
        newRecord.timestamp = is.readLong();
        newRecord.missed = is.readBoolean();
        return newRecord;
    }

    void write(DataOutputStream os) throws IOException {
        os.writeInt(this.transactionID);
        os.writeInt(this.applicationID);
        os.writeUTF(this.applicationName);
        os.writeInt(this.featureID);
        os.writeUTF(this.featureTitle);
        os.writeDouble(this.price);
        os.writeUTF(this.currency);
        os.writeInt(this.state);
        os.writeLong(this.timestamp);
        os.writeBoolean(this.missed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int calculateSize(String applicationName, String featureTitle) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(bos);
        try {
            os.writeUTF(applicationName);
            os.writeUTF(featureTitle);
            os.writeUTF(TEMPLATE_CURRENCY);
            int size = bos.size();
        }
        finally {
            os.close();
        }
        return size += 33;
    }
}

