/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.payment;

import com.sun.j2me.payment.PaymentInfo;
import com.sun.j2me.payment.ProviderInfo;
import com.sun.j2me.payment.Transaction;
import com.sun.j2me.payment.TransactionStore;
import com.sun.kvem.payment.TransactionRecordImpl;
import com.sun.midp.io.j2me.storage.File;
import com.sun.midp.io.j2me.storage.RandomAccessStream;
import com.sun.midp.security.SecurityToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.microedition.payment.TransactionRecord;

public final class TransactionStoreImpl
implements TransactionStore {
    private Vector reservedRecords;
    private int reservedSize;
    private int nextTransactionID;
    private int nextApplicationID;
    private Vector missedRecords;
    private Vector passedRecords;
    private final File file;
    private final RandomAccessStream storage;
    private static final String TRANSACTIONS_LIMIT_PROPERTY = "payment.transactions.limit";
    private static final int DEFAULT_TRANSACTIONS_LIMIT = 16;
    private static final int MISSED_TRANSACTIONS_LIMIT = 4;
    private static final int PASSED_TRANSACTIONS_LIMIT;
    private static final String STORE_FILE_NAME;

    public TransactionStoreImpl(SecurityToken securityToken) throws IOException {
        this.file = new File(securityToken);
        this.storage = new RandomAccessStream(securityToken);
        this.reservedRecords = new Vector();
        this.reservedSize = 0;
        this.readStore();
    }

    public synchronized TransactionRecord addTransaction(Transaction transaction) throws IOException {
        int transactionID = transaction.getTransactionID();
        ReservedRecord reservedRecord = this.findReservedRecord(transactionID);
        if (reservedRecord == null) {
            throw new IllegalStateException("The transaction record hasn't been reserved");
        }
        TransactionRecordImpl newTransactionRecord = new TransactionRecordImpl(reservedRecord.getApplicationID(), reservedRecord.getApplicationName(), transaction, System.currentTimeMillis(), reservedRecord.getApplicationID() < 0);
        this.reservedRecords.removeElement(reservedRecord);
        this.missedRecords.addElement(newTransactionRecord);
        this.reservedSize -= reservedRecord.getReservedSize();
        this.updateStore();
        return newTransactionRecord.createDuplicateRecord(false);
    }

    public synchronized boolean wasDelivered(int transactionID) throws IOException {
        TransactionRecordImpl transactionRecord = this.findMissedRecord(transactionID);
        return transactionRecord == null;
    }

    public synchronized void setDelivered(int transactionID) throws IOException {
        TransactionRecordImpl transactionRecord = this.findMissedRecord(transactionID);
        if (transactionRecord == null) {
            throw new IllegalArgumentException("Not a stored transaction");
        }
        this.missedRecords.removeElement(transactionRecord);
        transactionRecord = transactionRecord.createDuplicateRecord(false);
        this.passedRecords.addElement(transactionRecord);
        TransactionStoreImpl.limitRealRecords(this.passedRecords, PASSED_TRANSACTIONS_LIMIT);
        this.updateStore();
    }

    public synchronized int getNextApplicationID() throws IOException {
        int id = this.nextApplicationID++;
        this.updateStore();
        return id;
    }

    public synchronized TransactionRecord[] getMissedTransactions(int applicationID) throws IOException {
        return this.getMissedTransactions(applicationID, false);
    }

    public synchronized TransactionRecord[] getPassedTransactions(int applicationID) throws IOException {
        int count = this.passedRecords.size();
        int found = 0;
        for (int i = 0; i < count; ++i) {
            TransactionRecordImpl record = (TransactionRecordImpl)this.passedRecords.elementAt(i);
            if (record.getApplicationID() != applicationID) continue;
            ++found;
        }
        if (found == 0) {
            return null;
        }
        TransactionRecord[] appRecords = new TransactionRecordImpl[found];
        for (int i = 0; i < count; ++i) {
            TransactionRecordImpl record = (TransactionRecordImpl)this.passedRecords.elementAt(i);
            if (record.getApplicationID() != applicationID) continue;
            appRecords[--found] = record;
        }
        return appRecords;
    }

    public synchronized int reserve(int applicationID, Transaction transaction) throws IOException {
        Object record;
        int i;
        int used = 0;
        int count = this.reservedRecords.size();
        for (i = 0; i < count; ++i) {
            record = (ReservedRecord)this.reservedRecords.elementAt(i);
            if (((ReservedRecord)record).getApplicationID() != applicationID) continue;
            ++used;
        }
        count = this.missedRecords.size();
        for (i = 0; i < count; ++i) {
            record = (TransactionRecordImpl)this.missedRecords.elementAt(i);
            if (((TransactionRecordImpl)record).getApplicationID() != applicationID) continue;
            ++used;
        }
        if (used >= 4) {
            throw new IOException("No more space for records");
        }
        String applicationName = transaction.getTransactionModule().getMIDlet().getAppProperty("MIDlet-Name");
        int transactionID = this.nextTransactionID++;
        int size = applicationID < 0 ? 0 : TransactionRecordImpl.calculateSize(applicationName, transaction.getFeatureTitle());
        this.reservedSize += size;
        try {
            this.updateStore();
        }
        catch (IOException e) {
            this.reservedSize -= size;
            --this.nextTransactionID;
            throw e;
        }
        this.reservedRecords.addElement(new ReservedRecord(applicationID, applicationName, transactionID, size));
        return transactionID;
    }

    public synchronized int getSizeUsedByApplication(int applicationID) throws IOException {
        Object record;
        int i;
        if (applicationID < 0) {
            return 0;
        }
        int total = 0;
        int count = this.reservedRecords.size();
        for (i = 0; i < count; ++i) {
            record = (ReservedRecord)this.reservedRecords.elementAt(i);
            if (((ReservedRecord)record).getApplicationID() != applicationID) continue;
            total += ((ReservedRecord)record).getReservedSize();
        }
        count = this.missedRecords.size();
        for (i = 0; i < count; ++i) {
            record = (TransactionRecordImpl)this.missedRecords.elementAt(i);
            if (((TransactionRecordImpl)record).getApplicationID() != applicationID) continue;
            total += ((TransactionRecordImpl)record).getSerializedSize();
        }
        return total;
    }

    public synchronized void removeApplicationRecords(int applicationID) throws IOException {
        int i;
        int count = this.reservedRecords.size();
        for (i = 0; i < count; ++i) {
            ReservedRecord record = (ReservedRecord)this.reservedRecords.elementAt(i);
            if (record.getApplicationID() != applicationID) continue;
            this.reservedRecords.removeElementAt(i);
            this.reservedSize -= record.getReservedSize();
            --i;
            --count;
        }
        count = this.missedRecords.size();
        for (i = 0; i < count; ++i) {
            if (((TransactionRecordImpl)this.missedRecords.elementAt(i)).getApplicationID() != applicationID) continue;
            this.missedRecords.removeElementAt(i);
            --i;
            --count;
        }
        this.updateStore();
    }

    public synchronized void cleanUp() throws IOException {
        if (this.file.exists(STORE_FILE_NAME)) {
            this.file.delete(STORE_FILE_NAME);
        }
        this.reservedRecords.removeAllElements();
        this.reservedSize = 0;
        this.initStore();
    }

    synchronized TransactionRecord[] getMissedTransactions(int applicationID, boolean fakeOnly) throws IOException {
        int count = this.missedRecords.size();
        int found = 0;
        for (int i = 0; i < count; ++i) {
            TransactionRecordImpl record = (TransactionRecordImpl)this.missedRecords.elementAt(i);
            if (record.getApplicationID() != applicationID || fakeOnly && !record.isFake()) continue;
            ++found;
        }
        if (found == 0) {
            return null;
        }
        TransactionRecord[] appRecords = new TransactionRecordImpl[found];
        found = 0;
        for (int i = 0; i < count; ++i) {
            TransactionRecordImpl record = (TransactionRecordImpl)this.missedRecords.elementAt(i);
            if (record.getApplicationID() != applicationID || fakeOnly && !record.isFake()) continue;
            appRecords[found++] = record;
        }
        return appRecords;
    }

    synchronized void generateFakeRecords(int applicationID, String applicationName, PaymentInfo paymentInfo, String featurePrefix, int[] validProviders, int count) throws IOException {
        int transactionID = this.nextTransactionID;
        this.nextTransactionID += count;
        this.updateStore();
        Random random = new Random();
        long timestamp = System.currentTimeMillis() - 3600000L;
        int deltaTime = 3600000 / count;
        int numFeatures = paymentInfo.getNumFeatures();
        for (int i = 0; i < count; ++i) {
            String currency;
            double price;
            int state = random.nextInt(3);
            int featureID = (i + (count >>> 1)) * (numFeatures - 1) / count;
            if (state != 2) {
                int priceTag = paymentInfo.getPriceTagForFeature(featureID);
                int providerID = validProviders.length > 0 ? validProviders[random.nextInt(validProviders.length)] : 0;
                ProviderInfo providerInfo = paymentInfo.getProvider(providerID);
                price = providerInfo.getPrice(priceTag);
                currency = providerInfo.getCurrency();
            } else {
                price = 0.0;
                currency = "";
            }
            this.missedRecords.addElement(TransactionRecordImpl.createFakeRecord(transactionID++, applicationID, applicationName, featureID, featurePrefix + featureID, price, currency, state, timestamp));
            timestamp += (long)deltaTime;
        }
    }

    private TransactionRecordImpl findMissedRecord(int transactionID) {
        int count = this.missedRecords.size();
        for (int i = 0; i < count; ++i) {
            TransactionRecordImpl record = (TransactionRecordImpl)this.missedRecords.elementAt(i);
            if (record.getTransactionID() != transactionID) continue;
            return record;
        }
        return null;
    }

    private ReservedRecord findReservedRecord(int transactionID) {
        int count = this.reservedRecords.size();
        for (int i = 0; i < count; ++i) {
            ReservedRecord record = (ReservedRecord)this.reservedRecords.elementAt(i);
            if (record.getTransactionID() != transactionID) continue;
            return record;
        }
        return null;
    }

    private void initStore() {
        this.nextTransactionID = 1;
        this.nextApplicationID = 1;
        this.missedRecords = new Vector();
        this.passedRecords = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readStore() throws IOException {
        int nextApplicationID;
        int nextTransactionID;
        byte[] data;
        if (!this.file.exists(STORE_FILE_NAME)) {
            this.initStore();
            return;
        }
        this.storage.connect(STORE_FILE_NAME, 1);
        try {
            data = new byte[this.storage.getSizeOf()];
            this.storage.readBytes(data, 0, data.length);
        }
        finally {
            this.storage.disconnect();
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        DataInputStream is = new DataInputStream(bis);
        Vector<TransactionRecordImpl> missedRecords = new Vector<TransactionRecordImpl>();
        Vector<TransactionRecordImpl> passedRecords = new Vector<TransactionRecordImpl>();
        try {
            int i;
            nextTransactionID = is.readInt();
            nextApplicationID = is.readInt();
            int missedCount = is.readInt();
            int passedCount = is.readInt();
            for (i = 0; i < missedCount; ++i) {
                missedRecords.addElement(TransactionRecordImpl.read(is));
            }
            for (i = 0; i < passedCount; ++i) {
                passedRecords.addElement(TransactionRecordImpl.read(is));
            }
        }
        finally {
            is.close();
        }
        this.nextTransactionID = nextTransactionID;
        this.nextApplicationID = nextApplicationID;
        this.missedRecords = missedRecords;
        this.passedRecords = passedRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStore() throws IOException {
        byte[] data;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(bos);
        try {
            TransactionRecordImpl record;
            int i;
            os.writeInt(this.nextTransactionID);
            os.writeInt(this.nextApplicationID);
            int missedCount = this.missedRecords.size();
            int passedCount = this.passedRecords.size();
            os.writeInt(TransactionStoreImpl.getRealCount(this.missedRecords));
            os.writeInt(TransactionStoreImpl.getRealCount(this.passedRecords));
            for (i = 0; i < missedCount; ++i) {
                record = (TransactionRecordImpl)this.missedRecords.elementAt(i);
                if (record.isFake()) continue;
                record.write(os);
            }
            for (i = 0; i < passedCount; ++i) {
                record = (TransactionRecordImpl)this.passedRecords.elementAt(i);
                if (record.isFake()) continue;
                record.write(os);
            }
            for (i = 0; i < this.reservedSize; ++i) {
                os.write(0);
            }
            data = bos.toByteArray();
        }
        finally {
            os.close();
        }
        bos = null;
        os = null;
        this.storage.connect(STORE_FILE_NAME, this.file.exists(STORE_FILE_NAME) ? 2 : -3);
        try {
            this.storage.writeBytes(data, 0, data.length);
            this.storage.truncate(data.length);
        }
        finally {
            this.storage.disconnect();
        }
    }

    private static int getRealCount(Vector records) {
        int real = 0;
        int count = records.size();
        for (int i = 0; i < count; ++i) {
            if (((TransactionRecordImpl)records.elementAt(i)).isFake()) continue;
            ++real;
        }
        return real;
    }

    private static void limitRealRecords(Vector records, int limit) {
        int count = TransactionStoreImpl.getRealCount(records);
        if (count > limit) {
            int remove = count - limit;
            int total = records.size();
            for (int i = 0; i < total; ++i) {
                if (((TransactionRecordImpl)records.elementAt(i)).isFake()) continue;
                records.removeElementAt(i);
                if (--remove == 0) break;
                --i;
                --total;
            }
        }
    }

    static {
        STORE_FILE_NAME = File.getStorageRoot() + "_paytrans.bin";
        int limit = 16;
        String limitStr = System.getProperty(TRANSACTIONS_LIMIT_PROPERTY);
        if (limitStr != null) {
            try {
                int value = Integer.parseInt(limitStr);
                if (value >= 0) {
                    limit = value;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        PASSED_TRANSACTIONS_LIMIT = limit;
    }

    private static class ReservedRecord {
        private int applicationID;
        private String applicationName;
        private int transactionID;
        private int reservedSize;

        public ReservedRecord(int applicationID, String applicationName, int transactionID, int reservedSize) {
            this.applicationID = applicationID;
            this.applicationName = applicationName;
            this.transactionID = transactionID;
            this.reservedSize = reservedSize;
        }

        public int getApplicationID() {
            return this.applicationID;
        }

        public String getApplicationName() {
            return this.applicationName;
        }

        public int getTransactionID() {
            return this.transactionID;
        }

        public int getReservedSize() {
            return this.reservedSize;
        }
    }
}

