/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.util;

import java.io.IOException;
import java.io.InputStream;

public abstract class MarkableInputStream
extends InputStream {
    public int lookahead = -1;
    public int moreToRead = -1;

    public abstract void inMark() throws IOException;

    public abstract void inReset() throws IOException;

    public boolean markSupported() {
        return true;
    }

    public void mark(int lookahead) {
        try {
            this.inMark();
            this.lookahead = lookahead;
            this.moreToRead = lookahead;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public void reset() throws IOException {
        if (this.lookahead < 0) {
            throw new IOException("Cannot reset an unmarked stream");
        }
        try {
            this.inReset();
            this.moreToRead = this.lookahead;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public void close() throws IOException {
        this.inClose();
    }

    public int read() throws IOException {
        int res;
        if (this.moreToRead < 0 && this.lookahead >= 0) {
            this.lookahead = -1;
            this.moreToRead = -1;
        }
        if ((res = this.inRead()) != -1) {
            --this.moreToRead;
        }
        return res;
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        int res = this.inRead(b, offset, length);
        if (res != -1) {
            this.moreToRead -= res;
        }
        return res;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public abstract int inRead() throws IOException;

    public abstract int inRead(byte[] var1, int var2, int var3) throws IOException;

    public abstract void inClose() throws IOException;
}

