/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.dev;

import com.sun.midp.content.CHManager;
import com.sun.midp.dev.SuiteDownloadInfo;
import com.sun.midp.io.Base64;
import com.sun.midp.io.j2me.storage.File;
import com.sun.midp.io.j2me.storage.RandomAccessStream;
import com.sun.midp.lcdui.Resource;
import com.sun.midp.midlet.MIDletInfo;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midletsuite.InstallListener;
import com.sun.midp.midletsuite.InstallState;
import com.sun.midp.midletsuite.Installer;
import com.sun.midp.midletsuite.InvalidJadException;
import com.sun.midp.publickeystore.WebPublicKeyStore;
import com.sun.midp.security.SecurityToken;
import com.sun.midp.ssl.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.pki.CertificateException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class GraphicalInstaller
extends MIDlet
implements CommandListener {
    static final int ALERT_TIMEOUT = 1250;
    static final String SETTINGS_STORE = "settings";
    static final int URL_RECORD_ID = 1;
    static final int SELECTED_MIDLET_RECORD_ID = 2;
    static final String SIG_PROP = "MIDlet-Jar-RSA-SHA1";
    static boolean colorDisplay;
    static String storageName;
    private static final String CERT_PROP = "MIDlet-Certificate-";
    private Installer installer;
    private Display display;
    private String defaultInstallListUrl = "http://";
    private TextBox urlTextBox;
    private Form passwordForm;
    private TextField usernameField;
    private TextField passwordField;
    private BackgroundInstaller backgroundInstaller;
    private Form progressForm;
    private int progressGaugeIndex;
    private int progressUrlIndex;
    private long lastDisplayChange;
    private String cancelledMessage;
    private String finishingMessage;
    private boolean isTrusted = false;
    CHManager chmanager;
    private List installListBox;
    private Vector installList;
    private String currentSuiteName;
    private static SecurityToken securityToken;
    private Command endCmd = new Command(Resource.getString("Back"), 2, 1);
    private Command discoverCmd = new Command(Resource.getString("Go"), 1, 1);
    private Command saveCmd = new Command(Resource.getString("Save"), 1, 2);
    private Command backCmd = new Command(Resource.getString("Back"), 2, 1);
    private Command installCmd = new Command(Resource.getString("Install"), 8, 1);
    private Command stopCmd = new Command(Resource.getString("Stop"), 6, 1);
    private Command cancelCmd = new Command(Resource.getString("Cancel"), 3, 1);
    private Command continueCmd = new Command(Resource.getString("Install"), 4, 1);
    private Command confirmCmd = new Command(Resource.getString("Continue"), 4, 1);
    private Command nextCmd = new Command(Resource.getString("Next"), 4, 1);
    private Command okCmd = new Command(Resource.getString("Continue"), 4, 1);
    private Command exceptionCmd = new Command(Resource.getString("OK"), 4, 1);
    private Command keepRMSCmd = new Command(Resource.getString("Yes"), 4, 1);
    private Command removeRMSCmd = new Command(Resource.getString("No"), 3, 1);
    private Command keepPrivateCmd = new Command(Resource.getString("Yes"), 4, 1);
    private Command removePrivateCmd = new Command(Resource.getString("No"), 3, 1);
    private Command launchSuite = new Command(Resource.getString("OK"), 4, 1);
    private Command cancelSuite = new Command(Resource.getString("Exit"), 3, 1);
    private boolean cancelOrLaunchSuite = false;
    private static String[] errorMsgs;

    static Image getIconFromStorage(String iconName) {
        String iconFilename = File.getStorageRootFor(iconName);
        RandomAccessStream stream = securityToken != null ? new RandomAccessStream(securityToken) : new RandomAccessStream();
        try {
            stream.connect(iconFilename, 1);
            byte[] rawPng = new byte[stream.getSizeOf()];
            stream.readBytes(rawPng, 0, rawPng.length);
            stream.disconnect();
            return Image.createImage(rawPng, 0, rawPng.length);
        }
        catch (IOException noImage) {
            return null;
        }
    }

    private static String translateJadException(InvalidJadException exception, String name, String vendor, String version, String jadUrl) {
        String key;
        String[] values = new String[]{name, vendor, version, jadUrl, exception.getExtraData()};
        int code = exception.getReason();
        switch (code) {
            case 17: {
                key = "An OLDER version of %1 has been found. Continuing will replace the version installed on your phone.\n\nCurrently installed: %5\nVersion found: %3\nVendor: %2\nWebsite: %4\n\nWould you like to continue?";
                break;
            }
            case 39: {
                key = "This version of %1 is already installed on your phone. Continuing will replace the version installed on your phone.\n\nCurrently installed: %5\nVersion found: %3\nVendor: %2\nWebsite: %4\n\nWould you like to continue?";
                break;
            }
            case 32: {
                key = "A NEWER version of %1 has been found. Continuing will replace the version installed on your phone.\n\nCurrently installed: %5\nLatest available: %3\nVendor: %2\nWebsite: %4\n\nWould you like to continue?";
                break;
            }
            case 1: 
            case 2: 
            case 43: {
                key = "%1 cannot be found at this URL. Contact the application provider for more information.";
                break;
            }
            case 37: {
                key = "The application file (.jad) for %1 does not appear to be the correct type. Contact the application provider for more information.";
                break;
            }
            case 4: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 21: {
                key = "%1 cannot be installed because critical information is missing from the application file (.jad).";
                break;
            }
            case 41: 
            case 42: {
                key = "%1 cannot be installed because critical information is missing from the application file (.jar).";
                break;
            }
            case 16: 
            case 28: 
            case 29: 
            case 46: 
            case 48: {
                key = "%1 cannot be installed because critical information is not formatted correctly or is invalid. Contact your application provider to correct this situation.";
                break;
            }
            case 40: {
                key = "%1 is not designed to work with this device and cannot be installed.";
                break;
            }
            case 34: {
                key = "The new version of %1 is not from the same provider as the old version. The download URLs do not match. Do you want to install the new version?\n\nOld URL: %5\nNew URL: %4";
                break;
            }
            case 30: {
                key = "There is not enough room to install %1 (%5K is needed for installation.). Try removing other items to free up space.";
                break;
            }
            case 19: 
            case 20: 
            case 44: {
                key = "The application file (.jar) for %1 cannot be found at its URL. Contact the application provider for more information.";
                break;
            }
            case 38: {
                key = "The application file (.jar) for %1 does not appear to be the correct type. Contact the application provider for more information.";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 50: 
            case 59: {
                key = "%1 cannot be installed because critical information between the website and the application file does not match.";
                break;
            }
            case 36: {
                key = "The application file (.jar) for %1 appears to be corrupt. Contact the application provider for more information.";
                break;
            }
            case 35: {
                key = "The website has requested to authenticate the user in way that this device does not support.";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                key = "%1 cannnot be installed because the application files cannot verified. Contact your application provider to correct this situation.";
                break;
            }
            case 6: {
                key = "%1 cannot be installed. The system does not recognize who is trying to authorize the application. Contact your service provider to correct this situation. \n\n%5";
                break;
            }
            case 11: {
                key = "%1 cannot be installed. The trusted certificate used to authorize the application has expired. Contact your application provider to correct this situation.";
                break;
            }
            case 12: {
                key = "%1 cannot be installed. The public key used for authorization has expired. Contact your service provider to correct this situation.";
                break;
            }
            case 49: {
                key = "%1 cannot be installed because it does not have permission to the operation it requires.";
                break;
            }
            case 45: {
                key = "%1 cannot be installed. %1 is requires the use of a particular network resource to listen for network information. This resource is in use by another application. Try removing the other application and re-installing.";
                break;
            }
            case 47: {
                key = "%1 cannot be installed. %1 is requires the use of a particular network resource to listen for network information. This network resource is not supported on this device.";
                break;
            }
            case 52: {
                key = "The new version of %1, cannot be installed. The old version of %1 is authorized by %5. The new version is not authorized. Authorized applications cannot be replaced by unauthorized applications.";
                break;
            }
            case 54: {
                key = "%1 cannot be installed because critical content handler information is not formatted correctly or is invalid. Contact your application provider to correct this situation.";
                break;
            }
            case 55: {
                key = "%1 cannot be installed, it would conflict with another application.";
                break;
            }
            case 56: {
                key = "%1 cannot be installed. The payment information it contains is not supported.";
                break;
            }
            case 57: {
                key = "%1 cannot be installed. It has incorrect or incomplete payment information. Contact your application provider to correct this situation.";
                break;
            }
            case 58: {
                key = "%1 cannot be installed. It contains payment related information but is not trusted. Contact your application provider to correct this situation.";
                break;
            }
            default: {
                return exception.getMessage();
            }
        }
        String errMsg = "";
        try {
            errMsg = errorMsgs[code - 1];
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            // empty catch block
        }
        System.out.println("OTA Error Code (" + code + ") - " + errMsg + " [" + exception.getExtraData() + "]");
        return Resource.getString(key, values);
    }

    public GraphicalInstaller() {
        this(null, null);
    }

    public GraphicalInstaller(SecurityToken securityToken, String installUrl) {
        GraphicalInstaller.securityToken = securityToken;
        this.installer = securityToken != null ? Installer.getInstaller(securityToken) : Installer.getInstaller();
        this.display = Display.getDisplay(this);
        colorDisplay = this.display.isColor();
        this.chmanager = CHManager.newInstance();
        GraphicalInstaller.initSettings();
        this.restoreSettings();
        String storageName = this.getAppProperty("storageName");
        if (storageName != null) {
            GraphicalInstaller.storageName = storageName;
            this.updateSuite(storageName);
            return;
        }
        String url = this.chmanager.getInstallURL(this);
        if (url == null) {
            url = installUrl;
        }
        if (url != null) {
            String label = Resource.getString("Application");
            String successMessage = label + Resource.getString(" was successfully installed");
            this.cancelledMessage = Resource.getString("Installation cancelled.");
            this.finishingMessage = Resource.getString("Finishing installation.");
            this.installSuiteCommon("Installing", label, url, successMessage, false);
            return;
        }
        this.getUrl();
    }

    void exit(boolean success, boolean displayLaunchingConfirmation) {
        this.chmanager.installDone(success);
        boolean showAlert = false;
        if (displayLaunchingConfirmation && this.displayLaunchingConfirmation()) {
            MIDletSuite midletSuite = this.installer.getMIDletSuite(storageName);
            if (midletSuite.isTrusted() && !GraphicalInstaller.checkCertForInstalledApp(midletSuite)) {
                showAlert = true;
                Alert a = new Alert(null, Resource.getString("This application cannot be started because certificate used for application verifying is corrupted or not available."), null, AlertType.INFO);
                a.addCommand(this.exceptionCmd);
                a.setTimeout(4000);
                a.setCommandListener(new CommandListener(){

                    public void commandAction(Command c, Displayable s) {
                        GraphicalInstaller.this.notifyDestroyed();
                    }
                });
                while (System.currentTimeMillis() - this.lastDisplayChange < 1250L) {
                }
                this.display.setCurrent(a);
            } else {
                this.installer.execute(storageName, null);
            }
        }
        if (!showAlert) {
            this.notifyDestroyed();
        }
    }

    public void startApp() {
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
        if (this.installer != null) {
            this.installer.stopInstalling();
        }
        this.cancelBackgroundInstall();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commandAction(Command c, Displayable s) {
        if (c == this.discoverCmd) {
            this.discoverSuitesToInstall(this.urlTextBox.getString());
        } else if (s == this.installListBox && (c == List.SELECT_COMMAND || c == this.installCmd)) {
            this.installSuite(this.installListBox.getSelectedIndex());
        } else if (c == this.backCmd) {
            this.display.setCurrent(this.urlTextBox);
        } else if (c == this.nextCmd) {
            this.resumeInstallWithPassword();
        } else if (c == this.okCmd) {
            this.resumeInstallAfterWarning();
        } else if (c == this.continueCmd) {
            if (this.isTrusted) {
                this.startJarDownload();
            } else {
                this.displaySecurityConfirmation();
            }
        } else if (c == this.confirmCmd) {
            this.startJarDownload();
        } else if (c == this.saveCmd) {
            this.saveURLSetting();
        } else if (c == this.keepRMSCmd) {
            this.setKeepRMSAnswer(true);
        } else if (c == this.removeRMSCmd) {
            this.setKeepRMSAnswer(false);
        } else if (c == this.keepPrivateCmd) {
            this.setKeepPrivateAnswer(true);
        } else if (c == this.removePrivateCmd) {
            this.setKeepPrivateAnswer(false);
        } else if (c == this.stopCmd) {
            if (this.installer != null) {
                GraphicalInstaller graphicalInstaller = this;
                synchronized (graphicalInstaller) {
                    if (this.installer.stopInstalling()) {
                        this.displayCancelledMessage(this.cancelledMessage);
                    }
                }
            } else {
                this.exit(false, false);
            }
        } else if (c == this.cancelCmd) {
            this.displayCancelledMessage(this.cancelledMessage);
            this.cancelBackgroundInstall();
        } else if (c == this.endCmd || c == Alert.DISMISS_COMMAND) {
            this.exit(false, false);
        } else {
            if (c == this.launchSuite) {
                this.cancelOrLaunchSuite = true;
                GraphicalInstaller graphicalInstaller = this;
                synchronized (graphicalInstaller) {
                    this.notify();
                }
            }
            if (c == this.cancelSuite) {
                GraphicalInstaller graphicalInstaller = this;
                synchronized (graphicalInstaller) {
                    this.notify();
                }
                this.exit(false, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreSettings() {
        RecordStore settings = null;
        String url = null;
        url = System.getProperty("ams.url");
        if (url != null) {
            this.defaultInstallListUrl = url;
        } else {
            try {
                settings = RecordStore.openRecordStore(SETTINGS_STORE, false);
                byte[] data = settings.getRecord(1);
                if (data != null) {
                    ByteArrayInputStream bas = new ByteArrayInputStream(data);
                    DataInputStream dis = new DataInputStream(bas);
                    this.defaultInstallListUrl = dis.readUTF();
                }
            }
            catch (RecordStoreException e) {
            }
            catch (IOException e) {
            }
            finally {
                if (settings != null) {
                    try {
                        settings.closeRecordStore();
                    }
                    catch (RecordStoreException e) {}
                }
            }
        }
    }

    static void initSettings() {
        try {
            RecordStore settings = RecordStore.openRecordStore(SETTINGS_STORE, true);
            if (settings.getNumRecords() == 0) {
                settings.addRecord(null, 0, 0);
                settings.addRecord(null, 0, 0);
            }
            settings.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static Exception saveSettings(String url, String curMidlet) {
        Exception ret = null;
        storageName = curMidlet;
        try {
            byte[] data;
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bas);
            RecordStore settings = RecordStore.openRecordStore(SETTINGS_STORE, false);
            if (url != null) {
                dos.writeUTF(url);
                data = bas.toByteArray();
                settings.setRecord(1, data, 0, data.length);
            }
            if (curMidlet != null) {
                bas.reset();
                dos.writeUTF(curMidlet);
                data = bas.toByteArray();
                settings.setRecord(2, data, 0, data.length);
            }
            settings.closeRecordStore();
            dos.close();
        }
        catch (Exception e) {
            ret = e;
        }
        return ret;
    }

    private void saveURLSetting() {
        String temp = this.urlTextBox.getString();
        Exception ex = GraphicalInstaller.saveSettings(temp, null);
        if (ex != null) {
            this.displayException(Resource.getString("Exception"), ex.toString());
            return;
        }
        this.defaultInstallListUrl = temp;
        this.displaySuccessMessage(Resource.getString("Saved!"));
    }

    private void updateSuite(String storageName) {
        String name;
        MIDletSuite midletSuite = this.installer.getMIDletSuite(storageName);
        if (midletSuite.getNumberOfMIDlets() == 1) {
            MIDletInfo midletInfo = new MIDletInfo(midletSuite.getProperty("MIDlet-1"));
            name = midletInfo.name;
        } else {
            name = midletSuite.getProperty("MIDlet-Name");
        }
        this.cancelledMessage = Resource.getString("Update cancelled.");
        this.finishingMessage = Resource.getString("Finishing update.");
        this.installSuiteCommon("Updating", name, midletSuite.getDownloadUrl(), name + Resource.getString(" was successfully updated"), true);
    }

    private void discoverSuitesToInstall(String url) {
        new Thread(new BackgroundInstallListGetter(this, url)).start();
    }

    private void installSuite(int selectedSuite) {
        SuiteDownloadInfo suite = (SuiteDownloadInfo)this.installList.elementAt(selectedSuite);
        this.cancelledMessage = Resource.getString("Installation cancelled.");
        this.finishingMessage = Resource.getString("Finishing installation.");
        this.installSuiteCommon("Installing", suite.label, suite.url, suite.label + Resource.getString(" was successfully installed"), false);
    }

    private void installSuiteCommon(String action, String name, String url, String successMessage, boolean updateFlag) {
        try {
            this.currentSuiteName = name;
            this.createProgressForm(action, name, url, 0, "Connecting...");
            this.backgroundInstaller = new BackgroundInstaller(this, url, name, successMessage, updateFlag);
            new Thread(this.backgroundInstaller).start();
        }
        catch (Exception ex) {
            StringBuffer sb = new StringBuffer();
            sb.append(name);
            sb.append("\n");
            sb.append(Resource.getString("Error"));
            sb.append(": ");
            sb.append(ex.toString());
            this.displayException(Resource.getString("Cannot access: "), sb.toString());
        }
    }

    private void createProgressForm(String action, String name, String url, int size, String gaugeLabel) {
        Form installForm = this.displayProgressForm(action, name, url, size, gaugeLabel);
        installForm.addCommand(this.stopCmd);
        installForm.setCommandListener(this);
    }

    private Form displayProgressForm(String action, String name, String url, int size, String gaugeLabel) {
        this.progressForm = new Form(null);
        this.progressForm.setTitle(Resource.getString(action) + " " + name);
        Gauge progressGauge = size <= 0 ? new Gauge(Resource.getString(gaugeLabel), false, -1, 2) : new Gauge(Resource.getString(gaugeLabel), false, size, 0);
        this.progressGaugeIndex = this.progressForm.append(progressGauge);
        StringItem urlItem = url == null ? new StringItem("", "") : new StringItem(Resource.getString("Website") + ": ", url);
        this.progressUrlIndex = this.progressForm.append(urlItem);
        this.display.setCurrent(this.progressForm);
        this.lastDisplayChange = System.currentTimeMillis();
        return this.progressForm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelBackgroundInstall() {
        if (this.backgroundInstaller != null) {
            this.backgroundInstaller.continueInstall = false;
            BackgroundInstaller backgroundInstaller = this.backgroundInstaller;
            synchronized (backgroundInstaller) {
                this.backgroundInstaller.notify();
            }
        }
    }

    private void getUrl() {
        try {
            if (this.urlTextBox == null) {
                this.urlTextBox = new TextBox(Resource.getString("Enter a website to Install From:"), this.defaultInstallListUrl, 1024, 0);
                this.urlTextBox.addCommand(this.endCmd);
                this.urlTextBox.addCommand(this.saveCmd);
                this.urlTextBox.addCommand(this.discoverCmd);
                this.urlTextBox.setCommandListener(this);
            }
            this.display.setCurrent(this.urlTextBox);
        }
        catch (Exception ex) {
            this.displayException(Resource.getString("Exception"), ex.toString());
        }
    }

    private void updateStatus(int status, InstallState state) {
        if (status == 1) {
            this.updateProgressForm("", 0, "Downloading the application description file...");
            return;
        }
        if (status == 3) {
            this.updateProgressForm(state.getJarUrl(), state.getJarSize(), "Downloading the application file...");
            return;
        }
        if (status == 4 && state.getJarSize() > 0) {
            Gauge progressGauge = (Gauge)this.progressForm.get(this.progressGaugeIndex);
            progressGauge.setValue(progressGauge.getValue() + 1);
            return;
        }
        if (status == 5) {
            this.updateProgressForm(null, 0, "Verifying the application...");
            return;
        }
        if (status == 6) {
            this.displaySuccessMessage(this.finishingMessage);
            return;
        }
    }

    private void updateProgressForm(String url, int size, String gaugeLabel) {
        while (System.currentTimeMillis() - this.lastDisplayChange < 1250L) {
        }
        Gauge progressGauge = size <= 0 ? new Gauge(Resource.getString(gaugeLabel), false, -1, 2) : new Gauge(Resource.getString(gaugeLabel), false, size, 0);
        Gauge oldProgressGauge = (Gauge)this.progressForm.get(this.progressGaugeIndex);
        this.progressForm.set(this.progressGaugeIndex, progressGauge);
        oldProgressGauge.setValue(0);
        if (url == null) {
            StringItem urlItem = new StringItem("", "");
            this.progressForm.set(this.progressUrlIndex, urlItem);
        } else if (url.length() != 0) {
            StringItem urlItem = new StringItem(Resource.getString("Website") + ": ", url);
            this.progressForm.set(this.progressUrlIndex, urlItem);
        }
        this.lastDisplayChange = System.currentTimeMillis();
    }

    private void warnUser(String name, String vendor, String version, String jadUrl, InvalidJadException e) {
        Form warningForm = new Form(null);
        warningForm.setTitle(Resource.getString("Warning"));
        warningForm.append(GraphicalInstaller.translateJadException(e, name, vendor, version, jadUrl));
        warningForm.addCommand(this.cancelCmd);
        warningForm.addCommand(this.okCmd);
        warningForm.setCommandListener(this);
        this.display.setCurrent(warningForm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeInstallAfterWarning() {
        this.display.setCurrent(this.progressForm);
        this.backgroundInstaller.continueInstall = true;
        BackgroundInstaller backgroundInstaller = this.backgroundInstaller;
        synchronized (backgroundInstaller) {
            this.backgroundInstaller.notify();
        }
    }

    private void getUsernameAndPassword() {
        this.getUsernameAndPasswordCommon("");
    }

    private void getProxyUsernameAndPassword() {
        this.getUsernameAndPasswordCommon("Firewall Authentication");
    }

    private void getUsernameAndPasswordCommon(String title) {
        if (this.passwordForm == null) {
            this.passwordForm = new Form(null);
            this.usernameField = new TextField(Resource.getString("Please Enter ID"), null, 40, 0);
            this.passwordForm.append(this.usernameField);
            this.passwordField = new TextField(Resource.getString("Password"), null, 40, 65536);
            this.passwordForm.append(this.passwordField);
            this.passwordForm.addCommand(this.cancelCmd);
            this.passwordForm.addCommand(this.nextCmd);
            this.passwordForm.setCommandListener(this);
        }
        this.passwordForm.setTitle(Resource.getString(title));
        this.passwordField.setString("");
        this.display.setCurrent(this.passwordForm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeInstallWithPassword() {
        String username = this.usernameField.getString();
        String password = this.passwordField.getString();
        if (username == null || username.length() == 0) {
            Alert a = new Alert(Resource.getString("Error"), Resource.getString("The ID has not been entered."), null, AlertType.ERROR);
            a.setTimeout(1250);
            this.display.setCurrent(a, this.passwordForm);
            return;
        }
        if (password == null || password.length() == 0) {
            Alert a = new Alert(Resource.getString("Error"), Resource.getString("The password has not been entered."), null, AlertType.ERROR);
            a.setTimeout(1250);
            this.display.setCurrent(a, this.passwordForm);
            return;
        }
        this.display.setCurrent(this.progressForm);
        if (this.backgroundInstaller.proxyAuth) {
            this.backgroundInstaller.installState.setProxyUsername(username);
            this.backgroundInstaller.installState.setProxyPassword(password);
        } else {
            this.backgroundInstaller.installState.setUsername(username);
            this.backgroundInstaller.installState.setPassword(password);
        }
        this.backgroundInstaller.continueInstall = true;
        BackgroundInstaller backgroundInstaller = this.backgroundInstaller;
        synchronized (backgroundInstaller) {
            this.backgroundInstaller.notify();
        }
    }

    private void displayDownloadConfirmation(InstallState state) {
        StringBuffer label = new StringBuffer(40);
        StringBuffer value = new StringBuffer(40);
        String[] values = new String[1];
        String name = state.getAppProperty("MIDlet-Name");
        try {
            Form infoForm = new Form(null);
            infoForm.setTitle(Resource.getString("Confirmation"));
            values[0] = name;
            StringItem item = new StringItem(null, Resource.getString("Are you sure you want to install \"%1\"?", values));
            item.setLayout(16896);
            infoForm.append(item);
            label.append(Resource.getString("Size"));
            label.append(": ");
            value.setLength(0);
            value.append(state.getJarSize());
            value.append(" K");
            item = new StringItem(label.toString(), value.toString());
            item.setLayout(16896);
            infoForm.append(item);
            label.setLength(0);
            label.append(Resource.getString("Version"));
            label.append(": ");
            value.setLength(0);
            item = new StringItem(label.toString(), state.getAppProperty("MIDlet-Version"));
            item.setLayout(16896);
            infoForm.append(item);
            label.setLength(0);
            label.append(Resource.getString("Vendor"));
            label.append(": ");
            item = new StringItem(label.toString(), state.getAppProperty("MIDlet-Vendor"));
            item.setLayout(16896);
            infoForm.append(item);
            String desc = state.getAppProperty("MIDlet-Description");
            if (desc != null) {
                label.setLength(0);
                label.append(Resource.getString("Description"));
                label.append(": ");
                item = new StringItem(label.toString(), desc);
                item.setLayout(16896);
                infoForm.append(item);
            }
            label.setLength(0);
            label.append(Resource.getString("Website"));
            label.append(": ");
            infoForm.append(new StringItem(label.toString(), state.getJarUrl()));
            String sig = state.getAppProperty(SIG_PROP);
            if (sig == null) {
                state.setTrusted(false);
                this.isTrusted = false;
                label.setLength(0);
                label.append(Resource.getString("Advanced"));
                label.append(": ");
                infoForm.append(new StringItem(label.toString(), "Unidentified Third Party"));
            } else {
                this.isTrusted = true;
            }
            String ca = this.installer.getCAFromJad();
            if (ca != null) {
                infoForm.append(new StringItem(Resource.getString("Certificate Authority:"), ""));
                int delimiter = 59;
                String[] shortcuts = new String[]{"O=", "OU=", "ST=", "C=", "L=", "CN="};
                String[] fields = new String[]{Resource.getString("Organization"), Resource.getString("Organization Unit"), Resource.getString("State (Province)"), Resource.getString("Country Code"), Resource.getString("Locality (City)"), Resource.getString("Computer Name")};
                int pos = 0;
                int nLabels = 0;
                for (int i = 0; i < fields.length; ++i) {
                    pos = ca.indexOf(shortcuts[i]);
                    if (pos == -1) continue;
                    int posEnd = ca.indexOf(59, pos += shortcuts[i].length());
                    if (posEnd == -1) {
                        posEnd = ca.length();
                    }
                    label.setLength(0);
                    label.append(fields[i]);
                    label.append(": ");
                    infoForm.append(new StringItem(label.toString(), ca.substring(pos, posEnd)));
                    ++nLabels;
                }
                if (nLabels == 0) {
                    infoForm.append(new StringItem("", Resource.getString("None")));
                }
            }
            infoForm.addCommand(this.continueCmd);
            infoForm.addCommand(this.cancelCmd);
            infoForm.setCommandListener(this);
            while (System.currentTimeMillis() - this.lastDisplayChange < 1250L) {
            }
            this.display.setCurrent(infoForm);
        }
        catch (Exception ex) {
            StringBuffer sb = new StringBuffer();
            sb.append(name);
            sb.append("\n");
            sb.append(Resource.getString("Exception"));
            sb.append(": ");
            sb.append(ex.toString());
            this.displayException(Resource.getString("Cannot access: "), sb.toString());
        }
    }

    private void displaySecurityConfirmation() {
        Alert alert = new Alert(Resource.getString("Security Confirmation"));
        String iconFilename = File.getConfigRoot() + "security_query.png";
        RandomAccessStream stream = securityToken != null ? new RandomAccessStream(securityToken) : new RandomAccessStream();
        try {
            stream.connect(iconFilename, 1);
            byte[] rawPng = new byte[stream.getSizeOf()];
            stream.readBytes(rawPng, 0, rawPng.length);
            stream.disconnect();
            Image icon = Image.createImage(rawPng, 0, rawPng.length);
            alert.setImage(icon);
        }
        catch (IOException noImage) {
            // empty catch block
        }
        alert.setString(Resource.getString("Application to be installed is not signed.  Are you sure you want to continue with the installation?"));
        alert.setType(AlertType.CONFIRMATION);
        alert.addCommand(this.confirmCmd);
        alert.addCommand(this.cancelCmd);
        alert.setCommandListener(this);
        this.display.setCurrent(alert);
    }

    private void displayKeepRMSForm(InstallState state) {
        StringBuffer label = new StringBuffer(40);
        StringBuffer value = new StringBuffer(40);
        String[] values = new String[1];
        String name = state.getAppProperty("MIDlet-Name");
        try {
            Form infoForm = new Form(null);
            infoForm.setTitle(Resource.getString("Confirmation"));
            values[0] = name;
            value.append(Resource.getString("Do you want the new version of %1 to be able to use the information stored by the old version of %1?", values));
            infoForm.append(value.toString());
            infoForm.addCommand(this.keepRMSCmd);
            infoForm.addCommand(this.removeRMSCmd);
            infoForm.setCommandListener(this);
            while (System.currentTimeMillis() - this.lastDisplayChange < 1250L) {
            }
            this.display.setCurrent(infoForm);
        }
        catch (Exception ex) {
            StringBuffer sb = new StringBuffer();
            sb.append(name);
            sb.append("\n");
            sb.append(Resource.getString("Exception"));
            sb.append(": ");
            sb.append(ex.toString());
            this.displayException(Resource.getString("Cannot access: "), sb.toString());
        }
    }

    private void displayKeepPrivateForm(InstallState state) {
        Image icon;
        String suiteName = state.getAppProperty("MIDlet-Name");
        String iconFilename = File.getConfigRoot() + "security_query.png";
        RandomAccessStream stream = securityToken != null ? new RandomAccessStream(securityToken) : new RandomAccessStream();
        try {
            stream.connect(iconFilename, 1);
            byte[] rawPng = new byte[stream.getSizeOf()];
            stream.readBytes(rawPng, 0, rawPng.length);
            stream.disconnect();
            icon = Image.createImage(rawPng, 0, rawPng.length);
        }
        catch (IOException noImage) {
            icon = null;
        }
        try {
            Alert alert = new Alert("Confirmation");
            String[] values = new String[]{suiteName};
            alert.setType(AlertType.CONFIRMATION);
            alert.setString(Resource.getString("Do you want the new version of %1 to retain data in the private directory stored by the previous version of %1?", values));
            alert.addCommand(this.keepPrivateCmd);
            alert.addCommand(this.removePrivateCmd);
            alert.setImage(icon);
            alert.setCommandListener(this);
            while (System.currentTimeMillis() - this.lastDisplayChange < 1250L) {
            }
            this.display.setCurrent(alert);
        }
        catch (Exception ex) {
            StringBuffer sb = new StringBuffer();
            sb.append(suiteName);
            sb.append("\n");
            sb.append(Resource.getString("Exception"));
            sb.append(": ");
            sb.append(ex.toString());
            this.displayException(Resource.getString("Cannot access: "), sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setKeepPrivateAnswer(boolean keepPrivate) {
        this.display.setCurrent(this.progressForm);
        while (System.currentTimeMillis() - this.lastDisplayChange < 1250L) {
        }
        this.backgroundInstaller.continueInstall = keepPrivate;
        BackgroundInstaller backgroundInstaller = this.backgroundInstaller;
        synchronized (backgroundInstaller) {
            this.backgroundInstaller.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startJarDownload() {
        this.updateProgressForm(this.backgroundInstaller.url, 0, "Connecting...");
        this.display.setCurrent(this.progressForm);
        this.backgroundInstaller.continueInstall = true;
        BackgroundInstaller backgroundInstaller = this.backgroundInstaller;
        synchronized (backgroundInstaller) {
            this.backgroundInstaller.notify();
        }
    }

    private void displayJarOnlyDownloadConfirmation() {
        StringBuffer label = new StringBuffer(40);
        StringBuffer value = new StringBuffer(40);
        String[] values = new String[1];
        try {
            Form infoForm = new Form(null);
            infoForm.setTitle(Resource.getString("Confirmation"));
            values[0] = this.backgroundInstaller.name;
            StringItem item = new StringItem(null, Resource.getString("Are you sure you want to install \"%1\"?", values));
            item.setLayout(16896);
            infoForm.append(item);
            label.append(Resource.getString("Website"));
            label.append(": ");
            item = new StringItem(label.toString(), this.backgroundInstaller.url);
            item.setLayout(16896);
            infoForm.append(item);
            value.append(" \n");
            value.append(Resource.getString("There is no further information available for the application."));
            infoForm.append(new StringItem(null, value.toString()));
            infoForm.addCommand(this.continueCmd);
            infoForm.addCommand(this.cancelCmd);
            infoForm.setCommandListener(this);
            while (System.currentTimeMillis() - this.lastDisplayChange < 1250L) {
            }
            this.display.setCurrent(infoForm);
        }
        catch (Exception ex) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.backgroundInstaller.name);
            sb.append("\n");
            sb.append(Resource.getString("Exception"));
            sb.append(": ");
            sb.append(ex.toString());
            this.displayException(Resource.getString("Cannot access: "), sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setKeepRMSAnswer(boolean keepRMS) {
        this.display.setCurrent(this.progressForm);
        while (System.currentTimeMillis() - this.lastDisplayChange < 1250L) {
        }
        this.backgroundInstaller.continueInstall = keepRMS;
        BackgroundInstaller backgroundInstaller = this.backgroundInstaller;
        synchronized (backgroundInstaller) {
            this.backgroundInstaller.notify();
        }
    }

    private void displaySuccessMessage(String successMessage) {
        Image icon = GraphicalInstaller.getIconFromStorage(colorDisplay ? "_dukeok8.png" : "_dukeok2.png");
        Alert successAlert = new Alert(null, successMessage, icon, null);
        successAlert.setTimeout(1250);
        while (System.currentTimeMillis() - this.lastDisplayChange < 1250L) {
        }
        this.lastDisplayChange = System.currentTimeMillis();
        this.display.setCurrent(successAlert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean displayLaunchingConfirmation() {
        String[] values = new String[1];
        try {
            Form infoForm = new Form(null);
            infoForm.setTitle(Resource.getString("Launch Confirmation"));
            values[0] = this.currentSuiteName;
            StringItem item = new StringItem(null, Resource.getString("Do you want to launch \"%1\"?", values));
            item.setLayout(16896);
            infoForm.append(item);
            infoForm.addCommand(this.launchSuite);
            infoForm.addCommand(this.cancelSuite);
            infoForm.setCommandListener(this);
            while (System.currentTimeMillis() - this.lastDisplayChange < 1250L) {
            }
            this.display.setCurrent(infoForm);
            GraphicalInstaller graphicalInstaller = this;
            synchronized (graphicalInstaller) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            return this.cancelOrLaunchSuite;
        }
        catch (Exception ex) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.currentSuiteName);
            sb.append("\n");
            sb.append(Resource.getString("Exception"));
            sb.append(": ");
            sb.append(ex.toString());
            this.displayException(Resource.getString("Cannot access: "), sb.toString());
            return false;
        }
    }

    private void displayCancelledMessage(String message) {
        Form form = new Form(null);
        Image icon = GraphicalInstaller.getIconFromStorage(colorDisplay ? "_ack_8.png" : "_ack_2.png");
        form.append(new ImageItem(null, icon, 771, null));
        form.append(message);
        this.display.setCurrent(form);
        this.lastDisplayChange = System.currentTimeMillis();
    }

    private void displayException(String title, String message) {
        Alert a = new Alert(title, message, null, AlertType.ERROR);
        a.setTimeout(-2);
        a.setCommandListener(this);
        this.display.setCurrent(a);
    }

    public static boolean checkCertForInstalledApp(MIDletSuite mSuite) {
        WebPublicKeyStore.resetCertificateAuthorities();
        WebPublicKeyStore.loadCertificateAuthorities();
        int chain = 1;
        while (true) {
            int result;
            if ((result = GraphicalInstaller.checkCertChain(chain, mSuite)) == 1) {
                return true;
            }
            if (result == -1) break;
            ++chain;
        }
        return false;
    }

    private static int checkCertChain(int chainNum, MIDletSuite mSuite) {
        String base64Cert;
        Vector<X509Certificate> derCerts = new Vector<X509Certificate>();
        int certNum = 1;
        while ((base64Cert = mSuite.getProperty(CERT_PROP + chainNum + "-" + certNum)) != null) {
            try {
                byte[] derCert = Base64.decode(base64Cert);
                derCerts.addElement(X509Certificate.generateCertificate(derCert, 0, derCert.length));
            }
            catch (Exception e) {
                return 0;
            }
            ++certNum;
        }
        if (certNum == 1) {
            return -1;
        }
        try {
            String ca = X509Certificate.verifyChain(derCerts, 1, 8, WebPublicKeyStore.getTrustedKeyStore()).getIssuer();
            return 1;
        }
        catch (CertificateException ce) {
            return 0;
        }
    }

    static {
        storageName = null;
        errorMsgs = new String[]{"The server for the JAD was not found.", "The JAD was not found.", "", "The content provider certificate is missing.", "The content provider certificate cannot be decoded.", "The CA that issued the content provider certificate is unknown.", "The signature of the content provider certificate is invalid.", "The JAR signature cannot be decoded.", "The signature of the JAR is invalid.", "The content provider certificate is an unsupported version.", "The content provider certificate has expired.", "The CA's public key has expired.", "The name of MIDlet suite is missing.", "The vendor is missing.", "The version is missing.", "The format of the version is invalid.", "This suite is older that the one currently installed.", "The URL for the JAR is missing.", "The server for the JAR was not found at the URL given in the JAD.", "The JAR was not found at the URL given in the JAD.", "The JAR size is missing.", "", "", "", "The MIDlet suite name does not match the one in the JAR manifest.", "The version does not match the one in the JAR manifest.", "The vendor does not match the one in the JAR manifest.", "A key for an attribute is not formatted correctly.", "A value for an attribute is not formatted correctly.", "Not enough storage for this suite to be installed.", "The JAR downloaded was not size in the JAD.", "This suite is newer than the one currently installed.", "Webserver authentication required or failed.", "The JAD URL is for an installed suite but different than the original JAD URL.", "Server does not support basic authentication.", "An entry could not be read from the JAR.", "The server did not hava a resource with the correct type (code 406) or the JAD downloaded has the wrong media type.", "The server did not hava a resource with the correct type (code 406) or the JAR downloaded has the wrong media type.", "The JAD matches a version of a suite already installed.", "The device does not support either the configuration or profile in the JAD.", "The configuration is missing from the manifest.", "The profile is missing from the manifest.", "The JAD URL is invalid.", "The JAR URL is invalid.", "The connection in a push entry is already taken.", "The format of a push attribute has an invalid format.", "The connection in a push attribute is not supported.", "The class in a push attribute is not in MIDlet-<n> attribute.", "Application authorization failure.", "An attribute in both the JAD and JAR manifest of a signed MIDlet does not match.", "The user must first authenticate with the proxy.", "The user tried to overwrite a trusted suite with an untrusted suite during an update.", "", "The MicroEdition-Handler-<n> attribute has invalid values.  The classname may be missing or there are too many fields", "The installation of a content handler would conflict with an already installed handler.", "The payment information of the MIDlet suite is not supported.", "The payment information of the MIDlet suite is incorrect or incomplete.", "The MIDlet suite has payment related information but is not trusted.", "The permissions do not match the ones in the JAR manifest."};
    }

    private class BackgroundInstaller
    implements Runnable,
    InstallListener {
        private GraphicalInstaller parent;
        private String url;
        private String name;
        private String successMessage;
        private boolean update;
        InstallState installState;
        boolean continueInstall;
        boolean jarOnly;
        boolean proxyAuth;

        private BackgroundInstaller(GraphicalInstaller theParent, String theJadUrl, String theName, String theSuccessMessage, boolean updateFlag) {
            this.parent = theParent;
            this.url = theJadUrl;
            this.name = theName;
            this.successMessage = theSuccessMessage;
            this.update = updateFlag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String lastInstalledMIDletName = this.jarOnly ? this.parent.installer.installJar(this.url, false, false, this) : this.parent.installer.installJad(this.url, false, false, this);
                GraphicalInstaller.saveSettings(null, lastInstalledMIDletName);
                this.parent.displaySuccessMessage(this.successMessage);
                do {
                } while (System.currentTimeMillis() - this.parent.lastDisplayChange < 1250L);
                this.parent.exit(true, true);
                return;
            }
            catch (Throwable ex) {
                String msg;
                if (this.parent.installer != null && this.parent.installer.wasStopped()) {
                    this.displayListAfterCancelMessage();
                    return;
                }
                if (ex instanceof InvalidJadException) {
                    String mediaType;
                    InvalidJadException ije = (InvalidJadException)ex;
                    if (ije.getReason() == 37 && ("application/java".equals(mediaType = ije.getExtraData()) || "application/java-archive".equals(mediaType))) {
                        if (this.confirmJarOnlyDownload()) {
                            this.jarOnly = true;
                            this.installState = null;
                            this.run();
                            return;
                        }
                        this.displayListAfterCancelMessage();
                        return;
                    }
                    msg = GraphicalInstaller.translateJadException((InvalidJadException)ex, this.name, null, null, this.url);
                } else {
                    msg = ex instanceof IOException ? Resource.getString("The connection dropped and the installation did not complete. Please try installing again.") : ex.getMessage();
                }
                String title = Resource.getString("Install Error");
                if (this.parent.installListBox == null) {
                    GraphicalInstaller.this.displayException(title, msg);
                    return;
                }
                Alert a = new Alert(title, msg, null, AlertType.ERROR);
                a.setTimeout(-2);
                this.parent.display.setCurrent(a, this.parent.installListBox);
            }
            finally {
                if (this.parent.progressForm != null) {
                    Gauge progressGauge = (Gauge)this.parent.progressForm.get(this.parent.progressGaugeIndex);
                    progressGauge.setValue(0);
                }
            }
        }

        public boolean warnUser(InstallState state) {
            this.installState = state;
            InvalidJadException e = this.installState.getLastException();
            switch (e.getReason()) {
                case 33: {
                    this.proxyAuth = false;
                    this.parent.getUsernameAndPassword();
                    break;
                }
                case 51: {
                    this.proxyAuth = true;
                    this.parent.getProxyUsernameAndPassword();
                    break;
                }
                case 17: 
                case 32: 
                case 39: {
                    this.update = true;
                }
                default: {
                    this.parent.warnUser(this.name, state.getAppProperty("MIDlet-Vendor"), state.getAppProperty("MIDlet-Version"), this.url, e);
                }
            }
            return this.waitForUser();
        }

        public boolean confirmJarDownload(InstallState state) {
            if (this.update) {
                return true;
            }
            this.installState = state;
            this.url = state.getJarUrl();
            this.parent.displayDownloadConfirmation(state);
            return this.waitForUser();
        }

        public boolean keepRMS(InstallState state) {
            this.installState = state;
            this.parent.displayKeepRMSForm(state);
            return this.waitForUser();
        }

        public boolean keepPrivate(InstallState state) {
            this.installState = state;
            this.parent.displayKeepPrivateForm(state);
            return this.waitForUser();
        }

        private boolean confirmJarOnlyDownload() {
            if (this.update) {
                return true;
            }
            this.parent.displayJarOnlyDownloadConfirmation();
            return this.waitForUser();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean waitForUser() {
            BackgroundInstaller backgroundInstaller = this;
            synchronized (backgroundInstaller) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.installState = null;
            boolean temp = this.continueInstall;
            this.continueInstall = false;
            return temp;
        }

        public void updateStatus(int status, InstallState state) {
            this.parent.updateStatus(status, state);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void displayListAfterCancelMessage() {
            GraphicalInstaller graphicalInstaller = this.parent;
            synchronized (graphicalInstaller) {
                do {
                } while (System.currentTimeMillis() - this.parent.lastDisplayChange < 1250L);
                if (this.parent.installListBox == null) {
                    this.parent.exit(true, false);
                    return;
                }
                this.parent.display.setCurrent(this.parent.installListBox);
            }
        }
    }

    private class BackgroundInstallListGetter
    implements Runnable {
        private GraphicalInstaller parent;
        private String url;

        private BackgroundInstallListGetter(GraphicalInstaller theParent, String theUrl) {
            this.parent = theParent;
            this.url = theUrl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String errorMessage;
            StreamConnection conn = null;
            InputStreamReader in = null;
            long startTime = System.currentTimeMillis();
            try {
                block21: {
                    this.parent.displayProgressForm("Getting Install List", "", this.url, 0, "Connecting...");
                    conn = (StreamConnection)Connector.open((String)this.url, (int)1);
                    in = new InputStreamReader(conn.openInputStream());
                    this.parent.updateProgressForm("", 0, "Downloading...");
                    this.parent.installList = SuiteDownloadInfo.getDownloadInfoFromPage(in, this.url);
                    if (this.parent.installList.size() <= 0) break block21;
                    this.parent.installListBox = new List(Resource.getString("Select one to install:"), 3);
                    for (int i = 0; i < this.parent.installList.size(); ++i) {
                        SuiteDownloadInfo suite = (SuiteDownloadInfo)GraphicalInstaller.this.installList.elementAt(i);
                        this.parent.installListBox.append(suite.label, null);
                    }
                    this.parent.installListBox.addCommand(GraphicalInstaller.this.backCmd);
                    this.parent.installListBox.addCommand(GraphicalInstaller.this.installCmd);
                    this.parent.installListBox.setCommandListener(this.parent);
                    do {
                    } while (System.currentTimeMillis() - this.parent.lastDisplayChange < 1250L);
                    this.parent.display.setCurrent(this.parent.installListBox);
                    return;
                }
                try {
                    errorMessage = Resource.getString("No MIDlet Suites found. Check the URL to make sure it is correct.");
                }
                catch (IllegalArgumentException ex) {
                    errorMessage = Resource.getString("The URL is not formatted correctly.");
                }
                catch (Exception ex) {
                    errorMessage = ex.getMessage();
                }
            }
            catch (Exception ex) {
                errorMessage = Resource.getString("The connection failed. Please check the website URL and try again.");
            }
            finally {
                if (this.parent.progressForm != null) {
                    Gauge progressGauge = (Gauge)this.parent.progressForm.get(this.parent.progressGaugeIndex);
                    progressGauge.setValue(0);
                }
                try {
                    conn.close();
                    in.close();
                }
                catch (Exception e) {}
            }
            Alert a = new Alert(Resource.getString("Error"), errorMessage, null, AlertType.ERROR);
            a.setTimeout(-2);
            this.parent.display.setCurrent(a, this.parent.urlTextBox);
        }
    }
}

