/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.btgoep;

import com.sun.kvem.jsr082.obex.ObexTransport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.StreamConnection;

public class BTGOEPConnection
implements ObexTransport {
    private static final boolean DEBUG = false;
    private StreamConnection sock;
    private InputStream is;
    private OutputStream os;

    protected BTGOEPConnection(StreamConnection sock) throws IOException {
        this.sock = sock;
        this.is = sock.openInputStream();
        this.os = sock.openOutputStream();
    }

    public void close() throws IOException {
        IOException ioe = null;
        try {
            this.is.close();
        }
        catch (IOException e) {
            ioe = e;
        }
        try {
            this.os.close();
        }
        catch (IOException e) {
            ioe = e;
        }
        try {
            this.sock.close();
        }
        catch (IOException e) {
            ioe = e;
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    public int read(byte[] inData) throws IOException {
        this.readFully(inData, 0, 3);
        int packetLength = this.decodeLength16(inData, 1);
        if (packetLength < 3 || packetLength > inData.length) {
            throw new IOException("protocol error");
        }
        this.readFully(inData, 3, packetLength - 3);
        return packetLength;
    }

    public void write(byte[] outData, int len) throws IOException {
        this.os.write(outData, 0, len);
        this.os.flush();
    }

    public int getMaximumPacketSize() {
        return 4096;
    }

    private final void readFully(byte[] array, int offset, int size) throws IOException {
        while (size != 0) {
            int count = this.is.read(array, offset, size);
            if (count == -1) {
                throw new IOException("read error");
            }
            offset += count;
            size -= count;
        }
    }

    private final int decodeLength16(byte[] buffer, int off) {
        return ((buffer[off] & 0xFF) << 8) + (buffer[off + 1] & 0xFF);
    }

    public Connection getUnderlyingConnection() {
        return this.sock;
    }
}

