/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.btl2cap;

import com.sun.kvem.jsr082.impl.bluetooth.BTConnectionBase;
import com.sun.kvem.jsr082.impl.bluetooth.BTNotifierBase;
import com.sun.kvem.jsr082.impl.io.JSR082Connection;
import com.sun.midp.io.j2me.btl2cap.BTL2CAPNotifier;
import java.io.IOException;
import javax.bluetooth.BluetoothConnectionException;
import javax.bluetooth.L2CAPConnection;
import javax.bluetooth.LocalDevice;

public class BTL2CAPConnection
extends BTConnectionBase
implements L2CAPConnection {
    static final int MAX_RECEIVE_MTU;
    int receiveMTU;
    int transmitMTU;
    private static final boolean DEBUG = false;
    private static final String cn = "BTL2CAPConnection";
    private static final byte[] skipData;
    static /* synthetic */ Class class$com$sun$midp$io$j2me$btl2cap$BTL2CAPConnection;

    protected BTL2CAPConnection() {
    }

    public final int getReceiveMTU() throws IOException {
        if (this.isClosed) {
            throw new IOException("Connection is closed");
        }
        return this.receiveMTU;
    }

    public final int getTransmitMTU() throws IOException {
        if (this.isClosed) {
            throw new IOException("Connection is closed");
        }
        return this.transmitMTU;
    }

    public void send(byte[] data) throws IOException {
        if (this.isClosed) {
            throw new IOException("Connection is closed");
        }
        if (data == null) {
            throw new NullPointerException("null data.");
        }
        int len = data.length < this.transmitMTU ? data.length : this.transmitMTU;
        this.waitSecurityExchange();
        this.sendInt(len);
        this.conn.write(data, 0, len);
    }

    public int receive(byte[] inBuf) throws IOException {
        int size;
        if (this.isClosed) {
            throw new IOException("Connection is closed");
        }
        if (inBuf == null) {
            throw new NullPointerException("null inBuf.");
        }
        int dataLen = this.receiveInt();
        int len = inBuf.length < dataLen ? inBuf.length : dataLen;
        this.waitSecurityExchange();
        this.readFully(inBuf, len);
        for (int skip = inBuf.length < dataLen ? dataLen - inBuf.length : 0; skip != 0; skip -= size) {
            size = skip < skipData.length ? skip : skipData.length;
            this.readFully(skipData, size);
        }
        return len;
    }

    public boolean ready() throws IOException {
        if (this.isClosed) {
            throw new IOException("Connection is closed");
        }
        return this.conn.ready() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Class clazz = class$com$sun$midp$io$j2me$btl2cap$BTL2CAPConnection == null ? (class$com$sun$midp$io$j2me$btl2cap$BTL2CAPConnection = BTL2CAPConnection.class$("com.sun.midp.io.j2me.btl2cap.BTL2CAPConnection")) : class$com$sun$midp$io$j2me$btl2cap$BTL2CAPConnection;
        synchronized (clazz) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        this.finish();
    }

    protected void initClientConnection(JSR082Connection conn, int mode, boolean master, boolean authenticate, boolean encrypt) throws BluetoothConnectionException, IOException {
        String mn = "BTL2CAPConnection.completeClientConnection";
        this.conn = conn;
        this.negotiateReceiveMTU();
        this.negotiateTransmitMTU();
        super.initClientConnection(conn, mode, master, authenticate, encrypt);
    }

    protected void initServerConnection(JSR082Connection conn, BTNotifierBase parent, int mode, boolean master, boolean authorize, boolean authenticate, boolean encrypt) throws BluetoothConnectionException, IOException {
        this.conn = conn;
        BTL2CAPNotifier notifier = (BTL2CAPNotifier)parent;
        String mn = "BTL2CAPConnection.completeServerConnection";
        this.receiveMTU = notifier.receiveMTU;
        this.transmitMTU = notifier.transmitMTU;
        this.negotiateTransmitMTU();
        this.negotiateReceiveMTU();
        super.initServerConnection(conn, parent, mode, master, authorize, authenticate, encrypt);
    }

    protected void negotiateReceiveMTU() throws IOException {
        this.sendInt(this.receiveMTU);
        int receiveint = this.receiveInt();
        if (receiveint == 0) {
            throw new BluetoothConnectionException(6, "Can't negotiate receiveMTU: " + this.receiveMTU);
        }
    }

    protected void negotiateTransmitMTU() throws IOException {
        int receiveMTU_B = this.receiveInt();
        if (this.transmitMTU > receiveMTU_B) {
            this.transmitMTU = receiveMTU_B;
        }
        this.sendInt(1);
        if (this.transmitMTU == 0) {
            this.transmitMTU = Math.min(MAX_RECEIVE_MTU, receiveMTU_B);
        }
    }

    protected int clientConnectionGetTransportPort(String remoteAddress, int psmOrChannel) throws IOException {
        int psm = psmOrChannel;
        return this.control.getBTL2CAPNotifierPort(remoteAddress, psm);
    }

    private void sendInt(int i) throws IOException {
        byte[] lData = new byte[]{(byte)(i >>> 24), (byte)(i >>> 16 & 0xFF), (byte)(i >>> 8 & 0xFF), (byte)(i & 0xFF)};
        this.conn.write(lData);
    }

    private int receiveInt() throws IOException {
        byte[] lData = new byte[4];
        this.readFully(lData, lData.length);
        int i = (lData[0] & 0xFF) << 24;
        i |= (lData[1] & 0xFF) << 16;
        i |= (lData[2] & 0xFF) << 8;
        return i |= lData[3] & 0xFF;
    }

    private void readFully(byte[] array, int size) throws IOException {
        int offset = 0;
        while (size != 0) {
            int count = this.conn.read(array, offset, size);
            if (count == -1) {
                throw new IOException("Connection is closed");
            }
            offset += count;
            size -= count;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        int maxReceiveMTU;
        skipData = new byte[672];
        try {
            maxReceiveMTU = Integer.parseInt(LocalDevice.getProperty((String)"bluetooth.l2cap.receiveMTU.max"));
        }
        catch (NumberFormatException e) {
            System.err.println("Internal error: BTL2CAPBase: improper receiveMTU.max value");
            maxReceiveMTU = 672;
        }
        MAX_RECEIVE_MTU = maxReceiveMTU;
    }
}

