/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.btl2cap;

import com.sun.kvem.jsr082.bluetooth.SDDBImpl;
import com.sun.kvem.jsr082.bluetooth.ServiceRecordImpl;
import com.sun.kvem.jsr082.impl.BTPushFilter;
import com.sun.kvem.jsr082.impl.bluetooth.BTNotifierBase;
import com.sun.kvem.jsr082.impl.io.JSR082Connection;
import com.sun.kvem.jsr082.impl.io.JSR082Notifier;
import com.sun.midp.io.j2me.btl2cap.BTL2CAPConnection;
import java.io.IOException;
import javax.bluetooth.BluetoothConnectionException;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.L2CAPConnection;
import javax.bluetooth.L2CAPConnectionNotifier;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.ServiceRegistrationException;
import javax.bluetooth.UUID;

public class BTL2CAPNotifier
extends BTNotifierBase
implements L2CAPConnectionNotifier {
    int psm;
    int receiveMTU;
    int transmitMTU;
    private static final boolean DEBUG = false;
    private static final String cn = "BTL2CAPNotifier";
    static /* synthetic */ Class class$com$sun$midp$io$j2me$btl2cap$BTL2CAPNotifier;

    protected BTL2CAPNotifier(boolean isSystemUse) {
        this.isSystemUse = isSystemUse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2CAPConnection acceptAndOpen() throws IOException {
        BTL2CAPConnection conn;
        if (this.isClosed) {
            throw new IOException("Notifier is closed");
        }
        if (!this.control.isDeviceConnectable()) {
            throw new BluetoothStateException("Device is not connectable");
        }
        if (!this.isSystemUse) {
            Object object = this.serRecLock;
            synchronized (object) {
                try {
                    SDDBImpl sddb;
                    if (this.serRec.getHandle() == -1) {
                        sddb = SDDBImpl.getSDDBInstance();
                        this.serRec.setHandle(sddb.getFreeID());
                        this.updateServiceRecord();
                    }
                    if (this.serRec.isPush()) {
                        this.serRec.setNotifier(this);
                        sddb = SDDBImpl.getSDDBInstance();
                        sddb.updateServiceRecord(this.serRec);
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new ServiceRegistrationException(e.getMessage());
                }
            }
        }
        while (true) {
            JSR082Connection transport = null;
            transport = this.notif.acceptAndOpen();
            if (this.isPush) {
                this.negotiatePush(transport);
                return null;
            }
            conn = this.createBTL2CAPConnection();
            try {
                conn.initServerConnection(transport, this, this.mode, this.master, this.authorize, this.authenticate, this.encrypt);
            }
            catch (IOException e) {
                try {
                    transport.close();
                }
                catch (IOException ioe) {}
                continue;
            }
            break;
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Class clazz = class$com$sun$midp$io$j2me$btl2cap$BTL2CAPNotifier == null ? (class$com$sun$midp$io$j2me$btl2cap$BTL2CAPNotifier = BTL2CAPNotifier.class$("com.sun.midp.io.j2me.btl2cap.BTL2CAPNotifier")) : class$com$sun$midp$io$j2me$btl2cap$BTL2CAPNotifier;
        synchronized (clazz) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        this.control.unregisterBTL2CAPNotifier(this.notif.getServerPort());
        if (!this.isSystemUse) {
            SDDBImpl sddb = SDDBImpl.getSDDBInstance();
            sddb.removeServiceRecord(this.serRec);
            this.serRec.removeHandle();
        }
        this.notif.close();
    }

    protected BTL2CAPConnection createBTL2CAPConnection() {
        return new BTL2CAPConnection();
    }

    protected void initServerNotifier(JSR082Notifier notif, int mode, String name, boolean master, boolean authorize, boolean authenticate, boolean encrypt) throws IOException, BluetoothConnectionException {
        this.initServerNotifier(notif, mode, name, master, authorize, authenticate, encrypt, false, null);
    }

    protected void initServerNotifier(JSR082Notifier notif, int mode, String name, boolean master, boolean authorize, boolean authenticate, boolean encrypt, boolean isPush, BTPushFilter pushFilter) throws IOException, BluetoothConnectionException {
        DataElement[] attrVals;
        int[] attrIDs;
        this.notif = notif;
        this.mode = mode;
        this.master = master;
        this.authorize = authorize;
        this.authenticate = authenticate;
        this.encrypt = encrypt;
        this.isPush = isPush;
        this.pushFilter = pushFilter;
        this.control.registerBTL2CAPNotifier(this.psm, notif.getServerPort(), isPush);
        if (this.isSystemUse) {
            return;
        }
        DataElement serviceList = new DataElement(48);
        DataElement uuidDE = new DataElement(24, (Object)this.serverUUID);
        serviceList.addElement(uuidDE);
        DataElement protocolList = new DataElement(48);
        DataElement p1 = new DataElement(48);
        p1.addElement(DE_L2CAP_UUID);
        p1.addElement(new DataElement(9, (long)this.psm));
        protocolList.addElement(p1);
        if (name == null) {
            attrIDs = new int[]{1, 4};
            attrVals = new DataElement[]{serviceList, protocolList};
        } else {
            DataElement nameDE = new DataElement(32, (Object)name);
            attrIDs = new int[]{1, 4, 256};
            attrVals = new DataElement[]{serviceList, protocolList, nameDE};
        }
        this.serRec = new ServiceRecordImpl(this, attrIDs, attrVals, isPush);
        SDDBImpl sddb = SDDBImpl.getSDDBInstance();
        ServiceRecordImpl tmp = sddb.getServiceRecord(this.serRec);
        if (tmp != null) {
            if (!tmp.hasNotifier()) {
                this.serRec = tmp;
            } else if (((BTL2CAPNotifier)tmp.getNotifier()).isPush) {
                this.serRec = tmp;
                tmp.setNotifier(this);
            }
        }
        this.protocolListMC = this.serRec.getAttributeValue(4);
        this.store();
    }

    public ServiceRecord getServiceRecord() {
        if (this.isClosed) {
            throw new IllegalArgumentException("notifier is closed");
        }
        return this.serRec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServiceRecord() {
        if (this.isSystemUse) {
            return;
        }
        Object object = this.serRecLock;
        synchronized (object) {
            if (this.serRec.getHandle() == -1) {
                return;
            }
            ServiceRecordImpl rec = BTL2CAPNotifier.copyRecord(this, this.serRec);
            BTL2CAPNotifier.checkRecord(rec, this.protocolListMC);
            SDDBImpl sddb = SDDBImpl.getSDDBInstance();
            sddb.updateServiceRecord(rec);
            this.store();
            this.netmonUpdate(rec);
        }
    }

    protected void netmonUpdate(ServiceRecord rec) {
    }

    UUID getServerUUID() {
        return this.serverUUID;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

