/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.btl2cap;

import com.sun.cldc.io.ConnectionBaseInterface;
import com.sun.kvem.jsr082.impl.bluetooth.BTConnectionBase;
import com.sun.kvem.jsr082.impl.bluetooth.BTNotifierBase;
import com.sun.kvem.jsr082.impl.bluetooth.BluetoothProtocolBase;
import com.sun.midp.io.j2me.btl2cap.BTL2CAPConnection;
import com.sun.midp.io.j2me.btl2cap.BTL2CAPNotifier;
import java.io.IOException;
import java.util.Hashtable;
import javax.bluetooth.BluetoothConnectionException;
import javax.bluetooth.UUID;
import javax.microedition.io.Connection;

public class Protocol
extends BluetoothProtocolBase
implements ConnectionBaseInterface {
    private static final boolean DEBUG = false;
    private static final String cn = "btl2cap.Protocol";
    private static int free_psm = 4097;
    private static final UUID UUID_SDP = new UUID(1L);
    private static Hashtable uuid_psm = new Hashtable();

    public Protocol() {
        super("btl2cap:");
    }

    protected BTConnectionBase createConnection() throws IOException {
        return new BTL2CAPConnection();
    }

    protected BTNotifierBase createNotifier() throws IOException {
        return new BTL2CAPNotifier(this.isSystemUse);
    }

    protected void setUUID(BTNotifierBase inHandler) {
        super.setUUID(inHandler);
        BTL2CAPNotifier handler = (BTL2CAPNotifier)inHandler;
        handler.psm = this.isSystemUse && handler.getServerUUID().equals((Object)UUID_SDP) ? 1 : Protocol.getNextPSM(handler.getServerUUID());
    }

    protected void getParameters(Hashtable params, Connection handler, boolean isServer) throws BluetoothConnectionException {
        super.getParameters(params, handler, isServer);
        int receiveMTU = 0;
        int transmitMTU = 0;
        if (params != null) {
            receiveMTU = this.extractPositiveInt("receivemtu", params);
            transmitMTU = this.extractPositiveInt("transmitmtu", params);
        }
        if (receiveMTU == 0) {
            receiveMTU = Math.min(672, BTL2CAPConnection.MAX_RECEIVE_MTU);
        } else if (receiveMTU < 48 || receiveMTU > BTL2CAPConnection.MAX_RECEIVE_MTU) {
            throw new IllegalArgumentException("receiveMTU is out of range");
        }
        if (transmitMTU != 0 && transmitMTU > BTL2CAPConnection.MAX_RECEIVE_MTU) {
            throw new IllegalArgumentException("transmitMTU is out of range");
        }
        if (isServer) {
            BTL2CAPNotifier n = (BTL2CAPNotifier)handler;
            n.receiveMTU = receiveMTU;
            n.transmitMTU = transmitMTU;
        } else {
            BTL2CAPConnection c = (BTL2CAPConnection)handler;
            c.receiveMTU = receiveMTU;
            c.transmitMTU = transmitMTU;
        }
    }

    protected int getChannelOrPSM() {
        int psm = 0;
        if (this.numberStr.length() != 4 || this.numberStr.indexOf(45) != -1) {
            throw new IllegalArgumentException(this.errorMsg);
        }
        try {
            psm = Integer.parseInt(this.numberStr, 16);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(this.errorMsg);
        }
        if ((psm & 1) == 0 || (psm & 0x100) != 0) {
            throw new IllegalArgumentException(this.errorMsg);
        }
        if (psm < 4097 && !this.isSystemUse) {
            throw new IllegalArgumentException(this.errorMsg);
        }
        return psm;
    }

    private int extractPositiveInt(String key, Hashtable params) {
        String val = (String)params.remove(key);
        if (val == null) {
            return 0;
        }
        if (val.startsWith("-")) {
            throw new IllegalArgumentException(this.errorMsg);
        }
        try {
            int i = Integer.parseInt(val);
            if (i == 0) {
                throw new IllegalArgumentException(this.errorMsg);
            }
            return i;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(this.errorMsg);
        }
    }

    private static synchronized int getNextPSM(UUID uuid) {
        if (uuid_psm.get(uuid) != null) {
            int res = (Integer)uuid_psm.get(uuid);
            return res;
        }
        int res = free_psm;
        uuid_psm.put(uuid, new Integer(res));
        free_psm += 2;
        free_psm = (free_psm + 256 >>> 9 << 9) + (free_psm & 0xFF);
        return res;
    }
}

