/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.btspp;

import com.sun.kvem.jsr082.bluetooth.SDDBImpl;
import com.sun.kvem.jsr082.bluetooth.ServiceRecordImpl;
import com.sun.kvem.jsr082.impl.BTPushFilter;
import com.sun.kvem.jsr082.impl.bluetooth.BTNetmonNotifier;
import com.sun.kvem.jsr082.impl.bluetooth.BTNotifierBase;
import com.sun.kvem.jsr082.impl.io.JSR082Connection;
import com.sun.kvem.jsr082.impl.io.JSR082Notifier;
import com.sun.midp.io.j2me.btspp.BTSPPConnection;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.bluetooth.BluetoothConnectionException;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.ServiceRegistrationException;
import javax.bluetooth.UUID;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;

public class BTSPPNotifier
extends BTNotifierBase
implements StreamConnectionNotifier,
BTNetmonNotifier {
    private static final boolean DEBUG = false;
    private static final String cn = "BTSPPNotifier";
    private Integer cid;
    public BTNetmonNotifier btNetmonNotifier = this;

    protected BTSPPNotifier(boolean isSystemUse) {
        this.isSystemUse = isSystemUse;
    }

    protected void initServerNotifier(JSR082Notifier notif, int mode, String name, boolean master, boolean authorize, boolean authenticate, boolean encrypt) throws IOException, BluetoothConnectionException {
        this.initServerNotifier(notif, mode, name, master, authorize, authenticate, encrypt, false, null);
    }

    protected void initServerNotifier(JSR082Notifier notif, int mode, String name, boolean master, boolean authorize, boolean authenticate, boolean encrypt, boolean isPush, BTPushFilter pushFilter) throws IOException, BluetoothConnectionException {
        DataElement[] attrVals;
        int[] attrIDs;
        this.notif = notif;
        this.mode = mode;
        this.master = master;
        this.authorize = authorize;
        this.authenticate = authenticate;
        this.encrypt = encrypt;
        this.isPush = isPush;
        this.pushFilter = pushFilter;
        this.cid = IDAllocator.getID(this.serverUUID);
        this.control.registerBTSPPNotifier(this.cid, notif.getServerPort(), isPush);
        DataElement serviceList = new DataElement(48);
        serviceList.addElement(new DataElement(24, (Object)this.serverUUID));
        serviceList.addElement(DE_SERIAL_PORT_UUID);
        DataElement protocolList = new DataElement(48);
        DataElement protocol = new DataElement(48);
        protocol.addElement(DE_L2CAP_UUID);
        protocolList.addElement(protocol);
        protocol = new DataElement(48);
        protocol.addElement(DE_RFCOMM_UUID);
        protocol.addElement(new DataElement(8, (long)this.cid.intValue()));
        protocolList.addElement(protocol);
        if (this.isSystemUse) {
            protocol = new DataElement(48);
            protocol.addElement(DE_OBEX_UUID);
            protocolList.addElement(protocol);
        }
        if (name == null) {
            attrIDs = new int[]{1, 4};
            attrVals = new DataElement[]{serviceList, protocolList};
        } else {
            DataElement nameDE = new DataElement(32, (Object)name);
            attrIDs = new int[]{1, 4, 256};
            attrVals = new DataElement[]{serviceList, protocolList, nameDE};
        }
        this.serRec = new ServiceRecordImpl(this, attrIDs, attrVals, isPush);
        SDDBImpl sddb = SDDBImpl.getSDDBInstance();
        ServiceRecordImpl tmp = sddb.getServiceRecord(this.serRec);
        if (tmp != null) {
            if (!tmp.hasNotifier()) {
                this.serRec = tmp;
            } else if (((BTSPPNotifier)tmp.getNotifier()).isPush) {
                this.serRec = tmp;
                tmp.setNotifier(this);
            }
        }
        this.protocolListMC = this.serRec.getAttributeValue(4);
        this.store();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamConnection acceptAndOpen() throws IOException {
        BTSPPConnection conn;
        if (this.isClosed) {
            throw new IOException("Notifier is closed");
        }
        if (!this.control.isDeviceConnectable()) {
            throw new BluetoothStateException("Device is not connectable");
        }
        Object object = this.serRecLock;
        synchronized (object) {
            try {
                SDDBImpl sddb;
                if (this.serRec.getHandle() == -1) {
                    sddb = SDDBImpl.getSDDBInstance();
                    this.serRec.setHandle(sddb.getFreeID());
                    this.updateServiceRecord();
                }
                if (this.serRec.isPush()) {
                    this.serRec.setNotifier(this);
                    sddb = SDDBImpl.getSDDBInstance();
                    sddb.updateServiceRecord(this.serRec);
                }
            }
            catch (IllegalArgumentException e) {
                throw new ServiceRegistrationException(e.getMessage());
            }
        }
        while (true) {
            JSR082Connection transport = null;
            transport = this.notif.acceptAndOpen();
            if (this.isPush) {
                this.negotiatePush(transport);
                return null;
            }
            conn = this.createBTSPPConnection();
            try {
                conn.initServerConnection(transport, this, this.mode, this.master, this.authorize, this.authenticate, this.encrypt);
            }
            catch (IOException e) {
                try {
                    transport.close();
                }
                catch (IOException ioe) {}
                continue;
            }
            break;
        }
        return conn;
    }

    protected BTSPPConnection createBTSPPConnection() throws IOException {
        return new BTSPPConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        JSR082Notifier jSR082Notifier = this.notif;
        synchronized (jSR082Notifier) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        IDAllocator.freeID(this.cid, this.serverUUID);
        this.control.unregisterBTSPPNotifier(this.notif.getServerPort());
        SDDBImpl sddb = SDDBImpl.getSDDBInstance();
        sddb.removeServiceRecord(this.serRec);
        this.serRec.removeHandle();
        this.notif.close();
    }

    public ServiceRecord getServiceRecord() {
        if (this.isClosed) {
            throw new IllegalArgumentException("notifier is closed");
        }
        return this.serRec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServiceRecord() {
        Object object = this.serRecLock;
        synchronized (object) {
            if (this.serRec.getHandle() == -1) {
                return;
            }
            ServiceRecordImpl rec = BTSPPNotifier.copyRecord(this, this.serRec);
            BTSPPNotifier.checkRecord(rec, this.protocolListMC);
            SDDBImpl sddb = SDDBImpl.getSDDBInstance();
            sddb.updateServiceRecord(rec);
            this.store();
            this.btNetmonNotifier.netmonUpdate(rec);
        }
    }

    public void netmonUpdate(ServiceRecord rec) {
    }

    private static class IDAllocator {
        private static Vector ids;
        private static int busyCount;
        private static Hashtable uuid_cid;

        private IDAllocator() {
        }

        static synchronized Integer getID(UUID uuid) throws IOException {
            Integer res = (Integer)uuid_cid.get(uuid);
            if (res != null) {
                return res;
            }
            if (busyCount == ids.size()) {
                throw new IOException("no free channels left");
            }
            res = (Integer)ids.elementAt(busyCount++);
            uuid_cid.put(uuid, res);
            return res;
        }

        static synchronized void freeID(Integer id, UUID uuid) {
            uuid_cid.remove(uuid);
            ids.removeElement(id);
            ids.addElement(id);
            --busyCount;
        }

        static {
            uuid_cid = new Hashtable();
            ids = new Vector(30);
            for (int i = 1; i <= 30; ++i) {
                ids.addElement(new Integer(i));
            }
        }
    }
}

