/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.file;

import com.sun.kvem.midp.pim.formats.FormatSupport;
import com.sun.midp.io.j2me.file.BaseFileHandler;
import com.sun.midp.io.j2me.storage.File;
import java.io.IOException;
import java.util.Vector;

public class DefaultFileHandler
implements BaseFileHandler {
    public static final String FILESYSTEM_ROOT = "filesystem";
    public static final int _S_IFMT = 61440;
    public static final int _S_IFDIR = 16384;
    public static final int _S_IFCHR = 8192;
    public static final int _S_IFIFO = 4096;
    public static final int _S_IFREG = 32768;
    public static final int _S_IREAD = 256;
    public static final int _S_IWRITE = 128;
    public static final int _S_IEXEC = 64;
    private int readHandle = -1;
    private int writeHandle = -1;
    private long fileName;
    private long rootDir;
    private long savedDirectory;
    private static final int FS_AVAILABLE_SIZE = 0;
    private static final int FS_TOTAL_SIZE = 1;
    private static final int FS_USED_SIZE = 2;
    private static String illegalChars = null;

    public void connect(String rootName, String fileName) {
        StringBuffer name = new StringBuffer(File.getStorageRoot());
        int curr = name.length();
        name.append(FILESYSTEM_ROOT);
        name.append('/' + rootName);
        this.pathToNativeSeparator(name, curr, name.length() - curr);
        this.rootDir = DefaultFileHandler.getNativeName(name.toString());
        curr = name.length();
        fileName = fileName.substring(rootName.length());
        name.append(fileName);
        this.pathToNativeSeparator(name, curr, name.length() - curr);
        this.fileName = DefaultFileHandler.getNativeName(name.toString());
    }

    public Vector list(String filter, boolean includeHidden) throws IOException {
        return this.list(filter, includeHidden, false);
    }

    public Vector listRoots() {
        Vector<String> roots = new Vector<String>();
        String s = this.getMountedRoots();
        String[] rs = FormatSupport.split(s, '/', 0);
        for (int i = 0; i < rs.length; ++i) {
            roots.addElement(rs[i] + "/");
        }
        return roots;
    }

    public native void create() throws IOException;

    public boolean exists() {
        return this.mode() != 0;
    }

    public boolean isDirectory() {
        return (this.mode() & 0x4000) != 0;
    }

    public native void delete() throws IOException;

    public void rename(String newName) throws IOException {
        StringBuffer name = new StringBuffer(File.getStorageRoot());
        name.append(FILESYSTEM_ROOT);
        int curr = name.length();
        name.append(newName);
        this.rename0(this.pathToNativeSeparator(name, curr, name.length() - curr).toString());
    }

    private native void rename0(String var1) throws IOException;

    public native void truncate(long var1) throws IOException;

    public native long fileSize() throws IOException;

    public boolean canRead() {
        return (this.mode() & 0x100) != 0;
    }

    public boolean canWrite() {
        return (this.mode() & 0x80) != 0;
    }

    public boolean isHidden() {
        return this.isHidden0();
    }

    private native boolean isHidden0();

    public void setReadable(boolean readable) throws IOException {
        this.setMode(readable, 256);
    }

    public void setWritable(boolean writable) throws IOException {
        this.setMode(writable, 128);
    }

    public void setHidden(boolean hidden) throws IOException {
        this.setHidden0(hidden);
    }

    private native void setHidden0(boolean var1) throws IOException;

    public native void mkdir() throws IOException;

    public long availableSize() {
        return this.statfs(0);
    }

    public long totalSize() {
        return this.statfs(1);
    }

    public long usedSize() {
        return this.statfs(2);
    }

    public String illegalFileNameChars() {
        return illegalChars;
    }

    public native long lastModified();

    public native void openForRead() throws IOException;

    public native void openForWrite() throws IOException;

    public native int read(byte[] var1, int var2, int var3) throws IOException;

    public native int write(byte[] var1, int var2, int var3) throws IOException;

    public native void positionForWrite(long var1) throws IOException;

    public native void flush() throws IOException;

    public native void close() throws IOException;

    private StringBuffer pathToNativeSeparator(StringBuffer name, int off, int len) {
        int length = off + len;
        int curr = off;
        char sep = DefaultFileHandler.getFileSeparator();
        while (curr + 1 < length) {
            if (name.charAt(curr) == '/' && name.charAt(curr + 1) == '/') {
                name.deleteCharAt(curr);
                --length;
                continue;
            }
            if (name.charAt(curr) == '/') {
                name.setCharAt(curr, sep);
            }
            ++curr;
        }
        if (name.charAt(length - 1) == '/') {
            name.deleteCharAt(length - 1);
        }
        return name;
    }

    private void setMode(boolean isSet, int modeMask) throws IOException {
        int newmode = isSet ? modeMask | this.mode() : ~modeMask & this.mode();
        this.chmod(newmode);
    }

    private boolean filterAccept(String filter, String str) {
        if (filter == null) {
            return true;
        }
        if (filter.length() == 0) {
            return false;
        }
        int currPos = 0;
        int currComp = 0;
        int firstSigComp = 0;
        String[] components = DefaultFileHandler.split(filter, '*', 0);
        if (filter.charAt(0) != '*') {
            if (!str.startsWith(components[0])) {
                return false;
            }
            currPos += components[0].length();
            firstSigComp = ++currComp;
        }
        while (currComp < components.length) {
            int idx = str.indexOf(components[currComp], currPos);
            if (idx == -1) {
                return false;
            }
            currPos = idx + components[currComp].length();
            ++currComp;
        }
        if (filter.charAt(filter.length() - 1) != '*' && currPos != str.length()) {
            if (components.length > firstSigComp) {
                if (!str.endsWith(components[components.length - 1])) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private static String[] split(String data, char separatorChar, int startingPoint) {
        int i;
        if (startingPoint == data.length()) {
            return new String[0];
        }
        Vector<String> elementList = new Vector<String>();
        if (data.charAt(startingPoint) == separatorChar) {
            ++startingPoint;
        }
        int startSearchAt = startingPoint;
        int startOfElement = startingPoint;
        while ((i = data.indexOf(separatorChar, startSearchAt)) != -1) {
            if (i != 0 && data.charAt(i - 1) == '\\') {
                startSearchAt = i + 1;
                continue;
            }
            String element = data.substring(startOfElement, i);
            elementList.addElement(element);
            startSearchAt = startOfElement = i + 1;
        }
        if (data.length() > startOfElement) {
            if (elementList.size() == 0) {
                return new String[]{data.substring(startOfElement)};
            }
            elementList.addElement(data.substring(startOfElement));
        }
        String[] elements = new String[elementList.size()];
        for (int i2 = 0; i2 < elements.length; ++i2) {
            elements[i2] = (String)elementList.elementAt(i2);
        }
        return elements;
    }

    private Vector list(String filter, boolean includeHidden, boolean dirsOnly) throws IOException {
        Vector<String> list = new Vector<String>();
        this.openDir(includeHidden, dirsOnly);
        String fname = this.dirGetNextFile();
        while (fname != null) {
            String cleanname = fname.charAt(fname.length() - 1) == '/' ? fname.substring(0, fname.length() - 1) : fname;
            if (this.filterAccept(filter, cleanname)) {
                list.addElement(fname);
            }
            fname = this.dirGetNextFile();
        }
        return list;
    }

    private static native long getNativeName(String var0);

    private static native char getFileSeparator();

    private native int mode();

    private native void chmod(int var1);

    private native void openDir(boolean var1, boolean var2);

    private native String dirGetNextFile();

    private native String getMountedRoots();

    private native long statfs(int var1);

    private static native String illegalFileNameChars0();

    private static native void initNativeClass();

    private native void finalize();

    public native long skip(long var1);

    public int tell() {
        return this.tell0();
    }

    public void seek(int pos) {
        this.seek0(pos);
    }

    private native int tell0();

    private native void seek0(int var1);

    static {
        DefaultFileHandler.initNativeClass();
        illegalChars = DefaultFileHandler.illegalFileNameChars0();
        if (illegalChars == null) {
            illegalChars = "";
        }
    }
}

