/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.file;

import com.sun.midp.io.ConnectionBaseAdapter;
import com.sun.midp.io.j2me.file.BaseFileHandler;
import com.sun.midp.io.j2me.file.EscapedUtil;
import com.sun.midp.io.j2me.file.RootCache;
import com.sun.midp.io.j2me.storage.File;
import com.sun.midp.io.j2me.storage.RandomAccessStream;
import com.sun.midp.main.Configuration;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import com.sun.midp.security.SecurityInitializer;
import com.sun.midp.security.SecurityToken;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connection;
import javax.microedition.io.file.ConnectionClosedException;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.IllegalModeException;

public class Protocol
extends ConnectionBaseAdapter
implements FileConnection {
    private int mode;
    private String fileName;
    private String filePath;
    private String fileRoot;
    private String fileURL;
    private BaseFileHandler fileHandler;
    private static boolean hasOtherFileHandler = true;
    InputStream fis;
    OutputStream fos;
    private static SecurityToken classSecurityToken;
    private boolean permissionChecked;
    private SecurityToken ownerSecurityToken = null;
    static /* synthetic */ Class class$javax$microedition$io$file$FileSystemRegistry;

    public static void initSecurityToken(SecurityToken token) {
        if (classSecurityToken != null) {
            return;
        }
        classSecurityToken = token;
    }

    public Protocol() {
        this.connectionOpen = false;
        this.fileHandler = null;
    }

    public Connection openPrim(String name, int mode, boolean timeouts) throws IOException {
        return this.openPrim(null, name, mode, timeouts);
    }

    public Connection openPrim(SecurityToken token, String name, int mode, boolean timeouts) throws IOException {
        this.checkOwnerPermission(token, name);
        this.ensureProperName(name);
        name = EscapedUtil.getUnescapedString(name);
        return this.doOpenPrim(name, mode, timeouts);
    }

    void ensureProperName(String name) {
        if (!name.startsWith("//")) {
            throw new IllegalArgumentException("Missing protocol separator");
        }
        int rootStart = name.indexOf(47, 2);
        if (rootStart == -1) {
            throw new IllegalArgumentException("Malformed File URL");
        }
        String sep = System.getProperty("file.separator");
        if (name.indexOf("/../", rootStart) != -1 || name.indexOf("/./", rootStart) != -1 || name.endsWith("/..") || name.endsWith("/.") || !"/".equals(sep) && name.indexOf(sep, rootStart) != -1 || name.indexOf(92) != -1) {
            throw new IllegalArgumentException("/. or /.. is not supported or other illegal characters found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection doOpenPrim(String name, int mode, boolean timeouts) {
        int rootStart = name.indexOf(47, 2);
        this.fileURL = "file:" + name;
        int nameLength = name.length();
        int pathStart = name.indexOf(47, rootStart + 1);
        if (pathStart == -1) {
            throw new IllegalArgumentException("Root is not specified");
        }
        if (pathStart == nameLength - 1) {
            this.fileName = "";
            this.fileRoot = name.substring(rootStart + 1);
            this.filePath = name.substring(rootStart);
        } else {
            this.fileRoot = name.substring(rootStart + 1, pathStart + 1);
            int fileStart = name.lastIndexOf(47, nameLength - 2);
            if (fileStart <= pathStart) {
                this.fileName = name.substring(pathStart + 1);
                this.filePath = name.substring(rootStart, pathStart + 1);
            } else {
                this.filePath = name.substring(rootStart, fileStart + 1);
                this.fileName = name.substring(fileStart + 1);
            }
        }
        MIDletSuite midletSuite = Scheduler.getScheduler().getMIDletSuite();
        if (midletSuite != null) {
            String prefix = "/root1/";
            String keyword = "privdir";
            if (this.filePath.startsWith("/root1/") && this.filePath.indexOf("privdir") != -1) {
                try {
                    RandomAccessStream storage = new RandomAccessStream(classSecurityToken);
                    storage.connect(File.getStorageRoot() + "suites.utf", 1);
                    try {
                        DataInputStream in = storage.openDataInputStream();
                        String dirPrivate = System.getProperty("fileconn.dir.private");
                        if (dirPrivate != null) {
                            String line;
                            dirPrivate = dirPrivate.substring(7, dirPrivate.length());
                            while ((line = in.readUTF()) != null) {
                                line = line.replace('%', '_');
                                if (this.filePath.indexOf(line = line.replace('#', '_')) == -1) continue;
                                if (this.filePath.startsWith(dirPrivate)) break;
                                throw new IllegalArgumentException("MIDlets are not allowed to access other MIDletsuite's private directory");
                            }
                        }
                    }
                    finally {
                        storage.disconnect();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        switch (mode) {
            case 1: {
                this.maxOStreams = 0;
                try {
                    this.checkReadPermission();
                    break;
                }
                catch (InterruptedIOException iioe) {
                    return this;
                }
            }
            case 2: {
                this.maxIStreams = 0;
                try {
                    this.checkWritePermission();
                    break;
                }
                catch (InterruptedIOException iioe) {
                    return this;
                }
            }
            case 3: {
                try {
                    this.checkWritePermission();
                    this.checkReadPermission();
                    break;
                }
                catch (InterruptedIOException iioe) {
                    return this;
                }
            }
            default: {
                throw new IllegalArgumentException("Invalid mode");
            }
        }
        this.mode = mode;
        this.connectionOpen = true;
        return this;
    }

    public Connection openPrimEscaped(String name, int mode, boolean timeouts) {
        this.ensureProperName(name);
        return this.doOpenPrim(name, mode, timeouts);
    }

    public boolean isOpen() {
        return this.connectionOpen;
    }

    public InputStream openInputStream() throws IOException {
        this.checkReadPermission();
        return this.openInputStream(null);
    }

    public InputStream openInputStream(SecurityToken token) throws IOException {
        if (token != null) {
            token.checkIfPermissionAllowed(31);
        }
        try {
            this.ensureOpenAndConnected();
        }
        catch (ConnectionClosedException e) {
            throw new IOException(e.getMessage());
        }
        this.fileHandler.openForRead();
        this.fis = super.openFileInputStream();
        return this.fis;
    }

    protected long skip(long n) {
        return this.fileHandler.skip(n);
    }

    protected int tell() {
        return this.fileHandler.tell();
    }

    protected void seek(int pos) {
        this.fileHandler.seek(pos);
    }

    public OutputStream openOutputStream() throws IOException {
        return this.openOutputStream(0L);
    }

    public OutputStream openOutputStream(long byteOffset) throws IOException {
        if (byteOffset < 0L) {
            throw new IllegalArgumentException();
        }
        this.checkWritePermission();
        try {
            this.ensureOpenAndConnected();
        }
        catch (ConnectionClosedException e) {
            throw new IOException(e.getMessage());
        }
        this.fileHandler.openForWrite();
        this.fileHandler.positionForWrite(byteOffset);
        this.fos = super.openOutputStream();
        return this.fos;
    }

    public long totalSize() {
        long size = -1L;
        try {
            this.checkRootReadPermission();
            this.ensureOpenAndConnected();
            size = this.fileHandler.totalSize();
        }
        catch (IOException e) {
            size = -1L;
        }
        return size;
    }

    public long availableSize() {
        long size = -1L;
        try {
            this.checkRootReadPermission();
            this.ensureOpenAndConnected();
            size = this.fileHandler.availableSize();
        }
        catch (IOException e) {
            size = -1L;
        }
        return size;
    }

    public long usedSize() {
        long size = -1L;
        try {
            this.checkRootReadPermission();
            this.ensureOpenAndConnected();
            size = this.fileHandler.usedSize();
        }
        catch (IOException e) {
            size = -1L;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long directorySize(boolean includeSubDirs) throws IOException {
        long size = 0L;
        if (this.exists()) {
            if (!this.isDirectory(classSecurityToken)) {
                throw new IOException("directorySize is not invoked on directory");
            }
        } else {
            return -1L;
        }
        try {
            Enumeration fileList = this.listInternal(null, true);
            while (fileList.hasMoreElements()) {
                String fname = (String)fileList.nextElement();
                String furl = this.getURL() + "/" + fname;
                Protocol tfc = null;
                try {
                    tfc = new Protocol();
                    tfc.openPrim(classSecurityToken, furl.substring("file:".length()));
                    if (fname.charAt(fname.length() - 1) != '/') {
                        size += tfc.fileSize();
                        continue;
                    }
                    if (!includeSubDirs) continue;
                    size += tfc.directorySize(includeSubDirs);
                }
                catch (IOException e1) {}
                continue;
                finally {
                    if (tfc == null) continue;
                    tfc.close();
                }
            }
        }
        catch (IOException e) {
            size = -1L;
        }
        return size;
    }

    public long fileSize() throws IOException {
        this.checkReadPermission();
        return this.fileSize(null);
    }

    public long fileSize(SecurityToken token) throws IOException {
        if (token != null) {
            token.checkIfPermissionAllowed(31);
        }
        long size = -1L;
        if (this.isDirectory(classSecurityToken)) {
            throw new IOException("fileSize invoked on a directory");
        }
        try {
            this.ensureOpenAndConnected();
            size = this.fileHandler.fileSize();
        }
        catch (IOException e) {
            size = -1L;
        }
        return size;
    }

    public boolean canRead() {
        try {
            this.checkReadPermission();
        }
        catch (IOException e) {
            return false;
        }
        return this.canRead(null);
    }

    public boolean canRead(SecurityToken token) {
        boolean res = false;
        try {
            if (token != null) {
                token.checkIfPermissionAllowed(31);
            }
            this.ensureOpenAndConnected();
            res = this.fileHandler.canRead();
        }
        catch (IOException e) {
            res = false;
        }
        return res;
    }

    public boolean canWrite() {
        return this.canWrite(null);
    }

    public boolean canWrite(SecurityToken token) {
        boolean res = false;
        try {
            if (token != null) {
                token.checkIfPermissionAllowed(31);
            } else {
                this.checkReadPermission();
            }
            this.ensureOpenAndConnected();
            res = this.fileHandler.canWrite();
        }
        catch (IOException e) {
            res = false;
        }
        return res;
    }

    public boolean isHidden() {
        boolean res = false;
        try {
            this.checkReadPermission();
            this.ensureOpenAndConnected();
            res = this.fileHandler.isHidden();
        }
        catch (IOException e) {
            res = false;
        }
        return res;
    }

    public void setReadable(boolean readable) throws IOException {
        this.checkWritePermission();
        this.ensureOpenAndConnected();
        this.fileHandler.setReadable(readable);
    }

    public void setWritable(boolean writable) throws IOException {
        this.checkWritePermission();
        this.ensureOpenAndConnected();
        this.fileHandler.setWritable(writable);
    }

    public void setHidden(boolean hidden) throws IOException {
        this.checkWritePermission();
        this.ensureOpenAndConnected();
        this.fileHandler.setHidden(hidden);
    }

    public Enumeration list() throws IOException {
        return this.listInternal(null, false);
    }

    public Enumeration list(String filter, boolean includeHidden) throws IOException {
        if (filter == null) {
            throw new NullPointerException("List filter is null");
        }
        return this.listInternal(EscapedUtil.getUnescapedString(filter), includeHidden);
    }

    public void create() throws IOException {
        this.checkWritePermission();
        this.ensureOpenAndConnected();
        if (this.fileName.charAt(this.fileName.length() - 1) == '/') {
            throw new IOException("Can not create directory");
        }
        this.fileHandler.create();
    }

    public void mkdir() throws IOException {
        this.checkWritePermission();
        this.ensureOpenAndConnected();
        this.fileHandler.mkdir();
    }

    public boolean exists() {
        return this.exists(null);
    }

    public boolean exists(SecurityToken token) {
        boolean res = false;
        try {
            if (token != null) {
                token.checkIfPermissionAllowed(31);
            } else {
                this.checkReadPermission();
            }
            this.ensureOpenAndConnected();
            res = this.fileHandler.exists();
        }
        catch (IOException e) {
            res = false;
        }
        return res;
    }

    public boolean isDirectory() {
        return this.isDirectory(null);
    }

    public boolean isDirectory(SecurityToken token) {
        boolean res = false;
        try {
            if (token != null) {
                token.checkIfPermissionAllowed(31);
            } else {
                this.checkReadPermission();
            }
            this.ensureOpenAndConnected();
            res = this.fileHandler.isDirectory();
        }
        catch (IOException e) {
            res = false;
        }
        return res;
    }

    public void delete() throws IOException {
        this.checkWritePermission();
        this.ensureOpenAndConnected();
        try {
            if (this.fis != null) {
                this.fis.close();
                this.fis = null;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.fos != null) {
                this.fos.close();
                this.fos = null;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.fileHandler.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fileHandler.delete();
    }

    public void rename(String newName) throws IOException {
        this.checkWritePermission();
        newName = EscapedUtil.getUnescapedString(newName);
        int sepindex = newName.indexOf("/");
        if (sepindex != -1 && sepindex != newName.length() - 1) {
            throw new IllegalArgumentException("new name contains path specification");
        }
        String sep = System.getProperty("file.separator");
        if (!"/".equals(sep) && newName.indexOf(sep) != -1) {
            throw new IllegalArgumentException("New name contains path specification");
        }
        this.ensureOpenAndConnected();
        this.checkIllegalChars(newName);
        try {
            if (this.fis != null) {
                this.fis.close();
                this.fis = null;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.fos != null) {
                this.fos.close();
                this.fos = null;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.fileHandler.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.fileHandler.rename(this.filePath + newName);
        this.fileName = newName;
        this.fileURL = "file://" + this.filePath + this.fileName;
    }

    public void truncate(long byteOffset) throws IOException {
        this.checkWritePermission();
        this.ensureOpenAndConnected();
        if (byteOffset < 0L) {
            throw new IllegalArgumentException("offset is negative");
        }
        try {
            if (this.fos != null) {
                this.fos.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fileHandler.truncate(byteOffset);
    }

    public void setFileConnection(String fileName) throws IOException {
        this.ensureOpenAndConnected();
        int sepindex = fileName.indexOf("/");
        if (sepindex != -1 && sepindex != fileName.length() - 1) {
            throw new IllegalArgumentException("contains any path specification");
        }
        if (fileName.equals("..") && this.fileName.length() == 0) {
            throw new IOException("Cannot set FileConnection to '..' from a file system root");
        }
        String sep = System.getProperty("file.separator");
        if (!"/".equals(sep) && fileName.indexOf(sep) != -1) {
            throw new IllegalArgumentException("contains any path specification");
        }
        this.checkIllegalChars(fileName);
        if (!this.fileHandler.isDirectory()) {
            throw new IOException("Not a directory");
        }
        String origPath = this.filePath;
        String origName = this.fileName;
        if (fileName.equals("..")) {
            this.openPrimEscaped("//" + this.filePath, this.mode, false);
        } else {
            sep = this.fileName.endsWith("/") || this.fileName.length() == 0 ? "" : "/";
            this.openPrimEscaped("//" + this.filePath + this.fileName + sep + fileName, this.mode, false);
        }
        this.fileHandler = null;
        this.ensureOpenAndConnected();
        if (!this.fileHandler.exists()) {
            this.openPrimEscaped("//" + origPath + origName, this.mode, false);
            this.fileHandler = null;
            throw new IllegalArgumentException("New target does not exists");
        }
    }

    private void checkIllegalChars(String name) throws IOException {
        String illegalChars = this.fileHandler.illegalFileNameChars();
        for (int i = 0; i < illegalChars.length(); ++i) {
            if (name.indexOf(illegalChars.charAt(i)) == -1) continue;
            throw new IOException("Contains characters invalid for a filename");
        }
    }

    public String getName() {
        String name = this.fileName;
        try {
            if (this.exists(classSecurityToken)) {
                if (this.isDirectory(classSecurityToken)) {
                    if (!name.equals("") && !name.endsWith("/")) {
                        name = name + "/";
                    }
                } else if (name.endsWith("/")) {
                    name = name.substring(0, name.length() - 1);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    public String getPath() {
        return this.filePath;
    }

    public String getURL() {
        String url = EscapedUtil.getEscapedString(this.fileURL);
        try {
            if (this.exists(classSecurityToken)) {
                if (this.isDirectory(classSecurityToken)) {
                    if (!url.endsWith("/")) {
                        url = url + "/";
                    }
                } else if (url.endsWith("/")) {
                    url = url.substring(0, url.length() - 1);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    public long lastModified() {
        long res = 0L;
        try {
            this.checkReadPermission();
            this.ensureOpenAndConnected();
            res = this.fileHandler.lastModified();
        }
        catch (IOException e) {
            res = 0L;
        }
        return res;
    }

    protected int readBytes(byte[] b, int off, int len) throws IOException {
        this.ensureConnected();
        return this.fileHandler.read(b, off, len);
    }

    protected int writeBytes(byte[] b, int off, int len) throws IOException {
        this.checkWritePermission();
        this.ensureConnected();
        return this.fileHandler.write(b, off, len);
    }

    protected void flush() throws IOException {
        this.checkWritePermission();
        this.ensureConnected();
        this.fileHandler.flush();
    }

    protected void closeInputStream() throws IOException {
        ++this.maxIStreams;
        super.closeInputStream();
    }

    protected void closeOutputStream() throws IOException {
        ++this.maxOStreams;
        this.flush();
        super.closeOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect() throws IOException {
        try {
            if (this.fileHandler != null) {
                this.fileHandler.close();
            }
        }
        finally {
            this.fileHandler = null;
        }
    }

    protected void connect(String name, int mode, boolean timeouts) throws IOException {
    }

    protected void ensureConnected() throws IOException {
        (class$javax$microedition$io$file$FileSystemRegistry == null ? (class$javax$microedition$io$file$FileSystemRegistry = Protocol.class$("javax.microedition.io.file.FileSystemRegistry")) : class$javax$microedition$io$file$FileSystemRegistry).toString();
        if (!RootCache.getInstance().isRoot(this.fileRoot)) {
            throw new IOException("Root is not accessible");
        }
        if (this.fileHandler == null) {
            this.fileHandler = Protocol.getFileHandler();
            this.fileHandler.connect(this.fileRoot, this.filePath + this.fileName);
        }
    }

    protected void ensureOpenAndConnected() throws IOException {
        if (!this.isOpen()) {
            throw new ConnectionClosedException("Connection is closed");
        }
        this.ensureConnected();
    }

    protected final void checkReadPermission() throws InterruptedIOException {
        if (this.ownerSecurityToken != null) {
            return;
        }
        MIDletSuite suite = Scheduler.getScheduler().getMIDletSuite();
        if (suite == null) {
            return;
        }
        try {
            suite.checkForPermission(31, this.fileURL);
        }
        catch (InterruptedException ie) {
            throw new InterruptedIOException("Interrupted while trying to ask the user permission");
        }
        if (this.mode == 2) {
            throw new IllegalModeException("Connection is write only");
        }
    }

    protected final void checkRootReadPermission() throws InterruptedIOException {
        MIDletSuite suite = Scheduler.getScheduler().getMIDletSuite();
        if (suite == null) {
            return;
        }
        try {
            suite.checkForPermission(31, "file://" + this.fileRoot);
        }
        catch (InterruptedException ie) {
            throw new InterruptedIOException("Interrupted while trying to ask the user permission");
        }
        if (this.mode == 2) {
            throw new IllegalModeException("Connection is write only");
        }
    }

    protected final void checkWritePermission() throws InterruptedIOException {
        if (this.ownerSecurityToken != null) {
            return;
        }
        MIDletSuite suite = Scheduler.getScheduler().getMIDletSuite();
        if (suite == null) {
            return;
        }
        try {
            suite.checkForPermission(32, this.fileURL);
        }
        catch (InterruptedException ie) {
            throw new InterruptedIOException("Interrupted while trying to ask the user permission");
        }
        if (this.mode == 1) {
            throw new IllegalModeException("Connection is read only");
        }
    }

    protected final void checkOwnerPermission(SecurityToken token, String name) throws InterruptedIOException {
        if (token != null && !this.permissionChecked) {
            this.checkForPermission(token, 31, name, "file");
            this.permissionChecked = true;
            this.ownerSecurityToken = token;
        }
    }

    public static Vector listRoots() {
        BaseFileHandler fh = Protocol.getFileHandler();
        fh.connect("", "");
        return fh.listRoots();
    }

    private Enumeration listInternal(String filter, boolean includeHidden) throws IOException {
        this.checkReadPermission();
        this.ensureOpenAndConnected();
        if (filter != null) {
            String sep = System.getProperty("file.separator");
            if (filter.indexOf("/") != -1 || filter.indexOf(sep) != -1) {
                throw new IllegalArgumentException("Contains any path specification");
            }
            String illegalChars = this.fileHandler.illegalFileNameChars();
            for (int i = 0; i < illegalChars.length(); ++i) {
                if (filter.indexOf(illegalChars.charAt(i)) == -1) continue;
                throw new IllegalArgumentException("Contains characters invalid for a filename");
            }
        }
        return this.fileHandler.list(filter, includeHidden).elements();
    }

    private static BaseFileHandler getFileHandler() {
        String def = "com.sun.midp.io.j2me.file.DefaultFileHandler";
        if (hasOtherFileHandler) {
            String n = Configuration.getProperty("com.sun.midp.io.j2me.fileHandlerImpl");
            try {
                return (BaseFileHandler)Class.forName(n).newInstance();
            }
            catch (Exception e) {
                hasOtherFileHandler = false;
            }
        }
        try {
            return (BaseFileHandler)Class.forName(def).newInstance();
        }
        catch (Exception exception) {
            throw new Error("Unable to create FileConnection Handler");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Protocol.initSecurityToken(SecurityInitializer.getSecurityToken());
    }
}

