/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.irdaobex;

import com.sun.kvem.jsr082.impl.JSR082Controller;
import com.sun.kvem.jsr082.impl.Utilites;
import com.sun.midp.io.j2me.irdaobex.DeviceCache;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

final class IRDAOBEXControl {
    private static final boolean DEBUG = false;
    private static final String cn = "IRDAOBEXControl";
    private static final String OBEX_IRDA_MAX_PACKET_LENGTH = "irdaobex.packetLength";
    private static final String OBEX_IRDA_DISCOVERY_TIMEOUT = "irdaobex.discoveryTimeout";
    private static final int DISCOVERING_RETRY_TIME = 50;
    private static final int MIN_PACKET_SIZE = 64;
    private static final int CACHE_SIZE = 10;
    private static final String COMMAND_REGISTER_DEVICE = "registerIrDADevice";
    private static final String COMMAND_REGISTER_SERVICE = "registerIrDAService";
    private static final String COMMAND_UNREGISTER_SERVICE = "unregisterIrDAService";
    private static final String COMMAND_GET_ADDRESSES = "getIrDADevicesAddresses";
    private static final String COMMAND_GET_CONNECTION = "getIrDAConnection";
    private static boolean isCreated;
    private JSR082Controller finalizerObj;
    private static boolean isInitialized;
    private String address = "unspecified";
    private int maxPacketLength;
    private int discoveryTimeout;
    private DeviceCache deviceCache;
    static /* synthetic */ Class class$com$sun$midp$io$j2me$irdaobex$IRDAOBEXControl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IRDAOBEXControl() {
        Class clazz = class$com$sun$midp$io$j2me$irdaobex$IRDAOBEXControl == null ? (class$com$sun$midp$io$j2me$irdaobex$IRDAOBEXControl = IRDAOBEXControl.class$("com.sun.midp.io.j2me.irdaobex.IRDAOBEXControl")) : class$com$sun$midp$io$j2me$irdaobex$IRDAOBEXControl;
        synchronized (clazz) {
            if (isCreated) {
                throw new RuntimeException("IRDAOBEXControl is created already.");
            }
            isCreated = true;
        }
    }

    String getAddress() {
        return this.address;
    }

    int getMaximumPacketSize() {
        return this.maxPacketLength;
    }

    int getDiscoveryTimeout() {
        return this.discoveryTimeout;
    }

    synchronized void initialize() throws Exception {
        if (isInitialized) {
            throw new RuntimeException("IRDAOBEXControl is initialized already.");
        }
        try {
            String propsStr = JSR082Controller.getDeviceInfo(1, 17);
            Hashtable propsTable = new Hashtable();
            Utilites.parseInfo(propsStr, propsTable);
            this.extractFromProperties(propsTable);
            this.deviceCache = new DeviceCache(10);
            StringBuffer args = new StringBuffer(COMMAND_REGISTER_DEVICE);
            args.append('\n').append(this.address).append('\n');
            this.address = IRDAOBEXControl.processCommand(1, args.toString());
            this.finalizerObj = JSR082Controller.getInstance();
        }
        catch (Throwable e) {
            throw new Exception(e.toString());
        }
        isInitialized = true;
    }

    String[] findDevices(boolean isDiscoveringRequired) throws IOException {
        String[] addrs = null;
        System.out.println("IRDAOBEXControl.findDevices(" + isDiscoveringRequired + ")");
        if (isDiscoveringRequired) {
            addrs = this.discoverDevices();
            if (addrs != null && this.deviceCache != null) {
                for (int i = 0; i < addrs.length; ++i) {
                    this.deviceCache.addToCache(addrs[i]);
                }
            }
        } else if (this.deviceCache != null) {
            addrs = this.deviceCache.getCachedDevices();
        }
        return addrs;
    }

    int[] getDevicePortsForConnection(String address, int hintbits, String ias) throws IOException {
        StringBuffer args = new StringBuffer(COMMAND_GET_CONNECTION);
        args.append('\n').append(address).append('\n');
        args.append(Integer.toString(hintbits)).append('\n');
        args.append(ias).append('\n');
        String ports = IRDAOBEXControl.processCommand(1, args.toString());
        if (ports == null) {
            return null;
        }
        Vector<Integer> resVector = new Vector<Integer>();
        boolean lastOne = false;
        while (!lastOne) {
            String portStr = ports;
            int index = portStr.indexOf(44);
            if (index != -1) {
                portStr = portStr.substring(0, index);
                ports = ports.substring(index + 1);
            } else {
                lastOne = true;
            }
            try {
                Integer port = new Integer(Integer.parseInt(portStr));
                resVector.addElement(port);
            }
            catch (NumberFormatException e) {
                System.err.println("Internal Error: unexpected port:" + portStr);
            }
        }
        if (resVector.size() == 0) {
            return null;
        }
        int[] res = new int[resVector.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (Integer)resVector.elementAt(i);
        }
        return res;
    }

    synchronized void registerIrDAObexService(int hintbits, String ias, int port) throws IOException {
        StringBuffer args = new StringBuffer(COMMAND_REGISTER_SERVICE);
        args.append('\n').append(this.address).append('\n');
        args.append(Integer.toString(hintbits)).append('\n');
        args.append(ias).append('\n');
        args.append(Integer.toString(port)).append('\n');
        IRDAOBEXControl.processCommand(1, args.toString());
    }

    synchronized void unregisterIrDAObexService(int port) throws IOException {
        StringBuffer args = new StringBuffer(COMMAND_UNREGISTER_SERVICE);
        args.append('\n').append(this.address).append('\n');
        args.append(Integer.toString(port)).append('\n');
        IRDAOBEXControl.processCommand(1, args.toString());
    }

    private String[] discoverDevices() throws IOException {
        long start_time = System.currentTimeMillis();
        String addrs = null;
        do {
            StringBuffer args = new StringBuffer(COMMAND_GET_ADDRESSES);
            args.append('\n').append(this.address).append('\n');
            addrs = IRDAOBEXControl.processCommand(1, args.toString());
            if (addrs != null) break;
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (System.currentTimeMillis() - start_time < (long)this.discoveryTimeout) continue;
            throw new IOException("No devices in range.");
        } while (addrs == null);
        return Utilites.splitString(addrs, ',');
    }

    private void extractFromProperties(Hashtable props) {
        this.maxPacketLength = Utilites.getIntProperty(cn, props, OBEX_IRDA_MAX_PACKET_LENGTH, 64);
        this.discoveryTimeout = Utilites.getIntProperty(cn, props, OBEX_IRDA_DISCOVERY_TIMEOUT, 0);
    }

    private static String processCommand(int deviceType, String command) throws IOException {
        String res = JSR082Controller.processCommand(deviceType, command);
        if (res == null || res.equals("")) {
            return null;
        }
        return res;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

