/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.mms;

import com.sun.cldc.io.ConnectionBaseInterface;
import com.sun.midp.io.j2me.mms.ApplicationIDManager;
import com.sun.midp.io.j2me.mms.DatagramImpl;
import com.sun.midp.io.j2me.mms.MMSAddress;
import com.sun.midp.io.j2me.mms.MultipartObject;
import com.sun.midp.io.j2me.sms.MessageObject;
import com.sun.midp.io.j2me.sms.TransportImpl;
import com.sun.midp.io.j2me.sms.TransportMessage;
import com.sun.midp.main.Configuration;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import com.sun.midp.security.ImplicitlyTrustedClass;
import com.sun.midp.security.SecurityToken;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.io.Connection;
import javax.microedition.io.StreamConnection;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.MessageListener;

public class Protocol
implements MessageConnection,
ConnectionBaseInterface,
StreamConnection,
ImplicitlyTrustedClass {
    protected TransportImpl mmsimpl;
    protected static TransportImpl sharedimpl;
    protected String url;
    protected static int open_count;
    protected MIDletSuite midletSuite;
    private int connectionPermission = 18;
    private int receivePermission = 20;
    private boolean openPermission = false;
    protected boolean profiling = false;
    protected String host = null;
    protected String appID = null;
    protected boolean open;
    private static SecurityToken classSecurityToken;

    public final void initSecurityToken(SecurityToken token) {
        if (classSecurityToken != null) {
            return;
        }
        classSecurityToken = token;
    }

    public Connection openPrim(String name, int mode, boolean timeouts) throws IOException {
        this.initTransport();
        if (name.length() <= 2 || name.charAt(0) != '/' || name.charAt(1) != '/') {
            throw new IllegalArgumentException("Missing protocol separator");
        }
        String fullAddress = "mms:" + name;
        MMSAddress parsedAddress = MMSAddress.getParsedMMSAddress(fullAddress);
        if (parsedAddress == null) {
            throw new IllegalArgumentException("Invalid mms connection URL");
        }
        this.host = parsedAddress.address;
        this.appID = parsedAddress.appId;
        if (mode == 1 && this.host != null && this.host.length() > 0) {
            throw new IllegalArgumentException("Cannot read on client connection");
        }
        if (mode <= 0 || 3 < mode) {
            throw new IllegalArgumentException("Invalid mode");
        }
        if (!this.openPermission) {
            try {
                this.midletSuite.checkForPermission(this.connectionPermission, "mms:open");
                this.openPermission = true;
            }
            catch (InterruptedException ie) {
                throw new InterruptedIOException("Interrupted while trying to ask the user permission");
            }
        }
        if (this.host == null && this.appID != null) {
            try {
                ApplicationIDManager.register(this.appID, this);
            }
            catch (IllegalArgumentException iae) {
                throw new IOException("Application ID is already in use: " + this.appID);
            }
        }
        this.url = name;
        ++open_count;
        this.open = true;
        return this;
    }

    public void ensureOpen() throws IOException {
        if (!this.open) {
            throw new IOException("Connection closed");
        }
    }

    public void close() throws IOException {
        if (this.open) {
            this.open = false;
            this.mmsimpl.setMessageListener(this, null, this.appID);
            ApplicationIDManager.unregister(this);
            --open_count;
            if (this.mmsimpl instanceof com.sun.midp.io.j2me.sms.DatagramImpl) {
                ((com.sun.midp.io.j2me.sms.DatagramImpl)this.mmsimpl).notifyClosedConnection();
            }
            if (open_count == 0) {
                sharedimpl.close();
                sharedimpl = null;
            }
        }
    }

    public Message newMessage(String type) {
        String addr = null;
        if (this.host != null) {
            addr = "mms://" + this.host;
            if (this.appID != null) {
                addr = addr + ":" + this.appID;
            }
        }
        return this.newMessage(type, addr);
    }

    public Message newMessage(String type, String addr) {
        if (type.equals("multipart")) {
            return new MultipartObject(addr);
        }
        throw new IllegalArgumentException("Type not supported");
    }

    public void send(Message dmsg) throws IOException {
        Vector<String> allAddresses;
        MultipartObject mpo;
        long end;
        long start;
        block16: {
            if (dmsg == null) {
                throw new NullPointerException("Null message");
            }
            this.ensureOpen();
            start = 0L;
            end = 0L;
            if (this.profiling) {
                start = System.currentTimeMillis();
            }
            if (!(dmsg instanceof MultipartObject)) {
                throw new IllegalArgumentException("Unsupported message type");
            }
            mpo = (MultipartObject)dmsg;
            allAddresses = new Vector<String>();
            String[] addresses = mpo.getAddresses("to");
            boolean checkedTo = false;
            boolean checkedCC = false;
            int currIndex = 0;
            String parsedAppID = null;
            while (true) {
                if (addresses == null || currIndex >= addresses.length) {
                    if (!checkedTo) {
                        checkedTo = true;
                        addresses = mpo.getAddresses("cc");
                        currIndex = 0;
                        continue;
                    }
                    if (!checkedCC) {
                        checkedCC = true;
                        addresses = mpo.getAddresses("bcc");
                        currIndex = 0;
                        continue;
                    }
                    break block16;
                }
                String addr = addresses[currIndex++];
                allAddresses.addElement(addr);
                MMSAddress parsedAddress = MMSAddress.getParsedMMSAddress(addr);
                if (parsedAddress == null || parsedAddress.type == -1 || parsedAddress.type == 5) {
                    throw new IllegalArgumentException("Invalid MMS address: " + addr);
                }
                if (parsedAppID == null) {
                    parsedAppID = parsedAddress.appId;
                    continue;
                }
                if (parsedAddress.appId != null && !parsedAppID.equals(parsedAddress.appId)) break;
            }
            throw new IllegalArgumentException("Only one Application-ID can be specified per message");
        }
        if (allAddresses.size() == 0) {
            throw new IllegalArgumentException("No to, cc, or bcc addresses");
        }
        try {
            this.midletSuite.checkForPermission(19, allAddresses.toString(), Integer.toString(this.numberOfSegments(dmsg)));
        }
        catch (InterruptedException ie) {
            throw new InterruptedIOException("Interrupted while trying to ask the user permission");
        }
        String messageAppID = mpo.getApplicationID();
        String replyToAppID = null;
        String toAddress = "mms://:";
        if (messageAppID != null) {
            toAddress = toAddress + messageAppID;
        }
        if (messageAppID != null && this.host == null) {
            mpo.setReplyToApplicationID(this.appID);
            replyToAppID = this.appID;
        }
        String oldFromAddress = ((MessageObject)mpo).getAddress();
        if (this.mmsimpl instanceof DatagramImpl) {
            String fromAddress = ((DatagramImpl)this.mmsimpl).getDeviceID();
            mpo.setFromAddress("mms://" + fromAddress);
        }
        byte[] buf = mpo.getAsByteArray();
        long sendTime = this.mmsimpl.send("multipart", toAddress, buf, replyToAppID);
        mpo.setFromAddress(oldFromAddress);
        if (this.profiling) {
            end = System.currentTimeMillis();
            System.out.println("S," + sendTime + "," + start + "," + end + "," + (end - start));
        }
    }

    public synchronized Message receive() throws IOException {
        String addr;
        long start = 0L;
        long end = 0L;
        if (this.host != null) {
            throw new IOException("Can not receive from client only connection: " + this.host);
        }
        if (this.profiling) {
            start = System.currentTimeMillis();
        }
        try {
            this.ensureOpen();
        }
        catch (IOException ioe) {
            throw new InterruptedIOException("Connection closed during receieve");
        }
        this.checkReceivePermission();
        MultipartObject msg = null;
        TransportMessage tm = null;
        while ((addr = (tm = this.mmsimpl.receive(this)).getAddress()) == null || !addr.equals("mms://:" + this.appID)) {
        }
        byte[] buf = tm.getData();
        msg = MultipartObject.createFromByteArray(buf);
        msg.setTimeStamp(tm.getTimeStamp());
        msg.setFromAddress(tm.getSenderAddress());
        String deviceID = "unknown";
        if (this.mmsimpl instanceof DatagramImpl) {
            deviceID = ((DatagramImpl)this.mmsimpl).getDeviceID();
        }
        msg.fixupReceivedMessageAddresses(tm.getSenderAddress(), deviceID);
        if (this.profiling) {
            end = System.currentTimeMillis();
            System.out.println("R," + tm.getTimeStamp() + "," + start + "," + end + "," + (end - start));
        }
        return msg;
    }

    protected void checkReceivePermission() throws InterruptedIOException {
        try {
            this.midletSuite.checkForPermission(this.receivePermission, "mms:receive");
        }
        catch (InterruptedException ie) {
            throw new InterruptedIOException("Interrupted while trying to ask the user permission");
        }
    }

    protected final void setPermissions(SecurityToken token, int connPerm, int receivePerm) {
        token.checkIfPermissionAllowed(0);
        this.connectionPermission = connPerm;
        this.receivePermission = receivePerm;
    }

    public void setMessageListener(MessageListener l) throws IOException {
        this.ensureOpen();
        if (this.host != null && this.host.length() > 0) {
            throw new IOException("Cannot listen on client connection");
        }
        this.checkReceivePermission();
        this.mmsimpl.setMessageListener(this, l, this.appID);
    }

    public int numberOfSegments(Message msg) {
        return this.mmsimpl.numberOfSegments(msg);
    }

    public InputStream openInputStream() throws IOException {
        throw new IllegalArgumentException("Not supported");
    }

    public DataInputStream openDataInputStream() throws IOException {
        throw new IllegalArgumentException("Not supported");
    }

    public OutputStream openOutputStream() throws IOException {
        throw new IllegalArgumentException("Not supported");
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        throw new IllegalArgumentException("Not supported");
    }

    private void initTransport() {
        try {
            this.midletSuite = Scheduler.getScheduler().getMIDletSuite();
            if (this.midletSuite == null) {
                return;
            }
            String impl = Configuration.getPropertyDefault("com.sun.midp.io.j2me.mms.Impl", "com.sun.midp.io.j2me.mms.DatagramImpl");
            if (sharedimpl == null) {
                sharedimpl = (TransportImpl)Class.forName(impl).newInstance();
                try {
                    sharedimpl.open(this, classSecurityToken);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            this.mmsimpl = sharedimpl;
            String prof = Configuration.getProperty("com.sun.midp.io.j2me.mms.profiling");
            if (prof != null) {
                this.profiling = prof.equals("true");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        open_count = 0;
    }
}

