/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.push;

import com.sun.kvem.io.j2me.push.BTPushAdaptor;
import com.sun.midp.io.HttpUrl;
import com.sun.midp.io.Util;
import com.sun.midp.io.j2me.mms.MMSAddress;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import com.sun.midp.midletsuite.Installer;
import com.sun.midp.security.ImplicitlyTrustedClass;
import com.sun.midp.security.SecurityToken;
import java.io.IOException;
import java.io.InterruptedIOException;
import javax.microedition.io.ConnectionNotFoundException;

public class PushRegistryImpl
implements Runnable,
ImplicitlyTrustedClass {
    private static String SHARED_PORT = "*";
    private static SecurityToken classSecurityToken;
    private static BTPushAdaptor btPushAdaptor;
    private static boolean pushEnabled;
    public static final int BT_FIRST_FD = -11;

    public void run() {
        long fd = -1L;
        int ret = 0;
        byte[] entry = new byte[512];
        if (btPushAdaptor != null) {
            btPushAdaptor.invokeBluetoothListeners();
        }
        while (true) {
            try {
                while (true) {
                    byte[] registryEntry;
                    if (pushEnabled && (fd = this.poll0(System.currentTimeMillis())) != -1L && fd != -1L && (ret = PushRegistryImpl.getMIDlet0(fd, registryEntry = new byte[512], 512)) == 0) {
                        String name = Util.toJavaString(registryEntry);
                        this.launchEntry(name, fd < 0L);
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                continue;
            }
            break;
        }
    }

    protected void launchEntry(String name, boolean isBTPush) {
        String storage;
        String midlet;
        String conn;
        int comma1 = name.indexOf(44, 0);
        int comma2 = name.indexOf(44, comma1 + 1);
        int comma3 = name.indexOf(44, comma2 + 1);
        if (comma3 == -1) {
            conn = null;
            midlet = name.substring(0, comma1).trim();
            storage = name.substring(comma2 + 1).trim();
        } else {
            conn = name.substring(0, comma1).trim();
            midlet = name.substring(comma1 + 1, comma2).trim();
            String filter = name.substring(comma2 + 1, comma3).trim();
            storage = name.substring(comma3 + 1).trim();
        }
        try {
            boolean okToInterrupt = true;
            Installer installer = Installer.getInstaller(classSecurityToken);
            Scheduler scheduler = Scheduler.getScheduler();
            MIDletSuite current = scheduler.getMIDletSuite();
            String root = null;
            if (current != null) {
                root = current.getStorageName();
            }
            if (root != null && root.equals(storage)) {
                if (scheduler.isScheduled(midlet)) {
                    return;
                }
                if (!current.permissionToInterrupt(conn, isBTPush)) {
                    if (conn != null) {
                        PushRegistryImpl.checkInConnectionInternal(classSecurityToken, conn);
                    }
                    return;
                }
                current.saveSettings();
            } else {
                MIDletSuite next = installer.getMIDletSuite(storage);
                if (next == null) {
                    return;
                }
                okToInterrupt = next.permissionToInterrupt(conn, isBTPush);
                next.saveSettings();
                if (!okToInterrupt) {
                    if (conn != null) {
                        PushRegistryImpl.checkInConnectionInternal(classSecurityToken, conn);
                    }
                    return;
                }
            }
            installer.execute(storage, midlet);
            Scheduler.getScheduler().shutdown();
        }
        catch (Exception e) {
            if (conn != null) {
                PushRegistryImpl.checkInConnectionInternal(classSecurityToken, conn);
            }
            e.printStackTrace();
        }
    }

    public static void registerConnection(String connection, String midlet, String filter) throws ClassNotFoundException, IOException {
        Scheduler scheduler = Scheduler.getScheduler();
        MIDletSuite midletSuite = scheduler.getMIDletSuite();
        if (midletSuite == null) {
            throw new IllegalStateException("Not in a MIDlet context");
        }
        if (midlet == null || midlet.length() == 0) {
            throw new ClassNotFoundException("MIDlet missing");
        }
        Class<?> cl = Class.forName(midlet);
        Class<?> m = Class.forName("javax.microedition.midlet.MIDlet");
        if (!m.isAssignableFrom(cl)) {
            throw new ClassNotFoundException("Not a MIDlet");
        }
        PushRegistryImpl.registerConnectionInternal(classSecurityToken, midletSuite, connection, midlet, filter, false);
    }

    static void checkRegistration(String connection, String midlet, String filter) throws ClassNotFoundException {
        block14: {
            int len;
            block13: {
                if (midlet == null || midlet.length() == 0) {
                    throw new ClassNotFoundException("MIDlet missing");
                }
                if (connection == null || connection.length() == 0) {
                    throw new IllegalArgumentException("Connection missing");
                }
                if (filter == null || filter.length() == 0) {
                    throw new IllegalArgumentException("Filter missing");
                }
                len = filter.length();
                if (!connection.startsWith("mms://") && !connection.startsWith("sms://")) break block13;
                for (int i = 0; i < len; ++i) {
                    char c = filter.charAt(i);
                    if (i == 0 && c == '+' || c == '?' || c == '*' || '0' <= c && c <= '9') continue;
                    throw new IllegalArgumentException("MSIDN filter invalid");
                }
                break block14;
            }
            if (connection.startsWith("cbs://")) break block14;
            if ((connection.startsWith("btspp://") || connection.startsWith("btgoep://") || connection.startsWith("btl2cap://")) && btPushAdaptor != null) {
                if (!btPushAdaptor.checkConnectionString(connection)) {
                    throw new IllegalArgumentException("Invalid connection URL");
                }
                if (!btPushAdaptor.checkFilterString(filter)) {
                    throw new IllegalArgumentException("Invalid AllowedSender string" + filter + " " + btPushAdaptor);
                }
            } else if (connection.startsWith("sip:")) {
                String transportType = PushRegistryImpl.getSipParam(connection, "transport");
                if (transportType != null && !transportType.equalsIgnoreCase("udp")) {
                    throw new IllegalArgumentException("Transport not supported");
                }
                String application = PushRegistryImpl.getSipParam(connection, "type");
                String port = PushRegistryImpl.getSipPortAsString(connection);
                if (application == null && port.equals(SHARED_PORT)) {
                    throw new IllegalArgumentException("Shared port requires type tag");
                }
            } else {
                for (int i = 0; i < len; ++i) {
                    char c = filter.charAt(i);
                    if (c == '?' || c == '*' || c == '.' || '0' <= c && c <= '9') continue;
                    throw new IllegalArgumentException("IP Filter invalid");
                }
            }
        }
    }

    public static void registerConnectionInternal(SecurityToken token, MIDletSuite midletSuite, String connection, String midlet, String filter, boolean bypassChecks) throws ClassNotFoundException, IOException {
        BTPushAdaptor bt_pushListener = null;
        token.checkIfPermissionAllowed(0);
        if (!bypassChecks) {
            try {
                midletSuite.checkForPermission(10, null);
                PushRegistryImpl.checkRegistration(connection, midlet, filter);
                if (!midletSuite.isRegistered(midlet)) {
                    throw new ClassNotFoundException("No MIDLet-<n> registration");
                }
                boolean connectionOK = false;
                if (connection.startsWith("sip:")) {
                    if (null != System.getProperty("microedition.sip.version")) {
                        midletSuite.checkForPermission(49, connection);
                        connectionOK = true;
                    }
                } else if (connection.startsWith("mms://")) {
                    MMSAddress mmsAddress = MMSAddress.getParsedMMSAddress(connection);
                    if (mmsAddress.type != 5) {
                        throw new IllegalArgumentException("Invalid connection string");
                    }
                    midletSuite.checkForPermission(18, connection);
                    connectionOK = true;
                } else if ((connection.startsWith("btl2cap://") || connection.startsWith("btspp://") || connection.startsWith("btgoep://")) && btPushAdaptor != null) {
                    try {
                        bt_pushListener = (BTPushAdaptor)Class.forName("com.sun.kvem.jsr082.impl.JSR082PushAdaptor").newInstance();
                        bt_pushListener.setConnectionString(connection);
                        bt_pushListener.setFilterString(filter);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    midletSuite.checkForPermission(34, connection);
                    connectionOK = true;
                } else {
                    HttpUrl url = new HttpUrl(connection);
                    if (url.host != null) {
                        throw new ConnectionNotFoundException("Connection not supported");
                    }
                    if (connection.startsWith("socket://")) {
                        if (url.port == -1) {
                            new IllegalArgumentException("Port missing");
                        }
                        midletSuite.checkForPermission(6, connection);
                        connectionOK = true;
                    }
                }
                if (connection.startsWith("datagram://")) {
                    midletSuite.checkForPermission(8, connection);
                } else if (connection.startsWith("sms://")) {
                    midletSuite.checkForPermission(11, connection);
                } else if (connection.startsWith("cbs://")) {
                    midletSuite.checkForPermission(12, connection);
                } else if (!connectionOK) {
                    throw new ConnectionNotFoundException("Connection not supported");
                }
            }
            catch (InterruptedException ie) {
                throw new InterruptedIOException("Interrupted while trying to ask the user permission");
            }
        }
        String storageName = midletSuite.getStorageName();
        byte[] asciiRegistration = Util.toCString(connection + "," + midlet + "," + filter + "," + storageName);
        int fd = PushRegistryImpl.add0(asciiRegistration);
        if (fd == -1) {
            throw new IOException("Connection already registered");
        }
        if (bt_pushListener != null) {
            bt_pushListener.setFileDescriptor(fd);
            new Thread(bt_pushListener).start();
        }
    }

    public static String getSipPortAsString(String uri) {
        if (uri == null || uri.length() == 0) {
            return null;
        }
        int colon = uri.indexOf(":");
        if (-1 == colon) {
            return null;
        }
        int semi = uri.indexOf(";");
        if (semi == -1) {
            semi = uri.length();
        }
        String port = uri.substring(colon + 1, semi);
        return port;
    }

    public static String getSipParam(String uri, String parameter) {
        int startIdx = -1;
        int endIdx = 0;
        int c = 32;
        String fUri = uri + ";";
        for (int i = 0; i < fUri.length(); ++i) {
            int idx;
            c = fUri.charAt(i);
            if (c != 59) continue;
            if (startIdx == -1) {
                startIdx = i + 1;
                continue;
            }
            endIdx = i;
            String token = fUri.substring(startIdx, endIdx);
            startIdx = i + 1;
            if (!token.startsWith(parameter) || (idx = token.indexOf("=")) <= 0) continue;
            return token.substring(idx + 1);
        }
        return null;
    }

    public static boolean unregisterConnection(String connection) {
        byte[] asciiStorage;
        if (connection == null || connection.length() == 0) {
            return false;
        }
        Scheduler scheduler = Scheduler.getScheduler();
        MIDletSuite current = scheduler.getMIDletSuite();
        String root = current.getStorageName();
        byte[] asciiRegistration = Util.toCString(connection);
        int ret = PushRegistryImpl.del0(asciiRegistration, asciiStorage = Util.toCString(root));
        if (ret == -2) {
            throw new SecurityException("wrong suite");
        }
        if (ret != -1 && btPushAdaptor != null) {
            btPushAdaptor.killBluetoothListener();
        }
        return ret != -1;
    }

    public static boolean checkInConnectionInternal(SecurityToken token, String connection) {
        token.checkIfPermissionAllowed(0);
        if (connection == null || connection.length() == 0) {
            throw new IllegalArgumentException("Connection missing");
        }
        byte[] asciiRegistration = Util.toCString(connection);
        return PushRegistryImpl.checkInByName0(asciiRegistration) != -1;
    }

    public void initSecurityToken(SecurityToken token) {
        if (classSecurityToken == null) {
            classSecurityToken = token;
        }
    }

    public static String listConnections(boolean available) {
        MIDletSuite current = Scheduler.getScheduler().getMIDletSuite();
        if (current == null) {
            return null;
        }
        return PushRegistryImpl.listConnections(classSecurityToken, current.getStorageName(), available);
    }

    public static String listConnections(String storageName, boolean available) {
        return PushRegistryImpl.listConnections(null, storageName, available);
    }

    public static String listConnections(SecurityToken token, String storageName, boolean available) {
        String connections = null;
        if (token == null) {
            MIDletSuite current = Scheduler.getScheduler().getMIDletSuite();
            if (current != null) {
                current.checkIfPermissionAllowed(0);
            }
        } else {
            token.checkIfPermissionAllowed(0);
        }
        byte[] nativeStorageName = Util.toCString(storageName);
        byte[] connlist = new byte[512];
        if (PushRegistryImpl.list0(nativeStorageName, available, connlist, 512) == 0) {
            connections = Util.toJavaString(connlist);
        }
        return connections;
    }

    public static void unregisterConnections(SecurityToken token, String storageName) {
        token.checkIfPermissionAllowed(0);
        PushRegistryImpl.delAllForSuite0(Util.toCString(storageName));
        if (btPushAdaptor != null) {
            btPushAdaptor.killBluetoothListener();
        }
    }

    public static String getMIDlet(String connection) {
        byte[] registryEntry;
        if (connection == null || connection.length() == 0) {
            return null;
        }
        String midlet = null;
        byte[] asciiConn = Util.toCString(connection);
        if (PushRegistryImpl.getEntry0(asciiConn, registryEntry = new byte[512], 512) == 0) {
            String name = Util.toJavaString(registryEntry);
            try {
                int comma1 = name.indexOf(44, 0);
                int comma2 = name.indexOf(44, comma1 + 1);
                midlet = name.substring(comma1 + 1, comma2).trim();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return midlet;
    }

    public static String getFilter(String connection) {
        byte[] registryEntry;
        if (connection == null || connection.length() == 0) {
            return null;
        }
        String filter = null;
        byte[] asciiConn = Util.toCString(connection);
        if (PushRegistryImpl.getEntry0(asciiConn, registryEntry = new byte[512], 512) == 0) {
            String name = Util.toJavaString(registryEntry);
            try {
                int comma1 = name.indexOf(44, 0);
                int comma2 = name.indexOf(44, comma1 + 1);
                int comma3 = name.indexOf(44, comma2 + 1);
                filter = name.substring(comma2 + 1, comma3).trim();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return filter;
    }

    public static long registerAlarm(String midlet, long time) throws ClassNotFoundException, ConnectionNotFoundException {
        Scheduler scheduler = Scheduler.getScheduler();
        MIDletSuite midletSuite = scheduler.getMIDletSuite();
        if (midletSuite != null) {
            try {
                midletSuite.checkForPermission(10, null);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException("Interrupted while trying to ask the user permission");
            }
        }
        if (midlet == null || midlet.length() == 0) {
            throw new ClassNotFoundException("MIDlet missing");
        }
        if (!midletSuite.isRegistered(midlet)) {
            throw new ClassNotFoundException("No MIDLet-<n> registration");
        }
        Class<?> c = Class.forName(midlet);
        Class<?> m = Class.forName("javax.microedition.midlet.MIDlet");
        if (!m.isAssignableFrom(c)) {
            throw new ClassNotFoundException("Not a MIDlet");
        }
        MIDletSuite current = Scheduler.getScheduler().getMIDletSuite();
        if (current != null) {
            String root = current.getStorageName();
            byte[] asciiName = Util.toCString(midlet + "," + time + "," + root);
            return PushRegistryImpl.addAlarm0(asciiName, time);
        }
        return 0L;
    }

    public static void enablePushLaunch(SecurityToken token, boolean enable) {
        token.checkIfPermissionAllowed(0);
        pushEnabled = enable;
    }

    private static native int add0(byte[] var0);

    private native long poll0(long var1);

    private static native int getMIDlet0(long var0, byte[] var2, int var3);

    private static native int getEntry0(byte[] var0, byte[] var1, int var2);

    private static native long addAlarm0(byte[] var0, long var1);

    private static native int del0(byte[] var0, byte[] var1);

    private static native int checkInByName0(byte[] var0);

    private static native int list0(byte[] var0, boolean var1, byte[] var2, int var3);

    private static native void delAllForSuite0(byte[] var0);

    static {
        btPushAdaptor = null;
        try {
            btPushAdaptor = (BTPushAdaptor)Class.forName("com.sun.kvem.jsr082.impl.JSR082PushAdaptor").newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        pushEnabled = true;
    }
}

