/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.sip;

import com.sun.cldc.io.ConnectionBaseInterface;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import com.sun.midp.security.ImplicitlyTrustedClass;
import com.sun.midp.security.SecurityToken;
import gov.nist.core.ParseException;
import gov.nist.microedition.sip.StackConnector;
import gov.nist.siplite.address.SipURI;
import gov.nist.siplite.parser.URLParser;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.sip.SipClientConnection;
import javax.microedition.sip.SipException;

public abstract class ProtocolBase
implements ImplicitlyTrustedClass,
ConnectionBaseInterface {
    private static SecurityToken classSecurityToken;

    public void initSecurityToken(SecurityToken token) {
        if (classSecurityToken != null) {
            return;
        }
        classSecurityToken = token;
    }

    public boolean isProtocolSupported(String protocol) {
        if (protocol == null) {
            return false;
        }
        return protocol.equalsIgnoreCase("UDP") || protocol.equalsIgnoreCase("TCP");
    }

    public abstract Connection openPrim(String var1, int var2, boolean var3) throws IOException, IllegalArgumentException, ConnectionNotFoundException;

    public InputStream openInputStream() throws IOException {
        throw new IOException("SIP connection doesn't support input stream");
    }

    public OutputStream openOutputStream() throws IOException {
        throw new IOException("SIP connection doesn't support output stream");
    }

    public DataInputStream openDataInputStream() throws IOException {
        throw new IOException("SIP connection doesn't support input stream");
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        throw new IOException("SIP connection doesn't support output stream");
    }

    protected void checkForPermission(String name, String protocol, int permission) throws InterruptedIOException {
        Scheduler scheduler = Scheduler.getScheduler();
        MIDletSuite midletSuite = scheduler.getMIDletSuite();
        if (midletSuite == null) {
            return;
        }
        name = protocol + ":" + name;
        try {
            midletSuite.checkForPermission(permission, name);
        }
        catch (InterruptedException ie) {
            throw new InterruptedIOException("Interrupted while trying to ask the user permission");
        }
    }

    protected Connection openConn(String name, String scheme) throws IOException, IllegalArgumentException, SipException {
        SipClientConnection retval = null;
        URLParser parser = new URLParser(scheme + ":" + name);
        SipURI inputURI = null;
        try {
            inputURI = (SipURI)parser.parseWholeString();
        }
        catch (ParseException exc) {
            throw new IllegalArgumentException(exc.getMessage());
        }
        String transport = inputURI.getTransportParam();
        if (transport == null) {
            transport = "UDP";
        } else if (!transport.equalsIgnoreCase("UDP") && !transport.equalsIgnoreCase("TCP")) {
            throw new SipException(1);
        }
        if (transport == null) {
            transport = "UDP";
        }
        int portNum = inputURI.getPort();
        boolean isSecure = inputURI.isSecure();
        StackConnector stackConnector = StackConnector.getInstance(classSecurityToken);
        if (inputURI.isServer()) {
            String mimeType = inputURI.getTypeParam();
            if (inputURI.isShared()) {
                if (mimeType == null) {
                    throw new IllegalArgumentException("No type parameter in shared URI");
                }
                retval = stackConnector.createSharedSipConnectionNotifier(isSecure, transport, mimeType);
            } else {
                retval = stackConnector.createSipConnectionNotifier(portNum, isSecure, transport, mimeType);
            }
        } else {
            if (portNum == -1) {
                inputURI.setPort(5060);
            }
            retval = stackConnector.createSipClientConnection(inputURI);
        }
        return retval;
    }
}

